;the inner sanctum
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: gta 5 ost - minor turbulence

;a deeper look. the sequel to "necropolis 3071 a.d."

;it is quite simple: draw a color between 1 and 15 on the blank screen.
;the color representing the height gets 16 added when the scanner runs over the
;image to draw y = color upwards having the grayscale area of the standard palette
;used. so some shapes make a nice cityscape. maybe i will revisit this approach,
;there is quite a lot of potential for being creative.

;runs under xp, dosbox and freedos. it draws directly into the vga memory
;so you might be greeted by the shapes before it renders revealing the not so magic ;)

;assuming ax = bx = 0 / cx = 255

org 100h
use16

start:   push 0a000h     ;vga
         pop ds
         mov al,13h      ;320x200x256
         int 10h

;after init 13h the vga memory segment is (assumed to be) completely 0
;so there is no preparation needed to clear the screen
;cls:
;mov byte[ds:bx],ch;0
;inc bx
;jnz cls

main:

;create the isometric outline/base layout of the buildings

;cx = 255 here which is plenty
this3:
mov si,321*9 ; \
inc ax ;have it not being not 0 all the time please
mul cx ;good and rnd enough
       ;ax will determine the position of the tower

this2:
mov bx,318*6 ; /
this1:
adc dh,al ;randomize a bit
shr dx,12 ;0..15 / no need for inc dx
          ;this will give the planned height/color
          ;of the building
this4:
mov di,si ;get \ pos to draw the square
add di,ax ;add the pos from ax

;investing 7b into some extra of 1 tower having a colored top
;at this point i could have gone for a ray coming from a roof but that would
;be too obvious. it is more about an extra that kinda distracts but also grabs
;attention while adding some more ballance (given the circumstances because i
;did not revisit the code to change things up even more)

;those are the ones picked at the 1st pass ... change, compile, look, repeat ._.
;cmp cl,124;122;121;117;113;102;101;99;95;92;89;88;84;81;68;67;61;59;57;52;51;45;34;30;24;23;22;16
;cmp cl,253;251;247;244;227;222;209;208;202;186;184;179;177;175;168;165;156;154;143;134;133

;2nd pass picks
;cmp cl,23;45;57;59;61;84;92;101;113;117;143;154;156;165;168;179;184;202;222;244;227;247;253;179;

;honoroble mentions
;cmp cl,61;84;117;154;179;202;253;101;168;179;59;

;3rd pass
;cmp cl,23;45;57;59;61;101;143;156;168;184;222;227;179;

;4th pass
;cmp cl,23;59;143;156;184;227;

;almost there ...
;cmp cl,184;143;23;227;

;i went with this one mainly because it is close enough to the mirror image
;and so it does not double the blue part which is a bit too much. also the broken angle
;gives it some nice extra. other shapes are very interesting but unfortunately at the wrong place
cmp cl,156;

jne nooh
mov dl,18 ;make the tower 2 floors higher than everything else
nooh:


mov byte[ds:di+bx],dl   ;setting up word usage saved overall
mov byte[ds:di+bx+1],dl ;1b here but kills the overall layout
                        ;which i comitted to so yeah ...
sub bx,318 ;move into / direction and keep on drawing
jnz this1
sub si,321 ;move into \ direction and keep on drawing
jnz this2

loop this3 ;draw the isometric bases of the buildings




;create the isometric base of the cryo chamber logo
;first off draw the outline of 2 squares using a block
;of 16x10 which then gets moved around

mov si,8 ;draw in 4 directions

;xor dx,dx ;dx = 1 coming from above
;cx = 0 here
three:
mov ax,word[cs:dirs+si-2];get direction to move to while drawing
mov cl,40                ;lenght of move/distance to draw
test si,0000000000000010b;even? (which is the \ part of the squares)
jz noway
add cl,15                ;adjust/stretch out the \ direction
noway:                   ;for correct display

four:
mov di,318*10            ;/ direction of the block to draw
two:
mov bx,321*16            ;\ direction of the block to draw
one:
mov bp,bx                ;get \ direction
add bp,dx                ;add movement

mov word[ds:di+bp+320*90+48],1010h ;draw the left square
mov word[ds:di+bp+320*98+108],1010h;draw the right square

sub bx,321               ;move \ direction of block to draw
jnz one
mov bp,318               ;reuse 2x below and save 1b
sub di,bp;318            ;move \ direction of block to draw
jnz two
add dx,ax                ;move the block into grabbed direction
loop four                ;and keep drawing for the whole distance

dec si                   ;get the next direction
dec si
jnz three


;finalize the logo by deleting 4 areas/slices in the squares where
;they intersect. oh a nightmare of purists because the gaps are
;in reversed thickness compared to the original logo. however the
;correct way does not give a nice slice and bad corners based on the
;way of drawing things.

;bx = 0 here
mov bl,12     ;x thickness of slice/gap
cutt:
mov si,318*20 ;/ length of slice
cut:
cuttt:
mov word[ds:si+bx+320*70+154],cx;0                ;top left
mov byte[ds:si+bx+320*70+154+321*20],cl;0         ;top right
mov byte[ds:si+bx+320*122+140-318*4],cl;0         ;bottom left
mov word[ds:si+bx+320*122+140-318*4+321*20-1],cx;0;bottom right
sub si,bp;318
jnz cut
dec bx
jnz cutt ;create the whole cut

mov dx,320 ;save some bytes below by reusing

;finally create objects out of the isometric bases
;by grabbing the given color, calculating the height to draw
;and then draw in grayscale
;di = 0 here
ups:
xor ax,ax          ;setup
add al,byte[ds:di] ;get color
jz nah             ;but skip 0
;cmp al,40         ;test
;ja nah
mov si,di          ;copy currrent pos
mov bx,ax          ;given color equals the final height
mov al,16          ;start with black and get brighter the
                   ;higher the building is
rise:
mov cl,3           ;height/levels per color to stretch out
                   ;the buildings because the standard grayscale
                   ;only has 16 colors
goup:
mov byte[ds:si],al ;draw pixel
sub si,dx;320      ;move up
jc nah             ;prevent errors when overriding into bottom
                   ;of screen / higher offset
loop goup          ;draw all levels of 1 color
inc ax             ;next color (max range 16 .. 31)
dec bx             ;keep counting the height
jnz rise           ;until all done
nah:
inc di             ;move to the next pixel
jnz ups

;add some rays. this time with color which add a nice extra
;compared to a more hi res looking complete grayscale. i think.
;mov bx,320*200
mov bh,0fah ;-1b
;dec bx ;save another byte (*******)
ray:
mov byte[ds:bx+35-320*86],53           ;blue   \
mov word[ds:bx+25-320*57],5f5fh;95     ;green   --> yes, play it safe
mov byte[ds:bx-43+320*92],42           ;orange /    but good looking
mov byte[ds:bx-11],15                  ;bright extra ray spanning the whole
                                       ;image while being the outer corner
                                       ;of the mirror
mov byte[ds:bx-50],cl                  ;having this line/side of the mirror
                                       ;dark enhances the illusion and you
                                       ;might to have look twice


;mov byte[ds:bx+100-320*91],53
;mov word[ds:bx+90-320*62],5f5fh;95
;mov byte[ds:bx+22+320*87],42
;mov byte[ds:bx+54-320],cl ;(*******) which gets eaten here by adjusting
;mov byte[ds:bx+15-320],15 ;(*******) and even +1 here for killing a minor
                           ;          flaw on top ... you gain and you lose
sub bx,dx;320
jnc ray



;some traditions are not meant to be broken. sorry not sorry.
mov cl,38  ;width of the glass stripe
mov bp,-56-320 ;it is a mirror ;)

glass1:
xor si,si                ;init height
glass2:
mov al,byte[ds:si+bp] ;grab every 2nd pixel
                         ;for faking an angle of the mirror
cmp al,16                ;only work with colors above 16
jna k                    ;to avoid glitches
dec ax                   ;make mirror image a bit darker
k:
mov byte[ds:si+bx-49],al ;set pixel
add si,dx;320            ;copy and draw downwards
jnc glass2

dec bp ;pixel pos ;having the mirrored image 1:1 and not shrunk
dec bp            ;would save quite some bytes but this adds a
                  ;nice extra i assume nobody cares about but me ;)

;one more pixel for 4b
;or byte[ds:320*147+187],dl
or byte[ds:320*147+109],dl

;and another one for 3b
;mov byte[ds:320*144+47-319*15],al

;or byte[ds:320*137+166],bl
add byte[ds:320*137+166],dh

inc bx ;mirror pixel pos
loop glass1

waiting: in al,60h            ;read keyboard
         dec al               ;read, dammit!
         jnz waiting          ;nothing so wait. again.
         ret
         nop                  ;done. hi hellmood!
dirs dw -321,318,321,-318     ;order of directions to draw the parts of the logo