;head!crash
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: 1914 - where fear and weapons meet
;____________________________________________________________________________

;well, somewhat based on kurushi but not that complex. the 2nd press of
;a key would have affected the gameplay. plus it would have needed some
;less random blocks while costing the score system due to all the extra
;work needed. so i skipped a lot to have a playable game with scoring.
;if you do not know kurushi/intelligent qube (ps1) check it out. it is
;a fantastic game!

;aim of the game is to survive and getting your score up since there is no
;end of the enemy line. place a bomb to kill an enemy for astonishing
;5000 points. but you better do not collide with those goons - or with the
;non destructable blocks that are spread here and there.

;since things come your way randomly you might have no chance to escape
;your destiny. but it is what it is. in 256 bytes ;)

;if you place a bomb it is set at your position.
;so you need to move away from that spot before an enemy
;reaches the bomb or you will die as well. it would be silly if the bomb
;is a safe spot.

;you can set a bomb at another position if wanted. in that case
;the old one gets deleted. only 1 bomb for you majestro.

;controls: W/A/S/D/
;setabomb: Q
;selfmord: ESC

;____________________________________________________________________________

;assuming ax = 0 cx = 255 bx = 0

;uses vsync for constant speed of frames + frame counter (cx)

org 100h
use16

start:   push 0b800h ;textmooooooode
frmz:    pop ds
         inc ax      ;mov al,01h; 1 = 40*25 16 colors
         int 10h

mov si,80*11+10 ;init pos of player, one gotta start somewhere

;preparing the screen/playfield is needed
;because if you die memory would be identical after restart
;which is a big no no
cls:
mov byte[ds:bx],77h  ;fill with walls, gray
inc bx
jnz cls

;draw initial score on screen into screen memory
;recycled code but it works
mov bl,18 ;9 digits
scrz:
mov byte[ds:80*15+50+bx+1],7eh ;yellow on gray bg
                               ;since 7eh is also > "9"
                               ;it will be changed to "0"
                               ;when adding 1 in the next step
dec bx
jnz scrz

;clear playfield by deleting the relevant part
mov bx,80*5;5
fill:
mov byte[ds:bx+80*9],ch;0
dec bx
jnz fill

mov cl,1   ;make it all 0 by adding 1 to the score
jmp addor  ;which is over "9" at this point
           ;so ?????????? ---> 000000000

;add score
next:

mov cx,5000 ;add cx points to the score into screen buffer

addor:
mov di,80*15+50 ;pos of score

xor dx,dx       ;indicate that score +1 has to be proceeded

;bx = 0 here
mov bl,9*2; score numbers/digits * 2

scorehandler:
;mov dl,byte[cs:score+bx-1]
mov al,byte[ds:di+bx] ;only grab ascii from screen buffer
cmp dl,bh;0;1               ;next row is coming so +1, set above
jne fine3
inc ax ;score +1 ;dh does not matter
cmp al,"9"
jna fine4  ;no reminder
mov al,"0" ;reminder
;jmp fine3  ;update score
dec dx ;-1b
fine4:
;mov al,bh   ;0 ;no more change
inc dx;
fine3:

mov byte[ds:di+bx],al ;set new ascii to the screen

dec bx           ;next digit
dec bx           ;next digit
jnz scorehandler
loop addor       ;add up all score

mov cl,32   ;init frame handler
mov word[ds:bp],bx;0 ;delete bomb + enemy
mov bp,ds   ;bomb out of screen / inactive

main:

;vsync each frame
mov dx,3dah     ;wait for vsync for constant speed
vsync1:         ;of the frames
in al,dx        ;whole set needed this time
test al,8
jnz vsync1
vsync2:
in al,dx
test al,8
jz vsync2

mov dx,80 ;reuse below and save 2b

;frame handler
loop allright;-1b ;does its job
mov cl,32    ;speed of things
             ;movement every cl frames

;move blocks to the left + create a new set on the right
mov word[ds:si],bx;0 ;del player, so it does not get duped
;mov byte[ds:bp+1],cl;0h ;del bomb, so it does not get duped

;move everything 1 to the left
;bx = 0
two:
mov di,80*5;5
one:
mov ax,word[ds:di+bx+80*8+2] ;grab enemy/space
mov ah,9 ;set enemy color which also replaces
         ;bomb background so bomb does not need to get deleted above
         ;so -2b
mov word[ds:di+bx+80*8],ax ;set enemy/empty space
sub di,dx;80 ;move down
jnz one   ;until done
inc bx    ;move right
inc bx
cmp bx,dx;80 ;until done
jne two

;create new column of enemies
xor ax,ax ;make things idependent from input/gameplay
mov bx,80*5;5
new:
in al,40h                 ;le classique seedio
imul ax,5017              ;random enough
shr al,7                  ;0 or 1
cmp ah,8
ja nopz
mov al,254                ;the undestructable
nopz:
mov ah,9                   ;enemy color
mov word[ds:bx+80*8+78],ax ;draw
;mov word[ds:bx+80*8+18],7700h
sub bx,dx;80
jnz new

;you can not hide inside la bomba, biatcho
cmp byte[ds:si],bl;0;0 ;player hit by a block?
jne breaker            ;yes so game over

;search if there is something on a bomb
cmp byte[ds:bp],01h  ;enemy on the bomb?
;jne allright         ;nope
je next               ;yes
;by moving this into the score code -2b
;mov word[ds:bp],bx;0 ;delete bomb + enemy
;jmp next             ;add score + make bomb inactive

allright:

mov word[ds:si],0a02h ;draw player
mov byte[ds:bp+1],40h ;draw bomb (inside or outside of screen)

         mov ah,01h
         int 16h
         jz go_on               ;if no key pressed do nothing
                                ;and simply update screen

         mov ah,00h            ;key pressed so get the code
         int 16h               ;nouws

         cmp al,27             ;esc
         je breaker            ;bye bye

mov di,si ;dupe pos for checks
cut4:    cmp al,'a';97             ;A
         jne cut6
         dec di        ;move
         dec di        ;move
cut6:    cmp al,'d';100            ;D
         jne cut2
         inc di        ;move
         inc di        ;move
cut2:    cmp al,'s';115            ;S
         jne cut8
         add di,dx;80     ;move
cut8:    cmp al,'w';119            ;W
         jne cutx
         sub di,dx;80     ;move
cutx:    cmp al,'q'
         jne noboom
         mov byte[ds:bp+1],bl;0 ;del old one
         mov bp,si              ;set bomb

noboom:

mov al,byte[ds:di] ;save some bytes
cmp al,77h;0 ;check if new position is free
                      ;walls are 77h
je go_on              ;no free space so do not change pos

cmp al,01h;0 ;check if new position is on enemy
je breaker            ;it is so you die

cmp al,254;0 ;check if new position is on enemy
je breaker            ;it is so you die

setting:              ;free space so finalize move
mov word[ds:si],bx;0  ;del old player
mov si,di             ;update pos of player

go_on:
jmp main              ;do the thing again

breaker: mov word[ds:si],042bh ;game over
         ret                   ;halt!
db '256'                       ;filler thriller