;q-type:2 // function 2o23 invitation
;sensenstahl
;www.sensenstahl.com
;fasm 1.69.31
;listening: hitsujibungaku - fool
;____________________________________________________________________________

;quick dox:
;- 1 life
;- hit correct keys to delete asciis before they land on the bottom line

;dox:
;- random ascii fall down
;- ascii range 33(!) .. 122(z)
;- excluding ascii ^(94) and `(96) since they need an additional keypress
;- press the right key to delete 1 ascii (if present) and get 250 points
;- multiple keystrokes are allowed in case there are more than 1 identical
;  ascii present
;- asciis get deleted no matter their spot so you do not have to stay in
;  order of their appearence
;- in the lower rows asciis get marked by color(4) to show the danger zone
;- when an ascii drops on the bottom line it is game over
;- pressing a key for an ascii not on screen also means game over time
;- hitting ESC is also game over ;)

;---------------------------------------------------------------------------
;the basic idea is similar to q-type (which i released at lovebyte2o22)
;but with a different approach. also the asciis could have been dropped
;in 1 column but having them spread out gives more a feeling of chaos
;and always looming danger. plus your eyes have to move around searching.
;i just want to keep those marbles in healthy motion you know ;)

;to make it really hard the range could be spanning also asciis 122+ but
;that would be a bit too nerdy ;)

;i had bytes left and thought why not putting some text on it that is not
;hiscore or something. so here we are.

;---------------------------------------------------------------------------
;runs under freedos and the box. also under xp even though that does not
;like blink and thus fucks up the colors of the bottom line.

;---------------------------------------------------------------------------
;assuming ax = 0 cx = 255 bx = 0 bp > 20
;global use: si = rnd seed

org 100h
use16

score_bse equ 80*2*49+68+40 ;what it says
text_bse equ 80*2*49+14     ;what it says
frames equ 15               ;number of frames it takes
                            ;to let things fall +1 row

start:   push 0b800h  ;textmooooooode
         pop ds
         mov ax,1112h ;80x50
         int 10h

         mov fs,bx    ;timer

;clean it up
cls:
mov byte[ds:bx],ch ;0
inc bx
jnz cls

;draw the bottom line so score and text do not float in darkness
mov bl,160
thats_the_bottom_line_cos_stone_cold_said_so:
;mov word[ds:bx+80*2*49-2],7000h
mov byte[ds:bx+80*2*49-1],7ah+128 ;well it is an invitation
                                  ;so it can blink-a-long
dec bx
dec bx
jnz thats_the_bottom_line_cos_stone_cold_said_so

;grab the text and slap it on the screen
mov bl,32+3

mov bp,frames ;init counter here
              ;so pressing a key and getting score
              ;does not affect the frame counter
              ;using bx here would save 1b but the
              ;waiting at the start is annoying to me
              ;i would have nop'd it anyway

text:
mov al,byte[cs:txt+bx-1] ;get text
mov di,bx                ;word
;mov ah,16*7+2
mov byte[ds:di+bx+text_bse],al ;set it where it belongs
dec bx
jnz text


;draw initial score on screen into vga and NOT into the buffer
;used a lot in previous prods but it works
mov bl,18
scrz:
mov byte[ds:score_bse+bx+1],16*7+9;30h ;'0' = 48 = 30h / 16*7+1 = 113 = 71h
;mov word[es:80*24+50+bx],79;30h ;'0' = 48 = 30h / 16*7+1 = 113 = 71h
;dec bx ;save 2b
dec bx
jnz scrz
;dec byte[es:80*24+50+18]

mov cl,1
jmp addor
;start adding points with 1st frame because you deserve them!
next:

mov cx,250 ;add cx points to the score into screen buffer
addor:

xor ax,ax ;indicate that score +1 has to be proceeded

;bx = ? here
mov bx,9*2; score numbers/digits * 2

scorehandler:
;mov dl,byte[cs:score+bx-1]
mov dl,byte[ds:score_bse+bx] ;only grab ascii from screen buffer
cmp al,bh;0;1                    ;next row is coming so +1, set above
jne fine3
inc dl ;score +1
cmp dl,"9"
jna fine4  ;no reminder
mov dl,"0" ;reminder
jmp fine3  ;update score
fine4:
;mov al,bh   ;0 ;no more change
inc ax;
fine3:

mov byte[ds:score_bse+bx],dl ;set new ascii to the screen

dec bx           ;next digit
dec bx           ;next digit
jnz scorehandler
loop addor       ;add up all score

main:

dec bp      ;frame counter
jnz skippie ;no falling/creating yet
mov bp,frames   ;reset counter

;create new key consisting of (non)capital letters,
;extra keys (excluding a few), and numbers
again:
in al,40h ;should be random enough
mul si    ;at least it was while testing a bit
adc cx,ax
shr cl,1 ;0..128
add cl,33 ;!
cmp cl,122 ;z
ja again
;jbe safe
;xor cx,cx ;no new letter
;jmp safe2 ;but fuck that ;)
;safe:

;excluding those which need a 2nd keypress
cmp cl,'^';94
je again ;no way
cmp cl,'`';96
je again ;no way

;cmp cl,'C' ;test to make sure
;je breaker ;every letter is possible

;create pos of new letter
imul di,ax,127 ;-1b compared to 127+
shr di,10
shl di,1 ;word

;draw letter
mov ch,16*6+0eh ;add color
                ;bg needed to distinguish ' from ,
;safe2:
mov word[ds:di+16],cx
;move it all down
;since there was a cls everything that is no letter should be 0
;mov bx,80*2*48
mov bh,1eh
fall:
xor ax,ax
xchg ax,word[ds:bx-2]
cmp bx,80*2*39 ;last rows are danger zone!
jnae no        ;but you are safe!
mov ah,4       ;or get an alert!
no:
mov word[ds:bx+80*2-2],ax
dec bx
dec bx
jnz fall

skippie:

inc si    ;seed for rnd

;check if something dropped on the bottom
mov bl,160
check:
cmp byte[ds:bx+80*2*48-2],bh;0
jne breaker ;game over
dec bx
dec bx
jnz check

;check timer and make next frame
mov ax,word[fs:046ch] ;timer does not get a reset
again2:
cmp word[fs:046ch],ax ;let them wiggle slowly ;)
je again2 ;check again, if time passed


         mov ah,01h
         int 16h
         jz main               ;if no key pressed do nothing
                                ;and simply update screen

         mov ah,00h            ;key pressed so get the code
         int 16h               ;nouws

         cmp al,27             ;esc
         je breaker            ;bye bye

;check if there is a letter on screen that can be deleted
mov di,80*2*47
checking:
cmp al,byte[ds:di]
jne nothing_found
mov word[ds:di],bx;0 ;delete found letter
jmp next             ;add score

nothing_found:
dec di
dec di
jnz checking

;jmp main ;get back to the next frame
          ;or not. because funk cheaters that
          ;simply hack away randomly
          ;so if you hit a key that is not present
          ;it is game over
          ;also save 2b along the way

breaker: ret ;halt!
;       0         1         2         3
;       01234567890123456789012346578901234
txt db '!p0wered',254,'by',254,'FUNCTION',254,'2o23! #code4it'