
;extra segment offsets

BUF_TEXT  		equ 0000h
BUF_BACK  		equ 1000h
BUF_FILL  		equ 2000h
BUF_SPEC  		equ 2800h
BUF_MUSIC 		equ 4800h

SCAN_ESC  		equ 0100h
SCAN_SPACE		equ 3900h
SCAN_ENTER		equ 1c00h
SCAN_UP   		equ 4800h
SCAN_DOWN 		equ 5000h
SCAN_LEFT 		equ 4b00h
SCAN_RIGHT		equ 4d00h
SCAN_F1			equ 3b00h
SCAN_F2			equ 3c00h

SPECTRUM_HEIGHT equ 17
SPECTRUM_COLUMN	equ 0f0h
SPECTRUM_RANGE 	equ 8000


%ifdef HERCULES
TEXT_VRAM		equ 0b000h
%else
TEXT_VRAM		equ 0b800h
%endif

	use16
	cpu 8086
	org 100h
	

start:

	;get segments for memory buffers
	
	mov ax,ds
	add ax,1000h				;64K for COM file
	mov es,ax					;single extra segment
	
	mov [cs:extra_seg],ax
	
	;set video mode

%ifdef HERCULES
	mov ax,07h
%else
	mov ax,03h
%endif
	int 10h
	
	;hide cursor for page 0
	
	mov ah,2
	mov bh,0

	mov dx,1a50h
	
	int 10h
	
	;set active page
	
	mov ax,0500h

	int 10h
		
	;initialize vars, unpack title
	
	mov ax,0
	
	mov [cs:t_isr_installed],al
	mov [cs:playlist_repeat],al
	mov [cs:song_cursor],ax
	mov [cs:song_cursor_blink],ax
	mov [cs:song_done],al
	mov [cs:osd_timeout],al
	mov [cs:spec_color_id],ax
	mov [cs:music_ptr],ax
	mov [cs:music_predelay],ax
	mov al,1
	mov [cs:playlist_mode],al
	mov al,2
	mov [cs:playlist_repeat],al
	
	mov ah,2ch		;get system time
	int 21h
 
	mov [cs:rand_w],dx
	mov [cs:rand_b],dl


	call clear_buf
%ifndef SNOW
	call spectrum_init
%endif
	
	mov si,screen_packed
	mov di,BUF_BACK
	
	call DEC40
	
	call render_playlist

	call copy_back_to_buf
	
	call fill_in
	
	mov cx,120
	call set_timer_isr

;------------------------------------------------------------------------------

main_loop:
	
%ifdef SNOW
	call vsync
%endif

	call show_osd
	
	call show_cursor

	call rand16
	
	inc word [cs:song_cursor_blink]
	
	call read_key

	mov cx,[cs:music_ptr]
	or cx,cx
	jne main_music_playing
	
	push ax
	call sound_mute
	
%ifndef SNOW
	call vsync
	call spectrum_render
%endif
	pop ax
	
	cmp ax,SCAN_ESC
	je exit_to_dos
	
	push ax
	mov ax,[cs:song_cursor]
	mov cx,10
	mul cx
	mov bx,ax
	pop ax
	
	cmp ax,SCAN_LEFT
	je move_cursor_left
	
	cmp ax,SCAN_RIGHT
	je move_cursor_right
	
	cmp ax,SCAN_UP
	je move_cursor_up
	
	cmp ax,SCAN_DOWN
	je move_cursor_down
	
	cmp ax,SCAN_ENTER
	je set_play_normal
	
	cmp ax,SCAN_F1
	je change_playlist_mode
	
	cmp ax,SCAN_F2
	je change_repeat_mode
	
	jmp main_loop
	
	
	
change_playlist_mode:

	mov al,[cs:playlist_mode]
	inc al
	cmp al,3
	jc change_playlist_mode1
	xor al,al
change_playlist_mode1:
	mov [cs:playlist_mode],al
	
	jmp set_osd
	
	
	
change_repeat_mode:

	mov al,[cs:playlist_repeat]
	inc al
	cmp al,5+1
	jc change_repeat_mode1
	xor al,al
change_repeat_mode1:
	mov [cs:playlist_repeat],al
	
	
	
set_osd:

	mov al,60
	mov [cs:osd_timeout],al
	
	mov bx,1000h
	call sound_beep
	
	jmp main_loop
	
	
	
main_music_playing:

%ifndef SNOW
	push ax
	call spectrum_render
	pop ax
%endif
	
	mov al,[cs:song_done]
	or al,al
	jne main_music_done
	
	mov al,ah
	and al,80h
	jne main_loop
	mov al,ah
	and al,7fh
	je main_loop
	
main_music_done:

	call music_stop
	
	;just to restore colors of playlist
	
	mov si,screen_packed
	mov di,BUF_BACK
	
	call DEC40
	
	call render_playlist
	
%ifdef SNOW
	call copy_back_to_buf
	call copy_buf_to_screen
%endif

	mov al,[cs:song_done]
	or al,al
	je main_loop
	
	;playlist logic here
	
	mov al,0
	mov [cs:song_done],al
	
	mov al,[cs:playlist_mode]
	or al,al
	je main_loop		;0 single, 1 order, 2 shuffle
	cmp al,2
	je playlist_random

	

playlist_order:
	
	mov ax,[cs:song_cursor]
	inc ax
	cmp ax,23
	jnc main_loop
	mov [cs:song_cursor],ax

	mov ax,120
	mov [cs:music_predelay],ax
	
	jmp set_play
	
	
	
playlist_random:

	call rand16
	and ax,63
	
playlist_random1:
	cmp ax,23
	jc playlist_random2
	sub ax,23
	jmp playlist_random1
	
playlist_random2:

	mov [cs:song_cursor],ax
	
	mov ax,120
	mov [cs:music_predelay],ax
	
	jmp set_play
	
	
	

set_play_normal:

	mov ax,0
	mov [cs:music_predelay],ax
	
set_play:

	call vsync
	
%ifndef SNOW
	mov di,BUF_BACK+8*80*2+1
%else
	push es
	mov ax,TEXT_VRAM
	mov es,ax
	mov di,8*80*2+1
%endif

	mov cx,80*(25-8)
	mov al,08h
	
fade_back_loop1:

	mov byte [es:di],al
	add di,2
	loop fade_back_loop1
	
	mov ax,[cs:song_cursor]
	mov cx,10
	mul cx
	mov bx,ax
	mov di,[cs:song_list+bx]
%ifndef SNOW
	add di,BUF_BACK+1
%else
	add di,1
%endif
	mov cx,20
	mov al,07h
	
fade_back_loop2:

	mov byte [es:di],al
	add di,2
	loop fade_back_loop2
	
%ifndef SNOW
	call spectrum_init
%else
	pop es
%endif

	mov ax,[cs:song_cursor]
	
	call music_play
	
	jmp main_loop
	
	
;------------------------------------------------------------------------------

move_cursor_left:

	mov ax,[cs:song_list+2+bx]
	
move_cursor_done:

	and ax,00ffh
	cmp [cs:song_cursor],ax
	je main_loop
	mov [cs:song_cursor],ax

	xor ax,ax
	mov [cs:song_cursor_blink],ax
	
	mov bx,1000h
	call sound_beep
	call clear_cursor
	
	jmp main_loop
	
move_cursor_right:

	mov ax,[cs:song_list+2+bx]
	xchg al,ah

	jmp move_cursor_done
	
move_cursor_up:

	mov ax,[cs:song_list+4+bx]

	jmp move_cursor_done
	
move_cursor_down:

	mov ax,[cs:song_list+4+bx]
	xchg al,ah

	jmp move_cursor_done
	
;------------------------------------------------------------------------------

exit_to_dos:
	
	call music_stop
	
	call restore_timer_isr
	
	call clear_buf

	call fill_out
	
	mov ax,03h			;back to normal text mode
	int 10h
		
	mov ax,04c00h		;exit to dos
	int 21h
	
	

;------------------------------------------------------------------------------
	
render_playlist:

	mov di,song_list
	
render_pl_loop:

	mov bx,word [cs:di]
	or bx,bx
	je render_pl_done
	
	add bx,BUF_BACK+2*2
	
	mov si,[cs:di+8]
	
	mov ah,0fh
	
render_pl_loop_1:

	mov al,byte [cs:si]
	or al,al
	je render_pl_next
	
	mov word [es:bx],ax
	
	add bx,2
	inc si
	
	jmp render_pl_loop_1
	
render_pl_next:

	add di,10
	
	jmp render_pl_loop
	
render_pl_done:
	
	ret
	
	

;------------------------------------------------------------------------------

sound_beep:

	mov al,0b6h
	out 43h,al
	
	mov al,bl
	out 42h,al
	mov al,bh
	out 42h,al
		
	in al,61h
	or al,03h
	out 61h,al

	ret

	
	
;------------------------------------------------------------------------------

sound_mute:

	in al,61h
	and al,0fch
	out 61h,al
	
	ret
	
	
	
;------------------------------------------------------------------------------
;ES:DI=starting offset, CX=height, DX=width, AX=fill value, BX=value delta

fill_left_right:

fill_lr_0:

	push ax
	push cx
	push di
	
	mov cx,dx
	
fill_lr_1:

	mov byte [es:di],al
	inc di
	add ax,bx

	loop fill_lr_1
	
	pop di
	pop cx
	pop ax
	
	add di,80

	loop fill_lr_0
	
	ret
		
		
		
;------------------------------------------------------------------------------
;ES:DI=starting offset, CX=height, DX=width, AX=fill value, BX=value delta

fill_top_down:

fill_td_0:

	push cx
	push di
	
	mov cx,dx
	
fill_td_1:

	mov byte [es:di],al
	inc di

	loop fill_td_1
	
	pop di
	pop cx

	add di,80
	add ax,bx
	
	loop fill_td_0
	
	ret
	
	
	
;------------------------------------------------------------------------------

fill_in:

	mov di,BUF_FILL
	mov ax,0
	mov cx,80*25/2
	rep stosw
	
	mov di,BUF_FILL
	mov cx,10
	
fill_in_0:

	push cx
	
	mov cx,80

fill_in_1:

	push cx
	
	call rand16
	and ax,31
	
	add ax,40
	shr cx,1
	sub ax,cx
	
	mov [es:di],al
	inc di

	pop cx
	
	loop fill_in_1
	
	pop cx
	
	loop fill_in_0
	
	
	mov di,BUF_FILL+5+8*80
	mov cx,25-8
	mov dx,7
	mov ax,60
	mov bx,2
	call fill_left_right
	
	mov di,BUF_FILL+12+8*80
	mov cx,25-8
	mov dx,30
	mov ax,60+7
	mov bx,2
	call fill_top_down
	
	mov di,BUF_FILL+39+8*80
	mov cx,25-8
	mov dx,7
	mov ax,60+30
	mov bx,3
	call fill_left_right
	
	mov di,BUF_FILL+45+8*80
	mov cx,8;25-8
	mov dx,30
	mov ax,60+7+30
	mov bx,2
	call fill_top_down
	
	jmp fill_effect

	
	
;------------------------------------------------------------------------------

fill_out:

	mov di,BUF_FILL
	mov cx,25
	mov dx,0
	
fill_out_0:

	push cx
	
	mov cx,80

fill_out_1:

	call rand16
	and ax,15
	
	add ax,dx
	
	mov byte [es:di],al
	inc di

	loop fill_out_1
	
	pop cx
	
	add dx,2
	
	loop fill_out_0
	
	jmp fill_effect
	
	
	
;------------------------------------------------------------------------------

fill_effect:
	
	mov al,0b6h
	out 43h,al
	
	push ds
	
	mov ax,TEXT_VRAM
	mov ds,ax
	
	mov dl,0
	mov bx,80*25
	
fill_loop:
	
	mov si,BUF_FILL
	mov cx,80*25/8
		
	call vsync
	call sound_mute
		
fill_loop_1:

	cmp dl,[es:si]
	jne fill_loop_20
	
	call fill_copy
		
fill_loop_20:

	inc si

	cmp dl,[es:si]
	jne fill_loop_21
	
	call fill_copy
		
fill_loop_21:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_22
	
	call fill_copy
		
fill_loop_22:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_23
	
	call fill_copy
		
fill_loop_23:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_24
	
	call fill_copy
		
fill_loop_24:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_25
	
	call fill_copy
		
fill_loop_25:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_26
	
	call fill_copy
		
fill_loop_26:

	inc si
	
	cmp dl,[es:si]
	jne fill_loop_27
	
	call fill_copy
		
fill_loop_27:

	inc si
	
	loop fill_loop_1
	
	inc dl
	
	or bx,bx
	jne fill_loop

	pop ds
	
	call sound_mute
	
	ret
	
	
	
fill_copy:

	mov di,si
	sub di,BUF_FILL
	shl di,1
	mov ax,[es:BUF_TEXT+di]
	mov [ds:di],ax

	dec bx

	add ax,di
	and ax,si
	or ah,01h

	out 42h,al
	xchg al,ah
	out 42h,al
	
	in al,61h
	xor al,03h
	out 61h,al
	
	ret
	
	

;------------------------------------------------------------------------------
;AX returns random number
;originally designed for Z80 by introspec

rand16:

	mov ax,[cs:rand_w]
	mov bl,[cs:rand_b]
	add ax,ax
	rcl bl,1
	mov [cs:rand_b],bl
	sbb bl,bl
	and bl,0dbh
	xor al,bl
	mov [cs:rand_w],ax	

	ret
	
	

;------------------------------------------------------------------------------
	
vsync:

	push ax
	push dx
	
%ifdef HERCULES

	mov dx,03bah
	mov ah,080h
	
vsync_0:

	in al,dx
	and al,ah
	jnz vsync_0
	
vsync_1:

	in al,dx
	and al,ah
	jz vsync_1
	
%else
	
	mov dx,03dah
	mov ah,08h
	
vsync_0:

	in al,dx
	and al,ah
	jnz vsync_0
	
vsync_1:

	in al,dx
	and al,ah
	jz vsync_1
	
%endif

	pop dx
	pop ax
	
	ret
	
	
	
;------------------------------------------------------------------------------

show_osd:

	push es
	mov ax,TEXT_VRAM
	mov es,ax
	
	mov di,5*80*2+1*2
	
	mov al,[cs:osd_timeout]
	or al,al
	je show_osd_clear
	dec al
	mov [cs:osd_timeout],al
	
	mov al,[cs:playlist_mode]
	mov ah,0
	add ax,ax
	add ax,ax
	add ax,playlist_mode_str
	mov si,ax
	
	mov ah,07h
	mov cx,3
	
show_osd_1:

	mov al,[cs:si]
	mov [es:di],ax
	add di,2
	inc si
	
	loop show_osd_1
	
	mov al,[cs:playlist_repeat]
	or al,al
	je show_osd_2
	add al,'0'
	jmp show_osd_3
	
show_osd_2:

	mov al,0ech
	
show_osd_3:

	mov [es:di],ax
	
	pop es

	ret
	
show_osd_clear:

	mov ax,0
	mov [es:di],ax
	add di,2
	mov [es:di],ax
	add di,2
	mov [es:di],ax
	add di,2
	mov [es:di],ax
	add di,2
	
	pop es
	
	ret
	
	
	
;------------------------------------------------------------------------------

show_cursor:

%ifdef SNOW
	push es
	mov ax,TEXT_VRAM
	mov es,ax
%endif

	mov ax,[cs:song_cursor]
	mov cx,10
	mul cx
	mov bx,ax

	mov di,word [cs:song_list+bx]
%ifndef SNOW
	add di,BUF_BACK
%endif
	
	mov ax,[cs:music_ptr]
	or ax,ax
	jne show_cursor_playing
	
show_cursor_normal:

	mov ax,[cs:song_cursor_blink]
	
	xor ax,8
	and ax,8	

	je show_cursor_done
	
	mov ax,0fdbh
	
	jmp show_cursor_done
	
show_cursor_playing:

	mov ax,070eh

show_cursor_done:

	mov [es:di],ax
	
%ifdef SNOW
	pop es
%endif
	
	ret
	
	
	
;------------------------------------------------------------------------------

clear_cursor:

%ifdef SNOW
	push es
	mov ax,TEXT_VRAM
	mov es,ax
%endif

	mov bx,0
	mov ax,bx
	
clear_cursor_0:

	mov di,word [cs:song_list+bx]
	or di,di
	je clear_cursor_done
%ifndef SNOW
	add di,BUF_BACK
%endif
	mov word [es:di],ax
	
	add bx,10
	jmp clear_cursor_0
	
clear_cursor_done:

%ifdef SNOW
	pop es
%endif

	ret
	
	
	
;------------------------------------------------------------------------------

%ifndef SNOW

spectrum_init:

	mov di,spec_array_value
	mov cx,40+40+40*2
	mov ax,0
	
	rep stosw
	
	mov di,BUF_SPEC
	mov dx,0
	mov bx,35*512/SPECTRUM_RANGE
	mov cx,SPECTRUM_RANGE
	
spectrum_init_loop:

	mov ax,dx
	;shr ax,9	;286 opcode
	 mov al,ah
	 mov ah,0
	 shr ax,1
	cmp al,39
	jc spectrum_init_loop_1
	mov al,39
spectrum_init_loop_1:	

	mov ah,39
	sub ah,al
	mov byte [es:di],ah
	
	add dx,bx
	inc di
	
	loop spectrum_init_loop
	
	mov ax,[cs:spec_color_id]
	inc ax
	and ax,3
	mov [cs:spec_color_id],ax
	
	mov cx,21*2
	mul cx

	add ax,spectrum_color
	mov [cs:spec_array_color],ax

	mov bx,ax
	add bx,20*2
	mov ax,[cs:bx]
	mov [cs:spec_peak_color],ax
	
	ret
	
%endif
	

;------------------------------------------------------------------------------
;AX=period

%ifndef SNOW

spectrum_add:

	or ax,ax
	je spectrum_add_done
	
	;shr ax,1
	
	mov bx,SPECTRUM_RANGE-1
	cmp ax,bx
	jc spectrum_add_0
	
	mov ax,bx
	
spectrum_add_0:

	mov si,BUF_SPEC
	add si,ax
	mov al,byte [es:si]
	mov ah,0
	
	add ax,3
	sub ax,9/2
	add ax,ax
	mov bx,ax
	sub bx,6
	
	mov si,spectrum_grad
	mov cx,9
	
spectrum_add_1:

	cmp bx,40*2
	jnc spectrum_add_2
	
	mov di,spec_array_value
	add di,bx
	mov ax,word [cs:di]
	add ax,word [cs:si]
	cmp ax,512
	jnc spectrum_add_2
	mov word [cs:di],ax
	
spectrum_add_2:

	add si,2
	add bx,2
	
	loop spectrum_add_1
	
spectrum_add_done:

	ret
	
%endif
	
	
;------------------------------------------------------------------------------

%ifndef SNOW

spectrum_render:

	push ds
	
	mov ax,TEXT_VRAM
	mov ds,ax
	
	mov cx,40
	mov si,0
	mov di,24*80*2

spectrum_render_loop:

	push cx
	push si
	push di
	
	mov cl,[cs:spec_peak_value+si]
	mov ch,[cs:spec_peak_time+si]
	shl si,1
	mov bx,[cs:spec_array_value+si]
	
	push cx
	
	cmp bx,SPECTRUM_HEIGHT*16
	jc spectrum_render_clip_1
	mov bx,SPECTRUM_HEIGHT*16
spectrum_render_clip_1:

	mov ax,bx
	xor dx,dx
	
	mov cx,16
	div cx
	
	mov dh,al		;h
	shl al,1		;p
	
	pop cx
	
	je spectrum_render_clip_2
	cmp al,cl
	jc spectrum_render_clip_2
	
	mov cl,al		;peak=p
	mov ch,16		;time=16
	
	shr si,1
	mov [cs:spec_peak_value+si],cl
	mov [cs:spec_peak_time+si],ch
	
spectrum_render_clip_2:

	push di
	push cx
	
	xor ah,ah
	mov al,dh
	dec al
	add ax,ax
	add ax,[cs:spec_array_color]
	mov si,ax

	mov bx,80*2+2

	mov cl,dh
	or cl,cl
	je spectrum_render_column_skip
	
	mov ch,0
	mov bp,2

spectrum_render_column:

	mov ax,word [cs:si]
	mov word [ds:di],ax
	add di,bp
	mov word [ds:di],ax
	sub si,bp
	sub di,bx

	loop spectrum_render_column
	
spectrum_render_column_skip:

	mov cl,SPECTRUM_HEIGHT
	sub cl,dh
	je spectrum_fill_rest_done
	
	mov ch,0
	
	mov si,di
	add si,BUF_BACK
	mov bp,80*2
	mov dx,2

spectrum_fill_rest:

	mov ax,word [es:si+0]
	mov word [ds:di],ax
	add di,dx
	mov ax,word [es:si+2]
	mov word [ds:di],ax
	sub di,bx
	sub si,bp

	loop spectrum_fill_rest
	
spectrum_fill_rest_done:

	pop cx
	pop di

	mov al,cl
	mov ah,0
	shr ax,1
	dec ax
	
	cmp ax,SPECTRUM_HEIGHT-1
	jnc spectrum_skip_peak

	mov cx,80*2
	mul cx
	
	sub di,ax
	
	mov ax,[cs:spec_peak_color]
	mov word [ds:di+0],ax
	mov word [ds:di+2],ax
	
spectrum_skip_peak:

	pop di
	pop si
	pop cx
	
	inc si
	add di,4

	dec cx
	jne spectrum_render_loop
	
	pop ds
	
	ret
	
%endif
	
	
;------------------------------------------------------------------------------

%ifndef SNOW

spectrum_update:

	mov cx,40
	mov si,0

spectrum_update_loop:

	push si
	
	mov dl,[cs:spec_peak_value+si]
	mov dh,[cs:spec_peak_time+si]
	shl si,1
	mov bx,[cs:spec_array_value+si]
	
	cmp bx,SPECTRUM_HEIGHT*16
	jc spectrum_update_inc_0
	
	sub bx,40
	jnc spectrum_update_inc_0
	mov bx,0
	
spectrum_update_inc_0:

	sub bx,10
	jnc spectrum_update_inc_1
	mov bx,0
	
spectrum_update_inc_1:

	or dh,dh
	je spectrum_update_inc_2
	dec dh
	
	jmp spectrum_update_inc_3
	
spectrum_update_inc_2:

	or dl,dl
	je spectrum_update_inc_3
	dec dl
	
spectrum_update_inc_3:

	mov [cs:spec_array_value+si],bx
	shr si,1
	mov [cs:spec_peak_value+si],dl
	mov [cs:spec_peak_time+si],dh

	pop si
	inc si

	loop spectrum_update_loop

	ret
	
%endif


	
;------------------------------------------------------------------------------

clear_buf:

	mov di,BUF_TEXT
	mov cx,80*25
	mov ax,0
	
	rep stosw
	
	ret
	
	
;------------------------------------------------------------------------------

copy_back_to_buf:

	mov di,BUF_TEXT
	mov si,BUF_BACK
	mov cx,80*25
	
	;rep es movsw ;this won't work properly with enabled interrupts below 80386
	push ds
	mov ax,es
	mov ds,ax
	rep movsw
	pop ds
			
	ret

;------------------------------------------------------------------------------

copy_buf_to_screen:

	push ds			
	push es
	
	mov ax,es
	mov ds,ax
	mov ax,TEXT_VRAM
	mov es,ax
	
	mov di,0
	mov si,BUF_TEXT
	mov cx,80*25
	
	rep movsw
	
	pop es
	pop ds
	
	ret

;------------------------------------------------------------------------------
;AX returns scan code

read_key:

	push ds
	
	mov ax,0040h
	mov ds,ax
	
	mov si,001ah
	mov di,001ch
	
	mov bx,word [ds:si]		;head
	mov cx,word [ds:di]		;tail
	mov ax,0
	
	cmp bx,cx
	
	je read_key_done
	
	mov ax,word [ds:bx]
	mov word [ds:si],cx
	
	and ax,0ff00h

read_key_done:

	pop ds
	
	ret



;------------------------------------------------------------------------------
;AX=song number

music_play:

	push ax
	
	call music_stop
	
	pop ax
	
	mov cx,10
	mul cx
	mov bx,ax

	mov si,word [song_list+6+bx]
	
	mov di,BUF_MUSIC

	call DEC40

	mov di,BUF_MUSIC
	
	;mov al,byte [es:di]
	;mov ah,0
	
	;push ax	;ax=update rate, not used
	
	mov ax,0

	mov [cs:song_repeat],al
	mov [cs:song_done],al
	mov [cs:song_marker],al
	
	mov [cs:music_wait],ax
	mov [cs:music_period],ax
	
	inc di
	mov [cs:music_loop],di
	mov [cs:music_ptr],di	;enables playing

	ret
	

	
;------------------------------------------------------------------------------

music_stop:

	mov ax,0
	mov [cs:music_ptr],ax	;disables playing
	mov [cs:music_period],ax
	
	jmp sound_mute	;call/ret
	
	
	
;------------------------------------------------------------------------------

music_update:

	mov al,[cs:song_done]
	or al,al
	je music_not_done
	ret
	
music_not_done:
	
	mov ax,[cs:music_predelay]
	or ax,ax
	je music_no_predelay
	dec ax
	mov [cs:music_predelay],ax
	ret
	
music_no_predelay:

	mov di,[cs:music_ptr]

	mov al,[cs:music_wait]
	or al,al
	je music_update_loop
	
	dec al
	mov [cs:music_wait],al
	je music_update_loop
	
music_update_done:

	mov [cs:music_ptr],di
	
	ret
	
music_update_loop:

	mov al,byte [es:di]
	inc di
	
	or al,al
	je music_end
	cmp al,0ffh
	je music_marker
	
	mov [cs:music_wait],al

	mov ax,word [es:di]
	add di,2

	mov [cs:music_period],ax
	
	or ax,ax
	je music_update_mute
	
	out 42h,al
	xchg al,ah
	out 42h,al
	
	in al,61h
	or al,03h
	out 61h,al
	
	jmp music_update_done
	
music_update_mute:

	in al,61h
	and al,0fch
	out 61h,al
	
	jmp music_update_done

music_end:

	mov al,1
	mov [cs:song_done],al
	mov ax,0
	mov [cs:music_period],ax
	
	jmp music_update_done
	
music_marker:

	;first time it is loop start point, second time it is loop end point
	
	mov al,[cs:song_marker]
	or al,al
	jne music_marker_set
	
	mov [cs:music_loop],di	;remember loop start
	
	mov al,1
	mov [cs:song_marker],al

	jmp music_update_loop
	
music_marker_set:

	;song repeat logic

	mov al,[cs:playlist_repeat]
	or al,al
	je music_marker_go_loop		;0 infinite repeat, always take loop
	
	mov al,[cs:song_repeat]
	inc al
	mov [cs:song_repeat],al
	cmp al,[cs:playlist_repeat]
	jnc music_update_loop		;when number of repeats reached, don't take loop

music_marker_go_loop:

	mov di,[cs:music_loop]	;loop end, go to loop start
	
	jmp music_update_loop
	
	
	
;------------------------------------------------------------------------------
;CX=timer interrupt frequency in Hz

set_timer_isr:

	mov al,[cs:t_isr_installed]
	or al,al
	jne set_timer_ret
	
	cli

	mov al,036h
	out 043h,al
	mov al,036h
	out 043h,al
	in al,061h
	and al,0fch
	out 061h,al
	
				
	mov dx,1193180/65536		;divide 1193180 by CX (frequency in Hz)
	mov ax,1193180&65535
	div cx						;result in AX
				
	mov [cs:t_isr_delta],ax
	
	out 040h,al
	mov al,ah
	out 040h,al

	mov ax,0
	mov [cs:t_isr_accum],ax
	
	push ds
	
	mov ds,ax
	mov si,32
	
	mov ax,[ds:si]
	mov [cs:t_isr_std_doff],ax
	add si,2
	
	mov ax,[ds:si]
	mov [cs:t_isr_std_dseg],ax
	sub si,2
		
	mov ax,timer_custom_isr
	mov [ds:si],ax
	add si,2
	
	mov ax,cs
	
	mov [ds:si],ax
	
	pop ds
	
	mov al,1
	mov [cs:t_isr_installed],al

	sti
		
set_timer_ret:

	ret
	
		
	
;------------------------------------------------------------------------------

restore_timer_isr:

	mov al,[cs:t_isr_installed]
	or al,al
	je restore_timer_ret
	
	cli

	push ds
	
	mov ax,0
	mov ds,ax
	mov si,32
	
	mov ax,[cs:t_isr_std_doff]
	mov [ds:si],ax
	add si,2
	
	mov ax,[cs:t_isr_std_dseg]
	mov [ds:si],ax
	
	pop ds
	
	mov al,54
	out 43h,al
	mov ax,0
	
	out 40h,al
	xchg al,ah
	out 40h,al
	
	mov al,0
	mov [cs:t_isr_installed],al
	
	sti
	
restore_timer_ret:

	ret
	
	
	
;------------------------------------------------------------------------------

timer_custom_isr:
	
	push ax
	push bx
	push cx
	push dx
	push bp
	push si
	push di
	push ds
	push es
	
%ifndef SNOW
	call spectrum_update
%endif
	mov ax,[cs:music_ptr]
	or ax,ax
	je timer_custom_no_music
	
	mov ax,[cs:extra_seg]
	mov es,ax
	
	call music_update
	
	mov ax,[cs:music_period]
	or ax,ax
	je timer_custom_no_music

%ifndef SNOW
	call spectrum_add
%endif
	
timer_custom_no_music:

	mov ax,[cs:t_isr_accum]
	add ax,[cs:t_isr_delta]
	mov [cs:t_isr_accum],ax

	mov al,20h
	out 20h,al

	pop es
	pop ds
	pop di
	pop si
	pop bp
	pop dx
	pop cx
	pop bx
	pop ax

	jc timer_custom_back

	iret
	
timer_custom_back:

	jmp far [cs:t_isr_std_doff]
	
	
	
	
	
;------------------------------------------------------------------------------


	%include "unmegalz.asm"
	
	

spectrum_grad:

	dw 16,24,32,48,128,48,32,24,16

spectrum_color:

	dw 0f00h+SPECTRUM_COLUMN,0b00h+SPECTRUM_COLUMN,0b00h+SPECTRUM_COLUMN,0b00h+SPECTRUM_COLUMN		;blue
	dw 0a00h+SPECTRUM_COLUMN,0a00h+SPECTRUM_COLUMN,0a00h+SPECTRUM_COLUMN,0300h+SPECTRUM_COLUMN
	dw 0300h+SPECTRUM_COLUMN,0300h+SPECTRUM_COLUMN,0900h+SPECTRUM_COLUMN,0900h+SPECTRUM_COLUMN
	dw 0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN
	dw 0,0,0,0,0916h
	
	dw 0f00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN		;green/yellow
	dw 0a00h+SPECTRUM_COLUMN,0a00h+SPECTRUM_COLUMN,0a00h+SPECTRUM_COLUMN,0200h+SPECTRUM_COLUMN
	dw 0200h+SPECTRUM_COLUMN,0200h+SPECTRUM_COLUMN,0600h+SPECTRUM_COLUMN,0600h+SPECTRUM_COLUMN
	dw 0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN
	dw 0,0,0,0,0416h
	
	dw 0f00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN		;red/magenta
	dw 0d00h+SPECTRUM_COLUMN,0d00h+SPECTRUM_COLUMN,0c00h+SPECTRUM_COLUMN,0c00h+SPECTRUM_COLUMN
	dw 0600h+SPECTRUM_COLUMN,0600h+SPECTRUM_COLUMN,0400h+SPECTRUM_COLUMN,0400h+SPECTRUM_COLUMN
	dw 0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN
	dw 0,0,0,0,0116h
	
	dw 0f00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN,0e00h+SPECTRUM_COLUMN		;blue/magenta
	dw 0d00h+SPECTRUM_COLUMN,0d00h+SPECTRUM_COLUMN,0d00h+SPECTRUM_COLUMN,0900h+SPECTRUM_COLUMN
	dw 0900h+SPECTRUM_COLUMN,0900h+SPECTRUM_COLUMN,0100h+SPECTRUM_COLUMN,0100h+SPECTRUM_COLUMN
	dw 0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN,0000h+SPECTRUM_COLUMN
	dw 0,0,0,0,0116h
	
	
song_list:		;cursor position, move to left/right/up/down, data pointer

	dw  8*160+12*2,16+16*256,22+ 1*256,song_sys,str_sys	;0
	dw  9*160+12*2,17+17*256, 0+ 2*256,song_tmb,str_tmb	;1
	dw 10*160+12*2,18+18*256, 1+ 3*256,song_btl,str_btl	;2
	dw 11*160+12*2,19+19*256, 2+ 4*256,song_mnc,str_mnc	;3
	dw 12*160+12*2,20+20*256, 3+ 5*256,song_hst,str_hst	;4
	dw 13*160+12*2,21+21*256, 4+ 6*256,song_bad,str_bad	;5
	dw 14*160+12*2,21+21*256, 5+ 7*256,song_dld,str_dld	;6
	dw 15*160+12*2,22+22*256, 6+ 8*256,song_hsh,str_hsh	;7
	dw 16*160+12*2,22+22*256, 7+ 9*256,song_flo,str_flo	;8
	dw 17*160+12*2,22+22*256, 8+10*256,song_pxl,str_pxl	;9
	dw 18*160+12*2,22+22*256, 9+11*256,song_ssd,str_ssd	;10
	dw 19*160+12*2,22+22*256,10+12*256,song_led,str_led	;11
	dw 20*160+12*2,22+22*256,11+13*256,song_clo,str_clo	;12
	dw 21*160+12*2,22+22*256,12+14*256,song_txr,str_txr	;13
	dw 22*160+12*2,22+22*256,13+15*256,song_srv,str_srv	;14
	dw 23*160+12*2,22+22*256,14+16*256,song_stf,str_stf	;15

	dw  8*160+45*2,0+0*256,15+17*256,song_asf,str_asf	;16
	dw  9*160+45*2,1+1*256,16+18*256,song_run,str_run	;17
	dw 10*160+45*2,2+2*256,17+19*256,song_mym,str_mym	;18
	dw 11*160+45*2,3+3*256,18+20*256,song_sqw,str_sqw	;19
	dw 12*160+45*2,4+4*256,19+21*256,song_fin,str_fin	;20
	dw 13*160+45*2,5+5*256,20+22*256,song_coy,str_coy	;21

	dw 15*160+45*2,7+7*256,21+0*256,song_aon,str_aon	;22
	
	dw 0
	
	
str_asf:			db "Astro Force",0
str_btl:			db "Battery Low",0
str_mym:			db "My Mission",0
str_sqw:			db "Square Wave",0
str_bad:			db "Bad Sector",0
str_pxl:			db "Pixel Rain",0
str_dld:			db "Dial-Down",0
str_hst:			db "Head Step",0
str_txr:			db "TX/RX",0
str_mnc:			db "Monoculear",0
str_sys:			db "System Beeps",0
str_run:			db "Run Under Fire",0
str_stf:			db "Staff Roll",0
str_tmb:			db "Too Many Bits",0
str_led:			db "Twinkle LED",0
str_srv:			db "Serverside",0
str_aon:			db "AONDEMO Soundtrack",0
str_clo:			db "Clocking Ticks",0
str_coy:			db "Coming Year",0
str_fin:			db "Final Stretch",0
str_flo:			db "Floppy Flips",0
str_ssd:			db "Single-Sided Drive",0
str_hsh:			db "Handshake",0

screen_packed:		incbin "res\screen.mlz"

song_asf:			incbin "res\asf.mlz"
song_btl:			incbin "res\btl.mlz"
song_mym:			incbin "res\mym.mlz"
song_sqw:			incbin "res\sqw.mlz"
song_bad:			incbin "res\bad.mlz"
song_pxl:			incbin "res\pxl.mlz"
song_dld:			incbin "res\dld.mlz"
song_hst:			incbin "res\hst.mlz"
song_txr:			incbin "res\txr.mlz"
song_mnc:			incbin "res\mnc.mlz"
song_sys:			incbin "res\sys.mlz"
song_run:			incbin "res\run.mlz"
song_stf:			incbin "res\stf.mlz"
song_tmb:			incbin "res\tmb.mlz"
song_led:			incbin "res\led.mlz"
song_srv:			incbin "res\srv.mlz"
song_aon:			incbin "res\aon.mlz"
song_clo:			incbin "res\clo.mlz"
song_coy:			incbin "res\coy.mlz"
song_fin:			incbin "res\fin.mlz"
song_flo:			incbin "res\flo.mlz"
song_ssd:			incbin "res\ssd.mlz"
song_hsh:			incbin "res\hsh.mlz"

playlist_mode_str:	db "one ord rnd "

t_isr_installed:	db 0
t_isr_delta:		dw 0
t_isr_accum:		dw 0
t_isr_std_doff:		dw 0
t_isr_std_dseg:		dw 0

playlist_mode:		db 0		;0 single, 1 order, 2 shuffle
playlist_repeat:	db 0		;0 INF 1..9 number of repeats

song_cursor:		dw 0
song_cursor_blink:	dw 0
song_repeat:		db 0
song_done:			db 0
song_marker:		db 0

osd_timeout:		db 0

rand_w:				dw 0
rand_b:				db 0

music_ptr:			dw 0
music_loop:			dw 0
music_wait:			dw 0
music_period:		dw 0
music_predelay:		dw 0

extra_seg:			dw 0

spec_color_id:		dw 0
spec_array_color:	dw 0
spec_peak_color:	dw 0
spec_array_value:	times 40 dw 0
spec_peak_value:	times 40 db 0
spec_peak_time:		times 40 db 0
