#include <stdio.h>
#include <malloc.h>
#include <png.h>
#define UNPACK_STUB "<canvas id=Z><img onerror=src=location onload=for(C=Z.getContext(\"2d\"),S=\"\";!S;)for(L=Z.width=%u,C.drawImage(this,I=0,0),D=C.getImageData(0,0,L,1).data;I<L;S+=D[I*4]?String.fromCharCode(D[I*4]):'',I++);eval(S) src=#>"
#define UNPACK_REV_STUB "<canvas id=Z><img onerror=src=location onload=for(C=Z.getContext(\"2d\"),S=\"\";!S;)for(L=Z.width=%u,C.drawImage(this,0,0),D=C.getImageData(0,0,L,1).data;L--;S+=D[L*4]?String.fromCharCode(D[L*4]):'');eval(S) src=#>"
#define VER "0.3"

void reverseBytes(void *start, int size){
    unsigned char *lo = start;
    unsigned char *hi = start + size - 1;
    unsigned char swap;
    while(lo<hi){swap = *lo;*lo++ = *hi;*hi-- = swap;}
}

int writeWithFilter(char *fname, png_bytep buffer, int width, int fltr, int dir){
	FILE *fp;
	fp=fopen(fname,"wb");
	if(!fp){fprintf(stderr, "Could not open file %s for writing\n",fname);return 0;}
	png_structp png_ptr;
	png_infop info_ptr;
	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	if(!png_ptr){fprintf(stderr, "Could not allocate write struct\n");return 0;}
	info_ptr = png_create_info_struct(png_ptr);
	if(!info_ptr){fprintf(stderr, "Could not allocate info struct\n");return 0;}
	if(setjmp(png_jmpbuf(png_ptr))){fprintf(stderr, "I/O error, try again...\n");return 0;}
	rewind(fp);
	png_init_io(png_ptr, fp);
	png_set_IHDR(png_ptr, info_ptr, width,1,8, PNG_COLOR_TYPE_GRAY, PNG_INTERLACE_NONE,	PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);
	png_set_compression_level(png_ptr,9);
	png_write_info(png_ptr, info_ptr);
	png_set_filter(png_ptr, PNG_FILTER_TYPE_BASE, fltr);
	if(dir)reverseBytes(buffer,width);
	png_write_row(png_ptr,buffer);
	if(dir)reverseBytes(buffer,width);
	if(info_ptr)png_free_data(png_ptr, info_ptr, PNG_FREE_ALL, -1);
	if(png_ptr)png_destroy_write_struct(&png_ptr, (png_infopp)NULL);
	if(fp)fclose(fp);
	fp=fopen(fname,"rb+");
	fseek(fp,33,SEEK_SET);
	fputc('<',fp);fputc('!',fp);fputc('-',fp);fputc('-',fp);
	fseek(fp,-3,SEEK_END);
	fputc('-',fp);fputc('-',fp);fputc('>',fp);
	fseek(fp,0,SEEK_END);
	fprintf(fp,dir?UNPACK_REV_STUB:UNPACK_STUB,width);
	int csize=ftell(fp);
	if(fp)fclose(fp);
	return csize;
}

int main(int argc, char *argv[]) {
	FILE *infile;
	int width,code=0;
	png_bytep buffer;
	printf("PunkJS %s by Suborg\nbuilt on %s\n",VER,__DATE__);
	if(argc!=3){fprintf(stderr, "Please specify input and output file\n");return 1;}
	infile=fopen(argv[1],"rb");
	if(!infile){fprintf(stderr, "Could not open file %s for reading\n",argv[1]);return 1;}
	fseek(infile,0,SEEK_END);
	width=ftell(infile);
	rewind(infile);
	buffer=(png_bytep)malloc(width*sizeof(png_byte));
	if(!fread(buffer,1,width,infile)){fprintf(stderr, "Could not read input data from %s\n",argv[1]);return 1;}
	int fltr,opt_fltr=0,opt_dir=0,min_size=width,csize;
	for(fltr=0;fltr<5;fltr++) {
		csize=writeWithFilter(argv[2],buffer,width,fltr,0);
		if(csize<min_size){min_size=csize;opt_fltr=fltr;opt_dir=0;}
		csize=writeWithFilter(argv[2],buffer,width,fltr,1);
		if(csize<min_size){min_size=csize;opt_fltr=fltr;opt_dir=1;}
	}
	printf("Optimal filter code: %u, optimal direction: %s\n",opt_fltr,opt_dir?"reverse":"forward");
	csize=writeWithFilter(argv[2], buffer, width, opt_fltr, opt_dir);
	printf("Output HTML code saved into %s - packed size is %u bytes\n",argv[2],csize);
end:
	free(buffer);
	fclose(infile);
	return code;
}