;============================================================================
; BR?-TK-HUE! - Parts 2 and 3
;
; The second brazilian demo for TK90X 
;
; Authors:  TK90Fan (code and graphics)
;           raphaelgoulart (musics)
; Additional code by: Einar Saukas (FZX driver and ZX7)
;
; Date: 10/06/2014
;============================================================================

;============================================================================
; Labels
;============================================================================

    INCLUDE "Header_Print.asm"
    INCLUDE "Header_Basic.asm"

; Labels for part 3. 
huehue.bitmap   EQU 24000
huehue.attr     EQU huehue.bitmap+21600
huehue.nlin EQU 45
huehue.ncol EQU 60

;============================================================================
; Entry point for part 2
;============================================================================
 
    ORG 25088
    JP P2Main               ; Jump to main program of part 2. 
;
; Following lines are for debugging purposes. 
ld sp,Pad1
ld sp,Pad2
ld sp,Pad3
ld sp,Pad4

;============================================================================
; Variables
;============================================================================
Pad0
    DEFS 25600-$            ; Padding bytes (attribute buffer address must be
                            ;multiple of 1024). 

P2AttrBuff                  ; Attribute buffer for part 2 at 25600. 
    DEFS 768

;============================================================================
; Data
;============================================================================

;----------------------------------------------------------------------------
; ASM data file from a ZX-Paintbrush picture with 456 x 296 pixels (= 57 x 
;37 characters) and an attribute area of 2109 bytes.
;----------------------------------------------------------------------------

    INCLUDE "tk90x2.asm"

;----------------------------------------------------------------------------
; Strings
;----------------------------------------------------------------------------

P2msg
    DEFM "BR?-TK-HUE!"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "TK90X Fan & raphaelgoulart"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "O segundo demo brasileiro para TK90X. | "
    DEFM "The second brazilian demo for TK90X. "
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM 127, " 2014"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 8,"*"              ; Repeat "*" 8 times.
    DEFB 6," "              ; Repeat " " 6 times.  
    DEFM "Sinclair......   "
    DEFM "BR?......   "
    DEFM "Microdigital!!!   "
    DEFM "HUEHUEHUE!!!   "
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 8,"*"              ; Repeat "*" 8 times.
    DEFB 6," "              ; Repeat " " 6 times.  
    DEFM "ZX-81 ......   "
    DEFM "BR?......   "
    DEFM "TK82-C!!! TK83!!! TK85!!!   "
    DEFM "HUEHUEHUE!!!   "
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 8,"*"              ; Repeat "*" 8 times.
    DEFB 6," "              ; Repeat " " 6 times.  
    DEFM "ZX Spectrum......   "
    DEFM "BR?......   "
    DEFM "TK90X!!! TK95!!!   "
    DEFM "HUEHUEHUE!!!   "
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 8,"*"              ; Repeat "*" 8 times.
    DEFB 20," "             ; Repeat " " 20 times.  
    DEFB 0                  ; End of string separator. 

;============================================================================
; Main program - part 2
;============================================================================

P2Main
    DI                      ; Turn off interrupts. 
    XOR A                   ; Black border. 
    OUT (254),A
; Erase TRDOS or ZX Interface 1 variables to free up space. Part 3 will use
;RAM from 24000. 
    INCLUDE "ReclaimTRDOSVars.asm"
; Erase BASIC program. 
    LD DE,(PROG)            ; See "Header_Basic.asm" for details. 
    LD HL,(VARS)
    CALL RECLAIM_1
; Prepare IM 2. 
    LD A,0xFE               ; Interrupt vector MSB is 0xFE (254). 
    LD I,A
    IM 2                    ; Interrupt mode 2.
    LD B,0                  ; Make a table of interrupt vector LSB values. 
    LD HL,0xFE00
P2Main.l0
    LD (HL),0xFD
    INC HL
    DJNZ P2Main.l0
    LD (HL),0xFD
    LD A,0xC3               ; Opcode for JP. 
    LD (0xFDFD),A           ; Put "JP IntRoutine" at 0xFDFD (65021). 
    LD HL,IntRoutine
    LD (0xFDFE),HL
; Initialize music player. 
    CALL 49152
    LD IY,0                 ; Reset interrupt counter. 
    EI
; Prepare attribute buffer. 
    CALL ClearAttrBuf       ; All characters must be taken from Plane 1. 
; Part 2 main loop.
P2Main.loop
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    LD A,IYh                ; Message scrolling starts after 256 interrupt
    OR A                    ;cycles (5.12 seconds). 
    CALL NZ,ScrlPlane2      ; Message scrolling. 
    XOR A                   ; Exit part 2 when space or enter was pressed. 
    IN A,(254)
    RRCA
    JR NC,P3Init
    LD A,IYh                ; Repeat until scrolling message is showed 3 times
    CP 124                  ;(10 minutes and 35 seconds). 
    JR NZ,P2Main.loop

;   Prepare to go to the part 3. 
P3Init
    CALL ClearAttrBuf       ; Clear plane 2. 
    CALL AnimScreen         ; Show plane 1 still picture. 
;
    LD HL,63488             ; Change attribute buffer address. 
    LD (AttrBuffAdd),HL
    LD HL,huehue.bitmap     ; Change plane 1 parameters. 
    LD (Plane1BmapAddr),HL
    LD HL,huehue.attr
    LD (Plane1AttrAddr),HL
    LD HL,huehue.ncol
    LD (Plane1Size.Col),HL
    LD HL,huehue.nlin
    LD (Plane1Size.Lin),HL
    LD HL,0                 ; Reset plane 1 animation parameters. 
    LD (Plane1Coord.Col),HL
    LD (Plane1Coord.Lin),HL
    LD A,1
    LD (Plane1Delta.Col),A
    LD (Plane1Delta.Lin),A
;
    JP P3Main               ; Start part 3 of demo. 


;============================================================================
; Subroutines
;============================================================================

;----------------------------------------------------------------------------
; Padding bytes
;----------------------------------------------------------------------------
Pad1
    DEFS 48300-$

;----------------------------------------------------------------------------
; ClearAttrBuf
;
; Description: the attribute buffers contains attribute values that must be
;transferred to video RAM area (values with low bit 7) or map of 8x8 pixel
;cells that must be taken from video plane 1 (values with high bit 7).
; Used registers: AF, BC=0, DE=HL+1, HL=address of attribute buffer last byte. 
;----------------------------------------------------------------------------

ClearAttrBuf
    LD A,255
ClearAttrBuf1           ; In this entry point, A value must be specified. 
    LD HL,(AttrBuffAdd) ; HL is attribute buffer pointer.
    LD (HL),A           ; Raise bit 7 to disable video plane 2. 
    LD E,L              ; DE is pointer that always has one position after
    LD D,H              ;HL. 
    INC DE
    LD BC,767           ; Copy to full attribute area. 
    LDIR
    RET                 ; End of subroutine. 

;------------------------------------------------------------------------------
; ScrlPlane2
; 
; Description: scrolling message at second plane. 
; Used registers: AF, BC, DE, HL, IX. 
;------------------------------------------------------------------------------

ScrlPlane2
    LD A,(ScrollP2Bits)
    OR A                    ; Test whether exist bits to be scrolled.
    JR Z,ScrlPlane2.j0      ; Jump if not. 
    DEC A                   ; Decrement counter. 
    LD (ScrollP2Bits),A
    CALL AScrlLft           ; Scroll attributes to left. 
    LD E,8                  ; 8 lines. 
    LD IX,ModelChr6         ; IX points to character bitmap model. 
    LD BC,256*10+31         ; B=line 10 and C=column 31. 
ScrlPlane2.l1
    CALL ACoordAdd          ; Calculate address of BC at attribute buffer. 
    RLC (IX+0)              ; Test bit 7. 
    JR NC,ScrlPlane2.j1
    LD (HL),64+8*3+3        ; Bright 1 + Paper 3 + Ink 3. 
ScrlPlane2.j1
    INC B                   ; Go to one line below. 
    INC IX                  ; Next byte of character model. 
    DEC E                   ; Decrement counter and repeat for all 8 bytes
    JR NZ,ScrlPlane2.l1     ;of character. 
    RET                     ; End of routine. 
;
ScrlPlane2.j0
    LD IX,ScrollP2Bits
    LD (IX+0),6             ; Initialize number of bits to be scrolled. 
    LD HL,(StringP2Ptr)     ; Fetch string pointer. 
    LD A,(ScrollP2Rep)      ; Test whether last character must be repeated.
    OR A
    JR Z,ScrlPlane2.j2      ; Jump if not. 
    DEC (IX+1)              ; Decrement repetition counter. 
    DEC HL                  ; Decrement pointer. 
ScrlPlane2.j2
    LD A,(HL)               ; Take one character of string.
    OR A                    ; Test if end of string separator. 
    JR NZ,ScrlPlane2.j3     ; Jump if not. 
    LD HL,(StringP2Ini)
    LD (StringP2Ptr),HL
    LD A,(HL)
ScrlPlane2.j3
    CP 32                   ; Test whether character is less than 32.
    JR NC,ScrlPlane2.j4     ; Jump if not. 
    DEC A
    LD (ScrollP2Rep),A
    INC HL                  ; Take next character (it must be printable). 
    LD A,(HL)
ScrlPlane2.j4
    INC HL
    LD (StringP2Ptr),HL
    CALL MakeChr6
    JP ScrlPlane2

;------------------------------------------------------------------------------
; AScrlLft
; --------
; Scroll leftwise the color attributes in plane 2. 
;------------------------------------------------------------------------------
;
AScrlLft
    LD HL,(AttrBuffAdd)
    LD E,L
    LD D,H
    INC HL
    LD BC,767
    LDIR
    EX DE,HL
    LD DE,-32
    LD B,24
AScrlLft.l
    LD (HL),255
    ADD HL,DE
    DJNZ AScrlLft.l
    RET

;------------------------------------------------------------------------------
; AScrlRgt
; --------
; Scroll rightwise the color attributes in plane 2. 
;------------------------------------------------------------------------------
;
AScrlRgt
    LD HL,(AttrBuffAdd)
    LD BC,767
    ADD HL,BC
    LD E,L
    LD D,H
    DEC HL
    LDDR
    EX DE,HL
    LD DE,32
    LD B,24
AScrlRgt.l
    LD (HL),255
    ADD HL,DE
    DJNZ AScrlRgt.l
    RET

;------------------------------------------------------------------------------
; MakeChr6
; Make 6x8 pixel bitmap model of a character, based on 8x8 model stored in the 
;ROM.
;------------------------------------------------------------------------------
MakeChr6
    PUSH AF             ; Save character value. 
    LD DE,15360         ; Address of ROM character bitmap subtracted by 256. 
    LD H,E              ; H=0. 
    LD L,A              ; HL=character code. 
    ADD HL,HL           ; Multiply by 8 (each character is composed by 8 bytes). 
    ADD HL,HL
    ADD HL,HL
    ADD HL,DE           ; Add DE and get character address at ROM bitmap. 
    CALL AdjChr6        ; Define what bit of character will be discarded. 
    LD DE,ModelChr6     ; Pointer for 8 bytes character bitmap to be made. 
    LD C,8              ; Counter for 8 bytes. 
MakeChr6.l1
    PUSH DE             ; Save pointer. 
    LD B,6              ; Counter for width of 6 pixels. 
    XOR A               ; Initialize bitmap byte to 0. 
    LD D,(HL)           ; Take character bitmap from ROM. 
MakeChr6.l2
    RR D                ; Transfer leftmost bit to C flag. 
    EX AF,AF'           ; Take value of iteration when bit will be discarded. 
    CP B                ; Discard next bit if necessary, rotating D register
    JR NZ,MakeChr6.j    ;bits again. 
    RR D
MakeChr6.j
    EX AF,AF'           ; Restore bitmap and C flag values. 
    RRA                 ; Transfer C flag to rightmost bit of bitmap. 
    DJNZ MakeChr6.l2    ; Repeat until all 6 bits are tranferred. 
    POP DE              ; Fetch saved pointer. 
    LD (DE),A           ; Save 6 bit character bitmap to RAM. 
    INC DE              ; Increment pointers. 
    INC HL
    DEC C               ; Update counter. 
    JR NZ,MakeChr6.l1   ; Repeat until all 8 bytes are made. 
    POP AF              ; Recover character value.
    CP "Y"              ; Modify "Y" bitmap in ad-hoc manner. 
    RET NZ
    LD A,%10001000
    LD (ModelChr6+1),A
    RET                 ; End of subroutine. 
;
; This subroutine select what bit of character bitmap will be discarded.
; Input: A=character. 
; Output: A'=bit of character to be discarded. 
; Registers used: F, F'. 
AdjChr6
    EX AF,AF'
    LD A,5              ; Bit 2 will be discarded of
    EX AF,AF'
    CP "0"              ;"0" and
    RET Z
    CP "N"              ;"N".
    RET Z
    EX AF,AF'
    LD A,1              ; Bit 6 will be discarded of
    EX AF,AF'
    CP "#"              ;any character until "1" except "#",
    JR Z,AdjChr6.j1
    CP "1"+1
    RET C
    CP "7"              ;"7",
    RET Z
    CP "I"              ;"I",
    RET Z
    CP "b"              ;"b",
    RET Z
    CP "<"              ;"<", "=" and ">". 
    JR C,AdjChr6.j1
    CP ">"+1
    RET C
AdjChr6.j1
    EX AF,AF'
    LD A,3              ; Bit 4 will be discarded of
    EX AF,AF'
    CP "4"              ;any character until "X" except "4", 
    JR Z,AdjChr6.j2
    CP ":"              ;":",
    JR Z,AdjChr6.j2
    CP ";"              ;";" and
    JR Z,AdjChr6.j2
    CP "T"              ;"T". 
    JR Z,AdjChr6.j2
    CP "X"+1
    RET C
AdjChr6.j2
    LD A,6              ; Bit 1 will be discarded of any other characters. 
    EX AF,AF'
    RET

;------------------------------------------------------------------------------
; ACoordAdd
; ---------
; Calculate address of attribute cell from coordinates held by BC. B holds
;vertical coordinate (line) and C, horizontal coordinate (column).
; Label ABaseAdd is equal to address of first byte of attributes at RAM (usually
;at 22528/#5800). This address must be multiple of 1024/#0400). 
; Input: B=line coord. (0-23); C=column coord. (0-31).
; Output: HL=cell address; flag C=0 if coordinates is outside limits.
; Used registers: AF, BC (unchanged), HL. 
;------------------------------------------------------------------------------
;
ACoordAdd
    LD A,B                  ; Return if line>=24 (legal values are 0-23), with
    CP 24                   ;carry flag lowered. 
    RET NC
    LD A,C                  ; Return if column > 31 (legal values are 0-31). 
    AND %11100000           ; Carry flag is lowered.
    RET NZ
    LD H,B                  ; Calculate higher byte of address (bits 4 and 5 of
    RR H                    ;line). A is 0. 
    RRA
    RR H
    RRA
    RR H
    RRA                     ; A contains three least significant bits of line. 
    OR C                    ; Merge with 5-bit column value. 
    LD L,A
    LD A,(AttrBuffAdd+1)    ; Fetch MSB of buffer address. 
    OR H
    LD H,A
    SCF                     ; Raise carry flag (coordinates are legal).
    RET

;------------------------------------------------------------------------------
; AnimScreen
;------------------------------------------------------------------------------

AnimScreen
    LD A,(Plane1Coord.Col)  ; Fetch column. 
    LD HL,Plane1Delta.Col   ; HL is pointer to delta column. 
    ADD A,(HL)
    LD C,A
    CP 0
    CALL C,InvDelta
    LD A,(Plane1Size.Col)
    SUB 32
    CP C
    LD A,C
    CALL C,InvDelta
    LD (Plane1Coord.Col),A
    LD C,A
;
    LD A,(Plane1Coord.Lin)  ; Fetch line. 
    INC HL                  ; HL is pointer to delta line. 
    ADD A,(HL)
    LD B,A
    CP 0
    CALL C,InvDelta
    LD A,(Plane1Size.Lin)
    SUB 24
    CP B
    LD A,B
    CALL C,InvDelta
    LD (Plane1Coord.Lin),A
    LD B,A
    RET
;
InvDelta
    SUB (HL)
    EX AF,AF'
    LD A,R
    AND %00000011
    JP NZ,InvDelta.j0
    INC A
InvDelta.j0
    LD D,A
    LD A,(HL)
    AND %11111100
    OR D
    NEG
    LD (HL),A
    EX AF,AF'
    RET 

;------------------------------------------------------------------------------
; Plan1Screen
; Copy screen from model to video RAM. 
; Input:    BC=coordinates (B=character line, C=column).
;------------------------------------------------------------------------------

B1  EQU 16384
B2  EQU B1+2048
B3  EQU B2+2048

Plan1Screen

    HALT
    LD DE,B1+32*0
    CALL Plan1Line
    INC B
    LD DE,B1+32*1
    CALL Plan1Line
    INC B
    LD DE,B1+32*2
    CALL Plan1Line
    INC B
    LD DE,B1+32*3
    CALL Plan1Line
    INC B
    LD DE,B1+32*4
    CALL Plan1Line
    INC B
    LD DE,B1+32*5
    CALL Plan1Line
    INC B
    LD DE,B1+32*6
    CALL Plan1Line
    INC B
    LD DE,B1+32*7
    CALL Plan1Line
    INC B

    HALT
    LD DE,B2+32*0
    CALL Plan1Line
    INC B
    LD DE,B2+32*1
    CALL Plan1Line
    INC B
    LD DE,B2+32*2
    CALL Plan1Line
    INC B
    LD DE,B2+32*3
    CALL Plan1Line
    INC B
    LD DE,B2+32*4
    CALL Plan1Line
    INC B
    LD DE,B2+32*5
    CALL Plan1Line
    INC B
    LD DE,B2+32*6
    CALL Plan1Line
    INC B
    LD DE,B2+32*7
    CALL Plan1Line
    INC B

    HALT
    LD DE,B3+32*0
    CALL Plan1Line
    INC B
    LD DE,B3+32*1
    CALL Plan1Line
    INC B
    LD DE,B3+32*2
    CALL Plan1Line
    INC B
    LD DE,B3+32*3
    CALL Plan1Line
    INC B
    LD DE,B3+32*4
    CALL Plan1Line
    INC B
    LD DE,B3+32*5
    CALL Plan1Line
    INC B
    LD DE,B3+32*6
    CALL Plan1Line
    INC B
    LD DE,B3+32*7
    CALL Plan1Line
    INC B
    RET

;----------------------------------------------------------------------------
; Delay24BC
;
; Long delay rotine, the main loop delay is 24 T. An overhead of 27 T must be
;accounted for CALL and RET instructions. 
;
; Equation of delay duration: (24*BC+27) T
; Minimum delay (BC=1): 51 T
; Maximum delay (BC=0): 1 572 891 T
; Input: BC=number of cycles
; Output: A=B=C=0
; Registers used: AF, BC. 
;----------------------------------------------------------------------------

    INCLUDE "Delay24BCT.asm"

;------------------------------------------------------------------------------
; Plan1Line
; Copy 1 character line (composed by 8 pixel lines) from model to video RAM. 
; Input:    DE=destiny address at video RAM; BC=coordinates (B=character line,
;           C=column).
;------------------------------------------------------------------------------
Plan1Line
    PUSH BC                 ; Save coordinates twice. 
    PUSH BC
    PUSH DE                 ; Save initial destiny address twice. 
    PUSH DE
; Calculate initial address of byte to be copied from bitmap of model. The 
;address is given by: (number of columns by line)*(character line coordinate)*
;*(number of pixel lines per character line). 
    LD A,B                  ; Line coordinate of model. 
    LD DE,(Plane1Size.Col)  ; Number of columns per line multiplied by 8 pixel
    SLA E                   ;lines.  
    RL D
    SLA E
    RL D
    SLA E
    RL D
    LD HL,(Plane1BmapAddr)  ; Start of bitmap address.
    CALL Mul8+3             ; HL=HL+DE*A (first instructions of subroutine is
                            ; skipped). 
    ADD HL,BC               ; Add column coordinate (B=0 after executing Mul8).
    POP DE                  ; Restore initial destiny address. 
; Copy bitmap from model to video RAM. 
    LD A,8                  ; 8 pixel lines. 
Plan1Line.l0
    PUSH DE                 ; Save destiny address. 
    PUSH HL                 ; Save origin address.

    LDI                     ; Copy entire line of pixels (32 bytes). 
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI

    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI

    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI

    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI
    LDI

    POP HL
    LD DE,(Plane1Size.Col)  ; Calculate address of next pixel line. 
    ADD HL,DE 
    POP DE                  ; Restore destiny address. 
    INC D                   ; Calculate next address at video RAM. 
    DEC A
    JP NZ,Plan1Line.l0      ; Repeat until 8 pixel lines were copied. 
; Calculate address of attribute area of video RAM. 
    POP DE                  ; Restore destiny address (D=%010TT000), TT is 00,
                            ;01 or 10 (what third of video RAM will be written).
    SET 7,D                 ; D=%110TT000.
    SRL D                   ; D=%0110TT00.
    SCF
    RR D                    ; D=%10110TT0.
    SRL D                   ; D=%010110TT. 
; Calculate initial address of byte to be copied from attributes of model. 
    POP BC                  ; Restore coordinates.
    PUSH DE
; Calculate initial address of byte to be copied from bitmap of model. The 
;address is given by: (number of columns by line)*(character line coordinate)*
;*(number of pixel lines per character line). 
    LD A,B                  ; Line coordinate of model. 
    LD DE,(Plane1Size.Col)  ; Number of columns per line.  
    LD HL,(Plane1AttrAddr)  ; Start of attribute address.
    CALL Mul8+3             ; HL=HL+DE*A (first instructions of subroutine is
                            ; skipped). 
    ADD HL,BC               ; Add column coordinate (B=0 after executing Mul8).
; Copy attributes from model to video RAM. 
    POP DE
    LD IX,(AttrBuffAdd)
    ADD IX,DE
    LD BC,-22528
    ADD IX,BC
    LD BC,32*256+255
Plan1Line.l1
    LDI
    LD A,(IX+0)
    INC IX
    BIT 7,A
    JR NZ,Plan1Line.j0
    DEC DE
    LD (DE),A
    INC DE
Plan1Line.j0
    DJNZ Plan1Line.l1
    POP BC
    RET

;------------------------------------------------------------------------------
; Mul8: Multiply 16 bit operand with 8 bit operand. Perform HL=DE*A.
; From: http://sgate.emt.bme.hu/patai/publications/z80guide/part4.html#div8.
;------------------------------------------------------------------------------

Mul8                        ; this routine performs the operation HL=DE*A
    ld hl,0                 ; HL is used to accumulate the result
    ld b,8                  ; the multiplier (A) is 8 bits wide
Mul8Loop
    rrca                    ; putting the next bit into the carry
    jp nc,Mul8Skip          ; if zero, we skip the addition (jp is used for speed)
    add hl,de               ; adding to the product if necessary
Mul8Skip
    sla e                   ; calculating the next auxiliary product by shifting
    rl d                    ; DE one bit leftwards (refer to the shift instructions!)
    djnz Mul8Loop
    ret

;----------------------------------------------------------------------------
; RdSpace
;
; Read Caps-shift, A, Q, 1, 0, P, Space and Enter key. If any of them is 
;pressed, wait until key is released and then return, with carry flag reset. 
;----------------------------------------------------------------------------
RdSpace
    XOR A                   ; Enable all key columns for reading. 
    IN A,(254)              ; Read keyboard port. 
    RRCA                    ; Test bit 1. 
    RET C                   ; Exit no key was pressed. 
RdSpace.l
    HALT                    ; Make a delay. 
    XOR A
    IN A,(254)              ; Read keyboard port again. 
    CPL                     ; Bit values of a key press is 1. 
    AND %00011111           ; Test bits 0-5, i.e., all key rows. This instruction
                            ;also lower carry flag. 
    JR NZ,RdSpace.l          ; Wait to key release. 
    RET                     ; End of routine. 

;----------------------------------------------------------------------------
; Subroutines variables
;----------------------------------------------------------------------------

AttrBuffAdd                 ; Address of attribute buffer. 
    DEFW P2AttrBuff

; Graphics of this demo are composed by 2 video planes. First plane is a picture 
;that is bigger than computer screen, composed by bitmap and attribute color map. 

; The following variables concern about video plane 1. 8-bit variables are
;aligned into 16-bit boundary. 
Plane1BmapAddr              ; Address of plane 1 bitmap.
    DEFW tk90x2.bitmap
Plane1AttrAddr              ; Address of plane 1 attributes.
    DEFW tk90x2.attr
Plane1Size.Col              ; Size of plane 1 in columns with 8-pixel width. 
    DEFW tk90x2.ncol
Plane1Size.Lin              ; Size of plane 1 in lines with 8-pixel height.
    DEFW tk90x2.nlin
Plane1Coord.Col             ; Coordinates of current position on plane 1. 
    DEFW 0
Plane1Coord.Lin
    DEFW 0
Plane1Delta.Col             ; Delta line position to animate plane 1. 
    DEFB 1
Plane1Delta.Lin             ; Delta column position to animate plane 1. 
    DEFB 1

ModelChr6                   ; Store 8 bytes model of 6-bit wide charecter. 
    DEFS 8
StringP2Ini                 ; Initial address of string.
    DEFW P2msg
StringP2Ptr                 ; Pointer for string to be scrolled on plane 2. 
    DEFW P2msg
ScrollP2Bits                ; Counter for 6 bits to be scrolled for each character.
    DEFB 0
ScrollP2Rep                 ; Counter for repetition of scrolling of one character.
    DEFB 0

;----------------------------------------------------------------------------
; IntRoutine
; Interrupt Service Routine 
;----------------------------------------------------------------------------

IntRoutine
    DI                      ; (4T)
    PUSH AF                 ; (11T)
    PUSH BC                 ; (11T)
    PUSH DE                 ; (11T)
    PUSH HL                 ; (11T)
    PUSH IX                 ; (15T)
    EX AF,AF'               ; (4T)
    PUSH AF                 ; (11T)
; Play AY music. 
    CALL 49157
; Update interrupt counter and prepare to exit interrupt routine. 
    INC IY 
    POP AF
    EX AF,AF'
    POP IX
    POP HL
    POP DE
    POP BC
    POP AF
    EI
    RET 

;----------------------------------------------------------------------------
; Padding bytes
;----------------------------------------------------------------------------
Pad2
    DEFS 49152-$            ; Music player begins at 49152. 

;----------------------------------------------------------------------------
; AY music player & data
;----------------------------------------------------------------------------

MusPulsing
    INCBIN "PulsingAY.bin"

;----------------------------------------------------------------------------
; Padding bytes
;----------------------------------------------------------------------------
Pad3
;    DEFS 54887-$           ; This is not necessary. 

;============================================================================
; Part 3 - Main loop
;============================================================================
P3Main
; Initialize part 3. 
    LD HL,P3Plane1Data      ; Decompress plane 1 graphic data. 
    LD DE,huehue.bitmap
    CALL dzx7
    CALL ClearAttrBuf       ; Clear attribute buffer. 
    DI
    LD A,7
    OUT (254),A             ; White border. 
    LD IY,0                 ; Reset time counter. 
    EI

; Part 3 main loop.
P3Main.loop

; Start with plan 1 animation. 
    LD B,128                ; Number of repetitions. 
P3Main.l0
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,PrintFifa          ; Skip to next part if any of them is pressed. 
    DJNZ P3Main.l0

; FIFA 2014
PrintFifa
    LD HL,Fifa2014          ; Initialize string data. 
    LD (StringP2Ini),HL
    LD (StringP2Ptr),HL
    LD HL,0
    LD (ScrollP2Bits),HL
    LD B,6*38               ; Scroll 38 characters of 6 bits. 
P3Main.l1
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    CALL ScrlPlane2
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,PlayerPart        ; Skip to next part if any of them is pressed. 
    DJNZ P3Main.l1

; Player Part
PlayerPart
    LD B,200
P3Main.l2
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    CALL ClearAttrBuf
    LD A,R                  ; Fetch pseudorandom value and use it as column
    AND %00001111           ;number. 
    LD C,A
    LD B,0
    CALL ShowPlayer         ; Show picture of player. 
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,PrintHospit       ; Skip to next part if any of them is pressed. 
    DJNZ P3Main.l2

; Print Hospital
PrintHospit
    LD HL,Hospital
    LD (StringP2Ini),HL
    LD (StringP2Ptr),HL
    LD HL,0
    LD (ScrollP2Bits),HL
    LD BC,46*6              ; Scroll 46 characters of 6 bits. 
P3Main.l3
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    CALL ScrlPlane2
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,GkeeperPart       ; Skip to next part if any of them is pressed. 
    DEC BC
    LD A,B
    OR C
    JP NZ,P3Main.l3

; Show Goalkeeper
GkeeperPart
    LD B,200
P3Main.l4
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    CALL ClearAttrBuf
    LD A,R
    AND %01110000
    RLA
    INC A
    LD C,A
    LD B,0
    CALL ShowGkeeper
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,PrintGol          ; Skip to next part if any of them is pressed. 
    DJNZ P3Main.l4

; Gol
PrintGol
    LD HL,Gol
    LD (StringP2Ini),HL
    LD (StringP2Ptr),HL
    LD HL,0
    LD (ScrollP2Bits),HL
    LD BC,53*6              ; Scroll 53 characters of 6 bits. 
P3Main.l5
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    CALL ScrlPlane2
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,FulecoPart        ; Skip to next part if any of them is pressed. 
    DEC BC
    LD A,B
    OR C
    JP NZ,P3Main.l5

; Show Fuleco
FulecoPart
    CALL ClearAttrBuf
    CALL ShowFuleco
    LD B,150
P3Main.l6
    PUSH BC
    CALL AnimScreen         ; Move plan 1 coordinates. 
    CALL Plan1Screen        ; Show plan 1 at screen. 
    POP BC
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,ClearPlane1       ; Skip to next part if any of them is pressed. 
    DJNZ P3Main.l6

ClearPlane1
    LD HL,(AttrBuffAdd)     ; Clear all atributes except of Fuleco. 
    PUSH HL
    LD BC,768
    PUSH BC
P3Main.l7
    BIT 7,(HL)
    JR Z,P3Main.j0
    LD (HL),63
P3Main.j0
    INC HL
    DEC BC
    LD A,B
    OR C
    JR NZ,P3Main.l7
    POP BC
    LD DE,22528
    POP HL
    LDIR
P3Main.l8                   ; Make a delay.
    HALT                    ; Delay of 20 or 16.67 ms. 
    CALL RdSpace            ; Test space/enter keys. 
    JR NC,P3Exit            ; Finish demo if any of them is pressed. 
    DJNZ P3Main.l8          ; Repeat 256 times (initial value of B is 0). 
    JP P3Main.loop          ; Repeat part 3 from beginning. 

; Prepare to return to BASIC. 
P3Exit
; Restore BASIC system state to avoid crash. 
    DI
    IM 1
    LD IY,23610
    LD HL,10072
    EXX
; Mute AY. 
Mute
    LD A,14             ; Reset all AY registers. 
    LD DE,$BF00         ; D=MSB of AY port, E=0 used to reset register. 
Mute.Loop
    LD BC,$FFFD         ; Select port.
    OUT (C),A           ; Select register.
    LD B,D
    OUT (C),E           ; Reset port. 
    DEC A
    JP P,Mute.Loop      ; Repeat for all ports.
; Blank screen. 
    LD A,7              ; White border. 
    OUT (254),A
    LD (IY+14),56
    LD (IY+83),56       ; White paper and black ink. 
    CALL ROM_CLS
    EI
    RST 8               ; Return to BASIC raising error report. 
    DEFB 8              ; Error 9: "STOP statement".

;============================================================================
; Part 3 - subroutines
;============================================================================

;----------------------------------------------------------------------------
; dzx7
;
; ZX7 decoder by Einar Saukas
; "Mega" version (244 bytes, 30% faster)
;
; Parameters:
;   HL: source address (compressed data)
;   DE: destination address (decompressing)
;----------------------------------------------------------------------------

    INCLUDE "dzx7_mega.asm"


;----------------------------------------------------------------------------
; ShowPlayer
;
; Input: BC=column offset
;----------------------------------------------------------------------------

ShowPlayer
    LD A,Player.nlin
    LD DE,Player.attr
    LD HL,(AttrBuffAdd)
;    LD BC,0
ShowPlayer.l0
    ADD HL,BC
    EX DE,HL
    LD BC,Player.ncol
    LDIR
    EX DE,HL
    LD C,32-Player.ncol
    DEC A
    JR NZ,ShowPlayer.l0
    RET

;----------------------------------------------------------------------------
; ShowGkeeper
;
; Input: BC=32*(line offset)
;----------------------------------------------------------------------------

ShowGkeeper
    LD A,Goalkeeper.nlin
    LD DE,Goalkeeper.attr
    LD HL,(AttrBuffAdd)
ShowGkeeper.l0
    ADD HL,BC
    EX DE,HL
    LD BC,Goalkeeper.ncol
    LDIR
    EX DE,HL
    LD C,32-Goalkeeper.ncol
    DEC A
    JR NZ,ShowGkeeper.l0
    RET

;----------------------------------------------------------------------------
; ShowFuleco
;----------------------------------------------------------------------------

ShowFuleco
    LD A,Fuleco.nlin
    LD DE,Fuleco.attr
    LD HL,(AttrBuffAdd)
    LD BC,16*(24-Fuleco.nlin)+(32-Fuleco.ncol)/2
ShowFuleco.l0
    ADD HL,BC
    EX DE,HL
    LD BC,Fuleco.ncol
    LDIR
    EX DE,HL
    LD C,32-Fuleco.ncol
    DEC A
    JR NZ,ShowFuleco.l0
    RET

;============================================================================
; Part 3 - data
;============================================================================

;----------------------------------------------------------------------------
; Strings
;----------------------------------------------------------------------------

Fifa2014
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "FIFA"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "2014"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "Brasil"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 0                  ; End of string marker. 

Hospital
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "Maracana"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "Hospital"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "???   !!!   "
    DEFB 0                  ; End of string marker. 

Gol
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFM "Gol"
    DEFB 4," "              ; Repeat " " 4 times. 
    DEFM "Golo"
    DEFB 4," "              ; Repeat " " 4 times. 
    DEFM "Goal"
    DEFB 4," "              ; Repeat " " 4 times. 
    DEFM "But"
    DEFB 4," "              ; Repeat " " 4 times. 
    DEFM "Tor"
    DEFB 4," "              ; Repeat " " 4 times. 
    DEFM "Maal"
    DEFB 6," "              ; Repeat " " 6 times. 
    DEFB 0                  ; End of string marker. 
;----------------------------------------------------------------------------
; Graphics
;----------------------------------------------------------------------------

    INCLUDE "Player.asm"
    INCLUDE "fuleco3_04.asm"
    INCLUDE "Goalkeeper.asm"

;----------------------------------------------------------------------------
; Padding bytes
;----------------------------------------------------------------------------
Pad4
    DEFS 56976-$

;----------------------------------------------------------------------------
; Part 3 - video plane 1 compressed data
;----------------------------------------------------------------------------
P3Plane1Data
    INCBIN "HUEHUEHUE1.bin.zx7"


