; ----- START

      ldi sp, 0xA600  ; (4096 bytes code section + 38400 frame buffer)
      pal pallete
      vblnk

next_frame:


      ldi   ra, frame
      call  clear_frame

      ldi   r9,0      ; for i

dots_loop:
      ; calculate X coordinate
      ldm   r1,xst1
      ldm   r0,xspd1
      add   r1,r0     ; r1 = xst1+xspd1
      mov   r0,r9
      ldm   r2,dx1
      mul   r0,r2     ; r0 = i*dx1
      add   r1,r0,ra  ; ra = xst1+xspd1+i*dx1
      ldm   rb,slen1
      call  mod

      ldi   r0,stab1
      add   r0,ra
      ldm   r8,r0     
      andi  r8,255    ; r8 = stab1[(xst1+xspd1+i*dx1) mod slen1]


      ldm   r1,xst2
      ldm   r0,xspd2
      add   r1,r0  ; r1 = xst2+xspd2
      mov   r0,r9
      ldm   r2,dx2
      mul   r0,r2    ; r0 = i*dx2
      add   r1,r0,ra  ; ra = xst2+xspd2+i*dx2
      ldm   rb,slen2
      call  mod

      ldi   r0,stab2
      add   r0,ra
      ldm   r7,r0     
      andi  r7,255    ; r7 = stab2[(xst2+xspd2+i*dx2) mod slen2]

      add   r8,r7,r6
      addi  r6,70     ; R6 = X

      ; calculate Y coordinate
      ldm   r1,yst1
      ldm   r0,yspd1
      add   r1,r0  ; r1 = yst1+yspd1
      mov   r0,r9
      ldm   r2,dy1
      mul   r0,r2    ; r0 = i*dy1
      add   r1,r0,ra  ; ra = yst1+yspd1+i*dy1
      ldm   rb,slen1
      call  mod

      ldi   r0,stab1
      add   r0,ra
      ldm   r8,r0     
      andi  r8,255    ; r8 = stab1[(yst1+yspd1+i*dy1) mod slen1]

      ldm   r1,yst2
      ldm   r0,yspd2
      add   r1,r0  ; r1 = yst2+yspd2
      mov   r0,r9
      ldm   r2,dy2
      mul   r0,r2    ; r0 = i*dy2
      add   r1,r0,ra  ; ra = yst2+yspd2+i*dy2
      ldm   rb,slen2
      call  mod

      ldi   r0,stab2
      add   r0,ra
      ldm   r7,r0     
      andi  r7,255    ; r7 = stab2[(yst2+yspd2+i*dy2) mod slen2]

      add   r8,r7,r5
      addi  r5,20     ; R5 = Y

      ; draw sprite
      ;spr   #0201
      ;drw   r6,r5,dot_spr
      pushall
      ldi   ra, frame
      mov   rb, r6
      mov   rc, r5
      ldm   rd, cur_color
      push  rd
      call  set_pixel
      pop   rd
      cmpi  rd,#F
      jnz inc_color
      ldi  rd,0
inc_color:
      addi rd,1
      stm rd,cur_color
      popall

      addi  r9,1
      ldm   r0,dots
      cmp   r9,r0
      jnz   dots_loop

      ldm   ra,xst1
      ldm   r0,xspd1
      add   ra,r0
      ldm   rb,slen1
      call  mod
      stm   ra, xst1

      ldm   ra,yst1
      ldm   r0,yspd1
      add   ra,r0
      call  mod
      stm   ra, yst1

      ldm   ra,xst2
      ldm   r0,xspd2
      add   ra,r0
      ldm   rb,slen2
      call  mod
      stm   ra, xst2

      ldm   ra,yst2
      ldm   r0,yspd2
      add   ra,r0
      call  mod
      stm   ra, yst2

      ldm   r0,dots
      cmpi  r0,800
      ja    draw_frame

      addi  r0,2
      stm   r0,dots
draw_frame:
      push  r0
      push  r1
      ldi   r0,1
      ldi   r1,1
      spr   #f0a0
      cls
      drw   r0,r1,frame

      ldi   r0,268
      ldi   r1,226
      spr   #121B
      drw   r0,r1,tron_spr
      pop   r1
      pop   r0

;      ldi   ra,268
;      ldi   rb,226
;      ldi   rc,hello
;      ldi   rd,#e
;      call  draw_string

      jmp   next_frame


; ----- PROCEDURES
      
clear_frame:
; ra = pointer to sprite
      mov rc,ra
      addi rc,38400
      ldi rb, 0
do_clr:
      stm rb, ra
      addi ra, 2
      cmp ra, rc
      jb do_clr
      ret

set_pixel:
; ra = pointer to sprite
; rb = X
; rc = Y
; rd = color (0..0xF)
      muli rc, 320
      add  rc, rb
      shr  rc,1
      add  ra, rc

      ldm  r0, ra

      andi rb, 1            ; odd/even?
      jnz odd_px

      andi r0, #FF0F
      shl  rd, 4
      or   r0, rd
      stm  r0, ra
      jmp  end_plot
odd_px:
      or   r0, rd
      stm  r0, ra
end_plot:
      ret


mod:
; input:
;   ra = fist number
;   rb = second number
; output:
;   ra = result
      mov   rc,ra
      sub   ra,rb
      jnc   mod
      mov   ra,rc
      ret

; variables
xst1:  dw 100
xst2:  dw 800
yst1:  dw 300
yst2:  dw 700
cur_color: dw 1
; const

dots:  dw 1

slen1: dw 1100
samp1: dw 49
sofs1: dw 50

slen2: dw 1200
samp2: dw 39
sofs2: dw 40

dx1:   dw 3
dy1:   dw 5
xspd1: dw 4
yspd1: dw 2

dx2:   dw 4
dy2:   dw 3
xspd2: dw 2
yspd2: dw 3

stab1: 
db #32, #33, #33, #34, #34, #35, #35, #36, #36, #37, #38, #38, #39, #39
db #3A, #3A, #3B, #3B, #3C, #3D, #3D, #3E, #3E, #3F, #3F, #40, #40, #41
db #41, #42, #42, #43, #44, #44, #45, #45, #46, #46, #47, #47, #48, #48
db #49, #49, #4A, #4A, #4B, #4B, #4C, #4C, #4C, #4D, #4D, #4E, #4E, #4F
db #4F, #50, #50, #51, #51, #51, #52, #52, #53, #53, #54, #54, #54, #55
db #55, #56, #56, #56, #57, #57, #57, #58, #58, #58, #59, #59, #59, #5A
db #5A, #5A, #5B, #5B, #5B, #5C, #5C, #5C, #5D, #5D, #5D, #5D, #5E, #5E
db #5E, #5E, #5F, #5F, #5F, #5F, #5F, #60, #60, #60, #60, #60, #61, #61
db #61, #61, #61, #61, #62, #62, #62, #62, #62, #62, #62, #62, #62, #63
db #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63
db #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #62, #62, #62
db #62, #62, #62, #62, #62, #62, #61, #61, #61, #61, #61, #61, #60, #60
db #60, #60, #60, #5F, #5F, #5F, #5F, #5F, #5E, #5E, #5E, #5E, #5D, #5D
db #5D, #5D, #5C, #5C, #5C, #5B, #5B, #5B, #5A, #5A, #5A, #59, #59, #59
db #58, #58, #58, #57, #57, #57, #56, #56, #56, #55, #55, #54, #54, #54
db #53, #53, #52, #52, #51, #51, #51, #50, #50, #4F, #4F, #4E, #4E, #4D
db #4D, #4C, #4C, #4C, #4B, #4B, #4A, #4A, #49, #49, #48, #48, #47, #47
db #46, #46, #45, #45, #44, #44, #43, #42, #42, #41, #41, #40, #40, #3F
db #3F, #3E, #3E, #3D, #3D, #3C, #3B, #3B, #3A, #3A, #39, #39, #38, #38
db #37, #36, #36, #35, #35, #34, #34, #33, #33, #32, #31, #31, #30, #30
db #2F, #2F, #2E, #2E, #2D, #2C, #2C, #2B, #2B, #2A, #2A, #29, #29, #28
db #27, #27, #26, #26, #25, #25, #24, #24, #23, #23, #22, #22, #21, #20
db #20, #1F, #1F, #1E, #1E, #1D, #1D, #1C, #1C, #1B, #1B, #1A, #1A, #19
db #19, #18, #18, #18, #17, #17, #16, #16, #15, #15, #14, #14, #13, #13
db #13, #12, #12, #11, #11, #10, #10, #10, #0F, #0F, #0E, #0E, #0E, #0D
db #0D, #0D, #0C, #0C, #0C, #0B, #0B, #0B, #0A, #0A, #0A, #09, #09, #09
db #08, #08, #08, #07, #07, #07, #07, #06, #06, #06, #06, #05, #05, #05
db #05, #05, #04, #04, #04, #04, #04, #03, #03, #03, #03, #03, #03, #02
db #02, #02, #02, #02, #02, #02, #02, #02, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #01, #01, #02, #02, #02, #02, #02, #02, #02, #02
db #02, #03, #03, #03, #03, #03, #03, #04, #04, #04, #04, #04, #05, #05
db #05, #05, #05, #06, #06, #06, #06, #07, #07, #07, #07, #08, #08, #08
db #09, #09, #09, #0A, #0A, #0A, #0B, #0B, #0B, #0C, #0C, #0C, #0D, #0D
db #0D, #0E, #0E, #0E, #0F, #0F, #10, #10, #10, #11, #11, #12, #12, #13
db #13, #13, #14, #14, #15, #15, #16, #16, #17, #17, #18, #18, #18, #19
db #19, #1A, #1A, #1B, #1B, #1C, #1C, #1D, #1D, #1E, #1E, #1F, #1F, #20
db #20, #21, #22, #22, #23, #23, #24, #24, #25, #25, #26, #26, #27, #27
db #28, #29, #29, #2A, #2A, #2B, #2B, #2C, #2C, #2D, #2E, #2E, #2F, #2F
db #30, #30, #31, #31, #32, #33, #33, #34, #34, #35, #35, #36, #36, #37
db #38, #38, #39, #39, #3A, #3A, #3B, #3B, #3C, #3D, #3D, #3E, #3E, #3F
db #3F, #40, #40, #41, #41, #42, #42, #43, #44, #44, #45, #45, #46, #46
db #47, #47, #48, #48, #49, #49, #4A, #4A, #4B, #4B, #4C, #4C, #4C, #4D
db #4D, #4E, #4E, #4F, #4F, #50, #50, #51, #51, #51, #52, #52, #53, #53
db #54, #54, #54, #55, #55, #56, #56, #56, #57, #57, #57, #58, #58, #58
db #59, #59, #59, #5A, #5A, #5A, #5B, #5B, #5B, #5C, #5C, #5C, #5D, #5D
db #5D, #5D, #5E, #5E, #5E, #5E, #5F, #5F, #5F, #5F, #5F, #60, #60, #60
db #60, #60, #61, #61, #61, #61, #61, #61, #62, #62, #62, #62, #62, #62
db #62, #62, #62, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63
db #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63, #63
db #63, #62, #62, #62, #62, #62, #62, #62, #62, #62, #61, #61, #61, #61
db #61, #61, #60, #60, #60, #60, #60, #5F, #5F, #5F, #5F, #5F, #5E, #5E
db #5E, #5E, #5D, #5D, #5D, #5D, #5C, #5C, #5C, #5B, #5B, #5B, #5A, #5A
db #5A, #59, #59, #59, #58, #58, #58, #57, #57, #57, #56, #56, #56, #55
db #55, #54, #54, #54, #53, #53, #52, #52, #51, #51, #51, #50, #50, #4F
db #4F, #4E, #4E, #4D, #4D, #4C, #4C, #4C, #4B, #4B, #4A, #4A, #49, #49
db #48, #48, #47, #47, #46, #46, #45, #45, #44, #44, #43, #42, #42, #41
db #41, #40, #40, #3F, #3F, #3E, #3E, #3D, #3D, #3C, #3B, #3B, #3A, #3A
db #39, #39, #38, #38, #37, #36, #36, #35, #35, #34, #34, #33, #33, #32
db #31, #31, #30, #30, #2F, #2F, #2E, #2E, #2D, #2C, #2C, #2B, #2B, #2A
db #2A, #29, #29, #28, #27, #27, #26, #26, #25, #25, #24, #24, #23, #23
db #22, #22, #21, #20, #20, #1F, #1F, #1E, #1E, #1D, #1D, #1C, #1C, #1B
db #1B, #1A, #1A, #19, #19, #18, #18, #18, #17, #17, #16, #16, #15, #15
db #14, #14, #13, #13, #13, #12, #12, #11, #11, #10, #10, #10, #0F, #0F
db #0E, #0E, #0E, #0D, #0D, #0D, #0C, #0C, #0C, #0B, #0B, #0B, #0A, #0A
db #0A, #09, #09, #09, #08, #08, #08, #07, #07, #07, #07, #06, #06, #06
db #06, #05, #05, #05, #05, #05, #04, #04, #04, #04, #04, #03, #03, #03
db #03, #03, #03, #02, #02, #02, #02, #02, #02, #02, #02, #02, #01, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #02, #02, #02, #02
db #02, #02, #02, #02, #02, #03, #03, #03, #03, #03, #03, #04, #04, #04
db #04, #04, #05, #05, #05, #05, #05, #06, #06, #06, #06, #07, #07, #07
db #07, #08, #08, #08, #09, #09, #09, #0A, #0A, #0A, #0B, #0B, #0B, #0C
db #0C, #0C, #0D, #0D, #0D, #0E, #0E, #0E, #0F, #0F, #10, #10, #10, #11
db #11, #12, #12, #13, #13, #13, #14, #14, #15, #15, #16, #16, #17, #17
db #18, #18, #18, #19, #19, #1A, #1A, #1B, #1B, #1C, #1C, #1D, #1D, #1E
db #1E, #1F, #1F, #20, #20, #21, #22, #22, #23, #23, #24, #24, #25, #25
db #26, #26, #27, #27, #28, #29, #29, #2A, #2A, #2B, #2B, #2C, #2C, #2D
db #2E, #2E, #2F, #2F, #30, #30, #31, #31, #32

stab2:
db #28, #28, #29, #29, #2A, #2A, #2A, #2B, #2B, #2C, #2C, #2C, #2D, #2D
db #2E, #2E, #2F, #2F, #2F, #30, #30, #31, #31, #31, #32, #32, #32, #33
db #33, #34, #34, #34, #35, #35, #36, #36, #36, #37, #37, #37, #38, #38
db #39, #39, #39, #3A, #3A, #3A, #3B, #3B, #3C, #3C, #3C, #3D, #3D, #3D
db #3E, #3E, #3E, #3F, #3F, #3F, #40, #40, #40, #41, #41, #41, #41, #42
db #42, #42, #43, #43, #43, #44, #44, #44, #44, #45, #45, #45, #46, #46
db #46, #46, #47, #47, #47, #47, #48, #48, #48, #48, #48, #49, #49, #49
db #49, #4A, #4A, #4A, #4A, #4A, #4B, #4B, #4B, #4B, #4B, #4B, #4C, #4C
db #4C, #4C, #4C, #4C, #4D, #4D, #4D, #4D, #4D, #4D, #4D, #4D, #4E, #4E
db #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4F, #4F, #4F, #4F, #4F
db #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F
db #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4E, #4E
db #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4D, #4D, #4D, #4D, #4D
db #4D, #4D, #4D, #4C, #4C, #4C, #4C, #4C, #4C, #4B, #4B, #4B, #4B, #4B
db #4B, #4A, #4A, #4A, #4A, #4A, #49, #49, #49, #49, #48, #48, #48, #48
db #48, #47, #47, #47, #47, #46, #46, #46, #46, #45, #45, #45, #44, #44
db #44, #44, #43, #43, #43, #42, #42, #42, #41, #41, #41, #41, #40, #40
db #40, #3F, #3F, #3F, #3E, #3E, #3E, #3D, #3D, #3D, #3C, #3C, #3C, #3B
db #3B, #3A, #3A, #3A, #39, #39, #39, #38, #38, #37, #37, #37, #36, #36
db #36, #35, #35, #34, #34, #34, #33, #33, #32, #32, #32, #31, #31, #31
db #30, #30, #2F, #2F, #2F, #2E, #2E, #2D, #2D, #2C, #2C, #2C, #2B, #2B
db #2A, #2A, #2A, #29, #29, #28, #28, #28, #27, #27, #26, #26, #26, #25
db #25, #24, #24, #24, #23, #23, #22, #22, #21, #21, #21, #20, #20, #1F
db #1F, #1F, #1E, #1E, #1E, #1D, #1D, #1C, #1C, #1C, #1B, #1B, #1A, #1A
db #1A, #19, #19, #19, #18, #18, #17, #17, #17, #16, #16, #16, #15, #15
db #15, #14, #14, #13, #13, #13, #12, #12, #12, #11, #11, #11, #10, #10
db #10, #0F, #0F, #0F, #0F, #0E, #0E, #0E, #0D, #0D, #0D, #0C, #0C, #0C
db #0C, #0B, #0B, #0B, #0A, #0A, #0A, #0A, #09, #09, #09, #09, #08, #08
db #08, #08, #08, #07, #07, #07, #07, #06, #06, #06, #06, #06, #05, #05
db #05, #05, #05, #05, #04, #04, #04, #04, #04, #04, #03, #03, #03, #03
db #03, #03, #03, #03, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02
db #02, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02
db #02, #03, #03, #03, #03, #03, #03, #03, #03, #04, #04, #04, #04, #04
db #04, #05, #05, #05, #05, #05, #05, #06, #06, #06, #06, #06, #07, #07
db #07, #07, #08, #08, #08, #08, #08, #09, #09, #09, #09, #0A, #0A, #0A
db #0A, #0B, #0B, #0B, #0C, #0C, #0C, #0C, #0D, #0D, #0D, #0E, #0E, #0E
db #0F, #0F, #0F, #0F, #10, #10, #10, #11, #11, #11, #12, #12, #12, #13
db #13, #13, #14, #14, #15, #15, #15, #16, #16, #16, #17, #17, #17, #18
db #18, #19, #19, #19, #1A, #1A, #1A, #1B, #1B, #1C, #1C, #1C, #1D, #1D
db #1E, #1E, #1E, #1F, #1F, #1F, #20, #20, #21, #21, #21, #22, #22, #23
db #23, #24, #24, #24, #25, #25, #26, #26, #26, #27, #27, #28, #28, #28
db #29, #29, #2A, #2A, #2A, #2B, #2B, #2C, #2C, #2C, #2D, #2D, #2E, #2E
db #2F, #2F, #2F, #30, #30, #31, #31, #31, #32, #32, #32, #33, #33, #34
db #34, #34, #35, #35, #36, #36, #36, #37, #37, #37, #38, #38, #39, #39
db #39, #3A, #3A, #3A, #3B, #3B, #3B, #3C, #3C, #3D, #3D, #3D, #3E, #3E
db #3E, #3F, #3F, #3F, #40, #40, #40, #41, #41, #41, #41, #42, #42, #42
db #43, #43, #43, #44, #44, #44, #44, #45, #45, #45, #46, #46, #46, #46
db #47, #47, #47, #47, #48, #48, #48, #48, #48, #49, #49, #49, #49, #4A
db #4A, #4A, #4A, #4A, #4B, #4B, #4B, #4B, #4B, #4B, #4C, #4C, #4C, #4C
db #4C, #4C, #4D, #4D, #4D, #4D, #4D, #4D, #4D, #4D, #4E, #4E, #4E, #4E
db #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4F, #4F, #4F, #4F, #4F, #4F, #4F
db #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F
db #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4F, #4E, #4E, #4E, #4E
db #4E, #4E, #4E, #4E, #4E, #4E, #4E, #4D, #4D, #4D, #4D, #4D, #4D, #4D
db #4D, #4C, #4C, #4C, #4C, #4C, #4C, #4B, #4B, #4B, #4B, #4B, #4B, #4A
db #4A, #4A, #4A, #4A, #49, #49, #49, #49, #48, #48, #48, #48, #48, #47
db #47, #47, #47, #46, #46, #46, #46, #45, #45, #45, #44, #44, #44, #44
db #43, #43, #43, #42, #42, #42, #41, #41, #41, #41, #40, #40, #40, #3F
db #3F, #3F, #3E, #3E, #3E, #3D, #3D, #3D, #3C, #3C, #3B, #3B, #3B, #3A
db #3A, #3A, #39, #39, #39, #38, #38, #37, #37, #37, #36, #36, #36, #35
db #35, #34, #34, #34, #33, #33, #32, #32, #32, #31, #31, #31, #30, #30
db #2F, #2F, #2F, #2E, #2E, #2D, #2D, #2C, #2C, #2C, #2B, #2B, #2A, #2A
db #2A, #29, #29, #28, #28, #28, #27, #27, #26, #26, #26, #25, #25, #24
db #24, #24, #23, #23, #22, #22, #21, #21, #21, #20, #20, #1F, #1F, #1F
db #1E, #1E, #1E, #1D, #1D, #1C, #1C, #1C, #1B, #1B, #1A, #1A, #1A, #19
db #19, #19, #18, #18, #17, #17, #17, #16, #16, #16, #15, #15, #14, #14
db #14, #13, #13, #13, #12, #12, #12, #11, #11, #11, #10, #10, #10, #0F
db #0F, #0F, #0F, #0E, #0E, #0E, #0D, #0D, #0D, #0C, #0C, #0C, #0C, #0B
db #0B, #0B, #0A, #0A, #0A, #0A, #09, #09, #09, #09, #08, #08, #08, #08
db #08, #07, #07, #07, #07, #06, #06, #06, #06, #06, #05, #05, #05, #05
db #05, #05, #04, #04, #04, #04, #04, #04, #03, #03, #03, #03, #03, #03
db #03, #03, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01, #01
db #01, #01, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02, #02, #03
db #03, #03, #03, #03, #03, #03, #03, #04, #04, #04, #04, #04, #04, #05
db #05, #05, #05, #05, #05, #06, #06, #06, #06, #06, #07, #07, #07, #07
db #08, #08, #08, #08, #08, #09, #09, #09, #09, #0A, #0A, #0A, #0A, #0B
db #0B, #0B, #0C, #0C, #0C, #0C, #0D, #0D, #0D, #0E, #0E, #0E, #0F, #0F
db #0F, #0F, #10, #10, #10, #11, #11, #11, #12, #12, #12, #13, #13, #13
db #14, #14, #15, #15, #15, #16, #16, #16, #17, #17, #17, #18, #18, #19
db #19, #19, #1A, #1A, #1A, #1B, #1B, #1C, #1C, #1C, #1D, #1D, #1E, #1E
db #1E, #1F, #1F, #1F, #20, #20, #21, #21, #21, #22, #22, #23, #23, #24
db #24, #24, #25, #25, #26, #26, #26, #27, #27, #28, #28


pallete: db #00, #00, #00
         db #33, #66, #FF
         db #66, #33, #FF
         db #CC, #33, #FF
         db #FF, #33, #CC
         db #33, #CC, #FF
         db #00, #3D, #F5
         db #00, #2E, #B8
         db #FF, #33, #66
         db #33, #FF, #CC
         db #88, #8A, #00
         db #F5, #B8, #00
         db #FF, #66, #33
         db #33, #FF, #66
         db #66, #FF, #33
         db #CC, #FF, #33


tron_spr:    dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #EE00, #EEEE, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #00EE, #0000, #0000, #0000
             dw #0000, #EEE0, #000E, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #00EE, #EE00, #EE0E
             dw #0E00, #E0EE, #EE00, #E0EE, #0E00, #00EE, #EE00, #0E00, #00E0
             dw #0000, #EE00, #0000, #EE0E, #E00E, #00EE, #00EE, #00EE, #00EE
             dw #EE00, #0000, #E00E, #00EE, #0000, #0000, #00EE, #0E00, #0EE0
             dw #EEE0, #EE00, #EE00, #EE00, #0000, #00EE, #0000, #E0EE, #0000
             dw #0000, #EE00, #0000, #E00E, #0000, #00EE, #00EE, #00EE, #00EE
             dw #EE00, #0000, #E00E, #00EE, #0000, #0E00, #E0EE, #EE00, #00EE
             dw #0E00, #E0EE, #EE00, #EE00, #0E00, #E0EE, #EE00, #0E00, #00E0
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000, #0000
             dw #0000
frame: db 0