; ----- START

; frame at 0x2b50

        pal pallete
        vblnk

        ldi  r0, 0
        ldi  ra, bitmap
        ldi  r1,#2
fill_bmp:
        stm  r1,ra
        addi ra,1
        addi r0,1
        cmpi r0,1216
        jnz fill_bmp

        ldi r0, 0
        ldi r1, #3
fill_bmp2:
        stm  r1,ra
        addi ra,1
        addi r0,1
        cmpi r0,1216
        jnz fill_bmp2

        ldi r0, 0
        ldi r1, #4
fill_bmp3:
        stm  r1,ra
        addi ra,1
        addi r0,1
        cmpi r0,1216
        jnz fill_bmp3

next_frame:


      ldi   ra, #2b50
      call  clear_frame

        ldi r0, 0          ; R0 = X coord
do_x_loop:
        ldm r1, ymax       ; R1 = Y coord

do_y_loop:
        ; calculate XP
        ldm r2, size
        mul r2, r0         ; R2 = size * x

        ldm r3, sidx
        ldm r4, curve
        mul r4, r0
        add r3, r4         ; R3 = sidx+curve*x
        ldm r4, curve
        mul r4, r1         ; R4 = curve*y
        add r3, r4, ra     ; RA = (sidx+curve*x+curve*y)
        ldm rb, slen
        call mod           ; RA = (sidx+curve*x+curve*y) mod slen

        ldi   r3,stab
        add   r3,ra
        ldm   r4,r3
        andi  r4,255       ; R4 = stab[(sidx+curve*x+curve*y) mod slen]
        add   r2, r4, r5   ; R5 = XP

        ; calculate YP
        ldm r2, size
        mul r2, r1         ; R2 = size * y

        ldm r3, sidx
        ldi r4, 4
        mul r4, r0         ; R4 = 4*x
        add r3, r4         ; R3 = sidx+4*x
        ldm r4, curve
        mul r4, r1         ; R4 = curve*y
        add r3, r4         ; R3 = sidx+4*x+curve*y
        add r3, r1, ra     ; RA = sidx+4*x+curve*y+y
        ldm rb, slen
        call mod           ; RA = (sidx+4*x+curve*y+y) mod slen

        ldi r3,stab
        add r3,ra
        ldm r4,r3
        andi r4,255
        add r2, r4, r6     ; R6 = YP

        ; Draw Pixel
        ldi ra,#2b50
        mov rb,r5
        addi rb,12
        mov rc,r6

        ldi r2,bitmap
        ldm r3,xmax
        mul r3,r1
        add r3,r0
        add r2,r3
 
        ldm rd,r2
        andi rd,255
        push r0
        push r1
        call set_pixel
        pop r1
        pop r0

        subi r1,1
        cmpi r1,0
        jnz do_y_loop

        addi r0,1
        ldm r2,xmax
        ;addi r2,1
        cmp r0,r2
        jnz do_x_loop

        ldm r2,sidx
        ldm r3,spd
        add r2,r3,ra
        ldm rb,slen
        call mod
        stm ra,sidx
   
      ldi   ra,1
      ldi   rb,1
      spr   #c8a0
      cls
      ldi rc, #2b50
      drw   ra,rb,rc

      ldi ra,2
      ldi rb,pallete
      call get_color
      cmpi rc,#ff
      jz next_frame
      addi rc,1
      addi rd,1
      addi re,1

      ldi ra,2
      ldi rb,pallete
      call set_color

      ldi ra,3
      ldi rb,pallete
      call get_color
      addi re,1

      ldi ra,3
      ldi rb,pallete
      call set_color

      ldi ra,4
      ldi rb,pallete
      call get_color
      addi rc,1

      ldi ra,4
      ldi rb,pallete
      call set_color

      pal pallete
      vblnk

jmp next_frame
        
         
; ----- PROCEDURES

clear_frame:
; ra = pointer to sprite
      mov rc,ra
      addi rc,38400
      ldi rb, 0
do_clr:
      stm rb, ra
      addi ra, 2
      cmp ra, rc
      jb do_clr
      ret
      
set_pixel:
; ra = pointer to sprite
; rb = X
; rc = Y
; rd = color (0..0xF)
      muli rc, 320
      add  rc, rb
      shr  rc,1
      add  ra, rc

      ldm  r0, ra

      andi rb, 1            ; odd/even?
      jnz odd_px

      andi r0, #FF0F
      shl  rd, 4
      or   r0, rd
      stm  r0, ra
      jmp  end_plot
odd_px:
      or   r0, rd
      stm  r0, ra
end_plot:
      ret

set_color:
; ra = index
; rb = pointer to pallete
; rc = R
; rd = G
; re = B

      muli ra, 3
      add  rb, ra
      mov  r0, rd
      shl  r0, 8
      or   rc, r0
      stm  rc, rb

      addi rb, 2
      ldm  r0, rb
      shr  r0, 8
      shl  r0, 8
      or   re, r0
      stm  re, rb
      ret

get_color:
; ra = index
; rb = pointer to pallete
; output:
; rc = R
; rd = G
; re = B

      muli ra, 3
      add  rb, ra
      ldm  r0, rb
      push r0
      andi r0,#FF
      mov  rc,r0
      pop  r0
      shr  r0, 8
      mov  rd,r0

      addi rb, 2
      ldm  r0, rb
      andi r0, #FF
      mov  re, r0
      ret

mod:
; input:
;   ra = fist number
;   rb = second number
; output:
;   ra = result
      mov   rc,ra
      sub   ra,rb
      jnc   mod
      mov   ra,rc
      ret

; variables
sidx:   dw 0

; const
spd:    dw 1
size:   dw 3
curve:  dw 125
xmax:   dw 76  ; 230 div size
ymax:   dw 46  ; 140 div size
slen:   dw 255

stab:        db #1E, #1E, #1F, #1F, #20, #20, #21, #21, #22, #22, #23, #23
             db #24, #24, #24, #25, #25, #25, #26, #26, #26, #27, #27, #27
             db #27, #27, #28, #28, #28, #28, #28, #28, #28, #28, #28, #28
             db #28, #28, #28, #27, #27, #27, #27, #27, #26, #26, #26, #25
             db #25, #25, #24, #24, #23, #23, #23, #22, #22, #21, #21, #20
             db #20, #1F, #1F, #1E, #1E, #1D, #1D, #1C, #1C, #1B, #1B, #1B
             db #1A, #1A, #19, #19, #18, #18, #18, #17, #17, #16, #16, #16
             db #16, #15, #15, #15, #15, #15, #14, #14, #14, #14, #14, #14
             db #14, #14, #14, #14, #14, #14, #14, #15, #15, #15, #15, #16
             db #16, #16, #16, #17, #17, #17, #18, #18, #19, #19, #19, #1A
             db #1A, #1B, #1B, #1C, #1C, #1D, #1D, #1E, #1E, #1F, #1F, #20
             db #20, #21, #21, #22, #22, #23, #23, #23, #24, #24, #25, #25
             db #25, #26, #26, #26, #26, #27, #27, #27, #27, #28, #28, #28
             db #28, #28, #28, #28, #28, #28, #28, #28, #28, #28, #27, #27
             db #27, #27, #27, #26, #26, #26, #26, #25, #25, #24, #24, #24
             db #23, #23, #22, #22, #21, #21, #21, #20, #20, #1F, #1F, #1E
             db #1E, #1D, #1D, #1C, #1C, #1B, #1B, #1A, #1A, #19, #19, #19
             db #18, #18, #17, #17, #17, #16, #16, #16, #15, #15, #15, #15
             db #15, #14, #14, #14, #14, #14, #14, #14, #14, #14, #14, #14
             db #14, #14, #15, #15, #15, #15, #15, #16, #16, #16, #17, #17
             db #17, #18, #18, #18, #19, #19, #1A, #1A, #1B, #1B, #1C, #1C
             db #1D, #1D, #1E, #1E

pallete:  
          db #00, #00, #00
          db #00, #00, #00
          db #20, #20, #20
          db #00, #00, #20
          db #20, #00, #00
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF
          db #FF, #FF, #FF

bitmap: db 0
