#include "tool.h"




//-----------------------------------------------------------------------------
// cos
//-----------------------------------------------------------------------------
float cos(float x)
{
    float res ;
 
    __asm__ (
        "fld %1\n"
        "fcos\n"
        "fstp %0\n"
        : "=m" (res)
        : "m" (x)
        :
    );
    return res;
}

//-----------------------------------------------------------------------------
// sin
//-----------------------------------------------------------------------------
float sin(float x)
{
    float res ;
 
    __asm__ (
        "fld %1\n"
        "fsin\n"
        "fstp %0\n"
        : "=m" (res)
        : "m" (x)
        :
    );
    return res;
}

/*
//-----------------------------------------------------------------------------
// tan
//-----------------------------------------------------------------------------
float tan(float x)
{
    return sin(x)/cos(x);
}
*/

//-----------------------------------------------------------------------------
// clamp
//-----------------------------------------------------------------------------
float clamp(float x, float vmin, float vmax)
{

    while(x<vmin || x>vmax)
    {
        if(x<vmin)
            x=vmax-(vmin-x);
        if(x>vmax)
            x-=vmax;
    }
	return x;
}



