'    Asstroidz 0.42
'    Copyright (C) 2009  Jesse Ziegler aka xteraco
'
'    This program is free software: you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation, either version 3 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program.  If not, see <http://www.gnu.org/licenses/>.

DrawHUD:           
    if not xtz_asstroidz.gameState = 0 and not xtz_asstroidz.gameState = 2 then
        'healht frame
            glPushMatrix()  
                glScalef (2.1, 2.1, 1)
                glColor3f(0,1,1)
                glBegin(GL_QUADS)
                    glVertex2f(0.4,0.5)
                    glVertex2f(shipSelection.health + 0.4 , 0.5) 
                    glVertex2f(shipSelection.health + 0.4 , 1)
                    glVertex2f(0.4,1) 
                glEnd()
            glPopMatrix() 
    
        'health bar
            glPushMatrix()  
                glScalef (2, 2, 1)
                glColor3f(1,0,0)
                glBegin(GL_QUADS)
                    glVertex2f(0.6,0.5)
                    glVertex2f(player(1).health + 0.5 , 0.5) 
                    glVertex2f(player(1).health + 0.5 , 1)
                    glVertex2f(0.5,1) 
                glEnd()
            glPopMatrix()  
            
            'lives icons     
            glPushMatrix()  
                glScalef (2, 2, 1)    
                
                if xtz_asstroidz.shipChoice = 0 then
                    glColor3f(0,1,0)                    
                endif  
                if xtz_asstroidz.shipChoice = 1 then
                    glColor3f(1,1,0)                    
                endif
                if xtz_asstroidz.shipChoice = 2 then
                    glColor3f(0,0,1)                    
                endif
                
                for i = 1 to player(1).lives
                    glBegin(GL_QUADS)
                        glVertex2f(0.5 + i - 1, 1.5)
                        glVertex2f(1 + i - 1, 1.5) 
                        glVertex2f(1 + i - 1, 2)
                        glVertex2f(0.5 + i - 1,2) 
                    glEnd()
                next          
            glPopMatrix()  
    endif
    return

DrawPlayer:
    if currentPlayer.inGame and currentPlayer.deadCounter = 0 then    
        glPushMatrix ()    
        glTranslatef (currentPlayer.pos# (0), currentPlayer.pos# (1), 0)
        glRotatef (currentPlayer.dir#, 0, 0, 1)
        glScalef (1.5, 1.5, 1)  
        
        'draw everything but the ship if we are at game over
        if not xtz_asstroidz.gameState = 2 then 
            if xtz_asstroidz.shipChoice = 0 then 
                glColor3f (0, 1, 0)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
        
                glEnd ()  
            endif    
            
            if xtz_asstroidz.shipChoice = 1 then 
                glColor3f (1, 1, 0)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
        
                glEnd ()  
            endif
            
            if xtz_asstroidz.shipChoice = 2 then   
                glColor3f (0, 0, 1)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
        
                glEnd ()  
            endif  
                
            'thruster
            if currentPlayer.thrusterOn = 1 then    
                glColor3f (1, 0, 0)
                glBegin (GL_TRIANGLES)
                    glVertex2f (  0,  -2 - abs(currentPlayer.vel#(0) + currentPlayer.vel#(1)))
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                glEnd()
            endif
        endif 

        glPopMatrix ()   
    endif
    return  
    
RenderData:            
    cls
    
    centerMsg$ = " "

    if xtz_asstroidz.gameState = 0 then 
        centerMsg$ = "Press space to start"    
    endif    
        
    if xtz_asstroidz.gameState = 2 then
        centerMsg$ = "game over"
    endif 
    
    if xtz_asstroidz.pause = 1 then
        centerMsg$ = "pause"
    endif   
    
    
    locate (TextCols () - len(centerMsg$)) / 2, TextRows() / 2 
    print centerMsg$

    'draw score
    locate 0,0
    print xtz_asstroidz.score 
    
    'draw accuracy 
    locate 0,1
    print "acc: " + (xtz_asstroidz.shots_hits * 100) / xtz_asstroidz.shots_fired   

    'draw level number  
    locate 31,0
    print "Level " + xtz_asstroidz.level  

    DrawText()
    return
    
DrawShipSelector: 

    locate (TextCols () - len("select your ship")) / 2, 0 
    print "select your ship"
    DrawText()

    'ship 1
    glPushMatrix ()    
        glTranslatef (60 - 10, 50, 0)
        glRotatef (currentPlayer.dir# , 0, 0, 1)
        glScalef (1.5, 1.5, 1)  
        
                glColor3f (0, 1, 0)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
        
                glEnd ()  
        glPopMatrix () 
        
        'ship 2
        glPushMatrix()   
        glTranslatef (60, 50, 0)
        glRotatef (currentPlayer.dir# , 0, 0, 1)
        glScalef (1.5, 1.5, 1)
        glColor3f (1, 1, 0)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
                            
                glEnd ()  
        glPopMatrix () 
        
        'ship 3
        glPushMatrix()   
        glTranslatef (60 + 10, 50, 0)
        glRotatef (currentPlayer.dir# ,0, 0, 1)
        glScalef (1.5, 1.5, 1)
        glColor3f (0, 0, 1)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)     
                    
                    'left thruster
                    glVertex2f (  0 - 0.5,  0.2 )
                    glVertex2f (-.5 - 0.7, -1.5 )
                    glVertex2f ( .3 - 0.7, -1 ) 
                    
                    'right thruster
                    glVertex2f (  0 + 0.5,  0.2 )
                    glVertex2f (-.3 + 0.7, -1 )
                    glVertex2f ( .5 + 0.7, -1.5 )  
                            
                glEnd ()  
        glPopMatrix ()   
        
        'selector icon
        glPushMatrix()   
        glTranslatef (60 + ui.cursorPos, 40, 0)
        glRotatef (0 ,0, 0, 0)
        glScalef (1.5, 1.5, 1)
        glColor3f (1, 1, 1)

                glBegin (GL_TRIANGLES)  
        
                    glVertex2f (  0,  1)
                    glVertex2f (-.5, -1)
                    glVertex2f ( .5, -1)      
                            
                glEnd ()  
        glPopMatrix ()
    return

DrawBackground:    
    glPushMatrix()
    glEnable (GL_TEXTURE_2D)                                        
    'glClear (GL_DEPTH_BUFFER_BIT or GL_COLOR_BUFFER_BIT)        
    glLoadIdentity ()   
    glcolor3f(1,1,1)                                 
    glTranslatef (0, 100, -1)   
    glscalef(120,100.16,1)
    
    glBindTexture (GL_TEXTURE_2D, bgTexture)

    glBegin (GL_QUADS)                                    
        glTexCoord2f (0, 0):    glVertex2f (0,-1)
        glTexCoord2f (1, 0):    glVertex2f (1,-1)
        glTexCoord2f (1, 1):    glVertex2f (1, 0)
        glTexCoord2f (0, 1):    glVertex2f (0, 0)
    glEnd ()    
    glPopMatrix()
    glDisable(gl_texture_2d)
    return       
    
DrawSplash:    
    glPushMatrix()
    glEnable (GL_TEXTURE_2D)                                        
    'glClear (GL_DEPTH_BUFFER_BIT or GL_COLOR_BUFFER_BIT)        
    glLoadIdentity ()   
    glcolor3f(1,1,1)                                 
    glTranslatef (0, 100, -1)   
    glscalef(120,100.16,1)
    
    glBindTexture (GL_TEXTURE_2D, splashTexture)

    glBegin (GL_QUADS)                                    
        glTexCoord2f (0, 0):    glVertex2f (0,-1)
        glTexCoord2f (1, 0):    glVertex2f (1,-1)
        glTexCoord2f (1, 1):    glVertex2f (1, 0)
        glTexCoord2f (0, 1):    glVertex2f (0, 0)
    glEnd ()    
    glPopMatrix()
    glDisable(gl_texture_2d)
    return

DrawAsteroid:
    glPushMatrix ()
    glTranslatef (currentAsteroid.pos# (0), currentAsteroid.pos# (1), 0)
    glRotatef (currentAsteroid.rot#, 0, 0, 1)
    glScalef (1.5 * currentAsteroid.size, 1.5 * currentAsteroid.size, 1)
    glColor3f (0, 1, 1)     
    glLineWidth(3.0)   
    glEnable (GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA,GL_ONE)
    
    'outline
    glBegin (GL_LINE_LOOP)
        glVertex2f (-.51, -.88)
        glVertex2f (-.07, -.95)
        glVertex2f ( .07, -.72)
        glVertex2f ( .53, -.72)
        glVertex2f ( .88, -.06)
        glVertex2f ( .94,  .53)
        glVertex2f ( .49,  .52)
        glVertex2f (-.03,  .90)
        glVertex2f (-.45,  .69)
        glVertex2f (-.92,  .20)
        glVertex2f (-.51, -.49)
    glEnd () 
    
    'solid inner bits
    glColor3f (0, 0.2, 0.3)
    glBegin (GL_TRIANGLE_FAN)
        glVertex2f (-.51, -.88)
        glVertex2f (-.07, -.95)
        glVertex2f ( .07, -.72)
        glVertex2f ( .53, -.72)
        glVertex2f ( .88, -.06)
        glVertex2f ( .94,  .53)
        glVertex2f ( .49,  .52)
        glVertex2f (-.03,  .90)
        glVertex2f (-.45,  .69)
        glVertex2f (-.92,  .20)
        glVertex2f (-.51, -.49)
    glEnd ()  
    glDisable(GL_BLEND)
    glPopMatrix ()
    return 
    
tempDrawPowerup:
    glPushMatrix() 
        if currentPowerup.ptype$ = "health" then
            glcolor3f(1,0,1)  
        else
            glcolor3f(0,1,0)
        endif    

        glPointSize(currentPowerup.size * 1.5)
        glBegin (GL_POINTS)
            glVertex2f (currentPowerup.pos# (0), currentPowerup.pos# (1))
        glEnd ()
    glPopMatrix()
    return
    
DrawBullet:   
    currentBullet.bulletColor# = currentBullet.life / 30.0
    glcolor3f(currentBullet.bulletColor#,currentBullet.bulletColor#,currentBullet.bulletColor#)          
    glPointSize(4)
    glBegin (GL_POINTS)
        glVertex2f (currentBullet.pos# (0), currentBullet.pos# (1))
    glEnd ()
    return  
    
DrawSmoke:
    
    if not xtz_asstroidz.gameState = 0 then  
        
        i = 0

        while i < 10
            if smokeParticle(smokeCounter).life# = smokeLife then
                smokeParticle(smokeCounter).pos# = player(1).pos# 
            endif

            if smokeParticle(smokeCounter).life# <= 0 then 
                smokeParticle(smokeCounter).life# = smokeLife             
            endif
            
            if smokeCounter = 1000 then
                smokeCounter = 1
            endif
            
            smokeParticle(smokeCounter).life# = smokeParticle(smokeCounter).life# - 2  
            smokeParticle(smokeCounter).color# = smokeParticle(smokeCounter).life# / 30.0

            glEnable(GL_BLEND)
            glcolor3f(smokeParticle(smokeCounter).color# - 0.3,smokeParticle(smokeCounter).color# - 0.3,smokeParticle(smokeCounter).color# - 0.3)          
            glPointSize(smokeParticle(smokeCounter).life#)
            glBegin (GL_POINTS)
                glVertex2f (smokeParticle(smokeCounter).pos# (0), smokeParticle(smokeCounter).pos# (1))
            glEnd ()  
            glDisable(GL_BLEND)  
            
            smokeCounter = smokeCounter + 1
            
            i = i + 1
        wend  
        
        smokeParticle(smokeCounter).life# = smokeLife
    endif 
   
    return  

'TODO phantom powerup (turn off collision) and draw a trail of ships using particles
'to simulate blur 
DrawPhantom:
    
    if not xtz_asstroidz.gameState = 0 then  
        
        i = 0

        while i < 50'smokeParticle(smokeCounter).life# > 0  
            if smokeParticle(smokeCounter).life# = smokeLife then
                smokeParticle(smokeCounter).pos# = player(1).pos# 
                smokeParticle(smokeCounter).life# = smokeLife + 1
            endif

            if smokeParticle(smokeCounter).life# <= 0 then 
                smokeParticle(smokeCounter).life# = smokeLife             
            endif
            
            if smokeCounter = 1000 then
                smokeCounter = 2
            endif

            smokeCounter = smokeCounter + 1
            
            while smokeParticle(smokeCounter).life# > 0 
            smokeParticle(smokeCounter).life# = smokeParticle(smokeCounter).life# - 1  
            smokeParticle(smokeCounter).color# = smokeParticle(smokeCounter).life# / 30.0

            glEnable(GL_BLEND)
            glcolor3f(smokeParticle(smokeCounter).color#,smokeParticle(smokeCounter).color#,smokeParticle(smokeCounter).color#)          
            glPointSize(smokeParticle(smokeCounter).life#)
            glBegin (GL_POINTS)
                glVertex2f (smokeParticle(smokeCounter).pos# (0), smokeParticle(smokeCounter).pos# (1))
            glEnd ()  
            glDisable(GL_BLEND) 
            wend
            
            i = i + 1
        wend  
        
        smokeParticle(smokeCounter).life# = smokeLife
    endif 

    return

'particle effect for health regeneration powerup
DrawHealthRegen: 
    if not xtz_asstroidz.gameState = 0 then  
        
        i = 0

        while i < 50
            if smokeParticle(smokeCounter).life# = smokeLife then
                smokeParticle(smokeCounter).pos# = player(1).pos# 
            endif

            if smokeParticle(smokeCounter).life# <= 0 then 
                smokeParticle(smokeCounter).life# = smokeLife             
            endif
            
            if smokeCounter = 1000 then
                smokeCounter = 1
            endif
            
            'while smokeParticle(smokeCounter).life# > 0 
                smokeParticle(smokeCounter).life# = smokeParticle(smokeCounter).life# - 1  
                smokeParticle(smokeCounter).color# = smokeParticle(smokeCounter).life# / 30.0
    
                glEnable(GL_BLEND)
                glcolor4f(smokeParticle(smokeCounter).color#,0.5,smokeParticle(smokeCounter).color#,0.1)          
                glPointSize(smokeParticle(i).life#)
                glBegin (GL_POINTS)
                    glVertex2f (smokeParticle(smokeCounter).pos# (0), smokeParticle(smokeCounter).pos# (1))
                glEnd ()  
                glDisable(GL_BLEND) 
            'wend    
            
            smokeParticle(smokeCounter).pos# (0) = smokeParticle(smokeCounter).pos# (0) + 0.1
            smokeParticle(smokeCounter).pos# (1) = smokeParticle(smokeCounter).pos# (1) + 0.1
            smokeCounter = smokeCounter + 1
            
            i = i + 1
        wend  
        
        smokeParticle(smokeCounter).life# = smokeLife
    endif 
    return 
    
'particle effect for health regeneration powerup
DrawREDHealthRegen: 
    if not xtz_asstroidz.gameState = 0 then  
        
        i = 0

        while i < 50
            if smokeParticle(smokeCounter).life# = smokeLife then
                smokeParticle(smokeCounter).pos# = player(1).pos# 
            endif

            if smokeParticle(smokeCounter).life# <= 0 then 
                smokeParticle(smokeCounter).life# = smokeLife             
            endif
            
            if smokeCounter = 1000 then
                smokeCounter = 1
            endif
            
            'while smokeParticle(smokeCounter).life# > 0 
                smokeParticle(smokeCounter).life# = smokeParticle(smokeCounter).life# - 1  
                smokeParticle(smokeCounter).color# = smokeParticle(smokeCounter).life# / 30.0
    
                glEnable(GL_BLEND)
                glcolor4f(0.5,smokeParticle(smokeCounter).color#,smokeParticle(smokeCounter).color#,0.1)          
                glPointSize(smokeParticle(i).life#)
                glBegin (GL_POINTS)
                    glVertex2f (smokeParticle(smokeCounter).pos# (0), smokeParticle(smokeCounter).pos# (1))
                glEnd ()  
                glDisable(GL_BLEND) 
            'wend    
            
            smokeParticle(smokeCounter).pos# (0) = smokeParticle(smokeCounter).pos# (0) + 0.1
            smokeParticle(smokeCounter).pos# (1) = smokeParticle(smokeCounter).pos# (1) + 0.1
            smokeCounter = smokeCounter + 1
            
            i = i + 1
        wend  
        
        smokeParticle(smokeCounter).life# = smokeLife
    endif 
    return 

' if a powerup has an effect, it gets called here (just the call to the sub that does the drawing)
DrawPowerupEffect:   
    if player(1).health <= 2 then
        gosub DrawSmoke
    endif

    if player(1).healthPowerup = 2 then
        gosub DrawHealthRegen
    endif   
    
    if player(1).healthPowerup = 3 then
        gosub DrawREDHealthRegen
    endif
    return