/*
    Asstroidz 0.42
    Copyright (C) 2009  Jesse Ziegler aka xteraco

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

//kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "Basic4GLDLLInterface.h"
#include "Basic4GLStandardObjects.h"
#include <math.h>
#include "TestConsole.h"
#include <bass.h>
#include <iostream>
using namespace std;

HWND win=NULL;
DWORD cthread=0;
HSTREAM chan;
HSTREAM sfx1;
HSTREAM sfx2;
HSTREAM sfx3;
HSTREAM sfx4;
HSTREAM sfx5;
HSTREAM sfx6;
HSTREAM sfx7;

///////////////////////////////////////////////////////////////////////////////
//	TestPlugin
//
///	Main object representing the plugin to Basic4GL.
/// Basic4GL will access this through the IDLL_Plugin interface.

// Global variables.
// Necessary, because the runtime functions are called at a global scope.
TestConsole *console = NULL;
IB4GLText *textScreen = NULL;
char *pluginError = NULL;

class TestPlugin : public IDLL_Basic4GL_Plugin {
public:
	TestPlugin() { ; }
    virtual bool DLLFUNC Load(IDLL_Basic4GL_FunctionRegistry &registry, bool isStandaloneExe);
    virtual bool DLLFUNC Start();
    virtual void DLLFUNC End();
    virtual void DLLFUNC Unload();
    virtual void DLLFUNC GetError(char *error);
	virtual void DLLFUNC Pause();
	virtual void DLLFUNC Resume();
	virtual void DLLFUNC DelayedResume();
    virtual void DLLFUNC ProcessMessages();
};

///////////////////////////////////////////////////////////////////////////////
// DLL exported functions
extern "C" {

	/// Query function
	DLLExport int DLLFUNC Basic4GL_Query(char *details, int *major, int *minor) {
		char *detailSrc = "Basic4GL plugin example #1";
		int i;
		for (i = 0; detailSrc[i] != 0; i++)
			details[i] = detailSrc[i];
		*major = 1;
		*minor = 0;

		// MUST return BASIC4GL_DLL_VERSION here!
		return BASIC4GL_DLL_VERSION;
	}

	/// Main initialisation function.
	/// Here we will construct and return our plugin object
	DLLExport IDLL_Basic4GL_Plugin *DLLFUNC Basic4GL_Init() {

		// Construct and return our plugin object
		return new TestPlugin();
	}
}

///////////////////////////////////////////////////////////////////////////////
// Runtime functions
// These are the functions that Basic4GL calls

//init bass and load all our sounds
void DLLFUNC Func_BASSInit(IDLL_Basic4GL_Runtime &basic4gl) {
	BASS_Init(-1,44100,0,0,NULL);

	sfx1 = BASS_StreamCreateFile(FALSE,"aud\\gun1.ogg",0,0,0);
	sfx2 = BASS_StreamCreateFile(FALSE,"aud\\explode.ogg",0,0,0);
	sfx3 = BASS_StreamCreateFile(FALSE,"aud\\ric1.ogg",0,0,0);
	sfx4 = BASS_StreamCreateFile(FALSE,"aud\\ric2.ogg",0,0,0);
	sfx5 = BASS_StreamCreateFile(FALSE,"aud\\ric3.ogg",0,0,0);
	sfx6 = BASS_StreamCreateFile(FALSE,"aud\\healthPowerup.ogg",0,0,0);
	sfx7 = BASS_StreamCreateFile(FALSE,"aud\\weaponPowerup.ogg",0,0,0);
}

void DLLFUNC Func_BASSStreamMusic(IDLL_Basic4GL_Runtime &basic4gl) {
    chan = BASS_StreamCreateURL(basic4gl.GetStringParam(1), 0, BASS_STREAM_BLOCK|BASS_STREAM_STATUS|BASS_STREAM_AUTOFREE, NULL, 0);

    //while(BASS_ChannelPlay(stream,FALSE)){}
    BASS_ChannelPlay(chan,FALSE);
}

void DLLFUNC Func_BASSPlaySound(IDLL_Basic4GL_Runtime &basic4gl){
    int soundNum = basic4gl.GetIntParam(1);

    if(soundNum == 0){
        BASS_ChannelPlay(sfx1,TRUE);
    }
    if(soundNum == 1){
        BASS_ChannelPlay(sfx2,TRUE);
    }
    if(soundNum == 2){
        BASS_ChannelPlay(sfx3,TRUE);
    }
    if(soundNum == 3){
        BASS_ChannelPlay(sfx4,TRUE);
    }
    if(soundNum == 4){
        BASS_ChannelPlay(sfx5,TRUE);
    }
    if(soundNum == 5){
        BASS_ChannelPlay(sfx6,TRUE);
    }
    if(soundNum == 6){
        BASS_ChannelPlay(sfx7,TRUE);
    }

}

///////////////////////////////////////////////////////////////////////////////
//	TestPlugin

bool DLLFUNC TestPlugin::Load(IDLL_Basic4GL_FunctionRegistry &registry, bool isStandaloneExe) {

    // Fetch text interface

	// Initialise DLL stuff
	console = new TestConsole();

	// Register shared interfaces
	registry.RegisterInterface(console, "TextConsole", 1, 0);

    // Register constants
    registry.RegisterStringConstant("TESTPLUGIN_AUTHOR", "xteraco");
    registry.RegisterIntConstant("TESTPLUGIN_DLL_VERSION", BASIC4GL_DLL_VERSION);

	// Register runtime functions

	// Message box function
	registry.RegisterVoidFunction("BASSInit", Func_BASSInit);
	registry.ModTimeshare();					// This function is slow, so Basic4GL better perform a timeshare break after it finishes

	registry.RegisterVoidFunction("BASSStreamMusic", Func_BASSStreamMusic);
	registry.ModTimeshare();					// This function is slow, so Basic4GL better perform a timeshare break after it finishes
	registry.AddParam(DLL_BASIC4GL_STRING);

	registry.RegisterVoidFunction("BASSPlaySound", Func_BASSPlaySound);
	registry.ModTimeshare();					// This function is slow, so Basic4GL better perform a timeshare break after it finishes
	registry.AddParam(DLL_BASIC4GL_INT);

	return true;
}

void DLLFUNC TestPlugin::Unload() {

	// DLL is about to unload.
	// Final cleanup code
	if (console != NULL)
        delete console;

	// Delete this object. This is safe because Basic4GL will not access it again.
	delete this;
}

bool DLLFUNC TestPlugin::Start() {

	// Program is about to start.
	// Any pre-start init code would go here.
	console->Show();

	return true;
}

void DLLFUNC TestPlugin::End() {

	// Program is about to end
	// Any cleanup code would go here
	console->Hide();
}

void DLLFUNC TestPlugin::Pause() {

	// Called when the program is paused (i.e. during debugging).
	// A full screen window might hide itself here so that the user can see the
	// Basic4GL edit window (and debug their program)
}

void DLLFUNC TestPlugin::Resume() {

	// Called when the program is resumed (i.e. during debugging).
	// This is also called when the user "steps"
}

void DLLFUNC TestPlugin::DelayedResume() {

	// Called when the program is resumed for more than a short "step".
	// This is where a fullscreen window would re-show itself (if it did so in ::Resume()
	// we would get flickering when the user steps through the program)
}

void DLLFUNC TestPlugin::GetError(char *error) {
	if (pluginError != NULL)
		for (int i = 0; pluginError[i] != 0; i++)
			error[i] = pluginError[i];
}

void DLLFUNC TestPlugin::ProcessMessages() {

    // Called periodically (in practice, quite frequently).
    // This would be a good place to process windows messages etc.
}

