// PNG decoding example for SEGA 32X
// Mic, 2009

#include <stdio.h>
#include <stdlib.h>
#include "32x.h"
#include "dpng32x.h"


extern char image, image_end;


// Line table for scaling the 320x204 frame buffer to a 320x224 screen
const u16 LINE_TABLE[] = {
	256,256,576,896,1216,1536,1856,2176,2496,2816,3136,3456,3456,3776,4096,4416,4736,5056,5376,5696,
	6016,6336,6656,6656,6976,7296,7616,7936,8256,8576,8896,9216,9536,9856,9856,10176,10496,10816,11136,
	11456,11776,12096,12416,12736,13056,13056,13376,13696,14016,14336,14656,14976,15296,15616,15936,
	16256,16256,16576,16896,17216,17536,17856,18176,18496,18816,19136,19456,19776,19776,20096,20416,
	20736,21056,21376,21696,22016,22336,22656,22976,22976,23296,23616,23936,24256,24576,24896,25216,
	25536,25856,26176,26176,26496,26816,27136,27456,27776,28096,28416,28736,29056,29376,29376,29696,
	30016,30336,30656,30976,31296,31616,31936,32256,32576,32896,32896,33216,33536,33856,34176,34496,
	34816,35136,35456,35776,36096,36096,36416,36736,37056,37376,37696,38016,38336,38656,38976,39296,
	39296,39616,39936,40256,40576,40896,41216,41536,41856,42176,42496,42496,42816,43136,43456,43776,
	44096,44416,44736,45056,45376,45696,45696,46016,46336,46656,46976,47296,47616,47936,48256,48576,
	48896,49216,49216,49536,49856,50176,50496,50816,51136,51456,51776,52096,52416,52416,52736,53056,
	53376,53696,54016,54336,54656,54976,55296,55616,55616,55936,56256,56576,56896,57216,57536,57856,
	58176,58496,58816,58816,59136,59456,59776,60096,60416,60736,61056,61376,61696,62016,62016,62336,
	62656,62976,63296,63616,63936,64256,64576,64896,65216};


void slave()
{
	while (1) {}
}


int main()
{
	uint16 currentFB=0;
	vu16 *frameBuffer16 = &MARS_FRAMEBUFFER;
	int i;

	// Wait for the SH2 to gain access to the VDP
	while ((MARS_SYS_INTMSK & MARS_SH2_ACCESS_VDP) == 0) {}

	// Set 15-bit direct color mode, 224 lines
	MARS_VDP_DISPMODE = MARS_224_LINES | MARS_VDP_MODE_32K;

	MARS_VDP_FBCTL = currentFB;

    for(;;)
    {
		MARS_VDP_FBCTL = currentFB ^ 1;
		while ((MARS_VDP_FBCTL & MARS_VDP_FS) == currentFB) {}
		currentFB ^= 1;

		read_png(&image, (&image_end)-(&image), frameBuffer16+0x100);

		// Set up the line table
		for (i = 0; i < 224; i++)
		{
			frameBuffer16[i] = LINE_TABLE[i];
		}

     }

	return 0;
}


