OUTPUT_ARCH(m68k)
SEARCH_DIR(.)

/*
 * Setup the memory map of the SEGA Genesis.
 * stack grows down from high memory.
 *
 * The memory map look like this:
 * +--------------------+ <- low memory
 * | .text              |
 * |        _etext      |
 * |        ctor list   | the ctor and dtor lists are for
 * |        dtor list   | C++ support
 * +--------------------+
 * | .data              | initialized data goes here
 * |        _data       |
 * |        _edata      |
 * +--------------------+
 * | .bss               |
 * |        _bstart     | start of bss, cleared by crt0
 * |        _bend       | start of heap, used by sbrk()
 * +--------------------+
 * .                    .
 * .                    .
 * .                    .
 * |        __stack     | top of stack
 * +--------------------+
 */

MEMORY
{
    rom : ORIGIN = 0x00000000, LENGTH = 0x00400000
    ram : ORIGIN = 0x00ff0000, LENGTH = 0x00010000
}

/*
 * allocate the stack to be at the top of memory, since the stack
 * grows down
 */

PROVIDE (__stack = 0x01000000);

SECTIONS
{
  .text 0x00000000:
  {
    *(.text)
    . = ALIGN(0x4);
    *(.rodata*)
    *(.lit)
    _etext = .;
  } > rom

  .data 0x00ff0000 :
  AT ( ADDR (.text) + SIZEOF (.text) )
  {
    _data = . ;
    *(.shdata)
    *(.data)
    _edata = . ;
  } > ram

  .bss 0xff0000 + SIZEOF (.data) :
  {
    _bstart = . ;
    *(.shbss)
    *(.bss)
    *(COMMON)
    *(.eh_fram)
    *(.eh_frame)
    _bend =  . ;
  } > ram

}
