! memory.s
! shuboy memory access functions
! sh2 assembly version
! /mic 2009

! Note that some of these functions rely on R9 containing the value 0x1FFF, which is
! used as an address mask.

.global _mem_reset
.global _mem_read_byte
.global _mem_write_byte
.global _cart
.global keys
.global	_ROM0
.global _ROM1
.global _RAM1
.global IOREGS
.global VRAM
.global OAM
.global HIRAM
.global RAM
.global VRAM
.global read_byte_ftbl
.global timercnt
.global timerld
.global romSelect
.global ramSelect
.global highRomBits
.global mbc1Layout
.global __MEM_COPY_TO_IWRAM_START__
.global _mem_get_rd8_func
.global num_banks

! ###########################################################################################################

.include "shuboy.inc"

! ###########################################################################################################

.section .data

.align 1

mem_read_byte_null:
	rts
	mov	#0,r0


.align 2
__MEM_COPY_TO_IWRAM_START__:

mem_read_byte_0000_3FFF:
	mov.l	_ROM0,r1
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0

! +0x08	
mem_read_byte_C000_EFFF:
	mov.l	_RAM0_,r1
	and 	r9,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0

! +0x12	
mem_write_byte_C000_EFFF:
	mov.l	_RAM0_,r2
	and 	r9,r0
	rts
	mov.b	r1,@(r0,r2)

! +0x1A
nop	
_ROM0:		.long 0
_RAM0_:		.long RAM


! +0x24
_mem_read_byte:
	mov	r0,r3	
	mov.l	rd8_tbl,r2
	shlr8	r0
	shlr2	r0
	and 	#0x3C,r0
	mov.l	@(r0,r2),r1
	jmp	@r1
	mov	r3,r0

! +0x34
_mem_write_byte:
	mov	r0,r3	
	mov.l	wr8_tbl,r2
	shlr8	r0
	shlr2	r0
	and	#0x3C,r0
	mov.l 	@(r0,r2),r2
	jmp 	@r2
	mov 	r3,r0
	
	
! +0x44
rd8_tbl: .long MEM_CACHE_COPY_ADR  + read_byte_ftbl - __MEM_COPY_TO_IWRAM_START__
wr8_tbl: .long MEM_CACHE_COPY_ADR  + write_byte_ftbl - __MEM_COPY_TO_IWRAM_START__

! +0x4C
read_byte_ftbl:
.long MEM_CACHE_COPY_ADR + mem_read_byte_0000_3FFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_0000_3FFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_0000_3FFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_0000_3FFF - __MEM_COPY_TO_IWRAM_START__
.long mem_read_byte_4000_7FFF
.long mem_read_byte_4000_7FFF
.long mem_read_byte_4000_7FFF
.long mem_read_byte_4000_7FFF
.long MEM_CACHE_COPY_ADR + mem_read_byte_8000_9FFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_8000_9FFF - __MEM_COPY_TO_IWRAM_START__
.long mem_read_byte_A000_BFFF_mbc1 !mem_read_byte_null
.long mem_read_byte_A000_BFFF_mbc1 !mem_read_byte_null
.long MEM_CACHE_COPY_ADR + mem_read_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_read_byte_F000_FFFF - __MEM_COPY_TO_IWRAM_START__

! +0x8C
HIRAM:
.long 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

! +0x10C
timercnt:	.long 0
timerld:	.long 0


! +0x114
_mem_get_rd8_func:
	mov	r0,r3	
	mov.l	rd8_tbl_,r2
	shlr8	r0
	shlr2	r0
	and 	#0x3C,r0
	mov.l	@(r0,r2),r1
	rts
	mov	r1,r0
.align 2
rd8_tbl_: .long MEM_CACHE_COPY_ADR  + read_byte_ftbl - __MEM_COPY_TO_IWRAM_START__


mem_read_byte_F000_FFFF:
	mov.l	ram_end_i,r1
	cmp/hi	r1,r0
	bt	_rd8_F_check_hiram
	mov.l	_RAM0_i,r1
	and 	r9,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0	
_rd8_F_check_oam:
	mov.l	oam_end_i,r1
	cmp/hi	r1,r0
	bt	_rd8_F_check_io
	mov	#0x9F,r2
	mov.l	_OAM_i,r1
	extu.b 	r2,r2
	sub	r2,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0	
_rd8_F_check_io:
	mov.l	io_start_i,r2
	cmp/hs	r2,r0
	bf	_rd8_F_null
	cmp/eq	r2,r0
	bt	_rd8_F_keys
	mov.l	io_end_i,r1
	cmp/hi	r1,r0
	bt	_rd8_F_check_hiram
	mov.l	_IOREGS_i,r1
	sub	r2,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0
_rd8_F_check_hiram:
	mov.l	hiram_start_i,r2
	cmp/hs	r2,r0
	bf	_rd8_F_check_oam
	mov.l	hiram_end_i,r1
	cmp/hi	r1,r0
	bt	_rd8_F_ie
	mov.l	_HIRAM_i,r1
	sub	r2,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0
_rd8_F_ie:
	mov.l	_IOREGS_i,r1
	extu.b	r0,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0
_rd8_F_keys:
	mov.l	_IOREGS_i,r1
	mov.l	_keys_i,r3
	mov.b	@r1,r0
	mov 	r0,r2
	and 	#0x30,r0
	cmp/eq 	#0x30,r0
	bt 	_rd8_F_nokeys
	mov 	r2,r0
	mov	#0x0F,r2
	tst	#0x10,r0
	bf	_rd8_F_nodirkeys
	mov.b	@r3,r1
	and	r1,r2
_rd8_F_nodirkeys:
	tst	#0x20,r0
	bf	_rd8_F_nofunkeys
	add	#1,r3
	mov.b	@r3,r1
	and	r1,r2
_rd8_F_nofunkeys:
	and	#0xF0,r0
	or	r2,r0
	rts
	extu.b r0,r0
_rd8_F_nokeys:
	rts
	extu.b 	r2,r0
_rd8_F_null:
	rts
	xor	r0,r0
	nop


mem_write_byte_F000_FFFF:
	mov.l	ram_end_i,r2
	cmp/hi	r2,r0
	bt	_wr8_F_hiram
	mov.l	_RAM0_i,r2
	and 	r9,r0
	rts
	mov.b	r1,@(r0,r2)
_wr8_F_oam:
	mov.l	oam_end_i,r2
	cmp/hi	r2,r0
	bt	_wr8_F_io
	mov	#0x9F,r3
	extu.b 	r3,r3
	mov.l	_OAM_i,r2
	sub	r3,r0
	rts
	mov.b	r1,@(r0,r2)
_wr8_F_io:
	mov.l	io_start_i,r2
	cmp/hs	r2,r0
	bf	_wr8_F_null
	mov.l	io_end_i,r3
	cmp/hi	r3,r0
	bt	_wr8_F_null 
	sub	r2,r0
	mov.l	_IOREGS_i,r2
	mov.b	r1,@(r0,r2)
	cmp/eq	#0x04,r0
	bf	_wr8_F_TAC
	mov	#0,r1
	rts
	mov.b	r1,@(r0,r2)
_wr8_F_TAC:
	cmp/eq	#0x07,r0
	bf	_wr8_F_OAM_DMA
	mov	r1,r0
	and	#3,r0
	mov	r0,r2
	mova	timerld_values,r0
	shll	r2
	mov.w	@(r0,r2),r1
	mov.l	_timerld8,r3
	mov.l	r1,@r3
	mov.l	_timercnt8,r2
	mov	#0,r0
	rts
	mov.l	r0,@r2
_wr8_F_OAM_DMA:
	cmp/eq	#0x46,r0
	bf	_wr8_F_null
	sts.l	pr,@-r15
	mov.l	r7,@-r15
	mov.l	r6,@-r15
	mov.l	r5,@-r15
	mov	r1,r6
	mov.l	_OAM_i,r5
	shll8	r6
	mov	#160,r7
	extu.b	r7,r7
_wr8_F_OAM_DMA_loop:
	extu.w	r6,r0
	bsr	_mem_read_byte
	nop
	mov.b	r0,@r5
	add	#1,r6
	dt	r7
	bf/s	_wr8_F_OAM_DMA_loop
	add	#1,r5
	mov.l	@r15+,r5
	mov.l	@r15+,r6
	mov.l	@r15+,r7
	lds.l	@r15+,pr
	add 	#100,r12
	rts	
	nop
_wr8_F_hiram:
	mov.l	hiram_start_i,r2
	cmp/hs	r2,r0
	bf	_wr8_F_oam
	mov.l	hiram_end_i,r3
	cmp/hi	r3,r0
	bt	_wr8_F_ie
	sub	r2,r0
	mov.l	_HIRAM_i,r2
	rts
	mov.b	r1,@(r0,r2)
_wr8_F_ie:
	mov.l	_IOREGS_i,r2
	extu.b	r0,r0
	rts
	mov.b	r1,@(r0,r2)
_wr8_F_null:
	rts
	nop
	

.align 2
timerld_values: .short 1024,16,64,256
_timerld8: 	.long MEM_CACHE_COPY_ADR + timerld - __MEM_COPY_TO_IWRAM_START__
_timercnt8: 	.long MEM_CACHE_COPY_ADR + timercnt - __MEM_COPY_TO_IWRAM_START__
_keys_i: 	.long keys
_IOREGS_i:	.long IOREGS + UNCACHED_ADDRESS
_HIRAM_i:	.long MEM_CACHE_COPY_ADR + HIRAM - __MEM_COPY_TO_IWRAM_START__
_OAM_i:		.long OAM + UNCACHED_ADDRESS
_RAM0_i:	.long RAM
ram_end_i:	.long 0xFDFF
oam_end_i:	.long 0xFE9F
io_start_i:	.long 0xFF00
io_end_i:	.long 0xFF4B
hiram_start_i:	.long 0xFF80
hiram_end_i:	.long 0xFFFE


write_byte_ftbl:
.long mem_write_byte_0000_3FFF_mbc1
.long mem_write_byte_0000_3FFF_mbc1
.long mem_write_byte_0000_3FFF_mbc1
.long mem_write_byte_0000_3FFF_mbc1
.long mem_write_byte_4000_7FFF_mbc1
.long mem_write_byte_4000_7FFF_mbc1
.long mem_write_byte_4000_7FFF_mbc1
.long mem_write_byte_4000_7FFF_mbc1
.long MEM_CACHE_COPY_ADR + mem_write_byte_8000_9FFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_write_byte_8000_9FFF - __MEM_COPY_TO_IWRAM_START__
.long mem_write_byte_null
.long mem_write_byte_null
.long MEM_CACHE_COPY_ADR + mem_write_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_write_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_write_byte_C000_EFFF - __MEM_COPY_TO_IWRAM_START__
.long MEM_CACHE_COPY_ADR + mem_write_byte_F000_FFFF - __MEM_COPY_TO_IWRAM_START__



mem_read_byte_8000_9FFF:
	mov.l	_VRAM_i,r1
	and 	r9,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0
	
	
mem_write_byte_8000_9FFF:
	mov.l	_VRAM_i,r2
	and 	r9,r0
	rts
	mov.b	r1,@(r0,r2)
	
.align 2
_VRAM_i:	.long VRAM + UNCACHED_ADDRESS

__MEM_COPY_TO_IWRAM_END__:


mem_read_byte_4000_7FFF:
	mov.w	rom_mask2,r2	
	mov.l	_ROM1,r1
	and	r2,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0
	
	
mem_read_byte_A000_BFFF_mbc1:
	mov.l	_RAM1,r1
	and 	r9,r0
	mov.b	@(r0,r1),r2
	rts
	extu.b	r2,r0


mem_read_byte_A000_A1FF_mbc2:
	mov.l	mbc2ram_end,r2
	cmp/hi	r2,r0
	bt/s	_rd8_A_mbc2_null
	mov.w	mbc2ram_mask2,r2
	mov.l	_MBC2RAM,r1
	and	r2,r0
	mov.b	@(r0,r1),r2
	extu.b	r2,r0
_rd8_A_mbc2_null:	
	rts
	and	#0x0F,r0




.align 1
rom_mask2:	.short 0x3FFF
mbc2ram_mask2:	.short 0x01FF

! ###########################################################################################################


mem_write_byte_null:
	rts
	nop
	

mem_write_byte_0000_3FFF_mbc1:
	mov.w	_0x2000,r2
	cmp/hs	r2,r0
	bt	_wr8_0_romsel
	mov	#0x0F,r2
	and	r2,r1
	mov	#0x0A,r2
	cmp/eq	r2,r0
	bf	_wr8_0_ramdisable
	mov.l	ramSelect,r0
	shll8	r0
	shll2	r0
	shll2	r0	
	shll	r0	! r0 *= 0x2000
	mov.l	_EXRAM,r1
	add	r0,r1
	mova	_RAM1,r0
	mov.l	r1,@r0
	mov.l	_write_byte_ftbl,r0
	add	#0x2C,r0
	mov.l	mbc1_ramwrite,r1
	mov.l	r1,@-r0
	rts
	mov.l	r1,@r0
_wr8_0_ramdisable:
	mov	#0,r1
	mova	_RAM1,r0
	mov.l	r0,@r0
	mov.l	_write_byte_ftbl,r0
	add	#0x2C,r0
	mov.l	mem_nullwrite,r1
	mov.l	r1,@-r0
	rts
	mov.l	r1,@r0
_wr8_0_romsel:
	mov	r1,r0
	mov	#0,r1
	cmp/eq	#0,r0
	addc	r1,r0	! r0 += (r0==0)?1:0
	mov	r0,r1
	mov.l	num_banks,r2
	add	#-1,r2
	and	r2,r1
	mova	romSelect,r0
	mov.l	r1,@r0
	mov.l	mbc1Layout,r0
	cmp/eq	#0,r0
	bf	_wr8_0_lobanks
	mov.l	highRomBits,r2
	add	r2,r1
_wr8_0_lobanks:
	shll8	r1
	shll8	r1
	shlr2	r1	! r1 *= 0x4000
	mov.l	_cart,r0
	add	r0,r1
	mova	_ROM1,r0
	rts
	mov.l	r1,@r0
	

_0x2000:	.short 0x2000



mem_write_byte_4000_7FFF_mbc1:
	mov.w	_0x6000,r2
	cmp/hs	r2,r0
	bt	_wr8_4_layoutsel
	mov.l	mbc1Layout,r0
	cmp/eq	#0,r0
	bf	_wr8_4_enable_exram
	mov	r1,r0
	and	#3,r0
	shll2	r0
	shll2	r0
	shll	r0
	mov.l	_hrb,r1
	mov.l	r0,@r1
	mov.l	_hrbLatch,r1
	bra	_wr8_4_sel_hirom_exram
	mov.l	r0,@r1
_wr8_4_enable_exram:
	mov	r1,r0
	and	#3,r0
	mov.l	_ramSelect,r1
	mov.l	r0,@r1
	mov.l	_rsLatch,r1
	bra	_wr8_4_sel_hirom_exram
	mov.l	r0,@r1
_wr8_4_layoutsel:	
	mov	r1,r0
	mov.l	_mbc1Layout,r2
	and	#1,r0
	mov.l	r0,@r2
	cmp/eq	#0,r0
	bf	_wr8_4_disable_hirom
	mov.l	_ramSelect,r0
	mov	#1,r1
	mov.l	r1,@r0
	mov.l	highRomBitsLatch,r1
	mov.l	_hrb,r0
	bra	_wr8_4_sel_hirom_exram
	mov.l	r1,@r0
_wr8_4_disable_hirom:
	mov.l	_hrb,r0
	mov	#1,r1
	mov.l	r1,@r0
	mov.l	_ramSelect,r0
	mov.l	ramSelectLatch,r1
	mov.l	r1,@r0
_wr8_4_sel_hirom_exram:
	mov.l	ramSelect,r0
	shll8	r0
	shll2	r0
	shll2	r0
	shll	r0	! r0 = ramSelect * 0x2000
	mov.l	_EXRAM,r1
	add	r0,r1
	mova	_RAM1,r0
	mov.l	r1,@r0
	mov.l	romSelect,r1
	mov.l	highRomBits,r2
	add	r2,r1
	shll8	r1
	shll8	r1
	shlr2	r1	! r1 *= 0x4000
	mov.l	_cart,r0
	add	r0,r1
	mova	_ROM1,r0
	rts
	mov.l	r1,@r0
	

_0x6000:	.short 0x6000
.align 2
_mbc1Layout:	.long mbc1Layout
_ramSelect:	.long ramSelect
_rsLatch:	.long ramSelectLatch
_hrb:		.long highRomBits
_hrbLatch:	.long highRomBitsLatch


mem_write_byte_A000_BFFF_mbc1:
	mov.l	_RAM1,r2
	and	r9,r0
	rts
	mov.b	r1,@(r0,r2)


mem_write_byte_0000_3FFF_mbc2:
	mov	r1,r0
	mov	#0,r1
	cmp/eq	#0,r0
	addc	r1,r0	! r0 += (r0==0)?1:0
	and	#0x0F,r0
	mov	r0,r1
	mova	romSelect,r0
	mov.l	r1,@r0
	shll8	r1
	shll8	r1
	shlr2	r1	! r1 *= 0x4000
	mov.l	_cart,r0
	add	r0,r1
	mova	_ROM1,r0
	rts
	mov.l	r1,@r0


mem_write_byte_A000_A1FFF_mbc2:
	mov.l	mbc2ram_end,r2
	cmp/hi	r2,r0
	bt	_wr8_A_mbc2_null
	mov.w	mbc2ram_mask,r2
	and	r2,r0
	mov.l	_MBC2RAM,r2
_wr8_A_mbc2_null:	
	rts
	mov.b	r1,@(r0,r2)
	


! ###########################################################################################################


_mem_reset:
	mov	#0xFF,r1
	mova	keys,r0
	mov.l	r1,@r0
	
	mova	romSelect,r0
	mov	#1,r1
	mov.l	r1,@r0
	mova	ramSelect,r0
	mov	#0,r1
	mov.l	r1,@r0
	mova	highRomBits,r0
	mov.l	r1,@r0
	mova	mbc1Layout,r0
	mov.l	r1,@r0
	mov.l	_divcnt,r0
	mov.b	r1,@r0
	
	! Copy GB ROM bank 0 from ROM to SDRAM
	mov.l	__ROM0,r0
	mov.l	ROM0_,r2
	mov.l	r2,@r0
	mov.l	_cart,r0
	mov.w	rom_mask,r1
	add	r0,r1
_mr_copy_rom_bank_0:
	mov.b	@r0+,r3
	mov.b	r3,@r2
	cmp/hi	r1,r0
	bf/s	_mr_copy_rom_bank_0
	add	#1,r2

	mov.l	__ROM1,r1
	mov.l	r0,@r1
	mov	#0,r1
	mova	_RAM1,r0
	mov.l	r1,@r0

	mov.l	_m_cache_start,r0
	mov.l	_m_block_start,r1
	mov.l	_m_block_size,r2
_mr_copy_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_mr_copy_to_cache
	add	#1,r0

	mov.l	_IOREGS,r1
	mov	#0,r0
	mov.b	r0,@(4,r1)	! REG_DIV	
	mov.b	r0,@(7,r1)	! REG_TAC

	rts
	nop


.align 1
rom_mask:	.short 0x3FFF
ram_mask:	.short 0x1FFF
exram_mask:	.short 0x1FFF
mbc2ram_mask:	.short 0x01FF
vram_mask:	.short 0x1FFF

.align 2
.long 0
_HIRAM:		.long MEM_CACHE_COPY_ADR + HIRAM - __MEM_COPY_TO_IWRAM_START__
_EXRAM:		.long EXRAM
_cart:		.long 0
_ROM1:		.long 0 
_RAM0:		.long RAM
_RAM1:		.long 0
_MBC2RAM:	.long MBC2RAM
_VRAM:		.long VRAM + UNCACHED_ADDRESS
!_OAM:		.long OAM + UNCACHED_ADDRESS
_IOREGS:	.long IOREGS + UNCACHED_ADDRESS

_m_cache_start:
	.long MEM_CACHE_COPY_ADR
_m_block_start:
	.long __MEM_COPY_TO_IWRAM_START__
_m_block_size:
	.long __MEM_COPY_TO_IWRAM_END__ - __MEM_COPY_TO_IWRAM_START__
	
ram_end:	.long 0xFDFF
oam_end:	.long 0xFE9F
io_start:	.long 0xFF00
io_end:		.long 0xFF4B
hiram_start:	.long 0xFF80
hiram_end:	.long 0xFFFE
mbc2ram_end:	.long 0xA1FF

ROM0_:		.long ROM0
__ROM0:		.long _ROM0 
__ROM1:		.long _ROM1 
_divcnt:	.long 0xC0000000 !divcnt

.align 2
romSelect:	.long 0
highRomBits:	.long 0
ramSelect:	.long 0
ramSelectLatch:	.long 0
mbc1Layout:	.long 0
highRomBitsLatch: .long 0
keys:		.long 0
num_banks:	.long 0

mbc1_ramwrite:	.long mem_write_byte_A000_BFFF_mbc1
mem_nullwrite:	.long mem_write_byte_null

_write_byte_ftbl: .long MEM_CACHE_COPY_ADR  + write_byte_ftbl - __MEM_COPY_TO_IWRAM_START__



.section .bss
.comm	ROM0,16384
.comm	RAM,8192
.comm	VRAM,8192
.comm	OAM,160
.comm	IOREGS,256
.comm	MBC2RAM,512
.comm	EXRAM,32768
	
