! shuboy.s
! a gameboy emulator
! sh2 assembly version
! /mic 2009

.section .data

.global _main

! ###########################################################################################################

.include "shuboy.inc"

! ###########################################################################################################

.align 1

_reset_machine:
	sts.l	pr,@-r15
	mov.l	__cpu_reset,r1
	jsr	@r1
	nop
	mov.l	__mem_reset,r1
	jsr	@r1
	nop
	mov.l	__ppu_reset,r1
	jsr	@r1
	nop
	lds.l	@r15+,pr
	nop
	rts
	nop
	

_load_rom:
	shll2	r0
	mov	r0,r2
	mov.l	__rom_table,r1
	add	r2,r1	
	mov.l	@r1,r0
	nop
	mov.l	__cart,r1
	nop
	mov.l	r0,@r1

	mov.l	__rom_sizes,r1
	add	r2,r1	
	mov.l	@r1,r0
	shlr8	r0
	mov.l	__num_banks,r1
	shlr2	r0
	shlr2	r0
	shlr2	r0	! r0 = size / 0x4000
	mov.l	r0,@r1
	rts
	nop
	

_emulate:
	mov	#0,r12

	mov.l	__ppu_mode,r1
	jsr	@r1
	mov	#0,r0
	mov.l	__cpu_execute,r1
	mov	#204,r0
	jsr	@r1
	extu.b	r0,r0
	
	mov.l	__ppu_mode,r1
	jsr	@r1
	mov	#2,r0
	mov.l	__cpu_execute,r1
	mov.w	_285,r0
	jsr	@r1
	nop
	
	mov.l	__ppu_mode,r1
	jsr	@r1
	mov	#3,r0
	mov.l	__cpu_execute,r1
	mov.w	_456,r0
	jsr	@r1
	nop
	
	mov.l	__ppu_scanline,r1
	mov.w	@r1,r0
	mov	#145,r1
	extu.b	r1,r1
	cmp/eq	r1,r0
	bf	_emulate_frame_not_done
	mov.l	__slavectl_send_command,r2
	mov	#SLAVE_CMD_SWITCH_FRAMEBUFFER,r0
	jsr	@r2
	nop
_emulate_frame_not_done:
	mov.l	__gui_process,r1
	jsr	@r1
	nop
	bra	_emulate
	nop
	

_main:
	mov.l	__slavectl_init,r1
	jsr	@r1
	nop

	mov.l	__event_init,r1
	jsr	@r1
	nop

	mov.l	__gui_init,r1
	jsr	@r1
	nop

	bsr	_load_rom
	mov	#1,r0
	
	bsr	_reset_machine
	nop

	bsr	_emulate
	nop


.align 2
__rom_table:
	.long _rom_table
__rom_sizes:
	.long _rom_sizes
__cart:
	.long _cart
__num_banks:
	.long num_banks
	
! ###########################################################################################################


.align 1
_285:
	.short 285
_456:
	.short 456
	
.align 2
__cpu_reset:
	.long _cpu_reset
__cpu_execute:
	.long CPU_CACHE_COPY_ADR + 0x0C

__event_init:
	.long _event_init
__event_add:
	.long _event_add
__event_get:
	.long _event_get

__mem_reset:
	.long _mem_reset

__gui_init:
	.long _gui_init
__gui_present:
	.long _gui_present
__gui_process:
	.long _gui_process

__ppu_mode:
	.long _ppu_mode
__ppu_reset:
	.long _ppu_reset
__ppu_scanline:
	.long _ppu_scanline + UNCACHED_ADDRESS
	
__slavectl_init:
	.long _slavectl_init
__slavectl_send_command:
	.long SLAVECTL_CACHE_COPY_ADR  !_slavectl_send_command
	
	