! slave.s
! shuboy slave sh2 control
! sh2 assembly version
! /mic 2009

.global _slavectl_init
.global _slavectl_send_command
.global _slave_init
.global _slave_main


! The Master<->Slave communication is implemented like this:
!
!  The Master adds a command for the Slave to execute by calling
!  _slavectl_send_command. This function first waits for the Slave's
!  status to become SLAVE_READY, then sends the command and whatever
!  data is needed through the communication port.
!  The Slave just sits in a loop looking for some command other than
!  SLAVE_CMD_NULL. Once it gets a command, the Slave sets its status
!  to SLAVE_BUSY and executes whatever task it has been given. Once it's
!  finished the Slave changes its status back to SLAVE_READY and starts
!  polling for a new command.

! The _slave_init function will explicitly copy all the code and most of the
! data that is to be used by the Slave to the Slave's cache, in order to reduce
! the amount of SDRAM access competitions.

! The different sync levels (specified by SLAVE_SYNC_LEVEL when assembling) are:
!
!  1: The Master doesn't add a new command until the Slave is ready.
!  2: The Master can add one more command while the Slave is busy.
!  3: The Master can add two more commands while the Slave is busy.


! ###########################################################################################################

.include "shuboy.inc"

! ###########################################################################################################


! This part contains code and data used by the main SH2

.section .data

.align 2

__SLAVECTL_COPY_TO_IWRAM_START__:
	
_slavectl_send_command:
.ifeq SLAVE_SYNC_LEVEL-1
	mov.l	_slave_status2,r4
.else
	mov.l	_slave_command2,r4
.ifeq SLAVE_SYNC_LEVEL-3
	add 	#2,r4
.endif
.endif
	nop
_scsc_wait:
.ifeq SLAVE_SYNC_LEVEL-3
	add	#-2,r4
.endif
	mov	#15,r5
_scsc_wait2:
	dt 	r5
	bf 	_scsc_wait2
.ifeq SLAVE_SYNC_LEVEL-3
	mov.w	@r4,r5
	tst	r5,r5
	bf	_scsc_wait_over
	add	#2,r4
.endif
	mov.w	@r4,r5
	tst	r5,r5
	bf	_scsc_wait
_scsc_wait_over:	
	mov.w	r0,@r4
	rts
	nop

.align 2
__cache_ctl:
        .long 0xFFFFFE92
_slave_command2:
	.long 0x20004020 
_slave_status2:
	.long 0x20004024 
_slave_data2:
	.long slave_data + UNCACHED_ADDRESS
_sync_flag:
	.long 0
__sync_flag:
	.long _sync_flag
	
__SLAVECTL_COPY_TO_IWRAM_END__:


_slavectl_init:
	mov.l	_sc_cache_start,r0
	mov.l	_sc_block_start,r1
	mov.l	_sc_block_size,r2
_sci_copy_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_sci_copy_to_cache
	add	#1,r0
	rts
	nop
	
.align 2

_sc_cache_start:
	.long SLAVECTL_CACHE_COPY_ADR
_sc_block_start:
	.long __SLAVECTL_COPY_TO_IWRAM_START__
_sc_block_size:
	.long __SLAVECTL_COPY_TO_IWRAM_END__ - __SLAVECTL_COPY_TO_IWRAM_START__
	
	
! ###########################################################################################################


! This part contains code and data used by the slave SH2

_slave_init:
	mov.l	_slave_command,r0
	mov	#SLAVE_CMD_NULL,r1
	mov.w	r1,@r0
	add	#2,r0
	mov.w	r1,@r0
	mov.l	_slave_status,r0
	mov	#SLAVE_READY,r1
	mov.l	r1,@r0

	mov.l	__s_ppu_scanline,r0
	mov	#0,r1
	mov.l	r1,@r0
	
	mov.l	_s_cache_start,r0
	mov.l	_s_block_start,r1
	mov.l	_s_block_size,r2
_si_copy_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_si_copy_to_cache
	add	#1,r0

	! Copy code/data from ppu.s to the slave SH2 cache
	mov.l	_p_cache_start,r0
	mov.l	_p_block_start,r1
	mov.l	_p_block_end,r2
	sub	r1,r2
_si_copy_ppu_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_si_copy_ppu_to_cache
	add	#1,r0

	! Copy code/data from gui.s to the slave SH2 cache
	mov.l	_g_cache_start,r0
	mov.l	_g_block_start,r1
	mov.l	_g_block_end,r2
	sub	r1,r2
_si_copy_gui_to_cache:
	mov.b	@r1,r3
	add	#1,r1
	mov.b	r3,@r0
	dt	r2
	bf/s	_si_copy_gui_to_cache
	add	#1,r0
	
	rts
	nop

	
_slave_main:
	bsr	_slave_init
	nop
	mov.l	_s_cache_start,r2
	jsr	@r2
	nop
	bra	_slave_main
	nop
	
.align 2

_s_cache_start:
	.long SLAVE_CACHE_COPY_ADR
_s_block_start:
	.long __SLAVE_COPY_TO_IWRAM_START__
_s_block_size:
	.long __SLAVE_COPY_TO_IWRAM_END__ - __SLAVE_COPY_TO_IWRAM_START__

_p_cache_start:
	.long PPU_CACHE_COPY_ADR
_p_block_start:
	.long __PPU_COPY_TO_IWRAM_START__
_p_block_end:
	.long __PPU_COPY_TO_IWRAM_END__ 

_g_cache_start:
	.long GUI_CACHE_COPY_ADR
_g_block_start:
	.long __GUI_COPY_TO_IWRAM_START__
_g_block_end:
	.long __GUI_COPY_TO_IWRAM_END__

__s_ppu_scanline:
	.long _s_ppu_scanline

! ###########################################################################################################


__SLAVE_COPY_TO_IWRAM_START__:
	
_slave_main_loop:
	mov.l	_slave_command,r2
.ifeq SLAVE_SYNC_LEVEL-3
	add	#2,r2
.endif
_slave_main_loop_:	
.ifeq SLAVE_SYNC_LEVEL-3
	add	#-2,r2
.endif
	mov	#12,r5
_sml_wait:
	dt 	r5
	bf 	_sml_wait
.ifeq SLAVE_SYNC_LEVEL-3
	mov.w	@r2,r0
	nop
	cmp/eq	#SLAVE_CMD_NULL,r0
	bf	_sml_got_command
	add	#2,r2
.endif
	mov.w	@r2,r0
	nop
	cmp/eq	#SLAVE_CMD_NULL,r0
	bt	_slave_main_loop_
_sml_got_command:	
	cmp/eq	#SLAVE_CMD_DRAW_SCANLINE,r0
	bf	1f
	mov	#SLAVE_CMD_NULL,r1
	mov.w	r1,@r2
	mov.l	_slave_status,r2
	mov	#SLAVE_BUSY,r1
	mov.l	r1,@r2
	nop
	mov.l	_IOREGS6,r14
	mov.l	_ppu_draw_scanline6,r1
	jsr	@r1
	nop
	mov.l	_slave_status,r2
	mov	#SLAVE_READY,r1
	mov.l	r1,@r2
	bra	_slave_main_loop
	nop
1:
	cmp/eq	#SLAVE_CMD_SWITCH_FRAMEBUFFER,r0
	bf	2f
	mov	#SLAVE_CMD_NULL,r1
	mov.w	r1,@r2
	mov.l	_slave_status,r2
	mov	#SLAVE_BUSY,r1
	mov.l	r1,@r2
	nop
	mov.l	_gui_present6,r1
	jsr	@r1
	nop
	mov.l	_slave_status,r2
	mov	#SLAVE_READY,r1
	mov.l	r1,@r2
	bra	_slave_main_loop
	nop
2:
_sml_end:
	bra	_slave_main_loop
	nop


.align 2
_IOREGS6:
	.long IOREGS + UNCACHED_ADDRESS
_ppu_draw_scanline6:
	.long PPU_CACHE_COPY_ADR !ppu_draw_scanline
_gui_present6:
	.long GUI_CACHE_COPY_ADR !_gui_present
        
slave_data:
	.long 0,0,0,0
_slave_command:
	.long 0x20004020 
_slave_status:
	.long 0x20004024 
_slave_data:
	.long slave_data + UNCACHED_ADDRESS

__SLAVE_COPY_TO_IWRAM_END__:
	
