Wired         Segment Para Public

              ASSUME DS:Wired,CS:Wired

              ORG    100h

              .386

Start:        JMP    DemoStart

include democode.inc


;                             Initialized DATA                                 ;

ErrorMsg      DB     "This intro needs a 386, VGA and 80Kb RAM",0Ah,0Dh,'$'
Copyright     DB     "(c) 1994 Tasmaniac  (CiD  ôypernov.",0ah,0dh,'$'

Tile0         DB     00000000b
              DB     00000000b
              DB     00000000b
              DB     00000000b
              DB     00000000b
              DB     00000000b
              DB     00000000b
              DB     00000000b
Tile1         DB     11111111b
              DB     11111111b
              DB     11111111b
              DB     11111111b
              DB     11111111b
              DB     11111111b
              DB     11111111b
              DB     11111111b
Tile2         DB     11111111b
              DB     01111111b
              DB     01111111b
              DB     00111111b
              DB     00011111b
              DB     00001111b
              DB     00000111b
              DB     00000001b
Tile3         DB     00000001b
              DB     00000111b
              DB     00001111b
              DB     00011111b
              DB     00111111b
              DB     01111111b
              DB     01111111b
              DB     11111111b
Tile4         DB     11111111b
              DB     11111110b
              DB     11111110b
              DB     11111100b
              DB     11111000b
              DB     11110000b
              DB     11100000b
              DB     10000000b
Tile5         DB     10000000b
              DB     11100000b
              DB     11110000b
              DB     11111000b
              DB     11111100b
              DB     11111110b
              DB     11111110b
              DB     11111111b
Tile6         DB     11111111b
              DB     01111111b
              DB     00111111b
              DB     00011111b
              DB     00111111b
              DB     01111111b
              DB     01111111b
              DB     11111111b

              .Radix 16
Screen        DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     51,11,11,11,13,00,51,11,11,11,13,00,51,13,00,11,11,11,11,13
              DB     11,11,00,00,11,00,11,11,00,00,11,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,11,00,41,12,00,11,11,00,00,11
              DB     11,11,11,10,11,00,11,11,00,00,00,00,00,00,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,00,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,00,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,00,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,11,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,11,11,00,00,11,00,11,11,00,11,11,00,00,11
              DB     11,11,00,00,11,00,41,11,11,11,12,00,11,11,00,11,11,11,11,12
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              DB     00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
              .RADIX  10

SinTab        DB     128,130,131,133,135,137,138,140,142,143,145,147,148,150,152,153,155,156,158,159,161,163,164,165,167,168,170,171,172,174,175,176,177,179,180,181,182,183,184,185,186,187,188,189,190,191,191,192,193,193,194,194,195,195,196,196,197,197,197,197,198,198,198,198,198,198,198,198,198,197,197,197,197,196,196,195,195,194,194,193,193,192,191,191,190,189,188,187,186,185,184,183,182,181,180,179,177,176,175,174,172,171,170,168,167,165,164,163,161,159,158,156,155,153,152,150,148,147,145,143,142,140,138,137,135,133,131,130,128,126,125,123,121,119,118,116,114,113,111,109,108,106,104,103,101,100,98,97,95,93,92,91,89,88,86,85,84,82,81,80,79,77,76,75,74,73,72,71,70,69,68,67,66,65,65,64,63,63,62,62,61,61,60,60,59,59,59,59,58,58,58,58,58,58,58,58,58,59,59,59,59,60,60,61,61,62,62,63,63,64,65,65,66,67,68,69,70,71,72,73,74,75,76,77,79,80,81,82,84,85,86,88,89,91,92,93,95,97,98,100,101,103,104,106,108,109,111,113,114,116,118,119,121,123,125,126
CosTab        DB     110,110,110,110,110,109,109,109,108,108,107,106,106,105,104,103,102,101,100,99,98,97,96,94,93,92,90,89,87,86,84,82,81,79,77,75,73,72,70,68,66,63,61,59,57,55,53,51,48,46,44,41,39,37,34,32,30,27,25,22,20,17,15,12,10,8,5,3,0,254,251,249,246,244,242,239,237,235,232,230,228,225,223,221,219,217,215,213,210,208,206,204,203,201,199,197,195,194,192,190,189,187,186,184,183,182,180,179,178,177,176,175,174,173,172,171,170,170,169,168,168,167,167,167,166,166,166,166,166,166,166,166,166,167,167,167,168,168,169,170,170,171,172,173,174,175,176,177,178,179,180,182,183,184,186,187,189,190,192,194,195,197,199,201,203,204,206,208,210,213,215,217,219,221,223,225,228,230,232,235,237,239,242,244,246,249,251,254,0,3,5,8,10,12,15,17,20,22,25,27,30,32,34,37,39,41,44,46,48,51,53,55,57,59,61,63,66,68,70,72,73,75,77,79,81,82,84,86,87,89,90,92,93,94,96,97,98,99,100,101,102,103,104,105,106,106,107,108,108,109,109,109,110,110,110,110
Palette       DB     0,0,0
              DB     0,0,1
              DB     0,0,2
              DB     0,0,3
              DB     0,0,4
              DB     0,0,5
              DB     0,0,6
              DB     0,0,7
              DB     0,0,8
              DB     0,0,9
              DB     0,0,10
              DB     0,0,11
              DB     0,0,12
              DB     0,0,13
              DB     0,0,14
              DB     0,0,15
              DB     0,0,16
              DB     0,0,17
              DB     0,0,18
              DB     0,0,19
              DB     0,0,20
              DB     0,0,21
              DB     0,0,22
              DB     0,0,23
              DB     0,0,24
              DB     0,0,25
              DB     0,0,26
              DB     0,0,27
              DB     0,0,28
              DB     0,0,29
              DB     0,0,30
              DB     0,0,31
              DB     0,0,32
              DB     0,0,33
              DB     0,0,34
              DB     0,0,35
              DB     0,0,36
              DB     0,0,37
              DB     0,0,38
              DB     0,0,39
              DB     0,0,40
              DB     0,0,41
              DB     0,0,42
              DB     0,0,43
              DB     0,0,44
              DB     0,0,45
              DB     0,0,46
              DB     0,0,47
              DB     0,0,48
              DB     0,0,49
              DB     0,0,50
              DB     0,0,51
              DB     0,0,52
              DB     0,0,53
              DB     0,0,54
              DB     0,0,55
              DB     0,0,56
              DB     0,0,57
              DB     0,0,58
              DB     0,0,59
              DB     0,0,60
              DB     0,0,61
              DB     0,0,62
              DB     0,0,63
              DB     0,0,63
              DB     0,1,62
              DB     0,2,61
              DB     0,3,60
              DB     0,4,59
              DB     0,5,58
              DB     0,6,57
              DB     0,7,56
              DB     0,8,55
              DB     0,9,54
              DB     0,10,53
              DB     0,11,52
              DB     0,12,51
              DB     0,13,50
              DB     0,14,49
              DB     0,15,48
              DB     0,16,47
              DB     0,17,46
              DB     0,18,45
              DB     0,19,44
              DB     0,20,43
              DB     0,21,42
              DB     0,22,41
              DB     0,23,40
              DB     0,24,39
              DB     0,25,38
              DB     0,26,37
              DB     0,27,36
              DB     0,28,35
              DB     0,29,34
              DB     0,30,33
              DB     0,31,32
              DB     0,32,31
              DB     0,33,30
              DB     0,34,29
              DB     0,35,28
              DB     0,36,27
              DB     0,37,26
              DB     0,38,25
              DB     0,39,24
              DB     0,40,23
              DB     0,41,22
              DB     0,42,21
              DB     0,43,20
              DB     0,44,19
              DB     0,45,18
              DB     0,46,17
              DB     0,47,16
              DB     0,48,15
              DB     0,49,14
              DB     0,50,13
              DB     0,51,12
              DB     0,52,11
              DB     0,53,10
              DB     0,54,9
              DB     0,55,8
              DB     0,56,7
              DB     0,57,6
              DB     0,58,5
              DB     0,59,4
              DB     0,60,3
              DB     0,61,2
              DB     0,62,1
              DB     0,63,0
              DB     0,63,0
              DB     1,62,0
              DB     2,61,0
              DB     3,60,0
              DB     4,59,0
              DB     5,58,0
              DB     6,57,0
              DB     7,56,0
              DB     8,55,0
              DB     9,54,0
              DB     10,53,0
              DB     11,52,0
              DB     12,51,0
              DB     13,50,0
              DB     14,49,0
              DB     15,48,0
              DB     16,47,0
              DB     17,46,0
              DB     18,45,0
              DB     19,44,0
              DB     20,43,0
              DB     21,42,0
              DB     22,41,0
              DB     23,40,0
              DB     24,39,0
              DB     25,38,0
              DB     26,37,0
              DB     27,36,0
              DB     28,35,0
              DB     29,34,0
              DB     30,33,0
              DB     31,32,0
              DB     32,31,0
              DB     33,30,0
              DB     34,29,0
              DB     35,28,0
              DB     36,27,0
              DB     37,26,0
              DB     38,25,0
              DB     39,24,0
              DB     40,23,0
              DB     41,22,0
              DB     42,21,0
              DB     43,20,0
              DB     44,19,0
              DB     45,18,0
              DB     46,17,0
              DB     47,16,0
              DB     48,15,0
              DB     49,14,0
              DB     50,13,0
              DB     51,12,0
              DB     52,11,0
              DB     53,10,0
              DB     54,9,0
              DB     55,8,0
              DB     56,7,0
              DB     57,6,0
              DB     58,5,0
              DB     59,4,0
              DB     60,3,0
              DB     61,2,0
              DB     62,1,0
              DB     63,0,0
              DB     63,0,0
              DB     62,0,0
              DB     61,0,0
              DB     60,0,0
              DB     59,0,0
              DB     58,0,0
              DB     57,0,0
              DB     56,0,0
              DB     55,0,0
              DB     54,0,0
              DB     53,0,0
              DB     52,0,0
              DB     51,0,0
              DB     50,0,0
              DB     49,0,0
              DB     48,0,0
              DB     47,0,0
              DB     46,0,0
              DB     45,0,0
              DB     44,0,0
              DB     43,0,0
              DB     42,0,0
              DB     41,0,0
              DB     40,0,0
              DB     39,0,0
              DB     38,0,0
              DB     37,0,0
              DB     36,0,0
              DB     35,0,0
              DB     34,0,0
              DB     33,0,0
              DB     32,0,0
              DB     31,0,0
              DB     30,0,0
              DB     29,0,0
              DB     28,0,0
              DB     27,0,0
              DB     26,0,0
              DB     25,0,0
              DB     24,0,0
              DB     23,0,0
              DB     22,0,0
              DB     21,0,0
              DB     20,0,0
              DB     19,0,0
              DB     18,0,0
              DB     17,0,0
              DB     16,0,0
              DB     15,0,0
              DB     14,0,0
              DB     13,0,0
              DB     12,0,0
              DB     11,0,0
              DB     10,0,0
              DB     9,0,0
              DB     8,0,0
              DB     7,0,0
              DB     6,0,0
              DB     5,0,0
              DB     4,0,0
              DB     3,0,0
              DB     2,0,0
              DB     1,0,0
              DB     0,0,0

ALIGN         4
FrameNum      DD     0

;                                 Demo Start                                   ;

DemoStart     PROC   NEAR
              CLI
              MOV    SP,Offset EndByte
              STI
              MOV    AX,13h
              INT    10h
              CALL   INIT
              JC     StopRun

              SetPalette   Palette,0,256

NextFrame:    CALL   DemoFrame         ; Do a frame
              MOV    AH,01
              INT    16h
              JE     NextFrame
              JMP    Quit

Quit:         CALL   CleanUp           ; Cleanup

              MOV    AX,00003h
              INT    10h
StopRun:      MOV    AH,09h
              MOV    DX,Offset Copyright
              INT    21H

              MOV    AX,4C00h
              INT    21h
DemoStart     ENDP


;                             Initialization code                              ;

Init          PROC   NEAR
            ; Reallocate EXE and allocate memory
              MOV    AH,04Ah
              MOV    BX,Offset ENDByte
              SHR    BX,4
              INC    BX
              INT    21h
              JC     Error

              MOV    AX,CS
              MOV    DS,AX

              MOV    BX,4000
              MOV    AH,48h
              INT    21h
              JC     Error
              MOV    GS,AX

              MOV    AX,01A00h               ;Display Combination Code
              INT    10h                     ;
              CMP    AL,01Ah                 ;Is AL=01Ah --> VGA
              JNE    Error

; Test for 8088, 8086, V20, V30, 80188, 80186
;  On these processors bits 12-15 (high nibble) of flags register are
;  always SET
              MOV    BX,0F000h         ; We'll be using this value a few times.
              XOR    AX,AX             ; AX = 0
              PUSH   AX                ; Push 0 to stack
              POPF                     ; Pop as flags
              PUSHF                    ; Push flags
              POP    AX                ; Pop as AX
              AND    AX,BX             ; We only need bits 12-15
              CMP    AX,BX             ; All bits set ?
              JE     Error             ; It's not even a 286 !!
; Test for a 80286
;  bits 12-15 (high nibble) of the flags registerare always cleared on the
;  80286.
              MOV    AX,BX             ; Set bits 12-15
              PUSH   AX                ; Push to stack
              POPF                     ; Pop as flags
              PUSHF                    ; Push flags
              POP    AX                ; Pop as AX
              AND    AX,BX             ; Mask of bits 12-15
              JZ     Error             ; It's a 286 !!

              CALL   BuildPicture

              MOV    AX,VideoSeg
              MOV    ES,AX

              CLC
              RET

Error:        MOV    DX,Offset ErrorMsg
              MOV    AH,09h
              INT    21h
              STC
              RET

Init          ENDP


;                                Build Picture                                 ;


Tiles         DW     Offset Tile0, Offset Tile1, Offset Tile2, Offset Tile3
              DW     Offset Tile4, Offset Tile5, Offset Tile6

BuildPicture  PROC   NEAR
              MOV    AX,GS
              MOV    ES,AX
              MOV    DI,0
              MOV    SI,Offset Screen
              MOV    CX,32000
              CLD

              MOV    CH,25             ; 25 Rows
NextRow:      MOV    CL,20             ; 20 Columns
NextCol:      LODSB
              DEC    SI

              MOVZX  BX,AL
              SHR    BX,4
              SHL    BX,1
              MOV    BX,[Tiles+BX]
              MOV    DH,8
NextTileRow1: MOV    DL,8
              MOV    BP,[BX]
NextTileCol1: XOR    AL,AL
              SHR    BP,1
              RCR    AL,1
              STOSB
              DEC    DL
              JNZ    NextTileCol1

              INC    BX
              ADD    DI,320-8
              DEC    DH
              JNZ    NextTileRow1

              SUB    DI,320*8-8
           ;;;;;;
              LODSB

              MOVZX  BX,AL
              AND    BX,0Fh
              SHL    BX,1
              MOV    BX,[Tiles+BX]
              MOV    DH,8
NextTileRow2: MOV    DL,8
              MOV    BP,[BX]
NextTileCol2: XOR    AL,AL
              SHR    BP,1
              RCR    AL,1
              STOSB
              DEC    DL
              JNZ    NextTileCol2

              INC    BX
              ADD    DI,320-8
              DEC    DH
              JNZ    NextTileRow2

              SUB    DI,8*320-8
              DEC    CL
              JNZ    NextCol

              ADD    DI,7*320
              DEC    CH
              JNZ    NextRow

              RET
BuildPicture  ENDP



;                                 Demo Frame                                   ;


Ctr1          DB     255
Ctr2          DB     000
Ctr3          DB     255
Ctr4          DB     000


DemoFrame     PROC   NEAR
              MOV    AX,CS
              MOV    DS,AX
              INC    [FrameNum]

              vsync

              MOV    BL,[Ctr1]
              ADD    BL,-2
              MOV    [Ctr1],BL
              MOV    BH,[Ctr3]
              ADD    BH,-1
              MOV    [Ctr3],BH

              MOV    DI,0

              MOV    DL,0
              XOR    BH,BH
@ForY:
 ;      ctr2:=stable[(y+ctr1) mod 256];  }
              MOV    BL,DL
              ADD    BL,[Ctr1]     ; BL = Y+CTR1 MOD 256 }
              MOV    AL,BYTE PTR [SinTab+BX]
              MOV    [Ctr2],AL
 ;      ctr4:=stable[(y+ctr3) mod 256];  }
              MOV    BL,DL
              ADD    BL,[Ctr3]     ; BL = Y+CTR3 MOD 256 }
              MOV    AL,BYTE PTR [SinTab+BX]
              MOV    [Ctr4],AL

              MOV    DH,0
@ForX:
              MOV    CH,DH
              SHR    CH,1
 ;      c:=stable[(x+ctr2) mod 256]+ctable[(y+ctr4) mod 256]; }
              MOV    BL,CH
              ADD    BL,[Ctr2]     ; BL = X+CTR2 MOD 256 }
              MOV    AH,BYTE PTR [SinTab+BX]
              MOV    BL,DL
              ADD    BL,[Ctr4]     ; BL = Y+CTR4 MOD 256 }
              ADD    AH,BYTE PTR [CosTab+BX]
 ;      memw[curpage:temp]:=c SHL 8 + c; }

              INC    CH
 ;      c:=stable[(x+ctr2) mod 256]+ctable[(y+ctr4) mod 256]; }
              MOV    BL,CH
              ADD    BL,[Ctr4]     ; BL = X+CTR2 MOD 256 }
              MOV    AL,BYTE PTR [CosTab+BX]
              MOV    BL,DL
              ADD    BL,[Ctr2]     ; BL = Y+CTR4 MOD 256 }
              ADD    AL,BYTE PTR [SinTab+BX]
 ;      memw[curpage:temp]:=c SHL 8 + c; }

              MOV    CX,Word Ptr [FrameNum]
              ADD    CL,DL
              TEST   CL,1
              JZ     @Star
              XCHG   AL,AH
     @Star :
              XOR    AX,GS:[DI]
              STOSW

              INC    DH
              CMP    DH,159
              JBE    @ForX

              INC    DL
              CMP    DL,199
              JBE    @ForY

              RET
DemoFrame     ENDP


;                                 Cleanup                                   ;


Cleanup       PROC   NEAR
              RET
Cleanup       ENDP



              EVEN
OurStack      DW     512 DUP (?)
ENDBYTE       DW     ?

Wired         ENDS
              END    Start







