
/* Remember that 3DStudio in ASCII format ONLY uses triangles */

#include <math.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>

/* esta es la rutina principal de prueba */

char scanning(FILE *fd,char *cadena){

    char temp[80];

    do{
        fscanf(fd,"%s",&temp);
    } while(strcmp(temp,cadena) && strlen(temp)!=0);
    if(!strcmp(temp,cadena)) return(0);
    else return(1);
}

void main(int argc,char *argv[]){

    int i,j,fd2,k;
    int t1,t2,t3;
    FILE *fd;
    short int vertices,faces;
    char temp[80];
    int tmp;
    int *puntos;
    short valor,color;
    short *caras,*caras0;
    int *normals;
    float A,B,C,D,AT,TT;
    int x1,x2,x3,y1,y2,y3,z1,z2,z3,x10,y10,z10,x20,y20,z20,x30,y30,z30;
    int m,temporal;
    int faces2;
    float mmm;
    float A0,B0,C0,dot;
    float w1,w2;

    /* abre el fichero de entrada formato .ASC */

    puntos = (int *)malloc(100000);
    caras = (short *)malloc(100000);
    normals = (int *)malloc(100000);
    caras0 = (short *)malloc(100000);

    if(argc!=4){
        printf(".ASC (3DStudio) to .R3D (Real3D v3.00)\n");
        printf("(C) Jorge Cabezas Garcia'95\n\n");
        printf("Usage: asc2r3d <infile> <outfile> <precision>\n");
        exit(1);
    }

    if((fd = fopen(argv[1],"rt"))==NULL){
        printf("Error reading file %s\n",argv[1]);
        exit(1);
    }

    /* busca vertices */

    scanning(fd,"Vertices:");
    fscanf(fd,"%d",&vertices);
    printf("Number of vertexs: %d\n",vertices);
    scanning(fd,"Faces:");
    fscanf(fd,"%d",&faces);
    printf("Number of faces: %d\n",faces);

    /* coge uno a uno los vertices */
    scanning(fd,"Vertex");
    scanning(fd,"list:");

    j = 0;
    for(i=0;i<vertices;i++){
        scanning(fd,"Vertex");
        fscanf(fd,"%s",temp);
        scanning(fd,"X:");
        fscanf(fd,"%d",&tmp);
        puntos[j] = tmp; j++;
        scanning(fd,"Y:");
        fscanf(fd,"%d",&tmp);
        puntos[j] = tmp; j++;
        scanning(fd,"Z:");
        fscanf(fd,"%d",&tmp);
        puntos[j] = tmp; j++;
        printf("X: %d Y: %d Z: %d                    \r",puntos[j-3],puntos[j-2],puntos[j-1]);
    }
    printf("\n");

    /* ahora busca las caras */

    scanning(fd,"Face");
    scanning(fd,"list:");

    j = 0;
    k = 0;
    for(i=0;i<faces;i++){
        scanning(fd,"Face");
        fscanf(fd,"%s",temp);

        fscanf(fd,"%s",temp);
        caras0[j] = atoi(temp+2); j++;
        fscanf(fd,"%s",temp);
        caras0[j] = atoi(temp+2); j++;
        fscanf(fd,"%s",temp);
        caras0[j] = atoi(temp+2); j++;
        printf("A: %hd B: %hd C: %hd                    \r",caras0[j-3],caras0[j-2],caras0[j-1]);

        /* busca la direccion del polgono */
//        fscanf(fd,"%s",temp);
//        t1 = atoi(temp+3);
//        fscanf(fd,"%s",temp);
//        t2 = atoi(temp+3);
//        fscanf(fd,"%s",temp);
//        t3 = atoi(temp+3);
//        /* mira la direccion del polgono */
//        if(t1 && t2){
//             direccion[k] = 1; k++;
//        } else if(t2 && t3){
//             direccion[k] = 2; k++;
//        } else {
//             direccion[k] = 0;k++;
//        }
    }
    printf("\n");
    fclose(fd);

    printf("Reducing faces...\n");


    temporal = 0;
    k = 0;
    faces2 = 0;
    for(i=0;i<faces;i++){

      if(caras0[k]!=-1){

        x1 = puntos[caras0[k]*3];
        y1 = puntos[caras0[k]*3+1];
        z1 = puntos[caras0[k]*3+2];

        x2 = puntos[caras0[(k+1)]*3];
        y2 = puntos[caras0[(k+1)]*3+1];
        z2 = puntos[caras0[(k+1)]*3+2];

        x3 = puntos[caras0[(k+2)]*3];
        y3 = puntos[caras0[(k+2)]*3+1];
        z3 = puntos[caras0[(k+2)]*3+2];

        A = y1*(z2-z3) + y2*(z3-z1) + y3*(z1-z2);
        B = z1*(x2-x3) + z2*(x3-x1) + z3*(x1-x2);
        C = x1*(y2-y3) + x2*(y3-y1) + x3*(y1-y2);
/*        D = -x1*(y2*z3 - y3*z2) - x2*(y3*z1 - y1*z3) - x3*(y1*z2 - y2*z1); */

        m = (i+1)*3;
        for(j=i+1;j<faces;j++){


         if(caras0[m]!=-1){
           x10 = puntos[caras0[m]*3];
           y10 = puntos[caras0[m]*3+1];
           z10 = puntos[caras0[m]*3+2];

           x20 = puntos[caras0[(m+1)]*3];
           y20 = puntos[caras0[(m+1)]*3+1];
           z20 = puntos[caras0[(m+1)]*3+2];

           x30 = puntos[caras0[(m+2)]*3];
           y30 = puntos[caras0[(m+2)]*3+1];
           z30 = puntos[caras0[(m+2)]*3+2];

           A0 = y10*(z20-z30) + y20*(z30-z10) + y30*(z10-z20);
           B0 = z10*(x20-x30) + z20*(x30-x10) + z30*(x10-x20);
           C0 = x10*(y20-y30) + x20*(y30-y10) + x30*(y10-y20);


           dot = (A*A0+B*B0+C*C0)/(sqrt(A*A+B*B+C*C)*sqrt(A0*A0+B0*B0+C0*C0));
           w1 = 1 - atof(argv[3]);
           w2 = 1 + atof(argv[3]);
           if(dot>w1 && dot<w2){

            /* todas las posibilidades */
            /* 18 en total             */
            /* algunas combinaciones no son posibles...pero bueno... */

            /* 1 */

             if(x1==x10 && y1==y10 && z1==z10 && x3==x30 && y3==y30 && z3==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m+1];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x10 && y1==y10 && z1==z10 && x3==x20 && y3==y20 && z3==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x20 && y1==y20 && z1==z20 && x3==x30 && y3==y30 && z3==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x20 && y1==y20 && z1==z20 && x3==x10 && y3==y10 && z3==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x30 && y1==y30 && z1==z30 && x3==x20 && y3==y20 && z3==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x30 && y1==y30 && z1==z30 && x3==x10 && y3==y10 && z3==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[k+2];
                caras[temporal+4] = caras0[m+1];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else

            /* 2 */
             if(x1==x10 && y1==y10 && z1==z10 && x2==x30 && y2==y30 && z2==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m+1];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x10 && y1==y10 && z1==z10 && x2==x20 && y2==y20 && z2==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m+2];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x20 && y1==y20 && z1==z20 && x2==x30 && y2==y30 && z2==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x20 && y1==y20 && z1==z20 && x2==x10 && y2==y10 && z2==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m+2];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x30 && y1==y30 && z1==z30 && x2==x20 && y2==y20 && z2==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x1==x30 && y1==y30 && z1==z30 && x2==x10 && y2==y10 && z2==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[m+1];
                caras[temporal+3] = caras0[k+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else

            /* 3 */
             if(x2==x20 && y2==y20 && z2==z20 && x3==x30 && y3==y30 && z3==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x2==x20 && y2==y20 && z2==z20 && x3==x10 && y3==y10 && z3==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m+2];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x2==x10 && y2==y10 && z2==z10 && x3==x30 && y3==y30 && z3==z30){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x2==x10 && y2==y10 && z2==z10 && x3==x20 && y3==y20 && z3==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m+2];
                caras[temporal+4] = caras0[k+2];
                temporal = temporal + 5;
                caras0[k] = -1;
                caras0[m] = -1;
                j = faces;
                faces2++;
             } else
             if(x2==x30 && y2==y30 && z2==z30 && x3==x10 && y3==y10 && z3==z10){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m+1];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             } else
             if(x2==x30 && y2==y30 && z2==z30 && x3==x20 && y3==y20 && z3==z20){
                caras[temporal] = 4;
                caras[temporal+1] = caras0[k];
                caras[temporal+2] = caras0[k+1];
                caras[temporal+3] = caras0[m];
                caras[temporal+4] = caras0[k+2];
                caras0[k] = -1;
                caras0[m] = -1;
                temporal = temporal + 5;
                j = faces;
                faces2++;
             }


           }

         }
         m += 3;
        }
     }
     if(caras0[k]!=-1){
        caras[temporal] = 3;
        caras[temporal+1] = caras0[k];
        caras[temporal+2] = caras0[k+1];
        caras[temporal+3] = caras0[k+2];
        temporal += 4;
        faces2++;
     }
     k += 3;
    }


    /* now check for normals on faces vertices */

    mmm = 100 - 100*faces2/faces;
    printf("Now %d faces: %2.1f%% of reduction\n",faces2,mmm);
    faces = faces2;
    m = 0;

    printf("Calculating normals...\n");

    for(i=0;i<vertices;i++){
        k = 0;
        A = 0;
        B = 0;
        C = 0;
        AT = 0;
        for(j=0;j<faces;j++){

          if(caras[k]==3){

            /* check this face */
            if((caras[k+1]==i || caras[k+2]==i || caras[k+3]==i)){


                x1 = puntos[caras[k+1]*3];
                y1 = puntos[caras[k+1]*3+1];
                z1 = puntos[caras[k+1]*3+2];

                x2 = puntos[caras[(k+2)]*3];
                y2 = puntos[caras[(k+2)]*3+1];
                z2 = puntos[caras[(k+2)]*3+2];

                x3 = puntos[caras[(k+3)]*3];
                y3 = puntos[caras[(k+3)]*3+1];
                z3 = puntos[caras[(k+3)]*3+2];

                A += y1*(z2-z3) + y2*(z3-z1) + y3*(z1-z2);
                B += z1*(x2-x3) + z2*(x3-x1) + z3*(x1-x2);
                C += x1*(y2-y3) + x2*(y3-y1) + x3*(y1-y2);

                AT++;
            }
            k += 4;
           } else if(caras[k]==4){
            /* check this face */
            if((caras[k+1]==i || caras[k+2]==i || caras[k+3]==i || caras[k+4]==i)){


                x1 = puntos[caras[k+1]*3];
                y1 = puntos[caras[k+1]*3+1];
                z1 = puntos[caras[k+1]*3+2];

                x2 = puntos[caras[(k+2)]*3];
                y2 = puntos[caras[(k+2)]*3+1];
                z2 = puntos[caras[(k+2)]*3+2];

                x3 = puntos[caras[(k+3)]*3];
                y3 = puntos[caras[(k+3)]*3+1];
                z3 = puntos[caras[(k+3)]*3+2];

                A += y1*(z2-z3) + y2*(z3-z1) + y3*(z1-z2);
                B += z1*(x2-x3) + z2*(x3-x1) + z3*(x1-x2);
                C += x1*(y2-y3) + x2*(y3-y1) + x3*(y1-y2);

                AT++;
            }
            k += 5;

           }
        }

        /* now merge normal vectors and normalize (16 bits) */

        A = A / AT;
        B = B / AT;
        C = C / AT;

        TT = A*A + B*B + C*C;
        TT = sqrt(TT);
        A = A / TT;
        B = B / TT;
        C = C / TT;

        gcvt(A*32000,16,temp);
        temporal = atoi(temp);
        normals[m] = temporal;
        gcvt(B*32000,16,temp);
        temporal = atoi(temp);
        normals[m+1] = temporal;
        gcvt(C*32000,16,temp);
        temporal = atoi(temp);
        normals[m+2] = temporal;

        m += 3;
    }

    /* now save the file in our own format */

    printf("Saving...");

    if((fd2 = open(argv[2],O_WRONLY | O_CREAT | O_TRUNC | O_BINARY,S_IRWXU))<0){
       printf("Error creating file %s\n",argv[2]);
       exit(1);
    }

    write(fd2,&vertices,sizeof(vertices));
    write(fd2,&faces,sizeof(faces));
    write(fd2,puntos,vertices*3*4);
    write(fd2,normals,vertices*3*4);

    j = 0;
    k = 0;
    color = 0;
    for(i=0;i<faces;i++){
        if(caras[j]==3){
            valor = 4;              //siempre uno ms, por la construccion de la rutina
            write(fd2,&valor,sizeof(valor));
            color++;
            write(fd2,&color,sizeof(color));
            valor = 0;
            write(fd2,&valor,sizeof(valor));  //lo que seria el vector normal
            valor = caras[j+3];
            write(fd2,&valor,sizeof(valor));
            valor = caras[j+2];
            write(fd2,&valor,sizeof(valor));
            valor = caras[j+1];
            write(fd2,&valor,sizeof(valor));
            valor = 1;
            write(fd2,&valor,sizeof(valor));  //testear siempre visibilidad
            j += 4;
        } else if(caras[j]==4){
            valor = 5;              //siempre uno ms, por la construccion de la rutina
            write(fd2,&valor,sizeof(valor));
            color++;
            write(fd2,&color,sizeof(color));
            valor = 0;
            write(fd2,&valor,sizeof(valor));  //lo que seria el vector normal
            valor = caras[j+4];
            write(fd2,&valor,sizeof(valor));
            valor = caras[j+3];
            write(fd2,&valor,sizeof(valor));
            valor = caras[j+2];
            write(fd2,&valor,sizeof(valor));
            valor = caras[j+1];
            write(fd2,&valor,sizeof(valor));
            valor = 1;
            write(fd2,&valor,sizeof(valor));  //testear siempre visibilidad
            j += 5;
        }
    }

    close(fd2);

    free(normals);
    free(puntos);
    free(caras);
    free(caras0);
}


