;
; Display String (Terminate with '$')
; in :
;   DS:DX = Address of string
; out :
;    none
;
DisplayString MACRO
    mov     ah, 09h
    int     21h
ENDM DisplayString
;
; Terminate program
; in :
;   AL = Exit code
; out :
;   none
;
Terminate MACRO
    mov     ah, 04ch
    int     21h
ENDM Terminate 
;
; Wait
; in :
;   CX:DX = Microseconds to wait
; out :
;   none
;
Delay MACRO
    push    ax
    mov     ah, 86h
    int     15h
    pop     ax
ENDM Delay
;
;
; Get PSP
; in :
;   none
; out :
;   BX = PSP
;
GetPSP MACRO    
    mov     ah, 62h         ; Get PSP
    int     21h
ENDM GetPSP
;
;
; Memory Mode Register
; in :
;   AH = Bitplane of register values
;       Bit 3 = C4 Chain Four
;       Bit 2 = O/E Odd/Even
;       Bit 1 = EM Extended Memory
;       Bit 0 = Alpha/Graphics Mode
; out :
;   none
;
MemoryMode MACRO
    mov     dx,3c4h                 ; Sequencer WRITE COLOR
    mov     al,04h                  ; Index 04h - Memory Mode Register
                                    ; value = 06h = 0000 0110b
                                    ; bit 3 unchains the VGA
    out     dx,ax
ENDM MemoryMode

;
; Map Mask Register
; in :
;   AH =  Bitplane of register values
;       Bit 3 = EM3 Mask Memory Plane 3
;       Bit 2 = EM2 Mask Memory Plane 2
;       Bit 1 = EM1 Mask Memory Plane 1
;       Bit 0 = EM0 Mask Memory Plane 0
; out :
;   none
;
MapMask MACRO    
    mov     dx,3c4h                 ;; Sequencer WRITE COLOR
    mov     al,02h                  ;; Index 02h - Map Mask Register
                                    ;; EM3-0 Planes
    out     dx,ax
ENDM MapMask
    
;
; Underline Loc register
; in :
;   AH =  BitPlane of register values
;       Bit 6 = DW Double Word Mode
;       Bit 5 = CB4 Count by Four
;       Bits 4-0 = Underline Location
; out :
;   none
;
UnderlineLoc MACRO
    mov     dx,3d4h                 ;; CRTC Controler WRITE COLOR
    mov     al,14h                  ;; Index 14h - Underline Location
                                    ;; value = 00h = 0000 0000b
                                    ;; Disables Dword addressing
    out     dx,ax
ENDM UnderlineLoc

;
; Mode Control Register
; in :
;   AH =  BitPlane of register values
;       Bit 7 = HR Hardware Reset
;       Bit 6 = W/B Word/Byte Mode
;       Bit 5 = AW Address Wrap
;       Bit 4 = OC Output Controle
;       Bit 3 = CBT Count by Two
;       Bit 2 = HRS Horizontal Retrace Select
;       Bit 1 = SRS Select Row Scan Counter
;       Bit 0 = CMS Compatibility Mode Support
; out :
;   none
;
ModeControl MACRO    
    mov     dx,3d4h                 ;; CRTC Controler WRITE COLOR
    mov     al,17h                  ;; Index 17h - Mode Control Register
                                    ;; value = e3 = 1110 0000b
                                    ;; Enable Byte Mode
    out     dx,ax
ENDM ModeControl

;
; Maximum Scan Line Register
; in :
;   AH =  Number of scan lines
; out :
;   none
;
MaxScanLine MACRO    
    mov     dx,3d4h                 ;; CRTC Controler WRITE COLOR
    mov     al,09h                  ;; Index 09h - Maximum Scan Line Register
    out     dx,ax
ENDM MaxScanLine

;
; Preset Row Scan Register
; in :
;   AH =  BitPlane of register values
;       Bits 6-5 = BP Byte Panning
;       Bits 4-0 = PRS Preset Row Scan
; out :
;   none
;
PresetRowScan MACRO
    mov     dx,3d4h                 ;; CRTC Controler WRITE COLOR
    mov     al,08h                  ;; Index 08h - Preset Row Scan Register
    out     dx,ax
ENDM PresetRowScan

;
; Set Write Mode
; in :
;   AH =  Write mode 0-3
; out :
;   none
;
SetWriteMode MACRO
    mov     dx,3ceh                 ;; Graphics Controler Registers
    mov     al,05h                  ;; Index 05h - Mode Register
    out     dx,al
    inc     dx                      ;; Read/Write port
    
    in      al,dx                   ;; Get current status
    and     al,1111100b             ;; Clear current mode
    or      al,ah                   ;; Set new mode
    out     dx,al                   
ENDM SetWriteMode

;
; Start Horizontal Retrace Register
; in :
;   AH =  BitPlane of register values
;       Bits 7-0 = SHR Start Horizontal Retrace
; out :
;   none
;
StartHoriz MACRO
    mov     dx,3d4h                 ;; CRTC Controler WRITE COLOR
    mov     al,04h                  ;; Index 04h - Start Horizontal Retrace
    out     dx,ax
ENDM StartHoriz
