;
; The Forbiden Grounds -- (c) 1993 iCE Advertisements, Inc. 
; Author        : Leviathan [iCE]
; Description   : BBS Advertisement
; Requirements  : 286+
;                 VGA
;                 TASM/MASM
; Functions     : CopyPalette
;                 isVGA
;                 Init
;                 DeInit
;                 FadeIn
;                 FadeOut
; Needed extras : macros.inc       - Macros
;                 link.dat         - Link data
; Notes         : The source code is donated to the public 
;                 domain as free ware. Hope it helps
;
	dosseg
	
	.286
	locals
	jumps

	include macros.inc

;
; DATA SEGMENT
;
_data segment public public 'DATA'        
	no_vga_msg      db 'Error : A VGA card must be present to run this demo',10,13,'$'
	tmp             db 768      dup (0)
	ansi            db 4000     dup (0)
_data ends

;
_picture segment byte public 'DATA'
	palette         db 768      dup (0)
	picture         db 64000    dup (0)
_picture ends              

;
_stack segment byte stack 'STACK'
					db 256      dup (0)
_stack ends
	
;
; CODE SEGMENT
;
_code segment para 'CODE'
	ASSUME  ds:_data, cs:_code, ss:_stack

	start: jmp main
;
; Copy Palette to VGA card
; in :
;   DS:SI = Address of Palette
;   AL = Begining Color
;   AH = Number of Colors to write
; out :
;   none
;
CopyPalette PROC NEAR
	push    ax
	mov     dx, 3c8h
	out     dx, al

	inc     dx
	
	mov     bl, 3
	mul     bl
	add     si, ax    

	pop     ax

	mov     al, ah
	mul     bl
	mov     cx, ax

	rep     outsb
	ret
ENDP CopyPalette

;
; Fades the palette in from black
;
FadeIn PROC NEAR
	mov     ax, _data
	mov     ds, ax    
	mov     ax, _picture
	mov     es, ax

	mov     si, offset tmp
	mov     di, offset palette
	
	mov     cx, 64        
		@@fu1:
	push    cx
	push    si
	push    di    
	
	mov     cx, 768        
		@@fu2:
	mov     al, byte ptr ds:[si]
	cmp     byte ptr es:[di], al
	je      @@fu3
	inc     al
	mov     byte ptr ds:[si], al
		@@fu3:
	inc     si
	inc     di
	loop    @@fu2
	
	pop     di
	pop     si
	
	push    si
	mov     ax, 0ff00h
	call    CopyPalette
	
	xor     cx,cx
	mov     dx, 5000
	Delay
	
	pop     si
	pop     cx

	loop    @@fu1

	ret
ENDP FadeIn

;
; Fades the palette out to black
;
FadeOut PROC NEAR
	mov     ax, _picture
	mov     ds, ax    

	mov     si, offset palette
	
	mov     cx, 64        
		@@fu1:
	push    cx
	push    si
	
	mov     cx, 768        
		@@fu2:
	mov     al, byte ptr ds:[si]
	cmp     al, 0
	je      @@fu3
	dec     al
	mov     byte ptr ds:[si], al
		@@fu3:
	inc     si
	inc     di
	loop    @@fu2
	
	pop     si
	
	push    si
	mov     ax, 0ff00h
	call    CopyPalette
	
	xor     cx,cx
	mov     dx, 5000
	Delay
	
	pop     si
	pop     cx

	loop    @@fu1

	ret
ENDP FadeOut

;
; Detects if there is a VGA card present
; in :
;   none
; out :
;   AX = Vga card present or not (1 = yes, 0 = no)
;
isVGA PROC NEAR
	mov     ah,1ah
	mov     al,0
	int     10h
	cmp     al,1ah
	je      @@VgaPresent
	mov     ax,3
	int     10h

	mov     ax, 0
	stc
	ret

	@@VgaPresent:
	mov     ax, 1
	ret
ENDP isVGA

;
; Checks for hardware, and setups video
;
Init PROC NEAR
	mov     ax, _data
	mov     ds, ax
   
	call    isVGA
	jnc     @@vga_here

	mov     dx, offset no_vga_msg
	DisplayString
	Terminate
	
		@@vga_here:
	mov     cx, 16
	mov     ah, 16
		@@squash:                           ; Squish the screen
	push    cx
	MaxScanLine
	dec     ah
	xor     cx, cx
	mov     dx, 15000
	Delay
	pop     cx
	loop    @@squash

	mov     ax, 0013h                       ; set video mode 13
	int     10h
	ret
ENDP Init
	
;
; Resets video mode, display ANSI
;
DeInit PROC NEAR
	mov     ax, 0003h
	int     10h

	mov     ah, 0
	MaxScanLine

	mov     ax, _data
	mov     ds, ax
	push    0b800h
	pop     es
	xor     di, di
	mov     si, offset ansi
	mov     cx, (4000/2)
	rep     movsw

	mov     ah, 0
	mov     cx, 16        
		@@squash:                           ; Squish the screen
	push    cx
	MaxScanLine
	inc     ah
	xor     cx, cx
	mov     dx, 15000
	Delay
	pop     cx
	loop    @@squash
	
	mov     ah, 02h                         ; Set cursor position
	xor     bh, bh
	xor     dl, dl
	mov     dh, 24
	int     10h

	ret
ENDP DeInit
	
	main:
;
	call    Init
	
	mov     ax, _data
	mov     ds, ax
	mov     si, offset tmp
	mov     ax, 0ff00h
	call    CopyPalette
	
	mov     ax, _picture
	mov     ds, ax

	push    0a000h
	pop     es
	xor     di, di
	
	mov     si, offset picture
	mov     cx, (64000/2)
	rep     movsw

	call    FadeIn
		
		@@key_loop:
	mov     ah, 1
	int     16h
	jz      @@key_loop
	
	call    FadeOut
	
	call    DeInit
	Terminate
;
_code ends
	end start
