	;; Flag of Buddhism
	;; Flips between the international flag and the Tibetan variant
	
	org 100h

start:	mov al,13h		; set mode 13h
	int 10h			; VGA 320x200x8bpp

palset:	mov dx,0x3c8		; get an actual red
	mov al,39		; in the palette
	out dx,al
	inc dx
	mov al,63
	out dx,al
	xor ax,ax
	out dx,al
	out dx,al
	dec dx
	mov al,40		; maroon for the Tibetan variant
	out dx,al
	inc dx
	mov al,31
	out dx,al
	xor ax,ax
	out dx,al
	out dx,al	
	
	push 0a000h 		; start of the VGA-buffer
	pop es
redraw:	xor dx,dx
       	mov di,1		; 320 can not be evenly divided by 6
	mov si,fields+1
	push si
draw:	mov si,fields
draw2:	mov cl,53
	lodsb
draw3:	stosb
	loop draw3

	inc bl
	cmp bl,6
	jne draw2
	inc di
	inc di
	xor bx,bx
	inc dl
	inc dh
	cmp dh,40
	jne endchk
	pop si
	mov al,[ds:si]
	mov [fields+5],al	; field 6 changes color every 40th row
	inc si
	push si
	mov dh,0
endchk:	cmp dl,200
	jne draw
	pop si
	
	mov cl,80		; wait constant
twait:	mov bx,[fs:046ch]
twait2:	mov ax,[fs:046ch]
	cmp ax,bx
	je twait2
keywait:mov ah,1		; wait for keypress
	int 16h
	jnz endprg
	loop twait

	mov al,[fields+4]
	cmp al,42
	jne swap
	mov byte [fields+4],40	;change variant
	jmp swap2
swap:	mov byte [fields+4],42
swap2:  xor bx,bx
	mov byte [fields+5],32
	jmp redraw
	
endprg:	
	xor ax,ax		; clear the keyboard buffer for a clean
	int 16h			; exit

	mov ax,3		; textmode
	int 10h

	mov dx,quitmsg
	mov ah,9
	int 21h

	mov ah,4ch		; return to DOS
	int 21h

fields:	db 32, 44, 39, 15, 42, 32
quitmsg:
	db "Buddhist flags by El Topo in 2020.$"
