; CC2k2o (c) IlII / RMDA / 2020
; FASM, recommended to run via DOSBox

WIDTH   =       21
HEIGHT  =       21
BLOCK   =       6

        org 100h

        ; ax=bx=0, cx=0FFh, si=100h, df=0

        ; Init

        mov dx,3C9h             ; this opcode will be also palette :)

        mov al,13h
        int 10h                 ; 320x200, 256 colors

        rep outsb               ; r,g,b = 58,9,3 for color #0

        les bp,[bx]             ; es = 9FFFh (DOSBox; different systems may contain 0A000h, 9F80h and other)

        ; Draw QR code
drawqr:
        mov si,qr
        mov di,(200-HEIGHT*BLOCK)/2*320 + (320-WIDTH*BLOCK)/2 + 10h ; top left corver address (10h is compensation of inaccurate video segment value)
        mov dl,1
        mov cl,HEIGHT
continue:
        mov ch,WIDTH
next:
        out 61h,al              ; sound of crackle

        ror dl,1                ; set carry flag 1 time in 8 rotations
        jnc pixel
        lodsb
        xchg bp,ax
pixel:
        shr bp,1                ; extract next bit
        sbb ax,ax               ; ax = 0 or 0FFFFh
        cmp ch,dh
        jne @F
        mov al,0D0h             ; noise effect color
@@:
        mov bl,BLOCK
@@:
repeat BLOCK / 2
        stosw
end repeat
repeat BLOCK mod 2
        stosb
end repeat
        add di,320-BLOCK        ; first move vertically
        dec bx
        jnz @B

        dec ch
        jnz next

        sub di,(320*HEIGHT-1)*BLOCK ; then move horizontally
        loop continue

        ; Final

        imul dx,77              ; random number generator
;        shr dh,1                ; more often noise

        hlt                     ; delay

        in al,60h
        dec ax
        jnz drawqr              ; loop if no Esc key is pressed

        ret

        ; Data

qr      db 127,195,63,232,9,118,109,221,174,171,219,165,116,131,172,224
        db 95,245,7,96,0,93,45,222,67,109,177,101,116,156,175,143
        db 29,227,1,90,237,31,4,15,114,40,93,243,169,235,19,119
        db 13,214,32,71,240,119,145;,0
