		.model tiny

; ===========================================================================

; Segment type:	Pure code
seg000		segment	byte public 'CODE' use16
		assume cs:seg000
		org 100h
		assume es:nothing, ss:nothing, ds:seg000

; =============== S U B	R O U T	I N E =======================================

; Attributes: noreturn

		public start
start		proc near
		mov	ah, 4Ah
		mov	bx, 1000h
		int	21h		; DOS -	2+ - ADJUST MEMORY BLOCK SIZE (SETBLOCK)
					; ES = segment address of block	to change
					; BX = new size	in paragraphs
		mov	ah, 48h
		mov	bx, 1002h
		int	21h		; DOS -	2+ - ALLOCATE MEMORY
					; BX = number of 16-byte paragraphs desired
		jnb	short init
		int	20h		; DOS -	PROGRAM	TERMINATION
					; returns to DOS--identical to INT 21/AH=00h
; ---------------------------------------------------------------------------

init:					; CODE XREF: start_0+Ej
		mov	cs:sinTable, ax
		call	initSinTable
		call	initFont
		mov	ax, 4
		int	10h		; - VIDEO - SET	VIDEO MODE
					; AL = mode
		in	al, 61h		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		or	al, 3
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		mov	al, 0B6h
		out	43h, al		; Timer	8253-5 (AT: 8254.2).
		mov	bx, 0
		mov	al, bl
		out	42h, al		; Timer	8253-5 (AT: 8254.2).
		mov	al, bh
		out	42h, al		; Timer	8253-5 (AT: 8254.2).
		call	SetInt9Handler
		call	setCGAMono
		mov	dx, 3D9h
		mov	al, 1
		out	dx, al
		call	initLogo

mainloop:				; CODE XREF: start_0+BDj
		cli
		call	setCGAMono
		mov	dx, 3DAh
		mov	cx, 121
		mov	si, cs:rasterbarPos
		add	cs:rasterbarPos, 121
		cmp	si, (251*121)	; 8267h
		jb	short loc_214A
		mov	cs:rasterbarPos, 0

loc_214A:				; CODE XREF: start_0+5Fj
		mov	ds, cs:sinTable
		assume ds:seg000
		
		mov bh, 1
		
loopHBL:		
		lodsb
		xchg ax, bx

waitHBL1:				; CODE XREF: start_0+70j start_0+7Fj
		in	al, dx		; Video	status bits:
					; 0: retrace.  1=display is in vert or horiz retrace.
					; 1: 1=light pen is triggered; 0=armed
					; 2: 1=light pen switch	is open; 0=closed
					; 3: 1=vertical	sync pulse is occurring.
		test	al, ah
		jnz	short waitHBL1

waitHBL2:				; CODE XREF: start_0+75j
		in	al, dx		; Video	status bits:
					; 0: retrace.  1=display is in vert or horiz retrace.
					; 1: 1=light pen is triggered; 0=armed
					; 2: 1=light pen switch	is open; 0=closed
					; 3: 1=vertical	sync pulse is occurring.
		test	al, ah
		jz	short waitHBL2
		mov	dx, 3D9h
		xchg ax, bx
		out	dx, al
		mov	dx, 3DAh
		loop	loopHBL

		mov	ax, 40h
		mov	es, ax
		assume es:nothing
		mov	al, es:65h
		and	al, 0FBh
		mov	dx, 3D8h
		out	dx, al
		call	doScroll
		call	addNewChar
		call	doMusic
		mov	dx, 3DAh
		
		mov ah, 8

waitVBL1:				; CODE XREF: start_0+AFj
		in	al, dx		; Video	status bits:
					; 0: retrace.  1=display is in vert or horiz retrace.
					; 1: 1=light pen is triggered; 0=armed
					; 2: 1=light pen switch	is open; 0=closed
					; 3: 1=vertical	sync pulse is occurring.
		test	al, ah
		jz	short waitVBL1

waitVBL2:				; CODE XREF: start_0+B4j
		in	al, dx		; Video	status bits:
					; 0: retrace.  1=display is in vert or horiz retrace.
					; 1: 1=light pen is triggered; 0=armed
					; 2: 1=light pen switch	is open; 0=closed
					; 3: 1=vertical	sync pulse is occurring.
		test	al, ah
		jnz	short waitVBL2
		sti
		cmp	cs:exit, 1
		jnz mainloop
endMainLoop:
		call	ResetInt9Handler
		in	al, 61h		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		and	al, 0FCh
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		mov	ax, 3
		int	10h		; - VIDEO - SET	VIDEO MODE
					; AL = mode
		mov	ah, 49h
		mov	es, cs:sinTable
		assume es:nothing
		int	21h		; DOS -	2+ - FREE MEMORY
					; ES = segment address of area to be freed
		int	20h		; DOS -	PROGRAM	TERMINATION
start		endp			; returns to DOS--identical to INT 21/AH=00h

int9Handler:				; DATA XREF: SetInt9Handler+8o
		push	ds
		push	bx
		push	ax
		in	al, 60h		; AT Keyboard controller 8042.
		push	ax
		in	al, 61h		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		or	al, 80h
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		and	al, 7Fh
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		pop	ax
		cmp	al, 1
		jnz	short loc_1D45
		mov	cs:exit, 1

loc_1D45:				; CODE XREF: seg000:1D3Cj
		mov	al, 20h
		out	20h, al		; Interrupt controller,	8259A.
		pop	ax
		pop	bx
		pop	ds
		iret

; =============== S U B	R O U T	I N E =======================================


SetInt9Handler	proc near		; CODE XREF: start_0+36p
		mov	ax, 0
		mov	es, ax
		assume es:seg000
		mov	di, 24h
		mov	ax, offset int9Handler
		cld
		mov	bx, es:[di]
		mov	word ptr cs:oldInt9, bx
		stosw
		mov	ax, cs
		mov	bx, es:[di]
		mov	word ptr cs:oldInt9+2, bx
		stosw
		mov	al, 0FCh
		out	21h, al		; Interrupt controller,	8259A.
		sti
		retn
SetInt9Handler	endp


; =============== S U B	R O U T	I N E =======================================


ResetInt9Handler proc near		; CODE XREF: start_0+BFp
		mov	ax, 0
		mov	es, ax
		mov	di, 24h
		cld
		mov	ax, word ptr cs:oldInt9
		stosw
		mov	ax, word ptr cs:oldInt9+2
		stosw
		mov	al, 0
		out	21h, al		; Interrupt controller,	8259A.
		sti
		retn
ResetInt9Handler endp


; =============== S U B	R O U T	I N E =======================================


setCGAMono	proc near		; CODE XREF: start_0+39p start_0+46p
		mov	ax, 40h
		mov	es, ax
		assume es:nothing
		mov	al, es:65h
		or	al, 4
		mov	dx, 3D8h
		out	dx, al
		mov	es:65h,	al
		retn
setCGAMono	endp


; =============== S U B	R O U T	I N E =======================================


initSinTable	proc near		; CODE XREF: start_0+16p
		mov	ds, cs:sinTable
		mov	es, cs:sinTable
		assume es:nothing
		mov	al, 10h
		mov	ah, al
		mov	cx, 4172h
		rep stosw
		xor	bx, bx
		mov	si, bx
		mov	cx, 0FCh

loc_1DBC:				; CODE XREF: initSinTable:loc_1F2Fj
		mov	di, si
		mov	byte ptr [di], 14h
		mov	byte ptr [di+1], 14h
		mov	byte ptr [di+2], 1Ch
		mov	byte ptr [di+3], 1Ch
		mov	byte ptr [di+4], 1Dh
		mov	byte ptr [di+5], 1Dh
		mov	byte ptr [di+6], 1Ch
		mov	byte ptr [di+7], 1Ch
		mov	byte ptr [di+8], 14h
		mov	byte ptr [di+9], 14h
		add	di, 110
		mov	byte ptr [di], 14h
		mov	byte ptr [di+1], 14h
		mov	byte ptr [di+2], 1Ch
		mov	byte ptr [di+3], 1Ch
		mov	byte ptr [di+4], 1Dh
		mov	byte ptr [di+5], 1Dh
		mov	byte ptr [di+6], 1Ch
		mov	byte ptr [di+7], 1Ch
		mov	byte ptr [di+8], 14h
		mov	byte ptr [di+9], 14h
		mov byte ptr [di+10], 10h
		mov	al, cs:byte_109[bx]
		xor	ah, ah
		mov	di, si
		shr	ax, 1
		add	di, ax
		mov	byte ptr [di+0Ah], 14h
		mov	byte ptr [di+0Bh], 14h
		mov	byte ptr [di+0Ch], 1Ch
		mov	byte ptr [di+0Dh], 1Ch
		mov	byte ptr [di+0Eh], 1Dh
		mov	byte ptr [di+0Fh], 1Dh
		mov	byte ptr [di+10h], 1Ch
		mov	byte ptr [di+11h], 1Ch
		mov	byte ptr [di+12h], 14h
		mov	byte ptr [di+13h], 14h
		mov	al, cs:byte_110[bx]
		xor	ah, ah
		mov	di, si
		shr	ax, 1
		add	di, ax
		mov	byte ptr [di+0Ah], 16h
		mov	byte ptr [di+0Bh], 16h
		mov	byte ptr [di+0Ch], 1Eh
		mov	byte ptr [di+0Dh], 1Eh
		mov	byte ptr [di+0Eh], 1Fh
		mov	byte ptr [di+0Fh], 1Fh
		mov	byte ptr [di+10h], 1Eh
		mov	byte ptr [di+11h], 1Eh
		mov	byte ptr [di+12h], 16h
		mov	byte ptr [di+13h], 16h
		mov	al, cs:byte_117[bx]
		xor	ah, ah
		mov	di, si
		shr	ax, 1
		add	di, ax
		mov	byte ptr [di+0Ah], 12h
		mov	byte ptr [di+0Bh], 12h
		mov	byte ptr [di+0Ch], 1Ah
		mov	byte ptr [di+0Dh], 1Ah
		mov	byte ptr [di+0Eh], 1Bh
		mov	byte ptr [di+0Fh], 1Bh
		mov	byte ptr [di+10h], 1Ah
		mov	byte ptr [di+11h], 1Ah
		mov	byte ptr [di+12h], 12h
		mov	byte ptr [di+13h], 12h
		mov	al, cs:byte_11D[bx]
		xor	ah, ah
		mov	di, si
		shr	ax, 1
		add	di, ax
		mov	byte ptr [di+0Ah], 13h
		mov	byte ptr [di+0Bh], 13h
		mov	byte ptr [di+0Ch], 1Bh
		mov	byte ptr [di+0Dh], 1Bh
		mov	byte ptr [di+0Eh], 1Fh
		mov	byte ptr [di+0Fh], 1Fh
		mov	byte ptr [di+10h], 1Bh
		mov	byte ptr [di+11h], 1Bh
		mov	byte ptr [di+12h], 13h
		mov	byte ptr [di+13h], 13h
		mov	al, cs:byte_124[bx]
		xor	ah, ah
		mov	di, si
		shr	ax, 1
		add	di, ax
		mov	byte ptr [di+0Ah], 11h
		mov	byte ptr [di+0Bh], 11h
		mov	byte ptr [di+0Ch], 19h
		mov	byte ptr [di+0Dh], 19h
		mov	byte ptr [di+0Eh], 1Bh
		mov	byte ptr [di+0Fh], 1Bh
		mov	byte ptr [di+10h], 19h
		mov	byte ptr [di+11h], 19h
		mov	byte ptr [di+12h], 11h
		mov	byte ptr [di+13h], 11h
		add	si, 121
		inc	bx
		inc bx
		cmp	bx, (252*2)
		jb	short loc_1F2B
		xor	bx, bx

loc_1F2B:				; CODE XREF: initSinTable+187j
		loop	loc_1F2F
		jmp	short locret_1F32
; ---------------------------------------------------------------------------

loc_1F2F:				; CODE XREF: initSinTable:loc_1F2Bj
		jmp	loc_1DBC
; ---------------------------------------------------------------------------

locret_1F32:				; CODE XREF: initSinTable+18Dj
		retn
initSinTable	endp


; =============== S U B	R O U T	I N E =======================================


initLogo	proc near		; CODE XREF: start_0+42p
		mov	ax, 0B800h
		mov	es, ax
		assume es:nothing
		mov	ax, cs
		mov	ds, ax
		mov	si, offset logo
		xor	di, di
		mov	cx, 2000h
		rep movsw
		retn
initLogo	endp


; =============== S U B	R O U T	I N E =======================================


addNewChar	proc near		; CODE XREF: start_0+A3p
		cmp	cs:charColPos, 0
		jnz	short loc_1F7F
		mov	bx, cs:scrollPos
		inc	cs:scrollPos
		add	bx, offset scrollText ;	"HI... HO... HERE WE GO....   WELCOME TO"...
		xor	ah, ah
		mov	al, cs:[bx]
		cmp	al, 0
		jnz	short loc_1F6D
		mov	cs:scrollPos, 0

loc_1F6D:				; CODE XREF: addNewChar+1Dj
		mov	cl, 5
		shl	ax, cl
		add	ax, offset fontbuffer
		mov	cs:charPos, ax
		mov	cs:charColPos, 4

loc_1F7F:				; CODE XREF: addNewChar+6j
		dec	cs:charColPos
		mov	ax, 0B800h
		mov	es, ax
		mov	ax, cs
		mov	ds, ax
		mov	si, cs:charPos
		mov	di, 1ADFh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		movsb
		add	si, 3
		add	di, 4Fh
		inc	cs:charPos
		retn
addNewChar	endp


; =============== S U B	R O U T	I N E =======================================


doScroll	proc near		; CODE XREF: start_0+A0p
		mov	ax, 0B800h
		mov	ds, ax
		assume ds:nothing
		mov	es, ax
		mov	si, 1A91h
		mov	di, 1A90h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1AE1h
		mov	di, 1AE0h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1B31h
		mov	di, 1B30h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1B81h
		mov	di, 1B80h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1BD1h
		mov	di, 1BD0h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1C21h
		mov	di, 1C20h
		mov cx, 27h
		rep movsw
		movsb
		mov	si, 1C71h
		mov	di, 1C70h
		mov cx, 27h
		rep movsw
		movsb
		retn
doScroll	endp


; =============== S U B	R O U T	I N E =======================================


initFont	proc near		; CODE XREF: start_0+19p
		mov	ax, 0F000h
		mov	ds, ax
		assume ds:nothing
		mov	si, 0FA6Eh
		mov	di, offset fontbuffer
		mov	cx, 400h

loc_202F:				; CODE XREF: initFont+61j
		push	cx
		lodsb
		mov	bl, 0
		rcl	al, 1
		jnb	short loc_203A
		or	bl, 40h

loc_203A:				; CODE XREF: initFont+14j
		rcl	al, 1
		jnb	short loc_2041
		or	bl, 4

loc_2041:				; CODE XREF: initFont+1Bj
		mov	cs:[di], bl
		inc	di
		mov	bl, 0
		rcl	al, 1
		jnb	short loc_204E
		or	bl, 40h

loc_204E:				; CODE XREF: initFont+28j
		rcl	al, 1
		jnb	short loc_2055
		or	bl, 4

loc_2055:				; CODE XREF: initFont+2Fj
		mov	cs:[di], bl
		inc	di
		mov	bl, 0
		rcl	al, 1
		jnb	short loc_2062
		or	bl, 40h

loc_2062:				; CODE XREF: initFont+3Cj
		rcl	al, 1
		jnb	short loc_2069
		or	bl, 4

loc_2069:				; CODE XREF: initFont+43j
		mov	cs:[di], bl
		inc	di
		mov	bl, 0
		rcl	al, 1
		jnb	short loc_2076
		or	bl, 40h

loc_2076:				; CODE XREF: initFont+50j
		rcl	al, 1
		jnb	short loc_207D
		or	bl, 4

loc_207D:				; CODE XREF: initFont+57j
		mov	cs:[di], bl
		inc	di
		pop	cx
		loop	loc_202F
		retn
initFont	endp


; =============== S U B	R O U T	I N E =======================================


doMusic		proc near		; CODE XREF: start_0+A6p
		cmp	cs:musicTick, 0
		jnz	short doneMusic
		mov	si, cs:musicPos
		add	cs:musicPos, 2
		add	si, offset music
		mov	al, 0B6h
		out	43h, al		; Timer	8253-5 (AT: 8254.2).
		mov	bx, cs:[si]
		cmp	bx, 0FFFFh
		jnz	short disableSpkr
		mov	si, offset music
		mov	bx, cs:[si]
		mov	cs:musicPos, 2

disableSpkr:				; CODE XREF: doMusic+21j
		cmp	bx, 0
		jnz	short enableSpkr
		in	al, 61h		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		and	al, 0FCh
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		jmp	short updateMusicTimer
; ---------------------------------------------------------------------------
		nop

enableSpkr:				; CODE XREF: doMusic+33j
		in	al, 61h		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd
		or	al, 3
		out	61h, al		; PC/XT	PPI port B bits:
					; 0: Tmr 2 gate	 OR	03H=spkr ON
					; 1: Tmr 2 data	ͼ  AND	0fcH=spkr OFF
					; 3: 1=read high switches
					; 4: 0=enable RAM parity checking
					; 5: 0=enable I/O channel check
					; 6: 0=hold keyboard clock low
					; 7: 0=enable kbrd

updateMusicTimer:			; CODE XREF: doMusic+3Bj
		mov	al, 0B6h
		out	43h, al		; Timer	8253-5 (AT: 8254.2).
		mov	al, bl
		out	42h, al		; Timer	8253-5 (AT: 8254.2).
		mov	al, bh
		out	42h, al		; Timer	8253-5 (AT: 8254.2).
		mov	cs:musicTick, 2

doneMusic:				; CODE XREF: doMusic+6j
		dec	cs:musicTick
		retn
doMusic		endp

; ---------------------------------------------------------------------------
logo		db 1FDh	dup(0),	80h, 9Fh dup(0), 80h, 9Fh dup(0), 80h
					; DATA XREF: initLogo+9o
		db 3Eh dup(0), 7, 8 dup(0), 34h, 3 dup(0), 1, 3	dup(39h)
		db 8 dup(0), 34h, 39h dup(0), 15h, 70h,	35h, 2 dup(88h)
		db 87h,	34h, 6 dup(0), 7, 34h, 2 dup(88h), 97h,	3, 55h
		db 3Eh dup(0), 5Ch, 35h, 88h, 87h, 8 dup(0), 34h, 88h
		db 97h,	0Dh, 40h, 40h dup(0), 5Ch, 34h,	0Ah dup(88h), 87h
		db 0Dh,	40h, 0Bh dup(0), 70h, 7	dup(0),	3, 40h,	2Dh dup(0)
		db 73h,	48h, 9 dup(88h), 73h, 50h, 0Ch dup(0), 73h, 48h
		db 88h,	89h, 70h, 35h, 50h, 30h	dup(0),	7, 34h,	8 dup(88h)
		db 87h,	34h, 2 dup(0), 1, 5Ch, 9 dup(0), 3, 48h, 89h, 70h
		db 0D4h, 33h dup(0), 73h, 3 dup(0), 34h, 87h, 3	dup(0)
		db 73h,	40h, 2 dup(0), 70h, 0D5h, 0Bh dup(88h),	70h, 0D4h
		db 34h dup(0), 1Dh, 34h, 0, 7, 34h, 87h, 34h, 0, 7, 3Dh
		db 2 dup(0), 1Ch, 34h, 0Bh dup(88h), 87h, 34h, 3 dup(0)
		db 7, 8	dup(0),	0D4h, 28h dup(0), 7, 74h, 0, 7,	34h, 87h
		db 34h,	0, 7, 74h, 2 dup(0), 73h, 48h, 0Bh dup(88h), 73h
		db 40h,	3 dup(0), 7, 34h, 6 dup(88h), 89h, 70h,	0D0h, 2Ah dup(0)
		db 7, 34h, 87h,	34h, 4 dup(0), 7, 34h, 5 dup(88h), 97h
		db 5 dup(0), 3,	34h, 4 dup(0), 7, 34h, 7 dup(88h), 89h
		db 0CDh, 2Ah dup(0), 7,	34h, 87h, 34h, 4 dup(0), 1Ch, 0D8h
		db 4 dup(88h), 89h, 0CDh, 40h, 4 dup(0), 70h, 0D0h, 4 dup(0)
		db 7, 34h, 8 dup(88h), 73h, 40h, 29h dup(0), 7,	34h, 87h
		db 34h,	4 dup(0), 1Ch, 0D8h, 4 dup(88h), 9Ch, 0D0h, 5 dup(0)
		db 73h,	40h, 4 dup(0), 7, 34h, 88h, 87h, 2 dup(0), 0Dh
		db 48h,	2 dup(88h), 9Ch, 0D0h, 29h dup(0), 7, 34h, 87h
		db 34h,	4 dup(0), 73h, 48h, 4 dup(88h),	73h, 40h, 0Bh dup(0)
		db 7, 34h, 88h,	87h, 34h, 0, 1Ch, 0D8h,	2 dup(88h), 87h
		db 34h,	29h dup(0), 7, 34h, 87h, 34h, 4	dup(0),	73h, 48h
		db 4 dup(88h), 73h, 40h, 7 dup(0), 4, 3	dup(0),	7, 34h
		db 88h,	87h, 34h, 0, 7,	34h, 2 dup(88h), 87h, 34h, 29h dup(0)
		db 7, 34h, 87h,	34h, 4 dup(0), 73h, 48h, 4 dup(88h), 73h
		db 40h,	7 dup(0), 0Ch, 3 dup(0), 7, 34h, 88h, 87h, 34h
		db 0, 1Ch, 0D8h, 2 dup(88h), 87h, 34h, 29h dup(0), 7, 34h
		db 87h,	34h, 4 dup(0), 1Ch, 0D8h, 4 dup(88h), 9Ch, 0D0h
		db 7 dup(0), 4,	3 dup(0), 7, 34h, 88h, 87h, 2 dup(0), 0Dh
		db 48h,	2 dup(88h), 9Ch, 0D0h, 29h dup(0), 7, 34h, 87h
		db 34h,	4 dup(0), 1Ch, 0D8h, 4 dup(88h), 89h, 0CDh, 40h
		db 6 dup(0), 0Ch, 3 dup(0), 7, 34h, 8 dup(88h),	73h, 40h
		db 29h dup(0), 7, 34h, 87h, 34h, 4 dup(0), 7, 34h, 5 dup(88h)
		db 97h,	5 dup(0), 0Dh, 50h, 4, 3 dup(0), 7, 34h, 7 dup(88h)
		db 89h,	0CDh, 2Ah dup(0), 7, 34h, 87h, 34h, 5 dup(0), 73h
		db 48h,	0Ah dup(88h), 95h, 0C3h, 4Ch, 3	dup(0),	7, 34h
		db 6 dup(88h), 89h, 70h, 0D0h, 2Ah dup(0), 7, 34h, 87h
		db 34h,	5 dup(0), 1Ch, 34h, 0Bh	dup(88h), 87h, 5, 3 dup(0)
		db 7, 34h, 5 dup(88h), 87h, 0, 0D5h, 2Ah dup(0), 7, 40h
		db 74h,	87h, 15h, 74h, 5 dup(0), 70h, 0D5h, 0Bh	dup(88h)
		db 73h,	40h, 2 dup(0), 7, 34h, 6 dup(88h), 89h,	5Ch, 34h
		db 29h dup(0), 7, 34h, 88h, 87h, 35h, 6	dup(0),	1, 5Ch
		db 9 dup(0), 35h, 88h, 87h, 34h, 2 dup(0), 7, 34h, 8 dup(88h)
		db 70h,	0D0h, 28h dup(0), 7, 34h, 88h, 73h, 40h, 11h dup(0)
		db 5Ch,	0D8h, 89h, 0CDh, 2 dup(0), 7, 34h, 8 dup(88h)
		db 87h,	34h, 28h dup(0), 7, 34h, 87h, 34h, 12h dup(0)
		db 1, 0CDh, 89h, 0CDh, 2 dup(0), 7, 34h, 88h, 87h, 0, 3
		db 58h,	4 dup(88h), 73h, 40h, 27h dup(0), 7, 34h, 73h
		db 40h,	13h dup(0), 73h, 48h, 73h, 40h,	0, 7, 34h, 88h
		db 87h,	34h, 5,	0CDh, 4	dup(88h), 9Ch, 0D0h, 27h dup(0)
		db 7, 35h, 0CDh, 13h dup(0), 70h, 3, 48h, 70h, 3, 40h
		db 7, 34h, 88h,	87h, 34h, 0, 1Ch, 0D8h,	3 dup(88h), 9Ch
		db 0D0h, 27h dup(0), 7,	37h, 34h, 13h dup(0), 1, 73h, 48h
		db 88h,	73h, 40h, 7
		db 34h,	88h, 87h, 34h, 0, 7, 34h, 3 dup(88h), 87h, 34h
		db 27h dup(0), 7, 3Ch, 0D0h, 14h dup(0), 7, 34h, 88h, 73h
		db 40h,	7, 34h,	88h, 87h, 34h, 0, 7, 34h, 3 dup(88h), 87h
		db 34h,	27h dup(0), 7, 33h, 40h, 15h dup(0), 73h, 48h
		db 73h,	40h, 7,	34h, 88h, 87h, 34h, 0, 7, 34h, 3 dup(88h)
		db 87h,	34h, 27h dup(0), 7, 33h, 40h, 15h dup(0), 7, 34h
		db 73h,	40h, 7,	34h, 88h, 87h, 34h, 0, 1Ch, 0D8h, 3 dup(88h)
		db 9Ch,	0D0h, 27h dup(0), 7, 0Dh, 16h dup(0), 1, 0CDh
		db 73h,	40h, 7,	34h, 88h, 87h, 34h, 5, 0CDh, 4 dup(88h)
		db 9Ch,	0D0h, 27h dup(0), 7, 0Dh, 17h dup(0), 2	dup(73h)
		db 40h,	7, 34h,	88h, 87h, 0, 3,	58h, 4 dup(88h), 73h, 40h
		db 27h dup(0), 7, 34h, 17h dup(0), 1Ch,	0F3h, 40h, 7, 34h
		db 8 dup(88h), 87h, 3 dup(1Bh),	26h dup(0), 7, 34h, 17h	dup(0)
		db 7, 33h, 40h,	7, 34h,	8 dup(88h), 70h, 90h, 28h dup(0)
		db 7, 34h, 17h dup(0), 7, 33h, 40h, 7, 34h, 6 dup(88h)
		db 89h,	5Ch, 34h, 29h dup(0), 7, 34h, 17h dup(0), 1, 0C3h
		db 40h,	7, 8 dup(0), 0D5h, 0, 80h, 28h dup(0), 7, 74h
		db 17h dup(0), 1, 0C3h,	40h, 35h dup(0), 0C0h, 18h dup(0)
		db 73h,	40h, 0Bh dup(0), 80h, 29h dup(0), 40h, 18h dup(0)
		db 73h,	40h, 35h dup(0), 0C0h, 18h dup(0), 73h,	40h, 35h dup(0)
		db 40h,	18h dup(0), 73h, 40h, 35h dup(0), 0C0h,	18h dup(0)
		db 73h,	40h, 0E2Eh dup(0), 0C0h, 0CFh, 0Ch, 4 dup(0C0h)
		db 0CCh, 2 dup(3), 0, 3, 0, 0C0h, 0CCh,	3, 0, 0C0h, 0CCh
		db 0Ch,	0C0h, 0CCh, 2 dup(0), 0C0h, 0CCh, 0Ch, 0, 3 dup(3)
		db 30h,	0, 0Ch,	0, 0C0h, 0CCh, 0Ch, 0C0h, 30h, 33h, 0
		db 0C0h, 0CCh, 0, 2 dup(30h), 2	dup(0Ch), 0C0h,	0, 0Ch
		db 0F0h, 0C0h, 3, 30h, 0CCh, 30h, 0Ch, 30h, 14h	dup(0)
		db 0FFh, 0CCh, 3Ch, 4 dup(0C0h), 0CCh, 2 dup(3), 0, 3
		db 0, 0C0h, 0CCh, 3, 0,	0CCh, 0CFh, 0FCh, 0C0h,	0CCh, 2	dup(0)
		db 3 dup(0C0h),	0, 3 dup(3), 30h, 0, 0Ch, 0, 0C0h, 0CCh
		db 0Ch,	0C0h, 30h, 33h,	0, 0FFh, 0C0h, 3 dup(30h), 2 dup(0Ch)
		db 3, 0, 0Ch, 0C3h, 0C0h, 3, 0,	0C0h, 33h, 283h	dup(0)
		db 0C0h, 4Fh dup(0), 40h, 4Fh dup(0), 0C0h, 4Fh	dup(0)
		db 40h,	4Fh dup(0), 0C0h, 3Eh dup(0), 1, 8 dup(55h), 50h
		db 6 dup(0), 1,	8 dup(55h), 50h, 36h dup(0), 1,	2 dup(55h)
		db 70h,	0Dh, 4 dup(55h), 34h, 6	dup(0),	7, 35h,	3 dup(55h)
		db 5Ch,	3, 2 dup(55h), 50h, 3Ah	dup(0),	15h, 0C3h, 52h
		db 22h,	27h, 35h, 6 dup(55h), 57h, 36h,	22h, 21h, 70h
		db 0D5h, 3Fh dup(0), 5,	0C3h, 52h, 21h,	8 dup(55h), 52h
		db 21h,	70h, 0D4h, 0Bh dup(0), 15h, 8 dup(55h),	2Dh dup(0)
		db 5, 0CDh, 0Ah	dup(22h), 1Ch, 0D4h, 0Ch dup(0), 73h, 4	dup(55h)
		db 0C0h, 35h, 2	dup(55h), 2Eh dup(0), 1Ch, 0D2h, 8 dup(22h)
		db 21h,	0CDh, 3	dup(0),	5, 9 dup(55h), 73h, 62h, 22h, 17h
		db 0Dh,	50h, 31h dup(0), 1, 0CDh, 3 dup(55h), 52h, 21h
		db 3 dup(55h), 5Ch, 0D0h, 2 dup(0), 17h, 3, 0Ah	dup(55h)
		db 22h,	17h, 0Dh, 40h, 33h dup(0), 1Ch,	35h, 55h, 57h
		db 36h,	27h, 35h, 55h, 57h, 0Dh, 2 dup(0), 5, 0CDh, 62h
		db 0Ah dup(22h), 21h, 0CDh, 40h, 2 dup(0), 1, 8	dup(55h)
		db 40h,	28h dup(0), 7, 74h, 0, 7, 36h, 27h, 34h, 0, 7
		db 34h,	2 dup(0), 73h, 52h, 0Bh	dup(22h), 1Ch, 0D0h, 3 dup(0)
		db 7, 35h, 6 dup(55h), 57h, 0Dh, 40h, 27h dup(0), 1, 50h
		db 0, 7, 36h, 27h, 34h,	0, 1, 50h, 0, 1, 0CDh, 5 dup(22h)
		db 21h,	6 dup(55h), 0CDh, 4 dup(0), 7, 36h, 7 dup(22h)
		db 17h,	34h, 2Ah dup(0), 7, 36h, 27h, 34h, 4 dup(0), 7
		db 36h,	5 dup(22h), 70h, 0D5h, 4 dup(55h), 70h,	0D0h, 4	dup(0)
		db 7, 36h, 8 dup(22h), 73h, 40h, 29h dup(0), 7,	36h, 27h
		db 34h,	4 dup(0), 1Ch, 0D2h, 4 dup(22h), 27h, 34h, 5 dup(0)
		db 73h,	40h, 4 dup(0), 7, 36h, 22h, 21h, 2 dup(55h), 56h
		db 3 dup(22h), 1Ch, 0D0h, 29h dup(0), 7, 36h, 27h, 34h
		db 0
		db 3 dup(0), 73h, 62h, 4 dup(22h), 1Ch,	0D0h, 5	dup(0)
		db 15h,	5 dup(0), 7, 36h, 22h, 27h, 35h, 55h, 70h, 0D2h
		db 2 dup(22h), 27h, 34h, 29h dup(0), 7,	36h, 27h, 34h
		db 4 dup(0), 73h, 62h, 4 dup(22h), 73h,	40h, 0Bh dup(0)
		db 7, 36h, 22h,	27h, 34h, 0, 7,	36h, 2 dup(22h), 27h, 34h
		db 29h dup(0), 7, 36h, 27h, 34h, 4 dup(0), 73h,	62h, 4 dup(22h)
		db 73h,	40h, 0Bh dup(0), 7, 36h, 22h, 27h, 34h,	0, 7, 36h
		db 2 dup(22h), 27h, 34h, 29h dup(0), 7,	36h, 27h, 34h
		db 4 dup(0), 73h, 62h, 4 dup(22h), 1Ch,	0D0h, 7	dup(0)
		db 8, 3	dup(0),	7, 36h,	22h, 27h, 35h, 55h, 70h, 0D2h
		db 2 dup(22h), 27h, 34h, 29h dup(0), 7,	36h, 27h, 34h
		db 4 dup(0), 1Ch, 0D2h,	4 dup(22h), 27h, 34h, 0Bh dup(0)
		db 7, 36h, 22h,	21h, 2 dup(55h), 56h, 3	dup(22h), 1Ch
		db 0D0h, 29h dup(0), 7,	36h, 27h, 34h, 4 dup(0), 7, 36h
		db 5 dup(22h), 70h, 0D5h, 4 dup(55h), 54h, 0, 8, 3 dup(0)
		db 7, 36h, 8 dup(22h), 73h, 40h, 29h dup(0), 7,	36h, 27h
		db 34h,	4 dup(0), 1, 0CDh, 5 dup(22h), 21h, 5 dup(55h)
		db 70h,	35h, 4 dup(0), 7, 36h, 7 dup(22h), 17h,	34h, 2Ah dup(0)
		db 7, 36h, 27h,	34h, 5 dup(0), 73h, 52h, 0Bh dup(22h)
		db 5Ch,	0D8h, 3	dup(0),	7, 36h,	5 dup(22h), 21h, 57h, 0Dh
		db 40h,	29h dup(0), 1, 57h, 36h, 27h, 35h, 50h,	4 dup(0)
		db 5, 0CDh, 62h, 0Ah dup(22h), 21h, 71h, 3 dup(0B1h), 7
		db 36h,	5 dup(22h), 21h, 57h, 3, 50h, 29h dup(0), 7, 35h
		db 52h,	21h, 0C7h, 50h,	5 dup(0), 17h, 3, 9 dup(55h), 52h
		db 22h,	1Ch, 0D0h, 2 dup(0), 7,	36h, 7 dup(22h), 25h, 0CDh
		db 40h,	28h dup(0), 7, 36h, 22h, 1Ch, 0D0h, 7 dup(0), 5
		db 9 dup(55h), 0C3h, 62h, 27h, 34h, 2 dup(0), 7, 36h, 8	dup(22h)
		db 17h,	34h, 28h dup(0), 7, 36h, 21h, 0CDh, 12h	dup(0)
		db 7, 36h, 21h,	0CDh, 2	dup(0),	7, 36h,	22h, 21h, 2 dup(55h)
		db 4 dup(22h), 21h, 0CDh, 28h dup(0), 7, 36h, 1Ch, 0D0h
		db 12h dup(0), 1, 0CDh,	22h, 73h, 40h, 0, 7, 36h, 22h
		db 27h,	35h, 5Ch, 36h, 4 dup(22h), 73h,	40h, 27h dup(0)
		db 7, 36h, 73h,	40h, 12h dup(0), 15h, 73h, 62h,	73h, 55h
		db 0, 7, 36h, 22h, 27h,	34h, 0,	73h, 62h, 3 dup(22h), 1Ch
		db 0D0h, 27h dup(0), 7,	35h, 0CDh, 13h dup(0), 17h, 0Dh
		db 22h,	15h, 73h, 40h, 7, 36h, 22h, 27h, 34h, 0, 1Ch, 0D2h
		db 3 dup(22h), 27h, 34h, 27h dup(0), 7,	37h, 34h, 14h dup(0)
		db 1Ch,	0D2h, 22h, 73h,	40h, 7,	36h, 22h, 27h, 34h, 0
		db 7, 36h, 3 dup(22h), 27h, 34h, 27h dup(0), 7,	3Ch, 0D0h
		db 14h dup(0), 1, 0CDh,	22h, 73h, 40h, 7, 36h, 22h, 27h
		db 34h,	0, 7, 36h, 3 dup(22h), 27h, 34h, 27h dup(0), 7
		db 33h,	40h, 15h dup(0), 1Ch, 0D2h, 73h, 40h, 7, 36h, 22h
		db 27h,	34h, 0,	1Ch, 0D2h, 3 dup(22h), 27h, 34h, 27h dup(0)
		db 7, 0Dh, 16h dup(0), 7, 36h, 73h, 40h, 7, 36h, 22h, 27h
		db 34h,	0, 73h,	62h, 3 dup(22h), 1Ch, 0D0h, 27h	dup(0)
		db 7, 0Dh, 16h dup(0), 1, 0CDh,	73h, 40h, 7, 36h, 22h
		db 27h,	35h, 5Ch, 36h, 4 dup(22h), 73h,	40h, 27h dup(0)
		db 7, 34h, 17h dup(0), 2 dup(73h), 40h,	7, 36h,	22h, 21h
		db 2 dup(55h), 4 dup(22h), 21h,	0CDh, 28h dup(0), 7, 34h
		db 17h dup(0), 1Ch, 0F3h, 40h, 7, 36h, 8 dup(22h), 17h
		db 74h,	28h dup(0), 7, 34h, 17h	dup(0),	7, 33h,	40h, 7
		db 36h,	7 dup(22h), 25h, 0CDh, 0C0h, 28h dup(0), 7, 34h
		db 17h dup(0), 1, 0C3h,	40h, 7,	35h, 6 dup(55h), 57h, 3
		db 50h,	40h, 25h dup(0), 1, 3 dup(39h),	34h, 17h dup(0)
		db 1, 0C3h, 40h, 1, 8 dup(55h),	40h, 0,	0C0h, 28h dup(0)
		db 1, 90h, 18h dup(0), 73h, 40h, 0Bh dup(0), 40h, 42h dup(0)
		db 73h,	40h, 0Bh dup(0), 0C0h, 29h dup(0), 80h,	18h dup(0)
		db 73h,	40h, 0Bh dup(0), 40h, 42h dup(0), 73h, 40h, 35h	dup(0)
		db 80h,	18h dup(0), 73h
		db 40h,	4Eh dup(0), 15h, 0DDFh dup(0), 0FFh, 0CCh, 0Ch
		db 0FFh, 0CFh, 0FCh, 0C0h, 0CFh, 0F3h, 0FCh, 0,	3, 0FCh
		db 0FFh, 0Fh, 0F3h, 0FCh, 0C0h,	0CFh, 0FCh, 0FFh, 0Fh
		db 0F0h, 0, 0FFh, 2 dup(0Ch), 0, 3Fh, 0F3h, 3, 3Fh, 0C0h
		db 0Fh,	0FCh, 0FFh, 0CFh, 0F0h,	0FFh, 3Fh, 0C3h, 0, 0FFh
		db 0CFh, 0F3h, 0FFh, 3Fh, 0CFh,	0F0h, 0FFh, 0, 0Ch, 2 dup(0C0h)
		db 3, 3Fh, 0CFh, 0F3h, 0FCh, 30h, 14h dup(0), 0C0h, 2 dup(0CCh)
		db 3 dup(0C0h),	0FFh, 0CFh, 0C3h, 0FCh,	0, 3, 0F0h, 0FFh
		db 0Fh,	0C3h, 0F0h, 0C0h, 0CCh,	0Ch, 0FFh, 0Fh,	0C0h, 0
		db 0FFh, 3, 0F0h, 0, 2 dup(3), 0FFh, 3Fh, 0, 0Ch, 0, 0C0h
		db 0CCh, 0Ch, 0FCh, 3Fh, 0C3h, 0, 0C0h,	0CFh, 0F0h, 30h
		db 3Fh,	0Fh, 0F0h, 0FFh, 0, 0Ch, 0CCh, 0C0h, 3,	3Fh, 0CFh
		db 0F3h, 0FCh, 30h, 14h	dup(0),	0C0h, 0CCh, 0Ch, 0FFh
		db 3 dup(0C0h),	0CFh, 0F3h, 3, 0, 3, 0,	0C0h, 0CFh, 0F3h
		db 0FCh, 0FFh, 0CCh, 0Ch, 0C0h,	0CFh, 0F0h, 0, 0FFh, 0
		db 0C0h, 0, 3 dup(3), 3Fh, 0C0h, 0Fh, 0FCh, 0FFh, 0CFh
		db 0F0h, 0FFh, 3Fh, 0C3h, 0FCh,	0C0h, 0CFh, 0F0h, 30h
		db 3Fh,	0CCh, 0Ch, 0FFh, 0, 0Ch, 2 dup(0C0h), 3, 3Fh, 0CFh
		db 0F3h, 0FCh, 30h, 0D4h dup(0)

; ---------------------------------------------------------------------------
byte_109	db 7Bh,	7Bh, 7Ah, 7Ah, 79h, 79h, 78h ; DATA XREF: initSinTable+74r
byte_110	db 77h,	76h, 75h, 73h, 72h, 71h, 6Fh ; DATA XREF: initSinTable+A9r
byte_117	db 6Eh,	6Ch, 6Bh, 69h, 67h, 66h	; DATA XREF: initSinTable+DEr
byte_11D	db 64h,	62h, 60h, 5Fh, 5Dh, 5Ch, 5Ah ; DATA XREF: initSinTable+113r
byte_124	db 59h,	57h, 56h, 54h, 53h, 52h, 51h, 50h, 2 dup(4Fh)
					; DATA XREF: initSinTable+148r
		db 2 dup(4Eh), 5 dup(4Dh), 2 dup(4Eh), 4Fh, 2 dup(50h)
		db 51h,	53h, 54h, 55h, 57h, 58h, 5Ah, 5Ch, 5Dh,	5Fh, 61h
		db 63h,	65h, 67h, 6Ah, 6Ch, 6Eh, 70h, 72h, 75h,	77h, 79h
		db 7Bh,	7Dh, 7Fh, 81h, 83h, 85h, 87h, 88h, 8Ah,	8Bh, 8Ch
		db 8Dh,	8Eh, 8Fh, 2 dup(90h), 5	dup(91h), 90h, 2 dup(8Fh)
		db 8Eh,	8Ch, 8Bh, 8Ah, 88h, 86h, 84h, 82h, 80h,	7Eh, 7Bh
		db 78h,	76h, 73h, 70h, 6Dh, 6Ah, 66h, 63h, 60h,	5Ch, 59h
		db 55h,	52h, 4Eh, 4Bh, 47h, 44h, 40h, 3Dh, 3Ah,	36h, 33h
		db 30h,	2Dh, 2Ah, 27h, 25h, 22h, 20h, 1Eh, 1Bh,	19h, 18h
		db 16h,	14h, 13h, 12h, 11h, 10h, 2 dup(0Fh), 4 dup(0Eh)
		db 2 dup(0Fh), 2 dup(10h), 11h,	12h, 14h, 15h, 16h, 18h
		db 1Ah,	1Bh, 1Dh, 1Fh, 21h, 23h, 25h, 27h, 2Ah,	2Ch, 2Eh
		db 30h,	32h, 35h, 37h, 39h, 3Bh, 3Dh, 3Fh, 41h,	43h, 45h
		db 46h,	48h, 49h, 4Bh, 4Ch, 4Dh, 4Eh, 4Fh, 50h,	3 dup(51h)
		db 4 dup(52h), 2 dup(51h), 2 dup(50h), 4Fh, 4Eh, 4Dh, 4Ch
		db 4Bh,	4Ah, 48h, 47h, 45h, 44h, 42h, 41h, 3Fh,	3Dh, 3Ch
		db 3Ah,	38h, 37h, 35h, 33h, 32h, 30h, 2Fh, 2Dh,	2Ch, 2Bh
		db 2Ah,	2 dup(28h), 27h, 26h, 3	dup(25h), 3 dup(24h), 2	dup(25h)
		db 2 dup(26h), 27h, 28h, 29h, 2Bh, 2Ch,	2Eh, 30h, 32h
		db 34h,	36h, 38h, 3Bh, 3Dh, 40h, 43h, 46h, 48h,	4Ch, 4Fh
		db 52h,	55h, 58h, 5Ch, 5Fh, 62h, 65h, 69h, 6Ch,	6Fh, 73h
		db 76h,	79h, 7Ch, 7Fh, 82h, 84h, 87h, 8Ah, 8Ch,	8Eh, 91h
		db 93h,	94h, 96h, 98h, 99h, 9Ah, 9Bh, 9Ch, 2 dup(9Dh)
		db 4 dup(9Eh), 2 dup(9Dh), 9Ch,	9Bh, 9Ah, 99h, 97h, 96h
		db 94h,	92h, 90h, 8Eh, 8Ch, 8Ah, 87h, 85h, 82h,	80h, 7Dh
		db 7Ah,	78h, 75h, 72h, 6Fh, 6Ch, 69h, 67h, 64h,	61h, 5Eh
		db 5Ch,	59h, 57h, 54h, 52h, 50h, 4Eh, 4Ch, 4Ah,	48h, 46h
		db 45h,	43h, 42h, 41h, 40h, 3Fh, 2 dup(3Eh), 7 dup(3Dh)
		db 3Eh,	2 dup(3Fh), 40h, 41h, 42h, 43h,	44h, 46h, 47h
		db 48h,	4Ah, 4Bh, 4Dh, 4Eh, 50h, 51h, 53h, 54h,	55h, 57h
		db 58h,	59h, 5Bh, 5Ch, 5Dh, 5Eh, 5Fh, 2	dup(60h), 61h
		db 7 dup(62h), 2 dup(61h), 60h,	5Fh, 5Eh, 5Dh, 5Ch, 5Ah
		db 59h,	57h, 55h, 53h, 51h, 4Fh, 4Dh, 4Bh, 48h,	46h, 43h
		db 41h,	3Eh, 3Bh, 38h, 36h, 33h, 30h, 2Dh, 2Ah,	27h, 25h
		db 22h,	1Fh, 1Dh, 1Ah, 18h, 15h, 13h, 11h, 0Fh,	0Dh, 0Bh
		db 9, 8, 6, 5, 4, 3, 2 dup(2), 4 dup(1), 2 dup(2), 3, 4
		db 5, 6, 7, 9, 0Bh, 0Ch, 0Fh, 11h, 13h,	15h, 18h, 1Bh
		db 1Dh,	20h, 23h, 26h, 29h, 2Ch, 30h, 33h, 36h,	3Ah, 3Dh
		db 40h,	44h, 47h, 4Ah, 4Dh, 50h, 54h, 57h, 5Ah,	5Ch, 5Fh
		db 62h,	64h, 67h, 69h, 6Bh, 6Dh, 6Fh, 71h, 73h,	74h, 76h
		db 77h,	78h, 2 dup(79h), 2 dup(7Ah), 3 dup(7Bh), 3 dup(7Ah)
		db 79h,	78h, 2 dup(77h), 75h, 74h, 73h,	72h, 70h, 6Fh
		db 6Dh,	6Ch, 6Ah, 68h, 67h, 65h, 63h, 62h, 60h,	5Eh, 5Dh
		db 5Bh,	59h, 58h, 57h

exit		dw 0			; DATA XREF: seg000:1D3Ew start_0+B7r
oldInt9		dd 0			; DATA XREF: SetInt9Handler+Fw
					; ResetInt9Handler+9r ...
sinTable	dw 0			; DATA XREF: initSinTabler
					; initSinTable+5r ...
rasterbarPos	dw 0			; DATA XREF: start_0+4Fr start_0+54w ...
charPos		dw 0			; DATA XREF: addNewChar+2Dw
					; addNewChar+46r ...
charColPos	dw 0			; DATA XREF: addNewCharr
					; addNewChar+31w ...
scrollPos	dw 0			; DATA XREF: addNewChar+8r
					; addNewChar+Dw ...
musicTick	dw 0			; DATA XREF: doMusicr doMusic+50w ...
musicPos	dw 0			; DATA XREF: doMusic+8r doMusic+Dw ...
fontbuffer	db 1000h dup(0)		; DATA XREF: addNewChar+2Ao
					; initFont+8o
scrollText	db 'HI... HO... HERE WE GO....   WELCOME TO OUR VERY SPECIAL DEMO....'
					; DATA XREF: addNewChar+12o
		db '      (I BET YOU WONDER WHAT THE THING IS THAT MAKES THIS DEMO SO'
		db ' SPECIAL !)     WELL, I',27h,'D BETTER TELL YOU....    IT IS THE ONL'
		db 'Y DEMO THAT WORKS FINE, AND GIVES FULL COLOUR ON AN 8088 WITH CGA'
		db ' !      HAVE YOU EVER SEEN THE 320x200x16 RESOLUTION ON A CGA BEF'
		db 'ORE ?    I BET YOU',27h,'VE NOT.....   BUT AS WE ALWAYS SAY: EVERYTH'
		db 'ING IS POSSIBLE WITH SOME EXTREME CODING.           SORRY FOR NOT'
		db ' BRINGING YOU THE USUAL 4-VOICED SOUND.......    BECAUSE.... THER'
		db 'E ARE LIMITS FOR WHAT AN 8088 CAN DO....               WELL WELL.'
		db '... I THINK IT',27h,'S TIME TO WRAP.......                        ',0
music		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
					; DATA XREF: doMusic+13o doMusic+23o
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0E9h, 8, 0E3h, 0Bh, 8 dup(0), 94h, 23h,	6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0E9h, 8, 0E3h
		db 0Bh,	8 dup(0), 94h, 23h, 2 dup(0), 6Fh, 9, 0E3h, 0Bh
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 97h,	0Ah, 5Ah
		db 0Dh,	8 dup(0), 94h, 23h, 6 dup(0), 94h, 23h,	6 dup(0)
		db 94h,	23h, 94h, 23h, 97h, 0Ah, 5Ah, 0Dh, 8 dup(0), 94h
		db 23h,	2 dup(0), 0E3h,	0Bh, 1Fh, 0Eh, 94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0E3h, 0Bh, 1Fh, 0Eh, 8 dup(0), 94h
		db 23h,	6 dup(0), 94h, 23h, 6 dup(0), 94h, 23h,	94h, 23h
		db 0E3h, 0Bh, 1Fh, 0Eh,	8 dup(0), 94h, 23h, 2 dup(0), 5Ah
		db 0Dh,	0DAh, 0Fh, 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h
		db 0Ch dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0Ch dup(0), 94h, 23h, 6	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 94h, 23h, 0Ch dup(0), 94h,	23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0Ch dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 6 dup(0), 94h,	23h, 94h
		db 23h,	0DAh, 0Fh, 0DEh, 12h, 8	dup(0),	94h, 23h, 6 dup(0)
		db 94h,	23h, 6 dup(0), 94h, 23h, 94h, 23h, 0DAh, 0Fh, 0DEh
		db 12h,	8 dup(0), 94h, 23h, 0CAh, 11h, 1Fh, 0Eh, 0CAh
		db 11h,	94h, 23h, 0DAh,	0Fh, 4 dup(0), 94h, 23h, 0FCh
		db 0Eh,	6 dup(0), 0E3h,	0Bh, 4 dup(0), 94h, 23h, 0CAh
		db 11h,	4 dup(0), 94h, 23h, 0DAh, 0Fh, 4 dup(0), 94h, 23h
		db 0FCh, 0Eh, 6	dup(0),	0E3h, 0Bh, 4 dup(0), 94h, 23h
		db 0CAh, 11h, 4	dup(0),	94h, 23h, 0DAh,	0Fh, 4 dup(0)
		db 94h,	23h, 0FCh, 0Eh,	6 dup(0), 0E3h,	0Bh, 4 dup(0)
		db 94h,	23h, 0CAh, 11h,	4 dup(0), 94h, 23h, 0DAh, 0Fh
		db 4 dup(0), 94h, 23h, 0FCh, 0Eh, 6 dup(0), 0E3h, 0Bh
		db 4 dup(0), 94h, 23h, 0CAh, 11h, 4 dup(0), 94h, 23h, 0DAh
		db 0Fh,	4 dup(0), 94h, 23h, 0FCh, 0Eh, 6 dup(0), 0E3h
		db 0Bh,	4 dup(0), 94h, 23h, 0CAh, 11h, 4 dup(0), 94h, 23h
		db 0DAh, 0Fh, 4	dup(0),	94h, 23h, 0FCh,	0Eh, 6 dup(0)
		db 0E3h, 0Bh, 4	dup(0),	94h, 23h, 0CAh,	11h, 4 dup(0)
		db 94h,	23h, 0DAh, 0Fh,	4 dup(0), 94h, 23h, 0FCh, 0Eh
		db 6 dup(0), 0E3h, 0Bh,	4 dup(0), 94h, 23h, 0CAh, 11h
		db 4 dup(0), 94h, 23h, 0DAh, 0Fh, 4 dup(0), 0A2h, 1Ah
		db 0FCh, 0Eh, 6	dup(0),	3Bh, 0Bh, 4 dup(0), 0A2h, 1Ah
		db 0CAh, 11h, 4	dup(0),	0A2h, 1Ah, 0DAh, 0Fh, 4	dup(0)
		db 0A2h, 1Ah, 0FCh, 0Eh, 6 dup(0), 3Bh,	0Bh, 4 dup(0)
		db 0A2h, 1Ah, 0CAh, 11h, 4 dup(0), 0A2h, 1Ah, 0DAh, 0Fh
		db 4 dup(0), 0A2h, 1Ah,	0FCh, 0Eh, 6 dup(0), 3Bh, 0Bh
		db 4 dup(0), 0A2h, 1Ah,	0CAh, 11h, 4 dup(0), 0A2h, 1Ah
		db 0DAh, 0Fh, 4	dup(0),	0A2h, 1Ah, 0FCh, 0Eh, 6	dup(0)
		db 3Bh,	0Bh, 4 dup(0), 0A2h, 1Ah, 0CAh,	11h, 4 dup(0)
		db 0A2h, 1Ah, 0DAh, 0Fh, 4 dup(0), 2 dup(0FFh)
; ---------------------------------------------------------------------------
		
seg000		ends


		end start
