;Bank 4 - Music / Plus Sprites
;Bank 5 - Bootstrap Cache
;Bank 6 - 128k Special screens
;Bank 7 - Level sprites

DiskMap1 equ 1
DiskMap2 equ 2
DiskMap3 equ 2

	read "CoreDefs.asm"

limit &6000
org &4000

; The bootstrap is responsible for most loading, it will page in and start new levels when called
; handle their distribution over the system memory and do title screens / game over and the like

; depending on the command Control may not be returned, as this program wipes out the level code
; however if needed the level will be restarted via its jumpblock

; It loads into &4000, so cannot be used when the screen is page flipping

; When the bootstrap is in memory, the Bitmap font will be available at &7000 
; This is for the Main menu and similar

; on the 464 it will be loaded in each time
; in the 6128 it will be always in memory



;Make Instructions:

; Do not compile this directly, Compile Core.asm as it compiles this as well
; Both must be compiled together, as Bootstrap points to locations in Core - you will get a crash otherwise!



;mc_screen_offset equ &bd1f
;scr_set_position equ &bd55
;KeyboardScanner_Flush equ &BB03

jp Bootstrap_Launch	; &4000
jp Bootstrap_FromBasic	; &4003
jp Bootstrap_FromHL	; &4006
jp Bootstrap_Reload	; &4009
ifdef SupportPlus 
	jp Bootstrap_ReloadPlusSprites	; &400C
else
	jp null
endif



Bootstrap_Launch:
	ld bc,&7f8D	; Reset the firmware to OFF
	out (c),c
	ld hl,RasterColors_InitColors
	call SetColors
	
	ld h,0
	ld l,0
Bootstrap_FromHL:

	; HL is used as the bootstrap command
	; H=1 means levels
	; H=0 means system events (Menu etc)
	ld a,h
	or a
	jr z,Bootstrap_SystemEvent
	cp 1
	jr z,Bootstrap_Level

	; Bootstrap Level
ret	
Bootstrap_SystemEvent:
	; Bootstrap System event
	ld a,l
	cp 0
	jp z,BootsStrap_StartGame
	cp 1
	jp z,BootsStrap_ContinueScreen
	cp 2
	jp z,BootsStrap_ConfigureControls
	cp 3
	jp z,BootStrap_SaveSettings
	cp 4
	jp z,GameOverWin
ret
Bootstrap_Level:

	ld sp,&BFFF	; we are not returning, so reset the stack

	; Load and start a level
	ld a,l
	cp 0
	jp z,Bootstrap_Level_0Again

	cp 9
	jp z,Bootstrap_Level_9



	cp 1
	jp z,Bootstrap_Level_1

	cp 2
	jp z,Bootstrap_Level_2
	cp 3
	jp z,Bootstrap_Level_3
	cp 4
	jp z,Bootstrap_Level_4
	cp 5
	jp z,Bootstrap_Level_5
	cp 6
	jp z,Bootstrap_Level_6
	cp 7
	jp z,Bootstrap_Level_7
	cp 8
	jp z,Bootstrap_Level_8
	cp 250
	jp z,Bootstrap_Level_EndIntro	;Shown before the last level
	cp 251
	jp z,Bootstrap_Level_EndOutro	; End Sequence
	cp 252
	jp z,Bootstrap_Level_Intro
jp Bootstrap_Level_1 ;should never get here!

Bootstrap_FromBasic:
	ld l,(ix+0)	
	ld h,(ix+1)
	jp Bootstrap_FromHL

;***************************************************************************************************

;					Start Game

;***************************************************************************************************
BootStrap_Reload:

	ld a,0
	ld hl,DiskMap_Font
	ld b,DiskMap_Font_Size
	ld c,DiskMap_Font_Disk
	ld de,&7000
	call Akuyou_LoadDiscSector

ret
Blackout64k:			;Blackout screen on 64k, do nothing on 128
ifdef Support64k
	ifdef debug
		ret
	endif

	ifdef Support128k
		ld a,(CPCVer)
		and 64
		ret z
	endif
	ifndef debug
		ld e,1
		ld hl,RasterColors_Black
		call RasterColors_NoDelay
		ld hl,RasterColors_ZeroColors
		call SetColors
	endif
endif
ret
BootsStrap_StartGame:

	
	;set up the screen
	
	; border 0
	;LD BC,&7F00 ;Gate Array port
	;LD A,%00010000 ;Pen number (and Gate Array function)
	;OUT (C),A ;Send pen number
	;LD A,&54 ;Pen colour (and Gate Array function)
	;OUT (C),A ;Send it

	;mode 1
	;LD BC,&7F00 ;Gate array port
	;LD A,%10010001 ;Mode and ROM selection (and Gate Array function)
	;OUT (C),A ;Send it
	



	;Border To black
	ld a,1
	ld b,0
	ld c,b
	call &bc38	; set border 0 to black
	ifndef debug
		;ld hl,RasterColors_InitColors
		ld hl,RasterColors_ZeroColors
		call SetColors
	endif
	;Load the game core - this is always in memory
	ld hl,FileName_Core
	ld de,&8000
	call BootStrap_LoadDiskFile




	;xor a
	;ld (&BE78),a	;disable errors
	call &BB57 ; VDU Disable

	ld hl,FileName_Settings
	ld de,SavedSettings
	call BootStrap_LoadDiskFile

	call &BB54 ; VDU enable
	;ld a,255
	;ld (&BE78),a	;enable errors
	;

	;wipe the CPC ver setting
	xor a
	ld (CPCVer),a



	;Backup Disk operating system Vars here - Please add your own
	;if you have special requirements
	;please see Firmware_Restore in the core.asm file for the other half!




	ld hl,(&be7d)	; get address where current drive number is held
	ld a,(hl)	; get drive number
	ld (FirwareRestoreDriveNo_Plus1-1),a
	ld hl,(&BAFE)
	ld (ParadosSettings_Plus2-2),hl
;	ld hl,(&A700)
;	ld (AmsDosDiskSettings_Plus2-2),hl



	di
	ld hl,(&bd37+1)				;Get the Restore High Jumpblock command
	ld (FirmJumpLoc_Plus2-2),hl		; it's different on 464/6128 firmware!

;	exx
;	ld (FirmwareBCRestore_Plus2-2),bc
;	exx	



ifdef SupportPlus
	ld b,&bc
	ld hl,PlusInitSequence
	ld e,17
PlusInitLoop:
	ld a,(hl)
	out (c),a
	inc hl
	dec e
	jr nz,PlusInitLoop
	ei

	ld a,1
	call Akuyou_BankSwitch_128k_SetCurrent
	;copy to the lower area.
	ld bc,&100
	ld hl,Plus_BankCopy
	ld de,&C000
	ldir
	di

		ld bc,4
		ld de,&2000
		ld hl,&4000
		call &C000

		ld bc,&7fa0	; move the lower firmware back on a plus
		out (c),c
		ld bc,&7f8D	; Reset the firmware to OFF
		out (c),c
	ei

	;test 2 bytes from &4000 - if the asic has paged in they will not match main mem 

	ld hl,&2000	
	ld de,&4000
	ld a,(hl)
	ld b,a
	ld a,(de)
	cp b
	jp z,DetectedNonPlus ; non plus
	inc hl
	inc de
	ld a,(hl)
	ld b,a
	ld a,(de)
	cp b
	jp z,DetectedNonPlus ; 

	ld a,(CPCVer)
	or 1
	ld (CPCVer),a
endif
DetectedNonPlus:
	ld a,0
	call Akuyou_BankSwitch_128k_SetCurrent

	; reset location

	ld a,&c0
;	call SetScreenMemPos
	ld hl,&0000
	push hl
	push af
	call &bd1f	;call mc_screen_offset

	pop af
	pop hl
	call &bd55	;call scr_set_position

	ld a,1
	call &bc0e ;Scr_SetMode

	ifndef AllowDisk2
		ld hl,FileName_LoadingScreen
		ld de,&C000
		call BootStrap_LoadDiskFile
	endif



	ld hl,RasterColors_InitColors
	call SetColors

	call ScreenBackupC000

	;

;DiskMap_TitleScreen     		equ &26C1 ; T38-SC1.D01 
;DiskMap_TitleScreen_Size 		equ 32
;DiskMap_TitleScreen_Disk 		equ 1

;	ld a,0
;	ld hl,DiskMap_TitleScreen
;	ld b,DiskMap_TitleScreen_Size
;	ld c,DiskMap_TitleScreen_Disk
;	ld de,&C000
;	call Akuyou_LoadDiscSector



	call BootStrap_Reload


ifdef Support128k
	;test to see if we have multiple ram banks

	ld a,7
	ld bc,4
	ld de,&2000
	ld hl,&4000
	call Akuyou_BankSwitch_128k_BankCopy 

	ld hl,&2000	
	ld de,&4000
	ld a,(hl)
	ld b,a
	ld a,(de)
	cp b
	jr nz,Detected128k ; 64 k only
	inc hl
	inc de
	ld a,(hl)
	ld b,a
	ld a,(de)
	cp b
	jr nz,Detected128k ; 64 k only
endif
	ld a,(CPCVer)
	or 64
	ld (CPCVer),a

	ld a,&0D
	ld (SetDiskMessagePos_Plus2-1),a


	ld a,0
	call BankSwitch_128k_SetCurrent

	jp PlusLoad

;	call ClearC000
;	ld l,12				
;	ld bc,error64K
;	call ShowTextLines		;no 64k support error - not needed anymore!
;	di
;	halt

; Load 128k specific stuff
ifdef Support128k
Detected128k:
	ld a,(CPCVer)
	ifdef Support128k
		or 128
	else
		or 64
	endif 
	ld (CPCVer),a

	ld a,0
	call BankSwitch_128k_SetCurrent


	ld a,4
	ld hl,DiskMap_PlusSpritesChibiko
	ld c,DiskMap_PlusSpritesChibiko_Disk
	ld de,&4000
	call Akuyou_LoadDiscSector



	ld a,4
	ld hl,DiskMap_MusicLevel
	ld c,DiskMap_MusicLevel_Disk
	ld de,&4800
	call Akuyou_LoadDiscSector


	ld a,4
	ld hl,DiskMap_MusicBoss
	ld c,DiskMap_MusicBoss_Disk
	ld de,&5000
	call Akuyou_LoadDiscSector

	ld a,4
	ld hl,DiskMap_MusicMenu
	ld c,DiskMap_MusicMenu_Disk
	ld de,&5800
	call Akuyou_LoadDiscSector

;	ld a,1
;	ld hl,DiskMap_Core_128
;	ld b,DiskMap_Core_128_Size
;	ld c,DiskMap_Core_128_Disk
;	ld de,&FAFF
;	call Akuyou_LoadDiscSector


	ld a,1
	ld hl,&7000
	ld bc,&1000
	ld de,&C000			; copy the font to bank 7 for ingame on the 6128 (464 will have to use firmware or reload)
	call Akuyou_BankSwitch_128k_BankCopy
endif


PlusLoad:
	
;ifdef Force464
;	ld a,64
;	ld (CPCVer),a			;fake a 64k machine for testing
;	jp notaplus
;endif
ifdef SupportPlus
	ld a,(CPCVer)
	and 1
	jp z,notaplus


	ifdef AllowDisk2	;Plus sprites are on disk 1
		jp notaplus
	endif 

	call Blackout64k

	ld bc,15*2		;Snag a few bytes of temp space to copy the palette
	ld hl,-15*2-4
	add hl,sp
	ex hl,de
	push de
		ld hl,PlusPaletteGame
;	ld de,&C000
		ldir
	pop hl
;	ld hl,&C000
	di
	call Plus_SetPalette
	ei

	call Bootstrap_ReloadPlusSprites
di
	call Plus_HideSprites
ei
	


;	ld a,0
;	ld bc,&0000
;	ld de,&0009
;	call Akuyou_Plus_SetSprite
;	ld b,&10    	; Move X
;	ld d,&01
;	call Akuyou_Plus_SetSprite
;	ld bc,&0010 	;Move Y
;	ld d,&02
;	call Akuyou_Plus_SetSprite
;	ld b,&10	;Move X
;	ld d,&03
;	call Akuyou_Plus_SetSprite

;	ld bc,&2020
;	ld de,&0409
;	call Akuyou_Plus_SetSprite


;	ld bc,&1515
;	ld de,&0509
;	call Akuyou_Plus_SetSprite
;
;	ld bc,&3515
;	ld de,&0609
;	call Akuyou_Plus_SetSprite


;	ld bc,&3520
;	ld de,&0909
;	call Akuyou_Plus_SetSprite


;	ld bc,&000F
;	ld de,&0309
;	call Akuyou_Plus_SetSprite
;	ld bc,&0F0F
;	ld de,&0409
;	call Akuyou_Plus_SetSprite
	;ld a,1
	;ld bc,&0F00
	;ld d,9
	;call Akuyou_Plus_SetSprite
	;ld a,2
	;ld bc,&000F
	;ld d,9
	;call Akuyou_Plus_SetSprite
	;ld a,3
	;ld bc,&0F0F
	;ld d,9
	;call Akuyou_Plus_SetSprite
	call ScreenRestoreC000
endif
NotAPlus:


	ld a,0
	call BankSwitch_128k_SetCurrent



	ifdef Debug
	ld l,12				; Show the 'Debug mode' message
	ld bc,DebugBuild
	call ShowTextLines
	endif

ifdef Support128k
	ld a,6
	ld hl,DiskMap_Screens
	ld b,DiskMap_Screens_Size
	ld c,DiskMap_Screens_Disk
	ld de,&4000
	call Akuyou_LoadDiscSector
endif


	;ld a,0
	;ld hl,DiskMap_Core
	;ld b,DiskMap_Core_Size
	;ld c,DiskMap_Core_Disk
	;ld de,&8000
	;call Akuyou_LoadDiscSector



	;Load the Player Sprites - these are always in memory
;	ld hl,FileName_sprites
;	ld de,&1000
;	call BootStrap_LoadDiskFile
	ld a,0
	ld hl,DiskMap_PlayerSprite
	ld b,DiskMap_PlayerSprite_Size
	ld c,DiskMap_PlayerSprite_Disk
	ld de,&1000
	call Akuyou_LoadDiscSector





	; load the 128k font

	;ld a,1			;; bank number
	;ld de,&C000		;; load address
	;ld hl,FileName_Font
	;call Akuyou_LoadDiskFileFromHLtoBankA

	;ld hl,FileName_Font		; Loaded at &7000 for the 464 menus
	;ld de,&7000
	;call BootStrap_LoadDiskFile

	;Load the music
	call Bootstrap_MusicInit



ifdef Support128k
	; Copy the bootstrap to bank 5 - part 1

	ld hl,&4000
	ld de,&2000
	ld bc,&2000
	ldir


	ld a,5
	ld hl,&2000
	ld bc,&2000
	ld de,&4000		
	call Akuyou_BankSwitch_128k_BankCopy


	; Copy the bootstrap to bank 5 - part 2

	ld hl,&4000+&2000
	ld de,&2000
	ld bc,&2000
	ldir


	ld a,5
	ld hl,&2000
	ld bc,&2000
	ld de,&4000+&2000		
	call Akuyou_BankSwitch_128k_BankCopy

endif



	;ld a,0*3
	;call Akuyou_ShowCompiledSprite
;jp GameOverWin
;jp Bootstrap_Level_9
;jp Bootstrap_Level_EndOutro
;jp Bootstrap_Level_EndIntro
;jp Bootstrap_Level_EndOutro	

;	call Akuyou_Player_CheatMode
;	jp GameOver
;jp Bootstrap_Level_Intro
	;jp Bootstrap_Level_7
	jp Bootstrap_Level_0	; Start the menu





;There are two version of Level0 (Menu) - one to run from the game load up
; and one to reset things if the game has returned from gameover
Bootstrap_Level_0Again:	
	;call Akuyou_Firmware_Restore
	;call Akuyou_ScreenBuffer_Reset
	;ld hl,RasterColors_ZeroColors
	;call SetColors
	ei
	halt
	halt
	halt 
	halt 
	halt
	halt
	di
	ld a,5
	ld bc,&4000
	ld hl,&4000
	ld de,&C000
	push bc
	push hl
	push de
	call BankSwitch_128k_BankCopy	

	ld a,0
	;ld bc,&4000
	pop hl ;intentionally backwards!;ld hl,&C000
	pop de;ld de,&4000
	pop bc
	call BankSwitch_128k_BankCopy		
	call ClearC000

	ei

	call LevelReset0000

	ld a,0
	ld hl,DiskMap_MainMenu
	ld b,DiskMap_MainMenu_Size
	ld c,DiskMap_MainMenu_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector

	ld e,1
	ld hl,RasterColors_Black
	call RasterColors_NoDelay

	ld a,0
	ld hl,DiskMap_LoadingScreen
	ld b,DiskMap_LoadingScreen_Size
	ld c,DiskMap_LoadingScreen_Disk
	ld de,&C000
	call Akuyou_LoadDiscSector

	call ScreenBackupC000



	call Bootstrap_MusicInitMenu
	call Akuyou_Music_Restart

	call ScreenRestoreC000

	jp LevelData_StartLevel

Bootstrap_Level_0:	
	call StartANewGame
	call LevelReset0000


	;Load the level
	;ld hl,FileName_Menu
	;ld de,&2000
	;call BootStrap_LoadDiskFile

	ld a,0
	ld hl,DiskMap_MainMenu
	ld b,DiskMap_MainMenu_Size
	ld c,DiskMap_MainMenu_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector

	;Load the Addon Sprites (128k only)

	;ld a,1			;; bank number
	;ld de,&D000		;; load address
	;ld hl,FileName_Level1_128
	;call Akuyou_LoadDiskFileFromHLtoBankA

	call Bootstrap_MusicInitMenu
	call Akuyou_Music_Restart
	call ScreenRestoreC000

	jp LevelData_StartLevel

;	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it
;	jp LevelData_StartLevel ; the Bootstrap will be overwritten by the screenbuffer


ret
;backup 4k of screen for temp use - we always use the screen for scratch area,
;but if we have spare space somewhere else, lets's use it!
ScreenBackupC000:
	xor a
	ld hl,&C000
	ld de,&6000
	ld BC,&1000
	call BankSwitch_128k_BankCopy
ret

ScreenRestoreC000:
	xor a
	ld de,&C000
	ld hl,&6000
	ld BC,&1000
	call BankSwitch_128k_BankCopy


	ld e,1
	ld hl,RasterColors_Safe
	call RasterColors_NoDelay


ret

ShowTextLines:
	push hl
		ld hl,&7000
		call Akuyou_ShowSprite_SetBankAddr
	pop hl
ShowTextLinesAgain:
	ld a,(bc)
	ld h,a
	dec h
	inc bc
	call Akuyou_DrawText_LocateSprite	
	
	ld a,255
	ld i,a
	push hl
		call Akuyou_DrawText_PrintString	
	pop hl
	inc bc
	inc l
	ld a,(bc)
	or a
	jr nz,ShowTextLinesAgain
ret

ifdef Debug
DebugBuild:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db 13,"Debug Build","!"+&80
db 0
endif
error64K:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;db 11,"No Game For You!","!"+&80
;db 6,"This version requires 128K","!"+&80
;	db 0

Level_1Msg:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db 2 ,"After a hard nights work massacrin","g"+&80
db 2 ,"villagers and harvesting their bloo","d"+&80
db 1 ,"Chibiko is having a well earned day'","s"+&80
db 1 ,"sleep... Suddenly she is awoken by ","a"+&80
db 4 ,"commotion. A swarm of noizy, stupi","d"+&80
db 2 ,"ill concieved and badly drawn monster","s"+&80
db 2 ,"are being drawn to her castle, and ar","e"+&80
db 4 ,"seriously disturbing the peace","!"+&80
;db 15," "," "+&80
db 4 ,"No self respecting vampire ca","n"+&80
db 3 ,"overlook this insult! its time t","o"+&80
db 3 ,"'Rise from your grave' and unleas","h"+&80
db 6 ,"hell on whoever sent them","!"+&80
db &0
Bootstrap_Level_1:	
	
	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite

	ld a,0
	ld hl,DiskMap_LevelLoadScreens12
	ld b,DiskMap_LevelLoadScreens12_Size
	ld c,DiskMap_LevelLoadScreens12_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector
	call ClearC000
	call &2000

	ld l,&0C				; Show the Continue message
	ld bc,Level_1Msg
	call ShowTextLines



	call StartANewGame
	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level1
	ld b,DiskMap_Level1_Size
	ld c,DiskMap_Level1_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level1_128
	ld b,DiskMap_Level1_128_Size
	ld c,DiskMap_Level1_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector


	Call PressFireMessage

	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
Bootstrap_Level_2:	

	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite

	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level2
	ld b,DiskMap_Level2_Size
	ld c,DiskMap_Level2_Disk
	ld de,&1B00
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level2_128
	ld b,DiskMap_Level2_128_Size
	ld c,DiskMap_Level2_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

	call Bootstrap_MusicInitBoss
	call Akuyou_Music_Restart
	jp LevelData_StartLevel

ret

Level_3Msg:

db 3 ,"The monsters climbing the mountai","n"+&80
db 3 ,"Seem to be coming from the fores","t"+&80
db 3 ,"Its time to push forward, and sto","p"+&80
db 13,"the invasion","!"+&80
db 3 ,"The animals of the forest seem t","o"+&80
db 3 ,"have become mutants, zombies, an","d"+&80
db 8 ,"generally super-annoyin","g"+&80
db 15," "," "+&80
db 3 ,"But no matter what zombified evi","l"+&80
db 3 ,"lurks in the heart of the fores","t"+&80
db 3 ,"it will be no match for Chibiko'","s"+&80
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db 13,"Black Magic!!","!"+&80
db &0
Bootstrap_Level_3:	

	
	ld a,1*3		; moving up a level, so show "Level complete" screen
	call Akuyou_ShowCompiledSprite

	ld a,0
	ld hl,DiskMap_LevelLoadScreens12
	ld b,DiskMap_LevelLoadScreens12_Size
	ld c,DiskMap_LevelLoadScreens12_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector
	call ClearC000
	call &2003

	ld l,&0C				
	ld bc,Level_3Msg
	call ShowTextLines


	call LevelReset0000


	ld a,0
	ld hl,DiskMap_Level3
	ld b,DiskMap_Level3_Size
	ld c,DiskMap_Level3_Disk
	ld de,&2800
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level3_128
	ld b,DiskMap_Level3_128_Size
	ld c,DiskMap_Level3_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector


	Call PressFireMessage

	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel

ret



Bootstrap_Level_4:	

	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite


	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level4
	ld b,DiskMap_Level4_Size
	ld c,DiskMap_Level4_Disk
	ld de,&1E00
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level4_128
	ld b,DiskMap_Level4_128_Size
	ld c,DiskMap_Level4_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

	call Bootstrap_MusicInitBoss
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret

Level_5Msg:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db 15,""," "+&80
db  2,"After defeating the evil zombifie","d"+&80
db  3,"merchandise cash-cow,and narrowl","y"+&80
db  4,"avoiding buying the plush dol","l"+&80
db  3,"Chibiko headed down to the river",","+&80
db  3,"only to find it also full of weir","d"+&80
db  4,"stuff too! Heading to the sourc","e"+&80
db  5,"will reveal whoever sent the","m"+&80
db  3,"and stop this annoyance once an","d"+&80
db 15,"for all","!"+&80
db &0



Bootstrap_Level_5:	


	ld a,1*3		; moving up a level, so show "Level complete" screen
	call Akuyou_ShowCompiledSprite


	ld a,0
	ld hl,DiskMap_LevelLoadScreens34
	ld b,DiskMap_LevelLoadScreens34_Size
	ld c,DiskMap_LevelLoadScreens34_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector
	call ClearC000
	call &2000


	ld l,&0C				; Show the Continue message
	ld bc,Level_5Msg
	call ShowTextLines

	call LevelReset0000


	ld a,0
	ld hl,DiskMap_Level5
	ld b,DiskMap_Level5_Size
	ld c,DiskMap_Level5_Disk
	ld de,&2A00
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level5_128
	ld b,DiskMap_Level5_128_Size
	ld c,DiskMap_Level5_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

;	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it


	Call PressFireMessage

	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret



Bootstrap_Level_6:

	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite


	
	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level6
	ld b,DiskMap_Level6_Size
	ld c,DiskMap_Level6_Disk
	ld de,&2500
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level6_128
	ld b,DiskMap_Level6_128_Size
	ld c,DiskMap_Level6_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector


	call Bootstrap_MusicInitBoss
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret
PressFireMessage:

	ld hl,&0918				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,PressFireMsg
	ld a,255
	ld i,a
	call Akuyou_DrawText_PrintString	

	jp WaitForFire
PressFireMsg:
db "Press Fire to Continue","!"+&80

Level_7Msg:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
db 3 ,"The monsters are coming from thi","s"+&80
db 3 ,"cave! There's only one entranc","e"+&80
db 2 ,"So whoever is sending them must b","e"+&80
db 15,"in there","!"+&80
db 15," "," "+&80
db 3 ,"Its difficult to see, as the cave","s"+&80
db 2 ,"is are only lit by phosphor rock","s"+&80
db 09,"and Glowing Creature","s"+&80
db 15," "," "+&80
db 4 ,"but, Victory is in your grasp","!"+&80
db 1 ,"Go in there, and 'Sort that shit out!","'"+&80
db &0



Bootstrap_Level_7:	

	
	ld a,1*3		; moving up a level, so show "Level complete" screen
	call Akuyou_ShowCompiledSprite

	ld a,0
	ld hl,DiskMap_LevelLoadScreens34
	ld b,DiskMap_LevelLoadScreens34_Size
	ld c,DiskMap_LevelLoadScreens34_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector
	call ClearC000
	call &2003



	ld l,&0C				; Show the Continue message
	ld bc,Level_7Msg
	call ShowTextLines


	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level7
	ld b,DiskMap_Level7_Size
	ld c,DiskMap_Level7_Disk
	ld de,&1D00
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level7_128
	ld b,DiskMap_Level7_128_Size
	ld c,DiskMap_Level7_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

;	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it


	Call PressFireMessage

	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret



Bootstrap_Level_8:	


	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite


	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level8
	ld b,DiskMap_Level8_Size
	ld c,DiskMap_Level8_Disk
	ld de,&2300
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level8_128
	ld b,DiskMap_Level8_128_Size
	ld c,DiskMap_Level8_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel

ret


Bootstrap_Level_9:	


	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite


	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Level9
	ld b,DiskMap_Level9_Size
	ld c,DiskMap_Level9_Disk
	ld de,&3000
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Level9_128
	ld b,DiskMap_Level9_128_Size
	ld c,DiskMap_Level9_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

;	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it

;	jp LevelData_StartLevel ; the Bootstrap will be overwritten by the screenbuffer
	call Bootstrap_MusicInitBoss
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret

Bootstrap_Level_EndIntro:	

	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite


	call LevelReset0000


	ld a,0
	ld hl,DiskMap_EndIntro
	ld b,DiskMap_EndIntro_Size
	ld c,DiskMap_EndIntro_Disk
	ld de,&2600
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_EndIntro_128
	ld b,DiskMap_EndIntro_128_Size
	ld c,DiskMap_EndIntro_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

	;call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it
	;jp LevelData_StartLevel ; the Bootstrap will be overwritten by the screenbuffer
	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel
ret

Bootstrap_Level_EndOutro:	


	ld a,1*3		; moving up a level, so show "Level complete" screen
	call Akuyou_ShowCompiledSprite


	call LevelReset0000


	ld a,0
	ld hl,DiskMap_EndOutro
	ld b,DiskMap_EndOutro_Size
	ld c,DiskMap_EndOutro_Disk
	ld de,&2F00
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_EndOutro_128
	ld b,DiskMap_EndOutro_128_Size
	ld c,DiskMap_EndOutro_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

;	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it
;	jp LevelData_StartLevel ; the Bootstrap will be overwritten by the screenbuffer
	call Bootstrap_MusicInitLevel
	call Akuyou_Music_Restart
	jp LevelData_StartLevel

ret
Bootstrap_Level_Intro:



	ld a,0*3		;Loading
	call Akuyou_ShowCompiledSprite

	call LevelReset0000

	ld a,0
	ld hl,DiskMap_Intro
	ld b,DiskMap_Intro_Size
	ld c,DiskMap_Intro_Disk
	ld de,&2500
	call Akuyou_LoadDiscSector

	ld a,1
	ld hl,DiskMap_Intro_128
	ld b,DiskMap_Intro_128_Size
	ld c,DiskMap_Intro_Disk
	ld de,&D000
	call Akuyou_LoadDiscSector

	call Bootstrap_MusicInitIntro
	call Akuyou_Music_Restart
	jp LevelData_StartLevel

ifdef SupportPlus
Bootstrap_ReloadPlusSprites:
	ld a,0
	ld hl,DiskMap_PlusSprites
	ld b,DiskMap_PlusSprites_Size
	ld c,DiskMap_PlusSprites_Disk
	ld de,&2000
	call Akuyou_LoadDiscSector

	ld a,1
	call BankSwitch_128k_SetCurrent

		di
		ld b,4
		ld a,2
		ld hl,&20FF
		call Plus_CopySpriteCompressed

		ld b,5
		ld a,2
		ld hl,&207F
		call Plus_CopySpriteCompressed

		ld b,6
		ld a,2
		ld hl,&217F
		push hl
		call Plus_CopySpriteCompressed

		ld b,7
		ld a,2
		pop hl
		push hl
		call Plus_CopySpriteCompressed

		ld b,8
		ld a,2
		pop hl
		call Plus_CopySpriteCompressed

		ld b,9
		ld a,2
		ld hl,&21FF
		push hl
		call Plus_CopySpriteCompressed

		ld b,10
		ld a,2
		pop hl
		push hl
		call Plus_CopySpriteCompressed

		ld b,11
		ld a,2
		pop hl
		call Plus_CopySpriteCompressed

		ei

ret
endif

Bootstrap_Test:


	;Load the music
	call Bootstrap_MusicInit
	jp LevelData_StartLevel ; 

; File Locations in virtual Track-Sector
; The game was originally intended to use a direct disk reader - however as I managed
; to get Firware restore working, and the popularity of C4CPC and M4 disk emulators
; it seemed a bad choice to limit compatibility like that.
; note the SIZE variables are redundant, the reader never uses them!


DiskMap_BootStrap    		equ &05C1
DiskMap_BootStrap_Size 		equ 4
DiskMap_BootStrap_Disk 		equ 0

DiskMap_MusicLevel 	  		equ &05C8 ;T05-SC8.D00
DiskMap_MusicLevel_Size 		equ 2
DiskMap_MusicLevel_Disk 		equ 0

DiskMap_PlayerSprite 		equ &06C1 ;T06-SC1.D00
DiskMap_PlayerSprite_Size 	equ 4
DiskMap_PlayerSprite_Disk 	equ 0

DiskMap_Sfx	   		equ &06C8
DiskMap_Sfx_Size 		equ 2
DiskMap_Sfx_Disk 		equ 0

DiskMap_Font  	     		equ &07C1  
DiskMap_Font_Size 		equ 8
DiskMap_Font_Disk 		equ 0

DiskMap_MainMenu     		equ &08C1 ; T08-SC1.D01
DiskMap_MainMenu_Size 		equ 16
DiskMap_MainMenu_Disk 		equ DiskMap1

DiskMap_LevelLoadScreens12	equ &03C1	;T03-SC1.D01
DiskMap_LevelLoadScreens12_Size	equ 12
DiskMap_LevelLoadScreens12_Disk equ DiskMap1



DiskMap_Level1       		equ &0AC1	;10
DiskMap_Level1_Size		equ 16
DiskMap_Level1_128   		equ &0CC1	;12  T12-SC1.D01
DiskMap_Level1_128_Size		equ 16	; &2000
DiskMap_Level1_Disk 		equ DiskMap1


DiskMap_Level2       		equ &0EC1	;14
DiskMap_Level2_Size		equ 20
DiskMap_Level2_128   		equ &11C1	;17 T17-SC1.D01
DiskMap_Level2_128_Size		equ 20	;&2500 - 3 tracks
DiskMap_Level2_Disk 		equ DiskMap1


DiskMap_Level3       		equ &14C1	;20	
DiskMap_Level3_Size		equ 16
DiskMap_Level3_128   		equ &16C1	;22 T22-SC1.D01
DiskMap_Level3_128_Size		equ 16
DiskMap_Level3_Disk 		equ DiskMap1

DiskMap_Level4       		equ &18C1	;24	
DiskMap_Level4_Size		equ 20
DiskMap_Level4_Disk 		equ DiskMap1
DiskMap_Level4_128   		equ &1BC1	;27
DiskMap_Level4_128_Size		equ 20



DiskMap_Screens	       		equ &1DC1	;T29-SC1.D01
DiskMap_Screens_Size		equ 32
DiskMap_Screens_Disk 		equ DiskMap1



DiskMap_PlusSprites    		equ &21C1	;T33-SC1.D01
DiskMap_PlusSprites_Size	equ 10
DiskMap_PlusSprites_Disk 	equ DiskMap1



DiskMap_PlusSpritesChibiko 	equ &21C2	;T33-SC2.D00
DiskMap_PlusSpritesChibiko_Disk equ 0


DiskMap_GameOver    		equ &22C2	;T34-SC2.D01
DiskMap_GameOver_Size		equ 16
DiskMap_GameOver_Disk 		equ DiskMap1


;Note, we are loading this before the CORE, so we load by filename
DiskMap_LoadingScreen     		equ &26C1 ; T38-SC1.D01 
DiskMap_LoadingScreen_Size 		equ 32
DiskMap_LoadingScreen_Disk 		equ DiskMap1


DiskMap_LevelLoadScreens34	equ &03C1	;T03-SC1.D01
DiskMap_LevelLoadScreens34_Size	equ 12
DiskMap_LevelLoadScreens34_Disk equ DiskMap2


DiskMap_Level5       		equ &0AC1	;10 
DiskMap_Level5_Size		equ 16
DiskMap_Level5_128   		equ &0CC1	;12 T12-SC1.D02
DiskMap_Level5_128_Size		equ 16	; &2000
DiskMap_Level5_Disk 		equ DiskMap2


DiskMap_Level6       		equ &0EC1	;14
DiskMap_Level6_Size		equ 20
DiskMap_Level6_128   		equ &11C1	;17  T17-SC1.D02
DiskMap_Level6_128_Size		equ 20	;&2500 - 3 tracks
DiskMap_Level6_Disk 		equ DiskMap2


DiskMap_Level7       		equ &14C1	;20	
DiskMap_Level7_Size		equ 20
DiskMap_Level7_128   		equ &17C1	;23 T23-SC1.D02
DiskMap_Level7_128_Size		equ 16
DiskMap_Level7_Disk 		equ DiskMap2

DiskMap_Level8       		equ &19C1	;25	
DiskMap_Level8_Size		equ 16
DiskMap_Level8_Disk 		equ DiskMap2
DiskMap_Level8_128   		equ &1BC1	;27  T27-SC1.D02
DiskMap_Level8_128_Size		equ 16

DiskMap_Level9       		equ &1DC1	;29
DiskMap_Level9_Size		equ 16
DiskMap_Level9_Disk 		equ DiskMap2
DiskMap_Level9_128   		equ &1FC1	;31  T31-SC1.D02
DiskMap_Level9_128_Size		equ 16

DiskMap_EndIntro 	    		equ &26C1 ; T38-SC1.D02
DiskMap_EndIntro_Size 			equ 16
DiskMap_EndIntro_Disk 			equ DiskMap2
DiskMap_EndIntro_128   			equ &29C1 ;T41-SC1.D02
DiskMap_EndIntro_128_Size		equ 8

; Disk 3 - Anims!


DiskMap_EndOutro       		equ &0AC1+&2800	;10 T50-SC1.D03
DiskMap_EndOutro_Size		equ 16
DiskMap_EndOutro_128   		equ &0CC1+&2800	;12 T52-SC1.D03
DiskMap_EndOutro_128_Size	equ 8	
DiskMap_EndOutro_Screens  	equ &0DC1+&2800	;13 T53-SC1.D03
DiskMap_EndOutro_Screens_Size	equ 24	
DiskMap_EndOutro_Disk 		equ DiskMap3





DiskMap_Intro       		equ &10C1+&2800	; T56-SC1.D03
DiskMap_Intro_Size		equ 13
DiskMap_Intro_128   		equ &12C1+&2800	; T58-SC1.D03
DiskMap_Intro_128_Size	equ 8	
DiskMap_Intro_Screens  	equ &13C1	; T19-SC1.D03
DiskMap_Intro_Screens_Size	equ 32	
DiskMap_Intro_Screens2  	equ &17C1+&2800	; T63-SC1.D03
DiskMap_Intro_Screens2_Size	equ 32	
DiskMap_Intro_Disk 		equ DiskMap3


DiskMap_MusicIntro 	  		equ &1BC1+&2800 ;T67-SC1.D03
DiskMap_MusicIntro_Size 			equ 2
DiskMap_MusicIntro_Disk 			equ DiskMap3



; Common disk entries
	
DiskMap_MusicBoss 	  		equ &24C1 ;36 ;T36-SC1.D00
DiskMap_MusicBoss_Size 			equ 2
DiskMap_MusicBoss_Disk 			equ 0

DiskMap_MusicMenu 	  		equ &24C3 ;36 ;T36-SC3.D00
DiskMap_MusicMenu_Size 			equ 2
DiskMap_MusicMenu_Disk 			equ 0

DiskMap_Core  	     		equ &25C1  	;37
DiskMap_Core_Size 		equ 19
DiskMap_Core_Disk 		equ 0

DiskMap_Core_128  	   	equ &25C8  	;T37-SC8.D00
DiskMap_Core_128_Size 		equ 2
DiskMap_Core_128_Disk 		equ 0


			;&29 is last track

;Size in 512k Sectors






SetColors:

	ld a,1
	ld b,0
	ld c,b
	push hl
	call &bc38	; set border 0 to black
	pop hl
	ld b,4
	ld c,0
RasterColors_InitBasic:
	push hl
	push bc
		ld a,c
		ld c,(hl)
		ld b,c
		call &bc32	; set ink 0 to black
	pop bc
	pop hl
	inc c
	inc hl
	djnz RasterColors_InitBasic
	ret


;Savesettings save the Highscore, Controls etc

Bootstrap_SaveSettings:
	call SaveSettings
	ld hl,(MusicRestore)
	call CallHL

ret
SaveSettings:
	call &BB57 ; VDU Disable
	ld hl,FileName_Settings

	ld bc,70
	ld de,SavedSettings
	call BootStrap_SaveDiskFile
	call &BB54 ; VDU enable


	;ld hl,filename ;; HL = address of the start of the filename
	;bc lengh of file
	;de source mem pos
ret


RasterColors_ZeroColors:
	defb 0,0,0
RasterColors_InitColors:
	defb 0,4,14,26

;Before the core is active we load files by filename, afterwards we use Track-Sector-Disk
FileName_Settings:
	db "SETTINGS.V01"
FileName_Core:
	db "T37-SC1 .D00"
FileName_LoadingScreen:
	db "T38-SC1 .D01" 

;***************************************************************************************************

;					Generic Startlevel

;***************************************************************************************************
ifdef Support128k
GenericStartLevel128k:
	di

	push hl
		ld bc,&7f8D	; Reset the firmware to OFF
		out (c),c
		call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it
	pop hl

	;copy the music back
	ld a,4
	ld de,&B000
	ld bc,&800
	call BankSwitch_128k_BankCopy

	;get the plus sprites

	ld a,4
	ld hl,&4000
	ld de,&A800
	ld bc,&800
	call BankSwitch_128k_BankCopy

jp GenericStartLevel128kB
endif
GenericStartLevel:
	ifdef Support64k
		push af
		push de
		push bc
		push hl
		call Blackout64k
		pop hl
		pop bc
		pop de
		pop af
	endif
	;load the music
	call Akuyou_LoadDiscSector	

ifdef SupportPlus
	ld a,(CPCVer)
	and 1
	jp z,notaplusNoSprite

	ld a,0
	ld hl,DiskMap_PlusSpritesChibiko
	ld c,DiskMap_PlusSpritesChibiko_Disk
	ld de,&C000
	call Akuyou_LoadDiscSector
endif
notaplusNoSprite:

	di
	ld bc,&7f8D	; Reset the firmware to OFF
	out (c),c
	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it



	ld a,0
	ld hl,&C000
	ld de,&A800
	ld bc,&1000
	call BankSwitch_128k_BankCopy

GenericStartLevel128kB:

	ret
	;jp LevelData_StartLevel ; the Bootstrap will be overwritten by the screenbuffer




;***************************************************************************************************

;					Music Loader

;***************************************************************************************************
Bootstrap_MusicInitMenu:
	ld hl,Bootstrap_MusicInitMenu
	ld (MusicRestore),hl

ifdef Support128k
	ld hl,&5800
	ld a,(CPCVer)
	and 128
	jp nz,GenericStartLevel128k
endif
	ld a,0			;; bank number
	ld de,&C800		;; load address
	ld hl,DiskMap_MusicMenu
	ld c,DiskMap_MusicMenu_Disk
jp GenericStartLevel


Bootstrap_MusicInitBoss:
	ld hl,Bootstrap_MusicInitBoss
	ld (MusicRestore),hl
ifdef Support128k
	ld hl,&5000
	ld a,(CPCVer)
	and 128
	jp nz,GenericStartLevel128k
endif
	ld a,0			;; bank number
	ld de,&C800		;; load address
	ld hl,DiskMap_MusicBoss
	ld c,DiskMap_MusicBoss_Disk
jp GenericStartLevel


Bootstrap_MusicInitLevel:
	ld hl,Bootstrap_MusicInitLevel
	ld (MusicRestore),hl
ifdef Support128k
	ld hl,&4800
	ld a,(CPCVer)
	and 128
	jp nz,GenericStartLevel128k
endif
	ld a,0			;; bank number
	ld de,&C800		;; load address
	ld hl,DiskMap_MusicLevel
;	ld b,DiskMap_MusicLevel_Size
	ld c,DiskMap_MusicLevel_Disk
jp GenericStartLevel


Bootstrap_MusicInitIntro:


	call Blackout64k
	call Akuyou_Firmware_Kill ; Backup the firmware so the Level can override it

	;ld hl,DiskMap_MusicIntro
	;ld b,DiskMap_MusicIntro_Size
	;ld c,DiskMap_MusicIntro_Disk
ret
;jp GenericStartLevel


Bootstrap_MusicInitNone:

	ld hl,DiskMap_SFX
	ld b,DiskMap_SFX_Size
	ld c,DiskMap_SFX_Disk

Bootstrap_MusicInitGeneric:
	ld a,4			;; bank number
	ld de,&4000		;; load address
	push de
		call Akuyou_LoadDiscSector
	Pop de
	ld hl,Akuyou_Music_Init
	ld a,4
	jp Akuyou_BankSwitch_128k_CallHL

Bootstrap_MusicInit:



	;ld de,&E00		;; load address
	;push de
	;ld hl,TestSFXFileName
	;ld a,0			;; bank number
	;call Akuyou_LoadDiskFileFromHLtoBankA
	;call LoadDiskFileFromHL

	ld a,0
	ld hl,DiskMap_SFX
	ld b,DiskMap_SFX_Size
	ld c,DiskMap_SFX_Disk
	ld de,&E00
	push de
	call Akuyou_LoadDiscSector
	pop de
	jp Akuyou_Sfx_Init;

	;jp Bootstrap_MusicInitLevel
	;ld a,0
	;call Akuyou_BankSwitch_128k 


	;call PLY_InterruptionOn	;		to play the song from start.
;	call Player + 3 / PLY_InterruptionOff		to stop the song.
;	call Player + 6 / PLY_InterruptionContinue	to continue the song once it's been stopped.
;	ret

;This backs up the level colors, and uses the 'safe color' pallete
;used by the continue screen to pause the level, then restore it later
BootsStrap_BasicColors:
	ld hl,(RasterColors_ColorArray1Pointer_Plus2-2);,bc
	ld (BootsStrap_RestoreColors_BC_Plus2-2),hl
	ld hl,(RasterColors_ColorArray2Pointer_Plus2-2);,de
	ld (BootsStrap_RestoreColors_DE_Plus2-2),hl
	ld hl,(RasterColors_ColorArray3Pointer_Plus2-2);,hl
	ld (BootsStrap_RestoreColors_HL_Plus2-2),hl
	ld hl,(RasterColors_ColorArray4Pointer_Plus2-2);,ix
	ld (BootsStrap_RestoreColors_IX_Plus2-2),hl
	ld hl,(RasterColors_PerFrameCallRestore_Plus2-2);,iy
	ld (BootsStrap_RestoreColors_IY_Plus2-2),hl
	ld iy,null
	push de
	push de
	push de
	pop bc	
	pop hl
	pop ix
	jr BootsStrap_RestoreColors_Doset
BootsStrap_RestoreColors:
	ld bc,&0000 :BootsStrap_RestoreColors_BC_Plus2
	ld de,&0000:BootsStrap_RestoreColors_De_Plus2
	ld hl,&0000:BootsStrap_RestoreColors_HL_Plus2
	ld ix,&0000:BootsStrap_RestoreColors_IX_Plus2
	ld iy,&0000:BootsStrap_RestoreColors_IY_Plus2
BootsStrap_RestoreColors_Doset:
	ld a,1
	jp RasterColors_SetPointers


ifdef SupportPlus 
Plus_BankCopy:
	push bc
		ld bc,&7fb8
		out (c),c
		ld c,&8D
		out (c),c
	pop bc
	;call &b909

	ldir
	ld bc,&7fA8
	out (c),c
	ld c,&8D	; Reset the firmware to OFF
	out (c),c
ret
endif


BootsStrap_ContinueScreen:
	;call Akuyou_Music_Restart

	ld de,RasterColors_Safe_ForInterrupt
	call BootsStrap_BasicColors

	ld hl,(MusicRestore)
	call CallHL


	call RasterColors_RestoreInterrupt	

	;call Akuyou_RasterColors_MusicOnly
	ei
	;ld a,7
	;call BankSwitch_128k	; our font is back in memory at &4000
	ld hl,&7000
	call	Akuyou_ShowSprite_SetBankAddr

	call AkuYou_Player_GetPlayerVars
	ld a,(iy+5)	
	or a
	jp z,GameOver
	;ld a,3
	;call DrawText_SetPen
	


	ld a,2*3	; show beaten chibiko
	call Akuyou_ShowCompiledSprite

	ifdef Support64k	
	;simpler compiled sprite for 64k
		ld a,(CPCVer)
		and 64
		jr z,Skip64kcompiled
		call CompiledSpriteContinue
	endif
Skip64kcompiled:

	ld hl,&0F12				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,txtContinueMsg
	ld a,255
	ld i,a
	call Akuyou_DrawText_PrintString	


	ld hl,&0E14				; show how many credits are left
	call Akuyou_DrawText_LocateSprite	
	ld bc,txtCreditsMsg
	ld a,255
	ld i,a
	call Akuyou_DrawText_PrintString	

	call AkuYou_Player_GetPlayerVars
	ld a,(iy+5)	
	call DrawText_Decimal		

	ld B,10
	ld ixl,255

Player_Dead_CountDown:
	
	dec B					; Show the countdown
	jp z,GameOver;Player_Dead_Resume ;GameOver		;Player_Dead_Resume=continue on zero		
	ld hl,&1417
	call Akuyou_DrawText_LocateSprite 
	ld a,48
	add B
	push bc
		call Akuyou_DrawText_CharSprite  
	pop bc

	ld a,b
	cp 8
	jr C,Player_Dead_PauseForFire
	call PauseASec
	jr Player_Dead_Pause
Player_Dead_PauseForFire
	call PauseASecForFire

Player_Dead_Pause:
	
	ld a,b
	cp 8
	jr NC,Player_Dead_CountDown

	ld a, ixl	; read the keymap
	or %11110001
	cp 255
	jp nz,Player_Dead_Resume

	jr Player_Dead_CountDown
Player_Dead_Resume:
	call AkuYou_Player_GetPlayerVars
	ld a,(iy+3)
	or %11000011
	ld (iy+3),a

	ld a,(iy+5)
	dec a
	ld (iy+5),a
	;re-enable our buffered screen and bits
	di
	call BootsStrap_RestoreColors
	
;	call Firmware_Kill
	call RasterColors_RestoreInterrupt	
	ret



txtContinueMsg:
;
	db "Continue","?"+&80
txtCreditsMsg:
;
	db "Credits",":"+&80

PauseASec:
	push bc
	ld b,250
	ld c,4
PauseASecB:
		push bc
			call AkuYou_Player_ReadControls
		pop bc
		
	djnz PauseASecB
	dec c
	ld a,c
	or a
	jp nz,PauseASecB

	pop bc
ret


PauseASecForFire:
	push bc
	ld b,250
	ld c,4
PauseASecForFireB:
		push bc
			call AkuYou_Player_ReadControls
		pop bc
		ld a, ixl	; read the keymap
		or %11110001
		cp 255
		jp nz,PauseASecForFireDone
	djnz PauseASecForFireB
	dec c
	ld a,c
	or a
	jp nz,PauseASecForFireB

PauseASecForFireDone
	pop bc
ret
;Insulting player messages!
txtGameOver1Msg:
;      .1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0
;      .9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
 db 5,"The Monster Hoarde Has Drive","n"+&80
 db 7,"Chibiko from her homelan","d"+&80
 db 2,"She is forced to live in a cardboar","d"+&80
db 8,"box as a street vampire","!"+&80
 db 1,"With Chibiko gone, Peace and harmon","y"+&80
 db 6,"Spreads through out the land","."+&80
db 8,"(Boy! Did you fuck up!",")"+&80
db 0
RankText:

 db 2,"Your 'Chibiko Scoring System (TM)","'"+&80
db 15,"Rank was","-"+&80
	db 0
RankF:
	db 17,"*****"," "+&80
	db 17,"*    "," "+&80
	db 17,"*****"," "+&80
	db 17,"*    "," "+&80
	db 17,"*    "," "+&80
	db 0
ChibikoReview:
	db 10,"Chibiko says:"," "+&80
	db 0

ChibikoReviewsWin:
defw ChibikoReviewWin

ChibikoReviewsNewScore:
defw ChibikoReview1
defw ChibikoReview2
defw ChibikoReview3
defw ChibikoReview4

ChibikoReviewsMehScore:
defw ChibikoReview5
defw ChibikoReview6
defw ChibikoReview7
defw ChibikoReview8
ChibikoReviewWin:

	db 10,"Well, you won","!"+&80
	db 10,"But I'm still giving you a F","!"+&80
	db 10," "," "+&80
	db 10,"Try get a better score nex","t"+&80
	db 10,"time sucker! ;-)"," "+&80
	db 0
ChibikoReview1:
	db 10,"Well Done","!"+&80
	db 10,"I'm sure there's worse player","s"+&80
	db 10,"there, I mean, the world"," "+&80
	db 10,"population is 7 billion",","+&80
	db 10,"there MUST be, right","?"+&80
;	db 10,"Good Job","!"+&80

;	db 10,"Now try plugging the controlle","r"+&80
;	db 10,"in first before starting th","e"+&80
;	db 10,"game","!"+&80
	db 0

ChibikoReview2:
	db 10,"Amazing!!","!"+&80
	db 10,"You survived SUCH a long tim","e"+&80
	db 10,"by aimlessly hitting button","s"+&80
	db 10,"at random","!"+&80
	db 0

ChibikoReview3:
	db 10,"Superb Performace","!"+&80
	db 10,"Imagine how good you'll b","e"+&80
	db 10,"you actually learn how t","o"+&80
	db 10,"play","!"+&80
	db 0
ChibikoReview4:

	db 10,"Well Done","!"+&80
	db 10,"I'm sure there's worse player","s"+&80
	db 10,"out there, I mean, the worl","d"+&80
	db 10,"population is 7 billio","n"+&80
	db 10,"....There MUST be, right","?"+&80
	db 0


ChibikoReview5:

	db 10,"You're really something, afte","r"+&80
	db 10,"all, It's rare to see someon","e"+&80
	db 10,"CLINICALLY BRAINDEAD still abl","e"+&80
	db 10,"to play computer games","!"+&80
	db 0
ChibikoReview6:
	db 10,"If YOU are the result of 2"," "+&80
	db 10,"million years of human"," "+&80
	db 10,"evolution I'd say the species"," "+&80
	db 10,"is seriously fucked","!"+&80
	db 0
ChibikoReview7:

	db 10,"Never mind","!"+&80
;	       123456789012345678901234567890
	db 10,"Maybe you will manage to serv","e"+&80
	db 10,"some purpose one day!?","!"+&80
	db 10,"You DO own an organ donor"," "+&80
	db 10,"card don't you","?"+&80
	db 0
ChibikoReview8:

	db 10,"I'd say the purpose of you","r"+&80
	db 10,"existance is to defin","e"+&80
	db 10,"utter failure so the res","t"+&80
	db 10,"of the population can fee","l"+&80
	db 10,"superior","!"+&80
	db 0
backupmusic:
	;backup music
	ld hl,&A800
	ld bc,&1000
	ld de,&6000
	ldir
	ret
restoremusic:
	;backup music
	ld de,&A800
	ld bc,&1000
	ld hl,&6000
	ldir
	ret
GameOverWin:

	call Firmware_Restore

	ld hl,&7000
	call	Akuyou_ShowSprite_SetBankAddr


	ld a,0			;; bank number
	ld de,&2000		;; load address
	ld hl,DiskMap_GameOver
	ld c,DiskMap_GameOver_Disk
	call Akuyou_LoadDiscSector







	ld de,RasterColors_Safe_ForInterrupt
	call BootsStrap_BasicColors

	ld hl,(MusicRestore)
	call CallHL
	call backupmusic

	call RasterColors_RestoreInterrupt	


	xor a
	ld (ReviewFilter_Plus1-1),a
	ld hl,ChibikoReviewsWin
	ld (ReviewBank_Plus2-2),hl
	ld (NewScoreBank_Plus2-2),hl	

	jr GameOverWinB
GameOver:
;jp GameOverReloadMenu
	;ld bc,&7f8D	; Reset the firmware to OFF



	ld a,0*3		; moving up a level, so show "Level complete" screen
	call Akuyou_ShowCompiledSprite

	ld a,3
	ld (ReviewFilter_Plus1-1),a	
	
	ld hl,ChibikoReviewsMehScore
	ld (ReviewBank_Plus2-2),hl	
	ld hl,ChibikoReviewsNewScore 
	ld (NewScoreBank_Plus2-2),hl	
	call backupmusic
	call Firmware_Restore


	ld a,0			;; bank number
	ld de,&2000		;; load address
	ld hl,DiskMap_GameOver
	ld b,DiskMap_GameOver_Size
	ld c,DiskMap_GameOver_Disk
	call Akuyou_LoadDiscSector
	call &2000
	
	;DiskMap_GameOver    		equ &22C2	;T34-SC2.D01
;	DiskMap_GameOver_Size	equ 12
;	DiskMap_GameOver_Disk 	equ 1

	call Firmware_Kill
	call restoremusic
;	ld hl,(MusicRestore)
;	call CallHL


	call RasterColors_RestoreInterrupt	
	ei

	ld hl,&7000
	call	Akuyou_ShowSprite_SetBankAddr


	;ld a,3
	;call DrawText_SetPen
	
	ld l,&10				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,txtGameOver1Msg
	call ShowTextLines
	

	Call WaitForFire
GameOverWinB:
;see if we have a highscore

	ld hl,HighScoreBytes+7
	ld de,Player_ScoreBytes+7
	ld b,8
NewScoreNextDigit:
	ld c,(hl)
	ld a,(de)
	cp c
	jr c,NewScoreNotHigher
	jr z,NewScoreDigitEqual
	jr NewScoreHigher
NewScoreDigitEqual:
	dec hl
	dec de
	djnz NewScoreNextDigit
	jr NewScoreNotHigher
NewScoreHigher:

	ld hl,HighScoreBytes+7
	ld de,Player_ScoreBytes+7
	ld b,8
HighScoreUpdateLoop:
	ld a,(de)
	ld (hl),a
	dec hl
	dec de
	djnz HighScoreUpdateLoop

	ld hl,ChibikoReviewsNewScore :NewScoreBank_Plus2
	ld (ReviewBank_Plus2-2),hl
NewScoreNotHigher:
	call &2003



	ld hl,&0700				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,txtYourScoreMsg
	ld a,255
	ld i,a
	call Akuyou_DrawText_PrintString	

	ld hl,&0A02				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,txtHighScoreMsg
	ld a,255
	ld i,a
	call Akuyou_DrawText_PrintString	



		ld hl,&2000
		call DrawText_LocateSprite

		ld hl, Player_ScoreBytes
		ld b,8	
		call GameOverScore_NextDigit

		ld hl,&2002
		call DrawText_LocateSprite

		ld hl,HighScoreBytes	
		ld b,8
		call GameOverScore_NextDigit


	ld l,&07				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,RankText
	call ShowTextLines



	call Firmware_Restore
	call SaveSettings

	call Firmware_Kill
	call restoremusic

	call RasterColors_RestoreInterrupt	
	ei




	ld l,&0A				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,RankF
	call ShowTextLines


	ld l,&11				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	ld bc,ChibikoReview
	call ShowTextLines


	ld hl,ChibikoReviewsNewScore :ReviewBank_Plus2
	ld a,r
	rrca
	rrca
 	and %00000011 :ReviewFilter_Plus1
	ld b,0
	ld c,a
	add hl,bc
	add hl,bc
	ld c,(hl)
	inc hl
	ld b,(hl)


	ld l,&13				; Show the Continue message
	call Akuyou_DrawText_LocateSprite	
	


	call ShowTextLines


	Call WaitForFire
GameOverReloadMenu:
	Call StartANewGame
;	di
;	ld bc,&4000
;	ld hl,
;call BankSwitch_128k_BankCopy	

ld de,RasterColors_Black_ForInterrupt
call BootsStrap_BasicColors


call Firmware_Restore
di

;call ScreenBuffer_Reset	
jp Bootstrap_Level_0Again

;	ld hl, &0100
;	jp Bootstrap_FromHL
	

GameOverScore_NextDigit:
	push bc
	push hl

		ld a,(hl)		
			add 48 ; Move to the correct digit (first 32 are not in font)
			 ;add 8 
			ld b,-2 ; we are drawing backwards!
			call DrawText_CharSpriteDirect;DrawText_DigitSprite

	pop hl
	pop bc
	inc hl
	dec b
	jp nz,GameOverScore_NextDigit
	ret

txtYourScoreMsg:
	db "Your Score was",":"+&80
txtHighScoreMsg:
	db "HighScore",":"+&80

WaitForFire:
	call PauseASec


WaitForFire_Continue:
	push bc
		call AkuYou_Player_ReadControls
	pop bc
	ld a, ixl	; read the keymap
	or %11110001
	cp 255
	jp z,WaitForFire_Continue
ret

DrawText_Decimal:
	ld c,0
DrawText_DecimalSub100:
	cp 100
	jp c,DrawText_DecimalLessThan100
	inc c
	sub 100
	jp DrawText_DecimalSub100
DrawText_DecimalLessThan100:
	ld b,a
	ld a,c
	or a
	jp z,SkipDigit100
	add 48
	push bc
		call Akuyou_DrawText_CharSprite
	pop bc

SkipDigit100:
	ld a,b
	ld c,0
DrawText_DecimalSubTen:
	cp 10
	jp c,DrawText_DecimalLessThanTen
	inc c
	sub 10
	jr DrawText_DecimalSubTen
DrawText_DecimalLessThanTen:
	ld b,a
	ld a,c
	or a
	jp z,SkipDigit10
	add 48
	push bc
		call Akuyou_DrawText_CharSprite
	pop bc
SkipDigit10:
	ld a,b
	add 48
	push bc
		call Akuyou_DrawText_CharSprite
	pop bc
	ret




StartANewGame:
	;reset all the scores n stuff
	call AkuYou_Player_GetPlayerVars
	ld a,(iy+6)
	ld (iy+5),a

	ld a,(iy+3)
	or %11000011
	ld (iy+3),a

;	ld a,(iy+5)
;	dec a
;	ld (iy+5),a

	ld a,%11100000
	ld (iy+4),a

	ld hl,Player_ScoreBytes
	ld b,8
	xor a
ScoreWipeNext:
	ld (hl),a
	inc hl
	djnz ScoreWipeNext

	ld a,(iy+7)
	or a
	jp z,Difficulty_Normal
	cp 1
	jp z,Difficulty_Easy
	cp 2
	jp z,Difficulty_Hard
ret



Difficulty_Easy:
	ld a,%00100000	
	jr Difficulty_Generic
	;ld (FireFrequencyA_Plus1-1),a
	;ld a,%00010000	
	;ld (FireFrequencyB_Plus1-1),a
	;ld a,%00010000	
	;ld (FireFrequencyC_Plus1-1),a
	;ld a,%00001000;	
	;ld (FireFrequencyD_Plus1-1),a
	;ld a,%00000100;	
	;ld (FireFrequencyE_Plus1-1),a
	;ret
Difficulty_Normal:
	ld a,%00010000	
	jr Difficulty_Generic
	;ld (FireFrequencyA_Plus1-1),a
	;ld a,%00001000	
	;ld (FireFrequencyB_Plus1-1),a
	;ld a,%00001000	
	;ld (FireFrequencyC_Plus1-1),a
	;ld a,%00000100;	
	;ld (FireFrequencyD_Plus1-1),a
	;ld a,%00000010;	
	;ld (FireFrequencyE_Plus1-1),a
	;ret
Difficulty_Hard:
	ld a,%00001000	
	jr Difficulty_Generic
	;ld (FireFrequencyA_Plus1-1),a
	;ld a,%00000100	
	;ld (FireFrequencyB_Plus1-1),a
	;ld a,%00000100	
	;ld (FireFrequencyC_Plus1-1),a
	;ld a,%00000010;	
	;ld (FireFrequencyD_Plus1-1),a
	;ld a,%00000001;	
	;ld (FireFrequencyE_Plus1-1),a
	;ret
Difficulty_Generic:
	;ld a,%00001000	
	ld (FireFrequencyA_Plus1-1),a
	rrca;ld a,%00000100	
	ld (FireFrequencyB_Plus1-1),a
	;ld a,%00000100	
	ld (FireFrequencyC_Plus1-1),a
	rrca;	ld a,%00000010;	
	ld (FireFrequencyD_Plus1-1),a
	rrca;ld a,%00000001;	
	ld (FireFrequencyE_Plus1-1),a
LevelReset0000:
di
ld hl,&E00
ld b,54
ld de,&0000
call SpFill

ld hl,&4000
ld b,160
ld de,&0000
call SpFill
ei

;This resets anything the last level may have messed with during play so we can start
;a new level with everything back to normal
ResetCore:
ld a,&69 
ld (Timer_CurrentTick_Plus1-1),a
xor a
ld (Timer_TicksOccured_Plus1-1),a
ld (Sfx_Sound_Plus1-1),a

;	ld (Event_LevelTime),a
;	ld a,(hl)
;	ld (Event_NextEventTime_Plus1-1),a
;	inc hl
;	ld (Event_NextEventPointer_Plus2-2),hl


	; reset reporgrammable stuff  - I AM USING EXX in these, so make sure that EX af and EXX are not used 	
	;at this point!!!
	ld hl,Object_DecreaseLifeShot	
	ld (ObjectShotOverride_Plus2-2),hl


	; set stuff that happens every level
	ld hl,&2064	;x,y
	ld (Player_Array),hl

	ld hl,domoves
	ld (ObjectDoMovesOverride_Plus2-2),hl

	ld hl,null
	ld (SmartBombSpecial_Plus2-2),hl
	
;	defb 100;Y
;	defb 64 ;X

	ld bc,Background_ShiftNow
	call set_BackgroundScrollDirection
	;ld a,&05	;Dec B	;04 - INC B
	
	xor a
	ld (Sfx_CurrentPriority_Plus1-1),a	; clear the to-do
	ld (Sfx_Sound_Plus1-1),a	; clear the note

	call DoMovesBackground_SetScroll

	call DoCustomRsts
	
	xor a
	call Akuyou_RasterColors_SetPointers

	;turbo mode! - disable stuff to make the game fster

	ld hl,PLY_Play
	ld (MusicExec_PerFrame_Plus2-2),hl

	ld hl, RasterColors_TickOverrideFirm 
	ld (RasterColorInterruptHandler_Plus2-2),hl

	call AkuYou_Player_GetPlayerVars
	ld a,(iy+8)
	or a
	ret z

	ld hl,null
	ld (MusicExec_PerFrame_Plus2-2),hl
	cp 1
	ret z
	;2
	ld (RasterColorInterruptHandler_Plus2-2),hl


ret

BootsStrap_ConfigureControls:
	ei
;	ld hl,RasterColors_InitColors
;	call SetColors

	ld e,1
	ld hl,RasterColors_Safe
	call RasterColors_NoDelay

;	ld de,RasterColors_Safe_ForInterrupt
;	call BootsStrap_BasicColors
call PauseASec;call KeyboardScanner_Flush ; flush the key buffer

	ld hl,&7000
	call Akuyou_ShowSprite_SetBankAddr
	
	ld b,8
	ld d,0
	ld e,0
ConfigureControls_Nextkey:
	push bc
		ld hl,KeyName
		add hl,de

		ld c,(hl)	; get the description of the key
		inc hl
		ld b,(hl)	; get the description of the key

		push de
			ld a,255
			ld i,a	;show 255 chars
			push bc
				call cls
				ld hl,&0A13
				ld bc,KeyMapString0

				call Akuyou_DrawText_LocateSprite
				call Akuyou_DrawText_PrintString
			pop bc
			ld hl,&120C
			call Akuyou_DrawText_LocateSprite
			call Akuyou_DrawText_PrintString

			call KeyboardScanner_WaitForKey
			
		
	
		pop de
			ld hl,KeyMap
			add hl,de
		push de
			ld (hl),a
			inc hl
			ld (hl),c

			;call DrawText_PrintHex	
			;ld a,"-"
			;call DrawText_PrintChar	
			;ld a,c
			;call DrawText_PrintHex	
		pop de
		inc de
		inc de
	pop bc
	djnz ConfigureControls_Nextkey

	call PauseASec;KeyboardScanner_Flush ; flush the key buffer
	ld hl,(MusicRestore)
	call CallHL

ret

 
KeyName: 
	defw KeyMapString1
	defw KeyMapString2
	defw KeyMapString3
	defw KeyMapString4
	defw KeyMapString5
	defw KeyMapString6
	defw KeyMapString7
	defw KeyMapString8

;We use - rather than space so the old text is overwritten - remember our
;spritefont has no space!
KeyMapString0: db  "Press Key For",":"+&80
KeyMapString1: db  "---Up--","-"+&80
KeyMapString2: db  "--Down-","-"+&80
KeyMapString3: db  "--Left-","-"+&80
KeyMapString4: db  "-Right-","-"+&80
KeyMapString5: db  "-FireL-","-"+&80
KeyMapString6: db  "-FireR-","-"+&80
KeyMapString7: db  "-SBomb-","-"+&80
KeyMapString8: db  "--Pause","-"+&80


ClearC000:
di
ld hl,&FFFF
ld b,256
ld de,&0000
call SpFill
ei
	ld e,1
	ld hl,RasterColors_Safe
	call RasterColors_NoDelay
ret



SpFill:
ld (SpRestoreFill_Plus2-2),sp

SpFillContinue:
ld sp,hl
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
push de
ld hl,&0000
add hl,sp
ld sp,&0000:SpRestoreFill_Plus2
ei
di
djnz SpFillContinue
ei
ret

;the commands we have to send to turn on a plus!
PlusInitSequence:
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee

PlusPaletteGame:
defw &0000			;; colour for sprite pen 1
defw &0555			;; colour for sprite pen 2
defw &0AAA				;; colour for sprite pen 3
defw &0FFF			;; colour for sprite pen 4
defw &0066			;; colour for sprite pen 5
defw &00AA			;; colour for sprite pen 6
defw &0808			;; colour for sprite pen 7
defw &0F0F			;; colour for sprite pen 8
defw &0FAF			;; colour for sprite pen 9
defw &00F0			;; colour for sprite pen 10
defw &06F7			;; colour for sprite pen 11
defw &0F00			;; colour for sprite pen 12
defw &0800			;; colour for sprite pen 13
defw &05A6			;; colour for sprite pen 14
defw &06F7			;; colour for sprite pen 15



;***************************************************************************************************

;					Bootstrap Disk Loader

;***************************************************************************************************

.cas_out_open equ &bc8c
.cas_out_direct equ &bc98
.cas_out_close equ &bc8f

BootStrap_LoadDiskFile:	

; HL - pointer to disk file
; DE - Destination to write to

	push de
	ld de,&C000	;; address of 2k buffer, 
	ld b,12		;12 chars
	call cas_in_open	

	pop hl
	jr nc,LoadGiveUp
	call cas_in_direct
LoadGiveUp:
	jp cas_in_close

BootStrap_SaveDiskFile:
	;ld hl,filename ;; HL = address of the start of the filename
	;bc lengh of file
	;de source mem pos

	ifdef ReadOnly	
		ret
	endif 
	

	push bc
	push de

		ld b,12 ;; B = length of the filename in characters
		ld de,&C000 ; Address of Buffer
		call cas_out_open ;; firmware function to open a file for writing

	pop hl  ;ld hl,&c000;; HL = load address
	pop de	;	ld de,&4000;; DE = length
	ld bc,&0000;; BC = execution address

	ld a,2 ;; A = file type (2 = binary)

	call cas_out_direct	;; write file
	jp cas_out_close 	;; firmware function to close a file opened for writing

;Mini continue compiles sprite for 64k
CompiledSpriteContinue:
ifdef Support64k
read "ContinueCompiled64k.asm"
endif

;DiskFileName:
;	db "01      .scr"




save direct "BootStrp.AKU",&4000,&2000	;address,size...}[,exec_address]
;save direct "T37-SC8.D00",&FAFF,&500	;address,size...}[,exec_address]