read "Core.asm"
;read "CoreDefs.asm"




org &2000
;***************************************************************************************************

;					 Testing Suite

;***************************************************************************************************
jp null 	;4000
jp Test_SpriteTest	;4003
jp null			;2006
jp Test_PrintText	;4009
jp null		;200C
jp RasterColors_Init 	;000F
jp RasterColors_Reset	;0012
jp RasterColors_Disable	;0015
jp DefineSprite		;0018
jp Akuyou_Background_Clear	;001B Gradiant background

jp ScreenBuffer_Init	;001e Init the double buffer
jp ScreenBuffer_Flip	;0021 Flip the buffer
jp DefineSprite_FromBasic ;0024
jp ShowSprite_FromBasic   ;2027
jp null	  ;202a
jp PLY_BasicSoundEffectInterface_PlaySound ;202D
jp ScreenBuffer_Reset 	  ;2030

jp Sprites_Clear          ;2033
jp Test_SpriteTest	  ;2036
jp DefineSprite_FromBasic2 ;2039
jp ShowSprite_FromBasic   ;203C
jp DefineSprite		  ;203F
	;jp ScreenBuffer_Reset	; Use Mode command instead - Remember 464 cannot do text to 4000
	;jp RasterColors_Basic







PLY_BasicSoundEffectInterface_PlaySound:
	ld c,(ix+0)	;Get Pitch
	ld b,(ix+1)
	ld d,(ix+2)	;Get Speed
	ld e,(ix+4)	;Get Note
	ld h,(ix+6)	;Get Volume
	ld l,(ix+8)	;Get SFX number
	ld a,(ix+10)	;Get Channel
	jp Akuyou_Sfx_Play


; Test the disk system








Test_PrintText:	; prints the text in BC

	ld bc,Test_TextString
	call DrawText_PrintString
	ld a,&ef
	call DrawText_PrintHex
	ret
	Test_TextString: db  "hello worl","d"+&80


; Test The Sprite System

; ************ Sprite Testing Code ***************

Test_SpriteTest:
	;call Init_BootStrap
	ld c,224
	ld b,184
	ld a,0
	ld (SprShow_SprNum),a
Test_SpriteTest_Tile:

		ld a,c
		ld (SprShow_Y),a
		ld a,b

		ld (SprShow_X),a
		push bc
		call Akuyou_ShowSprite
		call Akuyou_ShowSprite
		call Akuyou_ShowSprite
		pop bc	
		ld a,b
		sub 12
		ld b,a

		ld a,b
		cp 11
		jp NC,Test_SpriteTest_Tile

	ld b,184
	ld a,c
	sub 24
	ld c,a
	jp NC,Test_SpriteTest_Tile





	ld b,240
	ld c,20

Test_SpriteTest_Movement:

	ld a,b
	add 0
	ld (SprShow_Y),a
	ld a,40
	ld (SprShow_X),a
	push bc
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	pop bc
	push bc
	ld a,b
	ld (SprShow_X),a
	ld a,40
	ld (SprShow_Y),a
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite
	call Akuyou_ShowSprite

	pop bc
	djnz Test_SpriteTest_Movement

	ret
; ----------------------------------------------
l
; Show Sprite from basic

; ----------------------------------------------
ShowSprite_FromBasic:
cp 3	; Sprite,Xpos,Ypos

	ld a,(IX+0)
	add 24
	ld (SprShow_Y),a

	ld a,(IX+2)
	add 24
	ld (SprShow_X),a

	ld a,(IX+4)
	ld (SprShow_SprNum),a
	jp Akuyou_ShowSprite




Sprites_Clear:
	;specify no of bytes to leave for header
	; 6 bytes per sprite
	;
	cp 1 
	ret nz

	ld a,(IX+0)
	ld (SprGrab_NextSprite),a
	ld a,(IX+1)
	ld (SprGrab_NextSprite+1),a


	ld hl,&0000
	ld(SprGrab_NextIndex),hl
	;ld hl,&00C8
	;ld(SprGrab_NextSprite),hl

	

	ld hl,(SprGrab_BankAddr)
	ld (hl),&00
	inc hl
	ld d,h
	ld e,l


	ld hl,(SprGrab_BankAddr)
	ld bc,&3000
	ldir




ret
; ----------------------------------------------

; Sprite Grabber

; ----------------------------------------------


; each sprite needs 4 bytes, so 200 is enough for 50 sprites

SprGrab_LastLineA  : defw &0000 ; 
SprGrab_LineStartA : defw &0000 ; 
SprGrab_LineCount  : defb &00 ; 
SprGrab_FirstLine  : defb &00 ; 
SprGrab_LastLine   : defb &00 ; 

SprGrab_BankAddr   : defw &4000 ; pattern fill &2F0F
SprGrab_NextIndex  : defw &0000 ; 
SprGrab_NextSprite : defw &00C8 ; need to leave space for indexes


SprGrab_W: defw &06
SprGrab_H: defw &18

SprGrab_X: defw &00
SprGrab_Y: defw &00

SprGrab_TempAddr : defw &00C8 ; 
SprGrab_TempY: defw &00

SprGrab_LineNum: defw &00

DefineSprite_FromBasic2:
; Call &2039,X,Y,W,H,MODE,?
; set W+128 for PSET sprite
; set W+64 for DoubleHeight Intelaced sprite (Must be 24 px wide!)
;MODE=0 YCrop, 128=Fixedy
	cp 6	; check A came in with 4 params
	ret nz

	ld a,(IX+0)

	ld a,0
	ld(LineCountStart_Plus1-1),a
	ld (LineCountStartB_Plus1-1),a
	ld a,(IX+2)
	bit 7,a
	jp z,DefineSprite_FromBasic2DefaultMode
	
	ld a,1				;Force all lines to be nonezero
	ld(LineCountStart_Plus1-1),a
	ld (LineCountStartB_Plus1-1),a ;newly added
DefineSprite_FromBasic2DefaultMode:
	ld a,(IX+2)
	and %00000111
	ld (SpriteAlpha_Plus1-1),a
	ld (SpriteAlphaB_Plus1-1),a

	ld a,(IX+4)
	ld (SprGrab_H),a

	ld a,(IX+6)
	ld (SprGrab_W),a

	ld a,(IX+8)
	ld (SprGrab_Y),a

	ld a,(IX+10)
	ld (SprGrab_X),a
	jp DefineSprite	

DefineSprite_FromBasic:
; Call &2024,X,Y,W,H
; set W+128 for PSET sprite
; set W+64 for DoubleHeight Intelaced sprite (Must be 24 px wide!)
	cp 4	; check A came in with 4 params
	ret nz

	ld a,(IX+0)
	ld (SprGrab_H),a

	ld a,(IX+2)
	ld (SprGrab_W),a

	ld a,(IX+4)

	ld (SprGrab_Y),a
	ld a,(IX+6)
	ld (SprGrab_X),a

	xor a

	ld(LineCountStart_Plus1-1),a
	ld (LineCountStartB_Plus1-1),a

	ld (SpriteAlpha_Plus1-1),a
	ld (SpriteAlphaB_Plus1-1),a
DefineSprite: 		; Create a new sprite

	ld bc,(SprGrab_BankAddr)
	ld hl,(SprGrab_NextIndex)

	add hl,bc

	ld a,(SprGrab_H)
	ld (hl),a
	inc hl

	ld a,0:SpriteAlphaB_Plus1
	ld (DefineSprite_XOffset_Plus1-1),a

	ld a,(SprGrab_W)
	and %11000000
	ld a,(SprGrab_W)
	jp z,DefineSprite_Normalsprite
	;sprite is PSET not transparent
	and %11000000
	add 0:SpriteAlpha_Plus1
	ld (DefineSprite_XOffset_Plus1-1),a
	ld a,(SprGrab_W)
	and %00111111
	ld (SprGrab_W),a
DefineSprite_Normalsprite:
	ld (hl),a
	inc hl

	

	ld a,0 		;Y offset
	ld (hl),a
	inc hl
	ld a,0 :DefineSprite_XOffset_Plus1 ;X offset	; Byte 7 = Turbo ;
	ld (hl),a
	inc hl

	ld de,(SprGrab_NextSprite)
	ld (hl),e
	inc hl
	ld (hl),d

	;ld hl,(SprGrab_NextIndex)
	;inc hl
	;inc hl
	;inc hl
	;inc hl
	;ld (SprGrab_NextIndex),hl
	
;ld a,(IX+0)
;ld a,(IX+1)

	
	ld a,0	:LineCountStart_Plus1
	ld (SprGrab_FirstLine),a
	ld (SprGrab_LastLine),a
	ld hl,(SprGrab_NextSprite) ;reread the sprite address
	ld bc,(SprGrab_BankAddr)
	add hl,bc

	ld (SprGrab_LineStartA),hl
	ld (SprGrab_TempAddr),hl ; save the new start address
	
	ld a,(SprGrab_Y)
	ld (SprGrab_TempY),a

	ld a,1
	ld (SprGrab_LineNum),a

	ld a,(SprGrab_H)
	ld b,a	
	ld c,0

DefineSpriteLoop:	
   push bc		;b is the number of lines to read

	ld a,0 :LineCountStartB_Plus1
	ld (SprGrab_LineCount),a
	ld A,(SprGrab_X)		;xpos
	ld B,A
	ld A,(SprGrab_TempY)
	ld C,A				; updated ypos
	call GetMemPos
	ld de,(SprGrab_TempAddr)	; de=destination
	ld a,(SprGrab_W)
	ld c,a
	ld b,0				; bc=bytecount


	push bc ; c is the width
		;ldir ;load inc and repeat (inc hl; dec bc) - read from hl until bc is zero
	DefineSpriteLoop_NextByte:
		ld a,(hl)
		ld (de),a
		or a
		jp z,DefineSpriteLoop_Continue
		ld a,(SprGrab_LineCount)
		inc a
		ld (SprGrab_LineCount),a
	DefineSpriteLoop_Continue:
		inc hl
		inc de
		dec c
		jr nz,DefineSpriteLoop_NextByte
		; end of line reader







	pop bc
	
	ld hl,(SprGrab_TempAddr) ;reread the sprite address

	add hl,bc 		 ; add the width to the address
	ld (SprGrab_TempAddr),hl ; save the new start address


	ld a,(SprGrab_LineCount)
	or a
	jp z,	DefineSpriteLoop_LineZeroMem

		ld a,(SprGrab_FirstLine)
		or a
		jp nz,DefineSpriteLoop_FirstLineAlreadyFound
		; we have found the first line with data

		ld a,(SprGrab_LineNum)
		;ld a,(SprGrab_TempY)
		ld (SprGrab_FirstLine),a

		;decrease the number of lines in the sprite
		;pop bc
		;ld c,a
		;ld a,b

		;sub c
		;ld b,a
		;ld c,0
		
		;push bc


DefineSpriteLoop_FirstLineAlreadyFound:
		; remember the last line that actually has data
		ld hl,(SprGrab_NextSprite)
		;ld hl,(SprGrab_LastLineA)
		add hl,bc 		 ;
		ld (SprGrab_LastLineA),hl 

		ld a,(SprGrab_LineNum)
		;ld a,(SprGrab_TempY)
		;inc a
		ld (SprGrab_LastLine),a
		jp DefineSpriteLoop_LineZeroMemUpdate
DefineSpriteLoop_LineZeroMem:
		ld a,(SprGrab_FirstLine)
		or a
		jp nz,DefineSpriteLoop_LineZeroMemUpdate

		ld hl,(SprGrab_LineStartA)
		ld (SprGrab_TempAddr),hl

		jp DefineSpriteLoop_LineZeroMemSkip


DefineSpriteLoop_LineZeroMemUpdate:
	ld hl,(SprGrab_NextSprite)
	add hl,bc 		 ;
	ld (SprGrab_NextSprite),hl ;

DefineSpriteLoop_LineZeroMemSkip:
	ld a,(SprGrab_TempY)
	inc a
	ld (SprGrab_TempY),a

	ld a,(SprGrab_LineNum)
	inc a
	ld (SprGrab_LineNum),a

	pop bc	; get back the number of lines we want to read
	dec b
	jp nz,DefineSpriteLoop ; dec b and if not zero, loop back

	;remember last line which was used
	ld hl,(SprGrab_LastLineA) ;
	;ld hl,(SprGrab_TempAddr) ;

	ld (SprGrab_NextSprite),hl

	ld a, (SprGrab_FirstLine)
	ld d,a
	dec d
	;ld (SprGrab_FirstLine),a
	;ld d,a

	ld bc,(SprGrab_BankAddr)
	ld hl,(SprGrab_NextIndex)
	add hl,bc


	;ld a,(SprGrab_FirstLine)
	;ld b,a
	ld a,(SprGrab_LastLine)
	;add 1
	sub d

	cp 1
	jp nz,NotOneLine	
	di 
	ex af,af'
	ld (SprGrab_LineCount),a
	or a
	jp nz,NotOneLineDone
	ex af,af'
	xor a	; we found no pixels!
	ld d,a
	ei
	jp NotOneLine
NotOneLineDone:
	ex af,af'	
	ei
NotOneLine:

	;inc a
	ld (hl),a			;H
	inc hl				;W
	inc hl
	ld (hl),d			
	; sprite pointer is relative so reset and work out its new loc
	ld hl,(SprGrab_NextIndex)
	inc hl
	inc hl
	inc hl
	inc hl
	inc hl
	inc hl
	ld (SprGrab_NextIndex),hl

	ret



;read "BootStrap.asm"

