/*
 * Decompiled with CFR 0.152.
 */
package JCPC.core.device.io;

import JCPC.core.device.Device;
import JCPC.core.device.IOPort;

public class PPI8255
extends Device {
    public static final int PORT_A = 0;
    public static final int PORT_B = 1;
    public static final int PORT_C = 2;
    public static final int PORT_CONTROL = 3;
    protected int portLowMask = 1;
    protected int portLowTest = 1;
    protected int portHighMask = 2;
    protected int portHighTest = 2;
    protected int storedControl = 0;
    protected IOPort[] ports = new IOPort[]{new IOPort(0), new IOPort(0), new IOPort(0), new IOPort(255)};
    boolean plus = true;

    public PPI8255() {
        super("8255 PPI");
    }

    public void setPortMasks(int lowMask, int lowTest, int highMask, int highTest) {
        this.portLowMask = lowMask;
        this.portLowTest = lowTest;
        this.portHighMask = highMask;
        this.portHighTest = highTest;
    }

    @Override
    public int readPort(int port) {
        int selPort;
        int n = selPort = (port & this.portHighMask) == this.portHighTest ? 2 : 0;
        if ((port & this.portLowMask) == this.portLowTest) {
            ++selPort;
        }
        int result = this.ports[selPort].read();
        return result;
    }

    @Override
    public void writePort(int port, int value) {
        int selPort;
        int n = selPort = (port & this.portHighMask) == this.portHighTest ? 2 : 0;
        if ((port & this.portLowMask) == this.portLowTest) {
            ++selPort;
        }
        if (selPort == 3) {
            if ((value & 0x80) == 0) {
                IOPort ioPort = this.ports[2];
                int mask = 1 << (value >> 1 & 7);
                if ((value & 1) == 0) {
                    ioPort.write(ioPort.readOutput() & (mask ^ 0xFF));
                } else {
                    ioPort.write(ioPort.readOutput() | mask);
                }
            } else {
                this.setControl(value);
            }
        } else {
            this.ports[selPort].write(value);
        }
    }

    public void setReadDevice(int port, Device device, int readPort) {
        this.ports[port].setInputDevice(device, readPort);
    }

    public void setWriteDevice(int port, Device device, int writePort) {
        this.ports[port].setOutputDevice(device, writePort);
    }

    protected String readWrite(int port, int mask) {
        return (this.ports[port].getPortMode() & mask) == 0 ? "read" : "write";
    }

    public int readOutput(int port) {
        return this.ports[port].readOutput();
    }

    @Override
    public String toString() {
        return super.toString() + ": Port A = " + this.readWrite(0, 255) + ", Port B = " + this.readWrite(1, 255) + ", Port C (Upper) = " + this.readWrite(2, 240) + ", Port C (Lower) = " + this.readWrite(2, 15);
    }

    public void setOutputValue(int port, int value) {
        this.ports[port].setOutput(value);
    }

    public int getOutputValue(int port) {
        return this.ports[port].getOutput();
    }

    public void setPlus(boolean p) {
        System.out.println("Machine is: CPC " + (p ? "Plus" : "Old"));
        this.plus = p;
    }

    public void setControl(int value) {
        int mode;
        this.storedControl = value | 0x80;
        this.ports[3].setOutput(value);
        this.ports[0].setPortMode((value & 0x10) != 0 ? 0 : 255);
        if (this.plus) {
            this.ports[1].setPortMode(0);
        } else {
            this.ports[1].setPortMode((value & 2) != 0 ? 0 : 255);
        }
        int n = mode = (value & 8) != 0 ? 0 : 240;
        if ((value & 1) == 0) {
            this.ports[2].setPortMode(mode | 0xF);
        } else {
            this.ports[2].setPortMode(mode);
        }
        if (this.plus) {
            return;
        }
        this.ports[0].write(0);
        this.ports[1].write(0);
        this.ports[2].write(0);
    }

    public int getControl() {
        return this.ports[3].getOutput() | 0x80;
    }

    public int portInputA() {
        return this.readPort(0);
    }

    public int portInputB() {
        return this.readPort(1);
    }

    public int portInputC() {
        return this.readPort(2);
    }
}

