/*-------------------------------------------------------*/
/*                                                       */
/*       C part of the VGA undocumented 320x240          */
/*       graphics pack.                                  */
/*                                                       */
/*          [c] copyright by Alpha-Helix 1992.           */
/*              written by Dany Schoch                   */
/*                                                       */
/*-------------------------------------------------------*/



#include <io.h>
#include <sys\stat.h>
#include <fcntl.h>
#include <alloc.h>
#include <dos.h>
#include <mem.h>

#include "xmode.def"


#define selectplane(x)		outport(SC_INDEX, (x << 8) + MAP_MASK)
#define selectmask(x)		outport(GC_INDEX, (x << 8) + BIT_MASK)


// Graphic window.

int   windowx0, windowy0;       	// Upper left corber.
int   windowx1, windowy1;               // Lower right corner.


static char far *scrptr;


/*------------------------------------------------------
Function: defstarfield

Description: Defines a STARFIELD, but doesn't animate it
	     yet. WARNING: (x, y) coordinates in
	     '*star' will get destroyed if used.
------------------------------------------------------*/

void defstarfield(int n, struct starstrc *star)
{
   int   i;

   _sfield.n = n;
   _sfield.star = star;
   _sfield.go = FALSE;
   for (i = 0; i < n; i++) {
      star[i].x = star[i].y*BYTESPERLINE + star[i].x/4;
      star[i].speed *= BYTESPERLINE;
   }
   _sfield.active = TRUE;

}


void killstarfield(void)
{

   _sfield.active = FALSE;

}



/*------------------------------------------------------
Function: defsprite

Description:
   Prepares a sprite to be used by the low level sprite routines.
   On successful completion 'defsprite' returns a sprite HANDLE.
   Don't lose this number or you will lose access to the sprite
   (and memory will be lost!).
   If no free entry could be found, 'defsprite' returns -1.

   args: *sprite -> pointer to sprite structure
	 align   -> 4: only x coords as a multiple of 4 are supported.
		    2: even x coords are supported.
------------------------------------------------------*/

int defsprite(void *sprite, unsigned flags)
{

   int            i, a, n, x, y, p;
   struct sprstrc *spr;
   struct lowspr  *s;
   int            align;
   int            xs, ys, maxn, size;
   int            plane;
   char far       *data;
   char far       *mask;

   spr = (struct sprstrc *)sprite;
   align = 4 - (flags & SPR_ALIGN);
   for (i = 0; i < MAXSPRITES; i++) {
      if (!_sprite[i].active) {		// Look for a free sprite slot.
	 s = &_sprite[i];
	 xs = spr->xs; ys = spr->ys; maxn = spr->maxn;
	 s->xs = xs; s->ys = ys;
	 s->maxn = maxn*2;
	 if (flags & SPR_DOUBLE) s->nadd = 1; else s->nadd = 2;
	 xs = (xs+3+align) & 0xfffc;
	 size = (xs/4) * ys;
	 s->xsalign = xs;
	 s->picsize = size;
	 s->seqsize = size*maxn*(align/2);
	 s->fullsize = size*maxn*(align/2 + 1);

// Copy graphic data to offscreen memory now and create mask image.

	 selectmask(0xff);
	 if ((mask = s->mask = (char far *)malloc(s->fullsize)) == NULL)
	    return -1;
	 s->data = scrptr;

	 for (a = 0; a <= align; a+=2) {
	    data = spr->data;
	    for (n = 0; n < maxn; n++) {
	       for (y = 0; y < ys; y++) {
		  for (x = 0; x < xs; x+=4) {
		     plane = 0;
		     for (p = 0; p < 4; p++) {
			selectplane(1 << p);
			if ((x+p < spr->xs+a) && (x+p >= a)) {
			   if ((*scrptr = data[x+p-a]) != 0) {
			      plane |= (1 << p);
			   }
			}
		     }
		     if (FP_OFF(++scrptr) == 0) {  // Out of offscreen memory ?
			free(mask);
			return -1;
		     }
		     *mask = plane;
		     mask++;
		  }
		  data += spr->xs;
	       }
	    }
	 }

	 s->active = TRUE;
	 return i;
      }
   }

   return -1;

}


void killsprite(int sprite)
{
   char far *scr1;
   char far *scr2;
   int  i;


   if (_sprite[sprite].active) {
      _sprite[sprite].active = FALSE;
      free(_sprite[sprite].mask);
      selectplane(0x0f);
      selectmask(0);
      scrptr -= _sprite[sprite].fullsize;
      for (scr1 = (scr2 = _sprite[sprite].data) + _sprite[sprite].fullsize;
	   scr1 < MK_FP(base, 0xffff); scr1++, scr2++) {
	 *scr2 = *scr1;
      }
      selectmask(0x0f);
      for (i = 0; i < MAXSPRITES; i++) {
	 if (_sprite[i].active)
	    if (_sprite[i].data > _sprite[sprite].data)
	       _sprite[i].data -= _sprite[sprite].fullsize;
      }

   }

}


void killallsprites(void)
{
   int   i;


   for (i = 0; i < MAXSPRITES; i++) {
      if (_sprite[i].active) {
	 free(_sprite[i].mask);
	 _sprite[i].active = FALSE;
      }
   }

   scrptr = MK_FP(base, OFFSCREEN);

}


void setpage(int p)
{
   page = p * PAGESIZE;
}


void initxmode(void)
{
   int   i;

   setxmode();
   setstandardpalette();
   windowx0 = XMIN; windowy0 = YMIN;
   windowx1 = XMAX; windowy1 = YMAX;
   for (i = 0; i < MAXSPRITES; i++) {
      _sprite[i].active = FALSE;
   }
   scrptr = MK_FP(base, OFFSCREEN);
   killstarfield();
   killallobjects();
}

void shutxmode(void)
{

   killallobjects();
   killallsprites();
   killstarfield();
   screenmode(2);

}

// #pragma startup initxmode
// #pragma exit shutxmode


// VGA color and palette functions.

static char standardpal[PALETTESIZE] = {
   0x00,0x00,0x00,0x00,0x00,0x2A,0x00,0x2A,0x00,0x00,0x2A,0x2A,0x2A,0x00,0x00,0x2A,0x00,0x2A,0x2A,0x15,
   0x00,0x2A,0x2A,0x2A,0x15,0x15,0x15,0x15,0x15,0x3F,0x15,0x3F,0x15,0x15,0x3F,0x3F,0x3F,0x15,0x15,0x3F,
   0x15,0x3F,0x3F,0x3F,0x15,0x3F,0x3F,0x3F,0x3B,0x3B,0x3B,0x37,0x37,0x37,0x34,0x34,0x34,0x30,0x30,0x30,
   0x2D,0x2D,0x2D,0x2A,0x2A,0x2A,0x26,0x26,0x26,0x23,0x23,0x23,0x1F,0x1F,0x1F,0x1C,0x1C,0x1C,0x19,0x19,
   0x19,0x15,0x15,0x15,0x12,0x12,0x12,0x0E,0x0E,0x0E,0x0B,0x0B,0x0B,0x08,0x08,0x08,0x3F,0x00,0x00,0x3B,
   0x00,0x00,0x38,0x00,0x00,0x35,0x00,0x00,0x32,0x00,0x00,0x2F,0x00,0x00,0x2C,0x00,0x00,0x29,0x00,0x00,
   0x26,0x00,0x00,0x22,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x19,0x00,0x00,0x16,0x00,0x00,0x13,0x00,
   0x00,0x10,0x00,0x00,0x3F,0x36,0x36,0x3F,0x2E,0x2E,0x3F,0x27,0x27,0x3F,0x1F,0x1F,0x3F,0x17,0x17,0x3F,
   0x10,0x10,0x3F,0x08,0x08,0x3F,0x00,0x00,0x3F,0x2A,0x17,0x3F,0x26,0x10,0x3F,0x22,0x08,0x3F,0x1E,0x00,
   0x39,0x1B,0x00,0x33,0x18,0x00,0x2D,0x15,0x00,0x27,0x13,0x00,0x3F,0x3F,0x36,0x3F,0x3F,0x2E,0x3F,0x3F,
   0x27,0x3F,0x3F,0x1F,0x3F,0x3E,0x17,0x3F,0x3D,0x10,0x3F,0x3D,0x08,0x3F,0x3D,0x00,0x39,0x36,0x00,0x33,
   0x31,0x00,0x2D,0x2B,0x00,0x27,0x27,0x00,0x21,0x21,0x00,0x1C,0x1B,0x00,0x16,0x15,0x00,0x10,0x10,0x00,
   0x34,0x3F,0x17,0x31,0x3F,0x10,0x2D,0x3F,0x08,0x28,0x3F,0x00,0x24,0x39,0x00,0x20,0x33,0x00,0x1D,0x2D,
   0x00,0x18,0x27,0x00,0x36,0x3F,0x36,0x2F,0x3F,0x2E,0x27,0x3F,0x27,0x20,0x3F,0x1F,0x18,0x3F,0x17,0x10,
   0x3F,0x10,0x08,0x3F,0x08,0x00,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3B,0x00,0x00,0x38,0x00,0x00,0x35,0x00,
   0x01,0x32,0x00,0x01,0x2F,0x00,0x01,0x2C,0x00,0x01,0x29,0x00,0x01,0x26,0x00,0x01,0x22,0x00,0x01,0x1F,
   0x00,0x01,0x1C,0x00,0x01,0x19,0x00,0x01,0x16,0x00,0x01,0x13,0x00,0x01,0x10,0x00,0x36,0x3F,0x3F,0x2E,
   0x3F,0x3F,0x27,0x3F,0x3F,0x1F,0x3F,0x3E,0x17,0x3F,0x3F,0x10,0x3F,0x3F,0x08,0x3F,0x3F,0x00,0x3F,0x3F,
   0x00,0x39,0x39,0x00,0x33,0x33,0x00,0x2D,0x2D,0x00,0x27,0x27,0x00,0x21,0x21,0x00,0x1C,0x1C,0x00,0x16,
   0x16,0x00,0x10,0x10,0x17,0x2F,0x3F,0x10,0x2C,0x3F,0x08,0x2A,0x3F,0x00,0x27,0x3F,0x00,0x23,0x39,0x00,
   0x1F,0x33,0x00,0x1B,0x2D,0x00,0x17,0x27,0x36,0x36,0x3F,0x2E,0x2F,0x3F,0x27,0x27,0x3F,0x1F,0x20,0x3F,
   0x17,0x18,0x3F,0x10,0x10,0x3F,0x08,0x09,0x3F,0x00,0x01,0x3F,0x00,0x00,0x3F,0x00,0x00,0x3B,0x00,0x00,
   0x38,0x00,0x00,0x35,0x00,0x00,0x32,0x00,0x00,0x2F,0x00,0x00,0x2C,0x00,0x00,0x29,0x00,0x00,0x26,0x00,
   0x00,0x22,0x00,0x00,0x1F,0x00,0x00,0x1C,0x00,0x00,0x19,0x00,0x00,0x16,0x00,0x00,0x13,0x00,0x00,0x10,
   0x3C,0x36,0x3F,0x39,0x2E,0x3F,0x36,0x27,0x3F,0x34,0x1F,0x3F,0x32,0x17,0x3F,0x2F,0x10,0x3F,0x2D,0x08,
   0x3F,0x2A,0x00,0x3F,0x26,0x00,0x39,0x20,0x00,0x33,0x1D,0x00,0x2D,0x18,0x00,0x27,0x14,0x00,0x21,0x11,
   0x00,0x1C,0x0D,0x00,0x16,0x0A,0x00,0x10,0x3F,0x36,0x3F,0x3F,0x2E,0x3F,0x3F,0x27,0x3F,0x3F,0x1F,0x3F,
   0x3F,0x17,0x3F,0x3F,0x10,0x3F,0x3F,0x08,0x3F,0x3F,0x00,0x3F,0x38,0x00,0x39,0x32,0x00,0x33,0x2D,0x00,
   0x2D,0x27,0x00,0x27,0x21,0x00,0x21,0x1B,0x00,0x1C,0x16,0x00,0x16,0x10,0x00,0x10,0x3F,0x3A,0x37,0x3F,
   0x38,0x34,0x3F,0x36,0x31,0x3F,0x35,0x2F,0x3F,0x33,0x2C,0x3F,0x31,0x29,0x3F,0x2F,0x27,0x3F,0x2E,0x24,
   0x3F,0x2C,0x20,0x3F,0x29,0x1C,0x3F,0x27,0x18,0x3C,0x25,0x17,0x3A,0x23,0x16,0x37,0x22,0x15,0x34,0x20,
   0x14,0x32,0x1F,0x13,0x2F,0x1E,0x12,0x2D,0x1C,0x11,0x2A,0x1A,0x10,0x28,0x19,0x0F,0x27,0x18,0x0E,0x24,
   0x17,0x0D,0x22,0x16,0x0C,0x20,0x14,0x0B,0x1D,0x13,0x0A,0x1B,0x12,0x09,0x17,0x10,0x08,0x15,0x0F,0x07,
   0x12,0x0E,0x06,0x10,0x0C,0x06,0x0E,0x0B,0x05,0x0A,0x08,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x31,0x0A,0x0A,0x31,
   0x13,0x0A,0x31,0x1D,0x0A,0x31,0x27,0x0A,0x31,0x31,0x0A,0x27,0x31,0x0A,0x1D,0x31,0x0A,0x13,0x31,0x0A,
   0x0A,0x31,0x0C,0x0A,0x31,0x17,0x0A,0x31,0x22,0x0A,0x31,0x2D,0x0A,0x2A,0x31,0x0A,0x1F,0x31,0x0A,0x14,
   0x31,0x0B,0x0A,0x31,0x16,0x0A,0x31,0x21,0x0A,0x31,0x2C,0x0A,0x31,0x31,0x0A,0x2B,0x31,0x0A,0x20,0x31,
   0x0A,0x15,0x31,0x0A,0x0A,0x3F,0x3F,0x3F
};



void setpalette(char *ptr, int ncolors)
{
   struct REGPACK regs;

   regs.r_ax = 0x1012;
   regs.r_bx = 0;
   regs.r_cx = ncolors;
   regs.r_dx = (unsigned) ptr;
   regs.r_es = FP_SEG(ptr);
   intr(0x10, &regs);

}


void setcolor(int c, int r, int g, int b)
{
   outportb(0x3c8, c);
   outportb(0x3c9, r);
   outportb(0x3c9, g);
   outportb(0x3c9, b);
}

void setstandardpalette(void)
{
   memcpy(palette, standardpal, PALETTESIZE);
   setpalette(palette, PALETTESIZE/3);
}

void setvanillapalette(int c)
{
   int  i;

   for (i = 0; i < 256; i++)
      setcolor(i, c, c, c);

}


int cyclepalette(int c1, int c2, int pos)
{
   int   i;
   int   n;

   if ((n = --pos + c1) < c1) pos = c2 - c1;
   for (i = c2; i >= c1; i--) {
      if (n < c1) n = c2;
      setcolor(i, palette[n*3], palette[n*3+1], palette[n*3+2]);
      n--;
   }

   return pos;
}


void glowto(int r0, int g0, int b0)
{
   int  i, j;
   int  r, g, b;

   for (i = 0; i < 63; i+=3) {
      for (j = 0; j < 256; j++) {
	 r = (r0*i) / 63;
	 g = (g0*i) / 63;
	 b = (b0*i) / 63;
	 setcolor(j, r, g, b);
      }
      retrace();
   }
}


void setattrib(int m)
{
   struct REGPACK regs;

   regs.r_ax = 0x1013;
   regs.r_bx = (m << 8);
   intr(0x10, &regs);

}


void clearscreen(void)
{

   selectplane(0x0f);
   selectmask(0xff);
   _fmemset(MK_FP(base, 0), backgrndcolor, PAGESIZE * 2);

}

void clearregion(int y, int n)
{

   selectplane(0x0f);
   selectmask(0xff);
   _fmemset(MK_FP(base, y * BYTESPERLINE), backgrndcolor, n * BYTESPERLINE);
   _fmemset(MK_FP(base, PAGESIZE + y * BYTESPERLINE), backgrndcolor, n * BYTESPERLINE);

}


void showpcx256(void *pic, int line)
{
   int      height;
   char     data, count;
   unsigned i, size;
   char     *pos;
   char     far *scrptr;
   int      plane;


   height = ((int *)pic)[5] + 1;	// Get picture height.
   pos = ((char *)pic)+128;		// Skip Header.

   scrptr = MK_FP(base, page + line*BYTESPERLINE);
   plane = 1;
// Decode picture.
   while (FP_OFF(scrptr) < page + (height+line)*BYTESPERLINE) {
      count = *pos; pos++;
      if ((count & 0xc0) == 0xc0) {
	 count = count & 0x3f;
	 data = *pos; pos++;
      } else {
	 data = count; count = 1;
      }

      for (i = 0; i < count; i++) {
	 selectplane(plane);
	 *scrptr = data;
	 if ((plane <<= 1) > 8) {
	    plane = 1;
	    scrptr++;
	 }
      }
   }
// Load palette.
   pos++;
   for (i = 0; i < PALETTESIZE; i++, pos++) {
      palette[i] = (unsigned char)(*pos) >> 2;
   }


}


