
// epimgconv: Enterprise 128 and TVC image converter utility
// Copyright (C) 2008-2016 Istvan Varga <istvanv@users.sourceforge.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// The Enterprise 128 program files generated by this utility are not covered
// by the GNU General Public License, and can be used, modified, and
// distributed without any restrictions.

#ifndef EPIMGCONV_IMG_CFG_HPP
#define EPIMGCONV_IMG_CFG_HPP

#include "epimgconv.hpp"
#include "cfg_db.hpp"

namespace Ep128ImgConv {

  class ImageConvConfig : public Ep128Emu::ConfigurationDB {
   public:
    int     outputFormat;       // 0: EP program, 1: IVIEW uncompressed,
                                // 2-5: IVIEW compressed, 6: Agsys CRF,
                                // 7: ZozoTools VL/VS, 8: PaintBox, 9: Zaxial,
                                // 10: raw image data, 11: TVC KEP uncompressed,
                                // 12: TVC KEP RLE, 13-16: TVC KEP+ epcompress
    int     compressionLevel;   // 1 to 9
    int     conversionType;     // 0: 2 colors, 1: 4 colors, 2..4: 16 colors,
                                // 5: 256 colors, 6: attribute, 7-9: TVC 2/4/16;
                                // +10: interlace
    int     width;              // in characters
    int     height;             // lines per field
    int     borderColor;
    int     paletteResolution;  // in lines; 0: fixed palette
    int     conversionQuality;  // 1 to 9
    double  colorErrorScale;    // 0.0 to 1.0
    int     ditherType;         // 0: none, 1: FS, 2: Stucki, 3: Jarvis,
                                // 4: ordered (Bayer), 5: ordered (randomized)
    double  ditherDiffusion;    // 0.0 to 1.0
    int     scaleMode;          // 0: no clipping, 1: no empty areas
    double  scaleX;
    double  scaleY;
    double  offsetX;
    double  offsetY;
    double  yMin;
    double  yMax;
    double  colorSaturationMult;
    double  gammaCorrection;
    int     fixBias;            // FIXBIAS value (0 to 31), or -1 to optimize
    int     paletteColors[8];   // palette colors (0 to 255), or -1 to optimize
    bool    noInterpolation;    // disable interpolation if true
    bool    noCompress;         // no automatic compression of large programs
    bool    configChangeFlag;
   private:
    static void configChangeCallbackBoolean(void *userData_,
                                            const std::string& name_,
                                            bool value_);
    static void configChangeCallbackInteger(void *userData_,
                                            const std::string& name_,
                                            int value_);
    static void configChangeCallbackFloat(void *userData_,
                                          const std::string& name_,
                                          double value_);
   public:
    ImageConvConfig();
    virtual ~ImageConvConfig();
    void resetDefaultSettings();
    inline bool isImageConfigurationChanged() const
    {
      return configChangeFlag;
    }
    inline void clearConfigurationChangeFlag()
    {
      configChangeFlag = false;
    }
    static const char *getOutputFormatName(int outFmt);
    static const char *getVideoModeName(int mode);
    static const char *getDitherName(int d);
    // convert to/from -outfmt parameter of command line epimgconv
    int getOutputFormat() const;
    void setOutputFormat(int outFmt);
  };

}       // namespace Ep128ImgConv

#endif  // EPIMGCONV_IMG_CFG_HPP

