
// epimgconv: Enterprise 128 image converter utility
// Copyright (C) 2008-2016 Istvan Varga <istvanv@users.sourceforge.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// The Enterprise 128 program files generated by this utility are not covered
// by the GNU General Public License, and can be used, modified, and
// distributed without any restrictions.

#ifndef EPIMGCONV_IMG_DISP_HPP
#define EPIMGCONV_IMG_DISP_HPP

#include "epimgconv.hpp"
#include "display.hpp"
#include "gldisp.hpp"
#include "memory.hpp"
#include "nick.hpp"
#include "epimgconv_fl.hpp"

namespace Ep128ImgConv {
  class ImageData;
}

class Ep128ImgConvGUI_Nick : public Ep128::Nick {
 protected:
  Ep128Emu::VideoDisplay& display;
  uint8_t *videoRAMPtr;
  // --------
  /*!
   * drawLine() is called after rendering each line.
   * 'buf' defines a line of 768 pixels, as 48 groups of 16 pixels each,
   * in the following format: the first byte defines the number of
   * additional bytes that encode the 16 pixels to be displayed. The data
   * length also determines the pixel format, and can have the following
   * values:
   *   0x01: one 8-bit color index (pixel width = 16)
   *   0x02: two 8-bit color indices (pixel width = 8)
   *   0x03: two 8-bit color indices for background (bit value = 0) and
   *         foreground (bit value = 1) color, followed by a 8-bit bitmap
   *         (msb first, pixel width = 2)
   *   0x04: four 8-bit color indices (pixel width = 4)
   *   0x06: similar to 0x03, but there are two sets of colors/bitmap
   *         (c0a, c1a, bitmap_a, c0b, c1b, bitmap_b) and the pixel width
   *         is 1
   *   0x08: eight 8-bit color indices (pixel width = 2)
   * The buffer is aligned to 4 bytes, and contains 'nBytes' (in the range
   * of 96 to 432) bytes of data.
   */
  virtual void drawLine(const uint8_t *buf, size_t nBytes);
  /*!
   * Called at the beginning (newState = true) and end (newState = false)
   * of VSYNC. 'currentSlot_' is the position within the current line
   * (0 to 56).
   */
  virtual void vsyncStateChange(bool newState, unsigned int currentSlot_);
  void createLPT(int width, int height, unsigned char mode, bool isInterlaced,
                 unsigned char borderColor_, unsigned char fixBias_,
                 uint16_t *lineLPBAddrTable = (uint16_t *) 0);
 public:
  Ep128ImgConvGUI_Nick(Ep128Emu::VideoDisplay& display_, Ep128::Memory& m_);
  virtual ~Ep128ImgConvGUI_Nick();
  void reset();
  void loadImage(const Ep128ImgConv::ImageData& imgData, bool isTVC = false);
};

class Ep128ImgConvGUI_Display : public Ep128Emu::OpenGLDisplay {
 private:
  Ep128ImgConvGUI&  gui;
 public:
  Ep128ImgConvGUI_Display(Ep128ImgConvGUI& gui_,
                          int xx = 0, int yy = 0, int ww = 768, int hh = 576,
                          const char *lbl = (char *) 0,
                          bool isDoubleBuffered = false);
  virtual ~Ep128ImgConvGUI_Display();
  // Read and process messages sent by the child thread. Returns true if
  // redraw() needs to be called to update the display.
  virtual bool checkEvents();
 protected:
  virtual void draw();
};

#endif  // EPIMGCONV_IMG_DISP_HPP

