
// epimgconv: Enterprise 128 image converter utility
// Copyright (C) 2008-2016 Istvan Varga <istvanv@users.sourceforge.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// The Enterprise 128 program files generated by this utility are not covered
// by the GNU General Public License, and can be used, modified, and
// distributed without any restrictions.

#ifndef EPIMGCONV_IMGWRITE_HPP
#define EPIMGCONV_IMGWRITE_HPP

#include "epimgconv.hpp"

namespace Ep128ImgConv {

  bool writeEPImageAsProgram(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData,
      bool noCompress = false,
      void (*progressMessageCallback)(void *userData, const char *msg) =
          (void (*)(void *, const char *)) 0,
      bool (*progressPercentageCallback)(void *userData, int n) =
          (bool (*)(void *, int)) 0,
      void *progressCallbackUserData = (void *) 0);

  bool writeEPImageAsIViewFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData,
      int outputFormat = 1,
      void (*progressMessageCallback)(void *userData, const char *msg) =
          (void (*)(void *, const char *)) 0,
      bool (*progressPercentageCallback)(void *userData, int n) =
          (bool (*)(void *, int)) 0,
      void *progressCallbackUserData = (void *) 0);

  bool writeEPImageAsCRFFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData);

  bool writeEPImageAsVLoadFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData);

  bool writeEPImageAsPaintBoxFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData);

  bool writeEPImageAsZaxialFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData);

  bool writeEPImageAsRawFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData);

  bool writeTVCImageAsKEPFile(
      std::FILE *f, const Ep128ImgConv::ImageData& imgData,
      int outputFormat = 50,
      void (*progressMessageCallback)(void *userData, const char *msg) =
          (void (*)(void *, const char *)) 0,
      bool (*progressPercentageCallback)(void *userData, int n) =
          (bool (*)(void *, int)) 0,
      void *progressCallbackUserData = (void *) 0);

  bool writeConvertedImageFile(
      const char *fileName, const ImageData& imgData,
      int outputFormat = 0, bool noCompress = false,
      void (*progressMessageCallback)(void *userData, const char *msg) =
          (void (*)(void *, const char *)) 0,
      bool (*progressPercentageCallback)(void *userData, int n) =
          (bool (*)(void *, int)) 0,
      void *progressCallbackUserData = (void *) 0);

}       // namespace Ep128ImgConv

#endif  // EPIMGCONV_IMGWRITE_HPP

