TITLE FLower

    
    .Model Large
    .Stack 300h
    .386P
    jumps
    locals


Include     goldplay.inc

    
    .DATA

ModName     db  'flower.mod',0  ; Aerial Zic

pcxfile1    db  'flower.z1',0   ; mapping
pcxfile2    db  'flower.z2',0   ; ufo back ground
pcxfile3    db  'flower.z3',0   ; ship back ground
pcxsegadr   dw  ?
pcxhandle   dw  ?

palette     db  768 dup (63)

msg     db  13,10,'-= FLOWER =-',13,13,10,10,'$'

msg1        db  '  F.L.O.W.E.R',10
            db  ' CODE: TRANTOR',10
            db  ' GFX :  ANUBIS',10
            db  ' ZIC :  AERIAL',10
            db  '---------------',10
            db  '# THIS IS THE #',10
            db  '#FIRST  SHITTY#',10
            db  '#  ZEN INTRO  #',10
            db  '---------------',0
                 
msg2        db  'SPECIAL BONJOUR',10
            db  '---------------',10
            db  '  STACK FRIGO',10
            db  '  GEEK ANUBIS',10
            db  ' TONIO  THORIN',10
            db  'BALOUB  ARMORIC',10
            db  ' NOMADS CALS''N ',10
            db  'DRAKY JPS PIXEL',10
            db  'CREATEUR EVIL-M',0

msg3        db  'B$ GRENA  NECRO',10
            db  '  BRAINWASHER',10
            db  ' VINCE WILLIAM',10
            db  ' PATRICK BRUNO',10
            db  '  ET TOUS LES',10
            db  ' AUTRES DONT JE',10
            db  '  N''AI PAS LE',10
            db  '     PSEUDO.',0
           

msg4        db  10,10,10
            db  ' FLOWER  INTRO',10 
            db  ' % 1996 BY ZEN',10
            db  ' THAT''S ALL...',0
        
msg_bye db  13,10,13,10
        db  'CodeTrantor',13,10
        db  'MusicAerial',13,10
        db  'GfxAnubis / Overflow',13,10,'$'
        

include phong.dw

include fire.pal
include fire.rnd


tcoords dw  512+32 dup (0)
tnorms  dw  512+32 dup (0)
zcyl    dw  16 dup (0)
ofst    dw  16 dup (0)

tri     dw  0,-301,0,  0,301,304,     304,301,-303,  185,132, 73,199, 300,199
        dw  0,-301,0,  304,301,-303,  -304,301,-303, 184,130, 50,199, 50,60
        dw  0,-301,0,  -304,301,-303, 0,301,304,     186,130, 319,62, 319,198
        dw  0,301,304, -304,301,-303, 304,301,-303,  184,126, 75,60, 300,60

ufo     dw  16, 0,0,150, 0,400,0,     283,283,0,   70,170,75
        dw  17, 0,0,150, 283,283,0,   400,0,0,     170,70,75
        dw  18, 0,0,150, 400,0,0,     283,-283,0,  170,-70,75
        dw  19, 0,0,150, 283,-283,0,  0,-400,0,    70,-170,75
        dw  20, 0,0,150, 0,-400,0,    -283,-283,0, -70,-170,75
        dw  21, 0,0,150, -283,-283,0, -400,0,0,    -170,-70,75
        dw  22, 0,0,150, -400,0,0,    -283,283,0,  -170,70,75
        dw  23, 0,0,150, -283,283,0,  0,400,0,     -70,170,75

        dw  25, 0,0,-150, 283,283,0,   0,400,0,     70,170,-75
        dw  26, 0,0,-150, 400,0,0,     283,283,0,   170,70,-75
        dw  27, 0,0,-150, 283,-283,0,  400,0,0,     170,-70,-75
        dw  28, 0,0,-150, 0,-400,0,    283,-283,0,  70,-170,-75
        dw  29, 0,0,-150, -283,-283,0, 0,-400,0,    -70,-170,-75
        dw  30, 0,0,-150, -400,0,0,    -283,-283,0, -170,-70,-75
        dw  31, 0,0,-150, -283,283,0,  -400,0,0,    -170,70,-75
        dw  32, 0,0,-150, 0,400,0,     -283,283,0,  -70,170,-75

glenz   dw  02, 0,0,0, 230,230,230,   230,230,-230
        dw  08, 0,0,0, 230,230,-230,  -230,230,-230
        dw  04, 0,0,0, -230,230,-230, -230,230,230
        dw  06, 0,0,0, -230,230,230,  230,230,230

        dw  03, 0,0,0, 230,230,230,   230,-230,230
        dw  07, 0,0,0, 230,-230,230,  230,-230,-230
        dw  02, 0,0,0, 230,-230,-230, 230,230,-230
        dw  08, 0,0,0, 230,230,-230,  230,230,230

        dw  06, 0,0,0, 230,230,-230,   230,-230,-230
        dw  04, 0,0,0, 230,-230,-230,  -230,-230,-230
        dw  07, 0,0,0, -230,-230,-230, -230,230,-230
        dw  09, 0,0,0, -230,230,-230,  230,230,-230

        dw  02, 0,0,0, 230,-230,230,   230,-230,-230
        dw  08, 0,0,0, 230,-230,-230,  -230,-230,-230
        dw  04, 0,0,0, -230,-230,-230, -230,-230,230
        dw  06, 0,0,0, -230,-230,230,  230,-230,230

        dw  03, 0,0,0, -230,230,230,   -230,-230,230
        dw  07, 0,0,0, -230,-230,230,  -230,-230,-230
        dw  02, 0,0,0, -230,-230,-230, -230,230,-230
        dw  08, 0,0,0, -230,230,-230,  -230,230,230

        dw  06, 0,0,0, 230,230,230,   230,-230,230
        dw  04, 0,0,0, 230,-230,230,  -230,-230,230
        dw  07, 0,0,0, -230,-230,230, -230,230,230
        dw  03, 0,0,0, -230,230,230,  230,230,230

ship    dw  230,100,60,   -230,300,0, 230,100,-60
        dw  230,100,-60,  -230,300,0, -230,100,-60
        dw  -230,100,-60, -230,300,0, -230,100,60
        dw  -230,100,60,  -230,300,0, 230,100,60
            
        dw  230,100,60,   530,0,0, 230,-100,60
        dw  230,-100,60,  530,0,0, 230,-100,-60
        dw  230,-100,-60, 530,0,0, 230,100,-60
        dw  230,100,-60,  530,0,0, 230,100,60

        dw  230,100,-60,   0,0,-99, 230,-100,-60
        dw  230,-100,-60,  0,0,-99, -230,-100,-60
        dw  -230,-100,-60, 0,0,-99, -230,100,-60
        dw  -230,100,-60,  0,0,-99, 230,100,-60

        dw  -230,-300,0, 230,-100,60,   230,-100,-60
        dw  -230,-300,0, 230,-100,-60,  -230,-100,-60
        dw  -230,-300,0, -230,-100,-60, -230,-100,60
        dw  -230,-300,0, -230,-100,60,  230,-100,60

        dw  -230,0,0, -230,100,60,   -230,-100,60
        dw  -230,0,0, -230,-100,60,  -230,-100,-60
        dw  -230,0,0, -230,-100,-60, -230,100,-60
        dw  -230,0,0, -230,100,-60,  -230,100,60

        dw  0,0,60, 230,100,60,   230,-100,60
        dw  0,0,60, 230,-100,60,  -230,-100,60
        dw  0,0,60, -230,-100,60, -230,100,60
        dw  0,0,60, -230,100,60,  230,100,60

;

    .CODE

bufferseg   dw  ?
imageseg1   dw  ?
imageseg2   dw  ?
bkgroundseg dw  ?

seed        dw  0   ; A little increment variable (ship,envmap,bump)
msgn        db  0   ; Need for writing messages in Bump
xc          dw  ?   ; Bump 2D light source...
yc          dw  ?   ;       

include    memory.inc
include    files.inc
include    pcxunpk.inc
include    stuff.inc
include    3d.inc
include    fillpoly.inc
include    fillpmap.inc
include    filltria.inc
include    filltrit.inc
include    filltrig.inc
include    filltrim.inc


;
;

NiceBump    proc near

    mov     es,cs:bufferseg
    xor     di,di
    mov     cx,16000
    xor     eax,eax
    rep     stosd
    
    mov     es,cs:bkgroundseg
    xor     di,di
    mov     cx,16000
    xor     eax,eax
    rep     stosd

    mov     bx,0
PalLoop:
    push    bx
    mov     dx,03c8h
    mov     ax,bx
    out     dx,al
    inc     dx
    shr     bx,2
    mov     ax,bx
    out     dx,al
    out     dx,al
    out     dx,al
    pop     bx
    inc     bx
    cmp     bx,768
    jb      PalLoop
    
    mov     gs,cs:bkgroundseg ;
    mov     fs,cs:bufferseg  ;
    mov     es,cs:imageseg1  ; Phong picture

    mov     bx,offset msg1
    mov     bp,10
    mov     cx,5
    call    WriteL16

    xor     dx,dx
    mov     dl,127
    mov     dh,127
    mov     cs:seed,0
TSTLOOP:
    xor     bh,bh
    mov     bl,dl       ; dl=cosangle
    shl     bx,1
    mov     ax,cs:cosine[bx]
    sar     ax,7
    add     ax,160
    mov     cs:xc,ax
    xor     bh,bh
    mov     bl,dh       ; dh=cosangle
    shl     bx,1
    mov     ax,cs:sine[bx]
    sar     ax,7
    add     ax,100
    mov     cs:yc,ax

    push    dx
    call    DoBump2D
    call    waitretrace
    push    ds
    push    es
    mov     ds,cs:bufferseg
    mov     ax,0A000h
    mov     es,ax
    xor     si,si
    xor     di,di
    mov     cx,16000
    rep     movsd
    pop     es
    pop     ds
    pop     dx
    
    add     dh,3
    add     dl,5
    inc     cs:seed
    cmp     cs:seed,140
    jne     SkipNewBumpMessage
    inc     cs:msgn
    cmp     cs:msgn,1
    jne     ThirdBumpMessage
    mov     cs:seed,0
    mov     bx,offset msg2
    mov     bp,10
    mov     cx,5
    call    WriteL16
    jmp     SkipNewBumpMessage
ThirdBumpMessage:
    cmp     cs:msgn,3
    jae     FourthBumpMessage
    mov     cs:seed,0
    mov     bx,offset msg3
    mov     bp,10
    mov     cx,10
    call    WriteL16
    jmp     SkipNewBumpMessage
FourthBumpMessage:
    cmp     cs:msgn,4
    je      SkipNewBumpMessage
    mov     cs:seed,0
    mov     bx,offset msg4
    mov     bp,10
    mov     cx,5
    call    WriteL16
SkipNewBumpMessage:
    cmp     cs:msgn,4
    jne     TSTLOOP
    ret
NiceBump    endp


DoBump2D    proc near
    mov     di,321
    mov     cx,1        ; cx=y
    mov     si,cx       ; si=LY=1
    sub     si,cs:yc    ; si=LY=1-yc
YBumpLoop:
    push    cx
    mov     cx,1        ; cx=x
    mov     bp,cx       ; bp=LX=1
    sub     bp,cs:xc    ; bp=LX=1-xc
XBumpLoop:
    push    cx
    xor     dh,dh
    mov     dl,gs:[di+1]
    xor     bh,bh
    mov     bl,gs:[di-1]
    sub     dx,bx       ; dx=nx
    sub     dx,bp       ; dx=nx-lx
    xor     ah,ah
    mov     al,gs:[di+320]
    xor     bh,bh
    mov     bl,gs:[di-320]
    sub     ax,bx       ; ax=ny
    sub     ax,si       ; ax=ny-ly
    add     dx,160      ; dx=x=160+nx-lx
    add     ax,100      ; ax=y=100+ny-ly
    cmp     dx,319
    jb      NotWrongXBump
    xor     al,al
    jmp     PutBumpColor
NotWrongXBump:
    cmp     ax,199
    jb      NotWrongYBump
    xor     al,al
    jmp     PutBumpColor
NotWrongYBump:
    mov     bx,ax
    shl     ax,6
    shl     bx,8
    add     bx,ax
    add     bx,dx
    mov     al,es:[bx]
PutBumpColor:
    mov     fs:[di],al
    
    cmp     cs:seed,3
    jb      DoFireOnBump
    cmp     cs:seed,100
    jb      NoFireOnBump
DoFireOnBump:
    xor     ah,ah
    mov     al,gs:[di-1]
    xor     ch,ch
    mov     cl,gs:[di+1]
    add     ax,cx
    mov     cl,gs:[di+320]
    add     ax,cx
    mov     cl,gs:[di-320]
    add     ax,cx
    shr     ax,2
    cmp     cs:seed,3
    jb      NotZeroBump2
    cmp     al,0
    jng     NotZeroBump
    dec     al
NotZeroBump:
    cmp     al,8
    jng     NotZeroBump2
    sub     al,8
NotZeroBump2:
    mov     gs:[di],al
NoFireOnBump:
    
    inc     bp          ; inc lx
    inc     di
    pop     cx
    inc     cx
    cmp     cx,319
    jb      XBumpLoop
    add     di,2
    inc     si          ; inc ly
    pop     cx
    inc     cx
    cmp     cx,199
    jb      YBumpLoop
    ret
DoBump2D    endp



WriteL16    proc near   ; BX point on string, BP=X, CX=Y
    push    ax
    push    cx
    push    bp
    push    es
    mov     es,cs:imageseg2
WriteLoop:
    mov     al,ds:[bx]
    cmp     al,32
    je      SkipSpace
    cmp     al,0
    je      EndWriteL16
    cmp     al,10
    jne     NotEndLine
    add     cx,21 ;12
    mov     bp,10
    jmp     EndLine
NotEndLine:
    call    WChar16
SkipSpace:
    add     bp,20 ;10
EndLine:
    inc     bx
    jmp     WriteLoop
EndWriteL16:    
    pop     es
    pop     bp
    pop     cx
    pop     ax
    ret
WriteL16    endp



WChar16     proc near   ; AL=Char num, BP=X, CX=Y  from ES to GS
    pusha
    mov     bx,0
    xor     dh,dh
    xor     ah,ah
    mov     dl,al
    sub     dl,32
    cmp     al,47
    jbe     SndLine
    mov     bx,6400
    mov     dl,al
    sub     dl,48
    cmp     al,63
    jbe     SndLine
    mov     bx,12800
    mov     dl,al
    sub     dl,64
    cmp     al,79
    jbe     SndLine
    mov     bx,19200
    mov     dl,al
    sub     dl,80
SndLine:
    mov     ax,dx
    cwd
    mov     si,20 ;10
    imul    si
    add     bx,ax        ; BX = X start offset (depends on AL)

    mov     di,cx
    mov     si,cx
    shl     di,8
    shl     si,6
    add     di,si
    add     di,bp        ; DI = X dest. offset (Y*320+X)
    
    mov     dx,0
VertCLoop:
    mov     si,0
HorCLoop:
    mov     ax,es:[bx+si]
    push    bx
    mov     bx,di
    mov     gs:[bx+si],ax
    pop     bx
    add     si,2
    cmp     si,20 ;10
    jne     HorCLoop
    add     bx,320
    add     di,320
    inc     dx
    cmp     dx,20 ;12
    jne     VertCLoop
;TooHigh:
    popa
    ret
WChar16     endp

;

Transition4 proc near
    call    WhitePal
    mov     bp,255
FireTrLoop:
    cmp     bp,255
    jne     NoFadeOnFire
    call    fadeon
NoFadeOnFire:
    cmp     bp,0
    jne     NoFadeOffFire
    call    fadeOff
NoFadeOffFire:
    call    doflame
    call    waitretrace
    call    DrawFire
    cmp     bp,254
    jne     FireTrLoop
    mov     ax,0A000h
    mov     es,ax
    xor     di,di
    xor     eax,eax
    mov     cx,16000
    rep     stosd
    ret
Transition4 endp


DoFlame     proc near
    mov     gs,cs:bkgroundseg
    xor     di,di
    add     di,160*103
    mov     si,offset random
    mov     cx,160
    mov     bx,cs:seed
FillLoopFire:
    mov     al,ds:[si+bx]
    mov     gs:[di],al
    mov     gs:[di+160],al
    inc     di
    inc     bx
    cmp     bx,4096
    jne     okseedFire
    xor     bx,bx
okseedFire:
    dec     cx
    jnz     FillLoopFire
    mov     cs:seed,bx

    mov     di,0
    mov     cx,16480
FireLoopFire:
    xor     ax,ax
    xor     bx,bx
    mov     al,gs:[di+161]
    mov     bl,gs:[di+159]
    add     ax,bx
    mov     bl,gs:[di+160]
    add     ax,bx
    mov     bl,gs:[di+320]
    add     ax,bx
    shr     ax,2
    cmp     ax,0
    jng     @1Fire
    dec     ax
@1Fire:
    cmp     ax,0
    jng     @2Fire
    dec     ax
@2Fire:
    mov     gs:[di],al
    inc     di
    loop    FireLoopFire
    ret
DoFlame     endp


DrawFire    proc near
    mov     ax,0A000h
    mov     es,ax
    mov     gs,cs:bkgroundseg
    xor     di,di
    xor     si,si
VertLoopFire:
    mov     cx,160
HoriLoop1F:
    mov     al,gs:[si]
    mov     ah,al
    mov     es:[di],ax
    add     di,2
    inc     si
    loop    HoriLoop1F
    mov     cx,160
    sub     si,160
HoriLoop2F:
    mov     al,gs:[si]
    mov     ah,al
    mov     es:[di],ax
    add     di,2
    inc     si
    loop    HoriLoop2F
    cmp     di,64000
    jna     VertLoopFire
    ret
DrawFire    endp


FadeOn      proc near    
    mov     di,offset ds:Palette
    mov     si,offset ds:firep
    xor     bx,bx
    xor     bp,bp
FadeLoop1:
    mov     al,ds:[di+bx]
    cmp     ds:[si+bx],al
    jae     StopFireFade1
    mov     bp,255
    dec     al
    mov     ds:[di+bx],al
StopFireFade1:
    inc     bx
    cmp     bx,768
    jne     FadeLoop1
    xor     cx,cx
    mov     bx,offset ds:Palette
PalLoop2:
    mov     dx,03c8h
    mov     ax,cx
    out     dx,al
    inc     dx
    mov     al,ds:[bx]
    out     dx,al
    mov     al,ds:[bx+1]
    out     dx,al
    mov     al,ds:[bx+2]
    out     dx,al
    add     bx,3
    inc     cx
    cmp     cx,256
    jne     PalLoop2
    ret
FadeOn      endp

    
FadeOff     proc near    
    mov     di,offset ds:Palette
    xor     bx,bx
    mov     bp,254
FadeLoop2:
    mov     al,ds:[di+bx]
    cmp     al,0
    je      StopFireFade2
    xor     bp,bp
    dec     al
    mov     ds:[di+bx],al
StopFireFade2:
    inc     bx
    cmp     bx,768
    jne     FadeLoop2
    xor     cx,cx
    mov     bx,offset ds:Palette
PalLoop3:
    mov     dx,03c8h
    mov     ax,cx
    out     dx,al
    inc     dx
    mov     al,ds:[bx]
    out     dx,al
    mov     al,ds:[bx+1]
    out     dx,al
    mov     al,ds:[bx+2]
    out     dx,al
    add     bx,3
    inc     cx
    cmp     cx,256
    jne     PalLoop3
    ret
FadeOff     endp

;

NicePhong   proc near
    mov     fs,cs:imageseg1
    mov     cs:ycenter,-100
PhongLoop:
    push    ds
    mov     ds,cs:bkgroundseg
    mov     es,cs:bufferseg
    xor     di,di
    xor     si,si
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoPhong
    call    WaitRetrace
    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,2
    inc     cs:ycenter

    cmp     cs:ycenter,280
    jl      PhongLoop
    ret
NicePhong   endp



DoPhong     proc near
    mov     di,0
    mov     si,0
    mov     bx,0
jmpCyl:
    push    bx
    mov     bx,ds:cent[di]
    mov     cx,ds:cent[di+2]
    mov     bp,ds:cent[di+4]
    push    di
    push    si
    call    rotate
    pop     si
    pop     di
    mov     ds:zcyl[si],bp
    pop     bx
    mov     ds:ofst[si],bx
    add     bx,8*16
    add     di,6
    add     si,2
    cmp     si,32
    jb      jmpCyl

    call    BubbleSort

    mov     di,0
    mov     si,0
jmpcalc:                        ; rotation des points et des normales
    mov     bx,ds:tore[di]      ; place les points projets dans TCOORDS
    mov     cx,ds:tore[di+2]    ; et les (X,Y) des normales dans TNORMS
    mov     bp,ds:tore[di+4]
    push    di
    push    si
    call    rotate
    call    transform
    pop     si
    pop     di
    mov     ds:tcoords[si],ax
    mov     ds:tcoords[si+2],bx
    
    mov     bx,ds:norm[di]
    mov     cx,ds:norm[di+2]
    mov     bp,ds:norm[di+4]
    push    di
    push    si
    call    rotate
    pop     si
    pop     di
    add     cx,160
    add     bx,100
    mov     ds:tnorms[si],cx
    mov     ds:tnorms[si+2],bx
    add     si,4
    add     di,6
    cmp     di,1536
    jb      jmpcalc

    mov     di,offset ds:tcoords
    mov     si,offset ds:tnorms
    mov     bx,0
jmpcalc2:
    mov     ax,ds:[di+bx]
    mov     ds:[di+bx+1024],ax
    mov     ax,ds:[di+bx+2]
    mov     ds:[di+bx+1026],ax
    mov     ax,ds:[si+bx]
    mov     ds:[si+bx+1024],ax
    mov     ax,ds:[si+bx+2]
    mov     ds:[si+bx+1026],ax
    add     bx,4
    cmp     bx,32*2-2
    jb      jmpcalc2
    
    mov     si,0
jmpdraw:
    mov     di,cs:ofst[si]
    push    si
    mov     bx,0
jmpface:
    mov     si,ds:face[di+bx]
    mov     ax,ds:tcoords[si]
    mov     cs:xvars[0],ax
    mov     cs:xvars[8],ax
    mov     ax,ds:tcoords[si+2]
    mov     cs:yvars[0],ax
    mov     cs:yvars[8],ax
    mov     ax,ds:tnorms[si]
    mov     cs:xmap[0],ax
    mov     cs:xmap[8],ax
    mov     ax,ds:tnorms[si+2]
    mov     cs:ymap[0],ax
    mov     cs:ymap[8],ax

    mov     si,ds:face[di+bx+2]
    mov     ax,ds:tcoords[si]
    mov     cs:xvars[2],ax
    mov     ax,ds:tcoords[si+2]
    mov     cs:yvars[2],ax
    mov     ax,ds:tnorms[si]
    mov     cs:xmap[2],ax
    mov     ax,ds:tnorms[si+2]
    mov     cs:ymap[2],ax

    mov     si,ds:face[di+bx+4]
    mov     ax,ds:tcoords[si]
    mov     cs:xvars[4],ax
    mov     ax,ds:tcoords[si+2]
    mov     cs:yvars[4],ax
    mov     ax,ds:tnorms[si]
    mov     cs:xmap[4],ax
    mov     ax,ds:tnorms[si+2]
    mov     cs:ymap[4],ax
    
    mov     si,ds:face[di+bx+6]
    mov     ax,ds:tcoords[si]
    mov     cs:xvars[6],ax
    mov     ax,ds:tcoords[si+2]
    mov     cs:yvars[6],ax
    mov     ax,ds:tnorms[si]
    mov     cs:xmap[6],ax
    mov     ax,ds:tnorms[si+2]
    mov     cs:ymap[6],ax

    push    di
    push    bx
    mov     es,cs:bufferseg
    call    fillPolyM
    pop     bx
    pop     di

    add     bx,8
    cmp     bx,8*16
    jb      jmpface
    pop     si
    add     si,2
    cmp     si,16*2
    jb      jmpdraw
    ret
DoPhong     endp


BubbleSort  proc near
    mov     si,0
    mov     bp,1
SortWhileLoop:
    mov     bp,0
    mov     di,0
SortForLoop:
    mov     ax,ds:zcyl[di]
    cmp     ds:zcyl[di+2],ax
    jng     SortNotSwapList
    mov     bp,di
    mov     dx,ds:zcyl[di+2]
    mov     ds:zcyl[di],dx
    mov     ds:zcyl[di+2],ax

    mov     ax,ds:ofst[di]
    mov     dx,ds:ofst[di+2]
    mov     ds:ofst[di],dx
    mov     ds:ofst[di+2],ax
SortNotSwapList:
    add     di,2
    cmp     di,30
    jb      SortForLoop
    cmp     bp,0
    jne     SortWhileLoop
    ret
BubbleSort  endp

;

NiceShip    proc near
    jmp     StartShip
scpt        dw 0
StartShip:
    mov     cs:ycenter,250
    mov     cs:anglex,0
    mov     cs:angley,0
    mov     cs:anglez,0
@@ShipLoop:
    push    ds
    mov     ds,cs:bkgroundseg
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    call    DoShip              ; Draw the ship in the buffer.
    call    WaitRetrace    
    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    dec     cs:ycenter
   
    cmp     cs:ycenter,100
    jg      @@ShipLoop

@@ShipLoop2:
    push    ds
    mov     ds,cs:bkgroundseg
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    call    DoShip              ; Draw the ship in the buffer.
    call    WaitRetrace    
    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds
    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    inc     cs:scpt
    cmp     cs:scpt,250
    jl      @@ShipLoop2

@@ShipLoop3:
    push    ds
    mov     ds,cs:bkgroundseg
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoShip              ; Draw the ship in the buffer.
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    dec     cs:ycenter
   
    cmp     cs:ycenter,-50
    jg      @@ShipLoop3

    ret
NiceShip    endp



DoShip      proc near
    mov     di,0
jmpShip:
    mov     bx,ds:ship[di]
    mov     cx,ds:ship[di+2]
    mov     bp,ds:ship[di+4]
    push    di
    call    rotate
    mov     dx,bp
    add     dx,530
    shr     dx,2
    mov     ax,255
    sub     ax,dx
    mov     cs:colors[0],ax
    call    transform
    mov     cs:xvars[0],ax
    mov     cs:yvars[0],bx
    pop     di
    
    mov     bx,ds:ship[di+6]
    mov     cx,ds:ship[di+8]
    mov     bp,ds:ship[di+10]
    push    di
    call    rotate
    mov     dx,bp
    add     dx,530
    shr     dx,2
    mov     ax,255
    sub     ax,dx
    mov     cs:colors[2],ax
    call    transform
    mov     cs:xvars[2],ax
    mov     cs:yvars[2],bx
    pop     di

    mov     bx,ds:ship[di+12]
    mov     cx,ds:ship[di+14]
    mov     bp,ds:ship[di+16]
    push    di
    call    rotate
    mov     dx,bp
    add     dx,530
    shr     dx,2
    mov     ax,255
    sub     ax,dx
    mov     cs:colors[4],ax
    call    transform
    mov     cs:xvars[4],ax
    mov     cs:yvars[4],bx
    pop     di

    mov     ax,cs:xvars[0]
    mov     cs:xvars[6],ax
    mov     ax,cs:yvars[0]
    mov     cs:yvars[6],ax
    mov     ax,cs:colors[0]
    mov     cs:colors[6],ax

    
    push    di
    mov     es,cs:bufferseg
    call    fillpolyG
    pop     di
    
    add     di,18
    cmp     di,414
    jna     jmpShip

    ret
DoShip      endp

;

Transition3 proc near
    jmp     StartTrans3
Appear      dw  47919,159,31759,15919,15680,47680,31839,47759,79,239,47839
            dw  0,15839,15759,31919,31680
StartTrans3:
    push    ds
    
    mov     ds,cs:imageseg2
    mov     es,cs:bkgroundseg
    mov     si,0
    mov     di,0
    mov     cx,32000
    rep     movsd
    
    mov     ds,cs:bkgroundseg
    mov     es,cs:bkgroundseg
    mov     dx,0
    mov     si,100*320
    mov     di,319+100*320
Vert1loop:
    mov     cx,160
Hori1loop:
    mov     al,ds:[si]
    mov     es:[di],al
    inc     si
    dec     di
    dec     cx
    jnz     Hori1Loop
    add     si,160
    add     di,480
    inc     dx
    cmp     dx,100
    jne     Vert1Loop
    
    mov     ds,cs:bkgroundseg
    mov     es,cs:bkgroundseg
    mov     dx,0
    mov     si,100*320
    mov     di,100*320-320  ;63680
Vert2loop:
    mov     cx,320
Hori2loop:
    mov     al,ds:[si]
    mov     es:[di],al
    inc     si
    inc     di
    dec     cx
    jnz     Hori2Loop
    sub     di,640
    inc     dx
    cmp     dx,100
    jne     Vert2Loop


    mov     ds,cs:bkgroundseg
    mov     ax,0A000h
    mov     es,ax
    
    mov     bx,0
DefragAppear:

    mov     ax,Seg sounddevice
    mov     fs,ax
@@WaitForSoundT3:
    mov     ax,fs:bar4
    cmp     ax,60
    jne     @@WaitForSoundT3

    call    WaitRetrace
    
    mov     di,cs:appear[bx]
    mov     si,di
    mov     bp,0
VertT3Loop:
    mov     cx,20
    rep     movsd
    add     si,240
    add     di,240
    inc     bp
    cmp     bp,50
    jne     VertT3Loop

    add     bx,2
    cmp     bx,32
    jne     DefragAppear
    
    pop     ds
    ret
Transition3 endp

;

Transition2 proc near    
    
    mov     ax,0A000h
    mov     es,ax

    mov     bp,0
    mov     dx,199
@VertLineT:
    call    WaitRetrace
    mov     di,bp
    mov     si,bp
    shl     di,6
    shl     si,8
    add     di,si
    mov     cx,80
    xor     eax,eax
    rep     stosd
    
    mov     di,dx
    mov     si,dx
    shl     di,6
    shl     si,8
    add     di,si
    mov     cx,80
    xor     eax,eax
    rep     stosd

    sub     dx,2
    add     bp,2
    cmp     bp,200
    jne     @VertLineT
    
    ret
Transition2 endp

;

NiceGlenz   proc near
    mov     cs:ycenter,270
@@GLZLoop1:
    push    ds
    mov     ds,cs:imageseg2
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoGlenz             ; Draw the glenz in the buffer.
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    dec     cs:ycenter
   
    cmp     cs:ycenter,100
    jg      @@GLZLoop1

@@GLZLoop2:
    add     ds:glenz[4],2
    add     ds:glenz[24],2
    add     ds:glenz[44],2
    add     ds:glenz[64],2
    add     ds:glenz[82],2
    add     ds:glenz[102],2
    add     ds:glenz[122],2
    add     ds:glenz[142],2
    sub     ds:glenz[166],2
    sub     ds:glenz[186],2
    sub     ds:glenz[206],2
    sub     ds:glenz[226],2
    sub     ds:glenz[244],2
    sub     ds:glenz[264],2
    sub     ds:glenz[284],2
    sub     ds:glenz[304],2
    sub     ds:glenz[322],2
    sub     ds:glenz[342],2
    sub     ds:glenz[362],2
    sub     ds:glenz[382],2
    add     ds:glenz[406],2
    add     ds:glenz[426],2
    add     ds:glenz[446],2
    add     ds:glenz[466],2

    push    ds
    mov     ds,cs:imageseg2
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoGlenz             ; Draw the glenz in the buffer.
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    
    cmp     ds:glenz[4],400
    jl      @@GLZLoop2

@@GLZLoop3:
    push    ds
    mov     ds,cs:imageseg2
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoGlenz             ; Draw the glenz in the buffer.
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    dec     cs:ycenter
   
    cmp     cs:ycenter,-80
    jg      @@GLZLoop3

    ret
NiceGlenz   endp



DoGlenz     proc near
    mov     di,0
jmpglt:
    mov     ax,ds:glenz[di]
    mov     cs:color,al
    
    mov     bx,ds:glenz[di+2]
    mov     cx,ds:glenz[di+4]
    mov     bp,ds:glenz[di+6]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[0],ax
    mov     cs:yvars[0],bx
    pop     di
    
    mov     bx,ds:glenz[di+8]
    mov     cx,ds:glenz[di+10]
    mov     bp,ds:glenz[di+12]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[2],ax
    mov     cs:yvars[2],bx
    pop     di
    
    mov     bx,ds:glenz[di+14]
    mov     cx,ds:glenz[di+16]
    mov     bp,ds:glenz[di+18]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[4],ax
    mov     cs:yvars[4],bx
    pop     di

    mov     ax,cs:xvars[0]
    mov     cs:xvars[6],ax
    mov     ax,cs:yvars[0]
    mov     cs:yvars[6],ax
    
    push    di
    mov     es,cs:bufferseg
    call    fillTriT
    pop     di
    
    add     di,20
    cmp     di,460
    jna     jmpglt

    ret
DoGlenz    endp

;

NiceUFO     proc near
    mov     cs:ycenter,-80
@@UFOLoop:
    push    ds
    mov     ds,cs:imageseg2
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoUFO               ; Draw the ufo in the buffer.
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds
    

    add     cs:anglex,3
    add     cs:angley,2
    add     cs:anglez,1
    inc     cs:ycenter
   
    cmp     cs:ycenter,270
    jl      @@UFOLoop

    ret
NiceUFO     endp



DoUFO       proc near
    mov     di,0
jmpufo:
    mov     ax,ds:ufo[di]
    mov     cs:color,al
    
    mov     bx,ds:ufo[di+2]
    mov     cx,ds:ufo[di+4]
    mov     bp,ds:ufo[di+6]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[0],ax
    mov     cs:yvars[0],bx
    pop     di
    
    mov     bx,ds:ufo[di+8]
    mov     cx,ds:ufo[di+10]
    mov     bp,ds:ufo[di+12]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[2],ax
    mov     cs:yvars[2],bx
    pop     di
    
    mov     bx,ds:ufo[di+14]
    mov     cx,ds:ufo[di+16]
    mov     bp,ds:ufo[di+18]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[4],ax
    mov     cs:yvars[4],bx
    pop     di

    mov     bx,ds:ufo[di+20]
    mov     cx,ds:ufo[di+22]
    mov     bp,ds:ufo[di+24]
    push    di
    call    rotate
    pop     di
    
    xor     ax,ax               ; Define the intensity of color with the X
    mov     al,cs:color         ; coordinate of the normal.
    mov     dx,03C8h
    out     dx,al
    inc     dx
    add     bx,250
    shr     bx,3
    mov     ax,60
    sub     ax,bx
    out     dx,al
    mov     bl,cs:color
    shr     bl,1
    jae     StillGreen
    mov     al,0
StillGreen:
    out     dx,al
    out     dx,al

    mov     ax,cs:xvars[0]
    mov     cs:xvars[6],ax
    mov     ax,cs:yvars[0]
    mov     cs:yvars[6],ax
    
    push    di
    mov     es,cs:bufferseg
    call    fillPTri
    pop     di
    
    add     di,26
    cmp     di,390
    jna     jmpufo

    ret
DoUFO      endp

;

Transition  proc near
    Jmp     StartTransition
KloonT      dw 0,-7,-14,-21,-28,-35,-42,-49
StartTransition:
    mov     ax,Seg sounddevice
    mov     es,ax
@@WaitForSound:
    mov     ax,es:bar1
    cmp     ax,0
    je      @@WaitForSound

    call    Flash

    push    ds
    mov     ds,cs:imageseg2
    mov     ax,0A000h
    mov     es,ax
@@LoopKloon:
    call    waitretrace
    call    WaitRetrace
    call    waitretrace
    call    waitretrace
    
    mov     bx,0
@LoopK2:
    mov     dx,cs:KloonT[bx]
    
    cmp     dx,200
    jg      SkipLineK
    cmp     dx,0
    jl      SkipLineK

    mov     di,dx
    shl     dx,6
    shl     di,8
    add     di,dx
    mov     si,di
    mov     cx,80
    rep     movsd
SkipLineK:

    add     cs:KloonT[bx],8
    add     bx,2
    cmp     bx,16
    jne     @LoopK2

    mov     bx,14
    cmp     cs:KloonT[bx],200
    jl      @@LoopKloon
    pop     ds
    ret
Transition  endp

;

NiceTri     proc near
    mov     fs,cs:imageseg1
    mov     cs:ycenter,300
@@TriLoop:
    push    ds
    mov     ds,cs:bkgroundseg
    mov     si,0
    mov     es,cs:bufferseg
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy image to the virtual screen.
    pop     ds
    
    call    DoTri
    
    call    WaitRetrace    

    push    ds
    mov     ds,cs:bufferseg
    mov     si,0
    mov     ax,0A000h
    mov     es,ax
    mov     di,0
    mov     cx,16000
    rep     movsd               ; Copy the buffer to the screen.
    pop     ds

    add     cs:anglex,1
    add     cs:angley,2
    add     cs:anglez,3
    dec     cs:ycenter
   
    cmp     cs:ycenter,-100
    jg      @@TriLoop
    ret
NiceTri     endp



DoTri       proc near
    mov     di,0
jmptri:
    mov     bx,ds:tri[di]
    mov     cx,ds:tri[di+2]
    mov     bp,ds:tri[di+4]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[0],ax
    mov     cs:yvars[0],bx
    pop     di
    
    mov     bx,ds:tri[di+6]
    mov     cx,ds:tri[di+8]
    mov     bp,ds:tri[di+10]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[2],ax
    mov     cs:yvars[2],bx
    pop     di
    
    mov     bx,ds:tri[di+12]
    mov     cx,ds:tri[di+14]
    mov     bp,ds:tri[di+16]
    push    di
    call    rotate
    call    transform
    mov     cs:xvars[4],ax
    mov     cs:yvars[4],bx
    pop     di

    mov     ax,cs:xvars[0]
    mov     cs:xvars[6],ax
    mov     ax,cs:yvars[0]
    mov     cs:yvars[6],ax

    mov     ax,ds:tri[di+18]
    mov     cs:xmap[0],ax
    mov     cs:xmap[6],ax
    mov     ax,ds:tri[di+20]
    mov     cs:ymap[0],ax
    mov     cs:ymap[6],ax
    
    mov     ax,ds:tri[di+22]
    mov     cs:xmap[2],ax
    mov     ax,ds:tri[di+24]
    mov     cs:ymap[2],ax

    mov     ax,ds:tri[di+26]
    mov     cs:xmap[4],ax
    mov     ax,ds:tri[di+28]
    mov     cs:ymap[4],ax
    
    push    di
    mov     es,cs:bufferseg
    call    fillpolyMT
    pop     di
    
    add     di,30
    cmp     di,120
    jne     jmptri
    ret
DoTri       endp

;

TheTitle    proc near
    mov     ax,Seg sounddevice
    mov     es,ax
@WaitForSound:
    mov     ax,es:bar1
    cmp     ax,0
    je      @WaitForSound

    call    WhitePal

    push    ds
    mov     ds,cs:imageseg1
    xor     si,si
    mov     ax,0A000h
    mov     es,ax
    mov     di,70+55*320
    mov     dh,73          ; largeur  ;49
    mov     dl,0
@@TitleLoop:
    mov     bx,187         ; longueur ; 226
@@InternalTLoop:
    mov     al,ds:[si+bx]
    cmp     al,0
    je      @@SkipStoreC
    cmp     dl,58
    jna     PutZePix
    cmp     bx,33
    ja      @@SkipStoreC
PutZePix:
    mov     es:[di+bx],al
@@SkipStoreC:
    dec     bx
    cmp     bx,0
    jne     @@InternalTLoop
    add     si,320
    add     di,320
    inc     dl
    cmp     dl,dh
    jne     @@TitleLoop
    pop     ds

    call    flash

    push    ds
    mov     es,cs:bkgroundseg
    mov     ax,0A000h
    mov     ds,ax
    mov     si,0
    mov     di,0
    mov     cx,16000
    rep     movsd                 ; Copy image to Background segment
    pop     ds


    ret
TheTitle    endp

;

DrawZeLogo  proc near
    push    ds
    mov     dx,325
@@LittleLogo:
    push    dx
    
    cmp     dx,320
    ja      @@Skipthelogo

    mov     bp,99
    add     dx,99
    cmp     dx,320
    jna     @@LongIsOk
    sub     dx,99
    mov     ax,320
    sub     ax,dx
    mov     bp,ax

@@LongIsOk:

    call    WaitRetrace

    pop     dx
    push    dx

    mov     ds,cs:BkGroundSeg
    mov     si,240+170*320
    mov     di,si
    mov     ax,0A000h
    mov     es,ax
    mov     bh,30
    mov     bl,0
@@ClrLogo:
    mov     cx,80/4
    rep     movsd
    add     si,240
    add     di,240
    inc     bl
    cmp     bl,bh
    jne     @@ClrLogo
    

    mov     ds,cs:imageseg1
    mov     si,220
    mov     ax,0A000h
    mov     es,ax
    mov     di,170*320
    add     di,dx

    mov     ax,320
    sub     ax,bp
    mov     dh,25
    mov     dl,0
@@ZenLogo:
    inc     dl
    
    mov     cx,bp
    rep     movsb
    
    add     si,ax
    add     di,ax
    cmp     dl,dh    
    jne     @@ZenLogo
    
@@Skipthelogo:
    pop     dx    
    dec     dx
    cmp     dx,215
    jne     @@LittleLogo
    pop     ds    

    ret
DrawZeLogo  endp

;

WaveScreen  proc near
    jmp     StartWave
Angle1  db 50
Angle2  db 0
StartWave:
    pusha
    mov     cx,50                 ; number of total square to copy
    mov     bx,0
    mov     bp,0
    call    WaitRetrace    
    push    ds
    mov     ds,cs:imageseg1
    mov     es,cs:bufferseg
    cld
@@LoopSquare:                     ; Simple square copy...
    push    cx
    mov     si,74*320
    mov     ax,bp
    mov     dx,bp
    shl     ax,8
    shl     dx,6
    add     ax,dx
    mov     di,ax
    add     di,bx                 ; Ax=bp*320+bx

    mov     dh,40                 ; Square's height
    mov     dl,0
@@loopsIntern:
    inc     dl
    mov     cx,8                  ; Square's width div 4
    rep     movsd
    add     si,288
    add     di,288
    cmp     dl,dh
    jb      @@loopsIntern
    
    add     bx,32
    cmp     bx,320
    jb      @@SQitsok
    mov     bx,0
    add     bp,40
@@SQitsok:
    pop     cx
    loop    @@LoopSquare
    
    mov     es,cs:bkgroundseg
    mov     ds,cs:bufferseg
    mov     si,0
    mov     di,0
    mov     cx,16000
    rep     movsd                 ; Copy image to Background segment


    mov     ds,cs:bkgroundseg
    mov     ax,0A000h
    mov     es,ax
    mov     bp,-50
@@WavesView:
    call    WaitRetrace
    mov     dx,0
@@LoopWaves:
    mov     bx,dx
    add     bl,cs:angle1
    shl     bx,1
    mov     cx,cs:sine[bx]
    sar     cx,11
    
    mov     bx,dx
    add     bl,cs:angle2
    shl     bx,1
    mov     ax,cs:cosine[bx]
    sar     ax,10
    
    add     cx,ax
    add     cx,bp   ; cx=X+sin(angle1)+cos(angle2)
    cmp     cx,0
    jng     @@SkipLineWave
    cmp     cx,320
    jl      @@OkWaves
    mov     cx,320
@@OKWaves:
    cld
    mov     si,dx
    mov     di,dx
    shl     si,6
    shl     di,8
    add     si,di
    mov     di,si
    cmp     bp,40
    jng     @@TraceWave
    push    bx
    mov     bx,bp
    sub     bx,40
    add     di,bx
    add     si,bx
    sub     cx,bx
    pop     bx
@@TraceWave:
    rep     movsb
    
@@SkipLineWave:
    inc     dx
    cmp     dx,200
    jne     @@LoopWaves

    add     cs:angle1,2
    add     cs:angle2,1
    add     bp,1

    cmp     bp,345
    jng     @@WavesView
    pop     ds

    popa
    ret
WaveScreen  endp

;    

Flash       proc near    
    pusha
    call    WhitePal
@FadePal:
    xor     bp,bp
    xor     bx,bx
@Reinitpal: 
    mov     al,ds:palette[bx]
    cmp     al,cs:pcxpal[bx]
    jbe     @okpal
    dec     cs:palette[bx]
    mov     bp,1
@okpal:
    inc     bx
    cmp     bx,769
    jne     @Reinitpal
    call    WaitRetrace
    xor     cx,cx
    xor     bx,bx
@ActivePal:
    mov     dx,03C8h
    mov     ax,cx
    out     dx,al
    inc     dx
    mov     al,ds:palette[bx]
    out     dx,al
    mov     al,ds:palette[bx+1]
    out     dx,al
    mov     al,ds:palette[bx+2]
    out     dx,al
    add     bx,3
    inc     cx
    cmp     cx,256
    jne     @ActivePal
    cmp     bp,0
    jne     @Fadepal
    popa
    ret
Flash       endp


WhitePal    proc near
    mov     bp,0
    mov     bx,0
@InitPal:
    mov     dx,03C8h
    mov     ax,bp
    out     dx,al
    inc     dx
    mov     al,63
    mov     ds:palette[bx],al
    mov     ds:palette[bx+1],al
    mov     ds:palette[bx+2],al
    out     dx,al
    out     dx,al
    out     dx,al
    add     bx,3
    inc     bp
    cmp     bp,256
    jne     @InitPal
    ret
WhitePal    endp

;


start       proc near
    mov     ax,@DATA
    mov     ds,ax
    
    call    InitAlloc

    mov     dx,offset msg
    mov     ah,09h
    int     21h

    mov     bx,4000
    call    getrammem
    mov     cs:imageseg1,ax      ; reserve 16*4000 bytes at IMAGESEG1:0000

    mov     bx,4000
    call    getrammem
    mov     cs:imageseg2,ax


    mov     bx,4000
    call    getrammem
    mov     cs:BkGroundSeg,ax
    
    mov     bx,4000
    call    getrammem
    mov     cs:bufferseg,ax

    mov     dx,offset pcxfile1
    call    openfile
    mov     pcxhandle,bx        ; Open the file

    call    sizefile
    mov     ebx,edx             ; Size in ebx (bx in fact!'cauze less than 64k)
    shr     ebx,4               ; Divide size by 16.
    inc     bx                  ; Need to be increment to adjust the number of
    call    getrammem           ; wanted paragraphs for GetRamMem.
    mov     pcxsegadr,ax

    mov     ecx,edx             ; Now size in ecx->number of bytes to read.
    mov     bx,pcxhandle
    mov     dx,0
    push    ds
    mov     ds,pcxsegadr
    call    readfile            ; Put the datas in the buffer.
    pop     ds

    mov     bx,pcxhandle
    call    closefile           ; Close the file

    mov     es,cs:imageseg1      ; Prepare ES for Unpack.
    push    ds
    mov     ds,pcxsegadr        ; Prepare DS for Unpack.
    
    call    UnPackPCX           ; DO unpack...from PcxSegAdr:0 to imageseg1:0
    pop     ds
    
    mov     dx,offset pcxfile2
    call    openfile
    mov     pcxhandle,bx        ; Open the seconde file
    call    sizefile
    mov     ebx,edx
    shr     ebx,4
    inc     bx
    call    getrammem
    mov     pcxsegadr,ax
    mov     ecx,edx
    mov     bx,pcxhandle
    mov     dx,0
    push    ds
    mov     ds,pcxsegadr
    call    readfile
    pop     ds
    mov     bx,pcxhandle
    call    closefile
    mov     es,cs:imageseg2
    push    ds
    mov     ds,pcxsegadr
    call    UnPackPCX
    pop     ds

    mov     bx,pcxsegadr
    call    freerammem          ; Free memory reserved for packed pcx

    call    askinit
    call    initialize
    
    mov     dx,offset modname
    call    loadmodule
    
    call    StartPlaying

    mov     ax,13h
    int     10h                 ; Init MCGA 320x200 256 color mode
    
    mov     ax,0a000h       
    mov     es,ax
    xor     dx,dx
    xor     bx,bx
    mov     cx,256
    mov     ax,1012h            ; Palette cleared
    int     10h

    call    setpcxpal           ; Active pcxpal

    call    WaveScreen
    call    DrawZeLogo
    call    TheTitle
    call    NiceTri
    call    Transition
    call    NiceUFO
    call    NiceGlenz
    call    Transition2
    
    mov     dx,offset pcxfile3  ; The little gouraud picture
    call    openfile
    mov     pcxhandle,bx        ; Open the third pcx file in ImageSeg2
    call    sizefile
    mov     ebx,edx
    shr     ebx,4
    inc     bx
    call    getrammem
    mov     pcxsegadr,ax
    mov     ecx,edx
    mov     bx,pcxhandle
    mov     dx,0
    push    ds
    mov     ds,pcxsegadr
    call    readfile
    pop     ds
    mov     bx,pcxhandle
    call    closefile
    mov     es,cs:imageseg2
    push    ds
    mov     ds,pcxsegadr
    call    UnPackPCX
    pop     ds
    mov     bx,pcxsegadr
    call    freerammem

    push    ds                 ; Prepare the phong spot light gfx...
    mov     es,cs:imageseg1  
    mov     ds,cs:imageseg2
    mov     si,32160
    mov     di,32159
    xor     dx,dx
Vert1loopphx:
    mov     cx,160
Hori1loopphx:
    mov     al,ds:[si]
    mov     es:[di],al
    mov     es:[si],al
    inc     si
    dec     di
    dec     cx
    jnz     Hori1Loopphx
    add     si,160
    add     di,480
    inc     dx
    cmp     dx,100
    jb      Vert1Loopphx
    pop     ds       

    mov     es,cs:imageseg1
    mov     dx,0
    mov     si,100*320
    mov     di,100*320-320  ;63680
Vert2loopphx:
    mov     cx,320
Hori2loopphx:
    mov     al,es:[si]
    mov     es:[di],al
    inc     si
    inc     di
    dec     cx
    jnz     Hori2Loopphx
    sub     di,640
    inc     dx
    cmp     dx,100
    jb      Vert2Loopphx
    
    call    setpcxpal

    call    Transition3
    call    NiceShip
    call    NicePhong
    call    Transition4
    call    NiceBump

    mov     ax,seg sounddevice
    mov     es,ax
    mov     cx,64
FadeSDown:
    push    cx
    call    WaitRetrace
    mov     es:mastervolume,cx
    call    WaitRetrace
    pop     cx
    loop    FadeSDown
    
    call    stopplaying
    call    dealloc
    
    mov     bx,cs:imageseg1
    call    freerammem          ; Free memory reserved for unpacked pcx.

    mov     bx,cs:imageseg2
    call    freerammem

    mov     bx,cs:bufferseg
    call    freerammem

    mov     bx,cs:BkGroundSeg   ; Libere le memoire utilise par ce segment !
    call    freerammem

    mov     ax,03h
    int     10h

    mov     dx,offset msg_bye
    mov     ah,09h
    int     21h                 ; credits message
    
    mov     ah,4ch
    int     21h                 ; Bye bye...
    ret
start       endp


            end start
