;----------------------------------------------------------------------------;
; These procedures are used to fill a triangle polygon with Gouraud shading. ; 
; This methode is not the best you could have, but it runs perfectly on my   ;
; poor 386dx33. So use it in your own piece of code.                         ;
;                                                                            ;
;                                                                    Trantor ;
;----------------------------------------------------------------------------;




;----------------------------------------------------------------------------;
; CheckCWise - Check if a side is visible or not. Check for clock wise...    ;
; INPUT : DS,SI,DX=x's BP,DS,ES=y's                                          ;
; OUTPUT: CX (>0 then visible)      DESTRUCT: Nothing                        ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
CheckCWise  proc near
    cmp     di,si
    jng     orderok1
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok1:
    cmp     di,si
    jng     orderok2
    mov     ax,di
    mov     di,si
    mov     si,dx
    mov     dx,ax
    mov     ax,bp
    mov     bp,ds
    mov     bx,es
    mov     ds,bx
    mov     es,ax
orderok2:
    mov     ax,dx
    sub     ax,di
    mov     bx,ds
    sub     bx,bp
    imul    bx
    mov     cx,ax
    mov     ax,si
    sub     ax,di
    mov     bx,es
    sub     bx,bp
    imul    bx
    sub     cx,ax
    ret
CheckCWise  endp




;----------------------------------------------------------------------------;
; SetFTable - Sets the table used for drawing the veticals lines.            ;
; INPUT : AX=x  CX=y                                                         ;
; OUTPUT: Nothing                   DESTRUCT: Nothing                        ;
; - used by DoLine to set table -                                            ;
;----------------------------------------------------------------------------;
SetFTable   proc near
    cmp     cx,200
    jae     EndSetFTable
    push    ax
    mov     bx,cx
    shl     bx,1
    cmp     ax,cs:firstbyte[bx]
    jg      SetLine1
    mov     cs:firstbyte[bx],ax
    push    ax                      ; AX must be preserve for next CoMPare...
    mov     ax,cs:color
    mov     cs:firstcol[bx],ax      ; interpol color...
    pop     ax
SetLine1:
    cmp     ax,cs:lastbyte[bx]
    jng     SetLine2
    mov     cs:lastbyte[bx],ax
    mov     ax,cs:color
    mov     cs:lastcol[bx],ax       ; Interpol color...
    SetLine2:
    pop     ax
EndSetFTable:
    ret
SetFTable   endp




;----------------------------------------------------------------------------;
; DoLine - Proceed line to know the start and the end of each line.          ;
; INPUT : X1,Y1,X2,Y2...                                                     ;
; OUTPUT: Nothing                   DESTRUCT: AX CX Deltax                   ;
; - used by FillPoly - uses SetFTable -                                      ;
;----------------------------------------------------------------------------;
DoLine      proc near
    mov     cx,cs:y2
    cmp     cx,cs:y1
    jg      NoSwapCoords    ; Check if y2>y1 to have a positive substraction,
    xchg    cx,cs:y1        ; which is need for a correct DeltaX
    mov     cs:y2,cx
    mov     ax,cs:x2
    xchg    ax,cs:x1    
    mov     cs:x2,ax
    mov     ax,cs:color1
    xchg    ax,cs:color2
    mov     cs:color1,ax
NoSwapCoords:
    mov     cx,cs:y2
    sub     cx,cs:y1        ; CX=y2-y1
    cmp     cx,0
    je      EndDoLine       ; Check if CX<>0
CalcDX:
    mov     ax,cs:color2
    sub     ax,cs:color1
    cwd
    shl     ax,7
    idiv    cx
    mov     cs:deltacol,ax  ; Coef. need for color interpolation along (x1,y1) (x2,y2)
    mov     ax,cs:color1
    mov     cs:multcol,ax
    shl     cs:multcol,7

    mov     ax,cs:x2
    sub     ax,cs:x1
    cwd
    shl     ax,6            ; AX=64*(x2-x1)
    idiv    cx
    mov     cs:deltax,ax    ; dx=64*(x2-x1)/(y2-y1)=DeltaX

    mov     cx,cs:y1
    mov     dx,cs:y2
    mov     ax,cs:x1        ; ax=x1
    shl     ax,6

DoLineLoop:
    mov     bp,cs:multcol
    mov     cs:color,bp
    shr     cs:color,7
    push    ax
    shr     ax,6
    call    SetFTable
    pop     ax
    
    add     ax,cs:deltax
    mov     bp,cs:deltacol
    add     cs:multcol,bp
    inc     cx

    cmp     cx,dx           ; CoMPare y1 & y2
    jng     DoLineLoop
EndDoLine:
    ret
DoLine      endp




;----------------------------------------------------------------------------;
; FillIt - Draws the calculated table. Line per line...                      ;
; INPUT : Nothing                                                            ;
; OUTPUT: Nothing                       DESTRUCT: BP CX SI DX AX CX          ;
; - used by FillPoly -                                                       ;
;----------------------------------------------------------------------------;
FillIt      proc near
    cld
    mov     cx,200
FillItLoop:
    mov     bp,cx
    mov     si,cx
    dec     si
    add     si,si

    cmp     cs:firstbyte[si],320
    jge     EndFill
  
    mov     dx,cs:firstbyte[si]
    mov     ax,bp
    dec     ax
    mov     bx,ax
    shl     bx,6
    shl     ax,8
    add     ax,bx
    add     ax,dx
    mov     di,ax
    mov     cx,cs:lastbyte[si]
    sub     cx,dx
    cmp     cx,0
    je      endfill2
    
    mov     ax,cs:lastcol[si]
    sub     ax,cs:firstcol[si]
    cwd
    shl     ax,7
    idiv    cx      ;ax=deltacol=128*(lastcol-firstcol)/(lastbyte-firstbyte)
    
    mov     dx,cs:firstcol[si]
    mov     bx,dx
    shl     bx,7
llooop:
    mov     dx,bx
    shr     dx,7
    mov     es:[di],dl
    inc     di
    add     bx,ax
    dec     cx
    jnz     llooop

endfill2:
    mov     cs:lastbyte[si],-1
    mov     cs:firstbyte[si],320
    mov     cx,bp
EndFill:
    dec     cx
    cmp     cx,0
    jg      FillItLoop
    ret
FillIt      endp




;----------------------------------------------------------------------------;
; FillPoly - Draws a 4 sides polygon                                         ;
; INPUT : xvars, yvars, ES must be initialized                               ;
; OUTPUT: Nothing                       DESTRUCT: BX CX AX                   ;
; - uses CheckCWise, DoLine & FillIt -                                       ;
;----------------------------------------------------------------------------;
FillPoly    proc near
    
    push    ds
    push    es
    mov     di,cs:xvars[0]
    mov     si,cs:xvars[2]
    mov     dx,cs:xvars[4]
    mov     bp,cs:yvars[0]
    mov     ds,cs:yvars[2]
    mov     es,cs:yvars[4]
    call    CheckCWise
    pop     es
    pop     ds
    cmp     cx,0
    jng     EndFillPoly
    
    mov     bx,0
    mov     cx,3        ; 3 sides...
FillPolyLoop:
    mov     ax,cs:xvars[bx]
    mov     cs:x1,ax
    mov     ax,cs:yvars[bx]
    mov     cs:y1,ax
    mov     ax,cs:colors[bx]
    mov     cs:color1,ax
    mov     ax,cs:xvars[bx+2]
    mov     cs:x2,ax
    mov     ax,cs:yvars[bx+2]
    mov     cs:y2,ax
    mov     ax,cs:colors[bx+2]
    mov     cs:color2,ax
    push    bx
    push    cx
    call    DoLine
    pop     cx
    pop     bx
    add     bx,2
    dec     cx
    jnz     FillPolyLoop
    Call    FillIt
EndFillPoly:
    ret
FillPoly    endp




;-------------------------------------------------------------Global variables




firstbyte   dw 200 dup (320)    ; The famous table, used to have the start and
lastbyte    dw 200 dup (-1)     ; the end of the line to draw.
firstcol    dw 200 dup (0)
lastcol     dw 200 dup (0)

color       dw  0
color1      dw  0
color2      dw  0
deltacol    dw  0
multcol     dw  0

deltax      dw  0               ; For DoLine...

x1          dw  0               ; Temporary coordinates for DoLine.
y1          dw  0
x2          dw  0
y2          dw  0

xvars       dw  0,0,0,0
yvars       dw  0,0,0,0
colors      dw  0,0,0,0



                                
                        db 'Gouraud - (c)opyright Trantor of Zen, may 1996.',0
