/* SDL Setup */
#define FULLSCREEN 0
#define SCREEN_WIDTH 640
#define SCREEN_HEIGHT 480

/* Stars */
#define NUMSTARS 1000
#define SCALE 800

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_mixer.h>
#include <SDL/sge.h>
#include <fmod.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>
#include "extra.h"


/* Datatyper */
typedef	struct
{
  int x,y,z;
} star_type;

typedef struct
{
  int x1,y1,x2,y2;
  float speedx1, speedx2, speedy1, speedy2;
} line_type;

typedef struct
{
  int x, y;
  float speedy;
  int going_out;
} amigascroller_type;

typedef struct
{
  int x,y;
} sinscroller_type;

typedef struct
{
  char title[100],filename[100];
  int active;
} song_type;

/* Globala variabler */
star_type stars[NUMSTARS];
line_type lines[5];
amigascroller_type amigascroller[6];
sinscroller_type sinscroller[1000];
sinscroller_type greetingsscroller[1000];
song_type songlist[80];
int current_song;
int num_of_songs;
int show_menu = 0;
int blink=0;


SDL_Surface *img_logo,*img_raster,*img_figge,*img_figge_stor,*img_fulmust,*img_fulmust_stor,*img_hand,*img_hand_left,*img_transa;	
char text_scroller[] = "                            WELCOME!                          ";
char text_greetings[] = "                          HELLO FELLAS... AT LAST WE FINALLY RELEASED THIS CHIPTUNEDISK SO THAT YOU CAN ENJOY OUR MUSIC... TNX TO FULMUST FOR CODING THIS HAXXORDISK...   THIS MUSIC IS FEGOLHUZZ VERY BEST TOP 50..HAHA.. JUST KIDDING...    BUT ANYWAY KAKMONSTER WOULD LIKE TO GREET A FEW PEOPLE...GREETINGS FLIES OUT TO...   FULMUST FOR CODING...FEGOLHUZZ FOR MUSIC...REST OF THE CREW IN KAKMONSTERKLUBBEN...BERSERK STUDIOS...OUR PARENTS FOR THEIR TOTAL SUPPORT... AND REST OF OUR FAITHFUL FANS OUT THERE...   ARGHH...                     ";

int td2,td;
float dt = 0;
int lastframe;

/* SDL-meck & annat */
SDL_Surface *screen;
SDL_Event event;
sge_bmpFont *font,*font2;
Mix_Music *music;
FMUSIC_MODULE *handle = 0;


double stretch = 0;
double stretch_speed = 0.00002;



/* funktioner.. */

void F_CALLBACKAPI instcallback(FMUSIC_MODULE *mod, unsigned char param);

void playSong(int num) {

  //  Mix_HaltMusic();
  // Mix_FreeMusic(music);
  
  //music = Mix_LoadMUS(songlist[num].filename);
  //Mix_PlayMusic(music,0);

  FMUSIC_StopSong(handle);
  handle = FMUSIC_LoadSong (songlist[num].filename);
  FMUSIC_PlaySong(handle);
  FMUSIC_SetInstCallback(handle, instcallback, 0x30);

  current_song = num;

  //strcpy(text_scroller, "                                                    ");
  strcpy(text_scroller, songlist[current_song].title);
  

}  

void drawSongMenu() {

  int i,n;

  //if current_song

  for (i=current_song-1,n=0 ;i<=current_song+1;i++,n++) {
     sge_BF_textout(screen, font, songlist[i].title, SCREEN_WIDTH/2 - (strlen(songlist[i].title)/2 * 12), 360 + n*20);
  }


  /* plupp */
  sge_BF_textout(screen, font, ".........................................", SCREEN_WIDTH/2 - 145, 345);
  sge_BF_textout(screen, font, ".........................................", SCREEN_WIDTH/2 - 145, 415);


  /* hand */
  drawImg(screen, img_hand, 430 + 10 * sin(sinscroller[0].x * 0.02), 380);
  drawImg(screen, img_hand_left, 170 - 10 * sin(sinscroller[0].x * 0.02), 380);

  drawImg(screen, img_transa, 180, 360);
  drawImg(screen, img_transa, 180, 405);
}


void initGreetingsScroller() {

  int i;
  for (i=0; i < 1000; i++)
    greetingsscroller[i].x = i * 10;

}

void greetingsScroller() {

  char tmp[2];

  int i;
  
  /* printf("%d :", greetingsscroller[0].x); */


  if (greetingsscroller[0].x < -2400) 
    initGreetingsScroller();

  for (i=0; i < 1000; i++) {
    greetingsscroller[i].x -= 0.4 * dt;

    if (greetingsscroller[i].x > 0 && greetingsscroller[i].x < 300) {
      tmp[0] = text_greetings[i];
      tmp[1] = '\0';

      sge_BF_textout(screen, font, tmp, 165 + greetingsscroller[i].x, 455);
    }
  }

}
  

void initsinScroller() {
  int i;
  for (i=0; i < 200; i++) {
    sinscroller[i].x = i * 25;
    /* printf("%d,",sinscroller[i].x); */
  }
}


void sinScroller() {

  char tmp[2];
	
  char *strptr;
  strptr = text_scroller;

  int i=0;
  int len = strlen(text_scroller);

  for (i=0; i < 50; i++)
    sinscroller[i].x += 2.8 * dt;    
  
  i=0;
  while (*strptr) {
   
    tmp[0] = *strptr; 
    tmp[1] = '\0';
    
    sge_BF_textout(screen, font2, tmp, (SCREEN_WIDTH/2 - (len/2)*35) + 35*i, 220+(50 * sin(sinscroller[i].x * 0.008)));
    //sge_BF_textout(screen, font, tmp, 220+(sinscroller[i].y) + (i+1)*(abs(sinscroller[i].y)/2), 230);
    
    stretch += dt * stretch_speed;

    if (stretch > 100 || stretch < 0)
      stretch_speed *= -1;
    
    strptr++;
    i++;				
  }
  
}	




void initStars(void) {

  int i;
  for (i=0; i<NUMSTARS; i++) {
    stars[i].x = (rand() % SCREEN_WIDTH) - SCREEN_WIDTH/2;
    stars[i].y = (rand() % SCREEN_HEIGHT) - SCREEN_HEIGHT/2;
    stars[i].z = i + 1;
  }
}

void placeStars() {
	
  int i, xpos,ypos;
	
  int nr = rand() % NUMSTARS;
		
  /* 3D -> 2D */
  xpos =(int)((stars[nr].x*SCALE)/stars[nr].z)+(SCREEN_WIDTH/2);
  ypos =(int)((stars[nr].y*SCALE)/stars[nr].z)+(SCREEN_HEIGHT/2);
		
  float size;
  size = 1.0 - ((float)stars[nr].z / 500.0);
  
  if(xpos < SCREEN_WIDTH && ypos < SCREEN_HEIGHT-80 && xpos> 0 && ypos>100) {
    //drawImg(screen, sge_transform_surface(img_heart, SDL_MapRGB(img_heart->format, 255,0,255), 0, size, size, 0), xpos, ypos);	
  }
		
		
}
			
			
void drawStars(SDL_Surface *S)
{
  int loop;
  int xpos;
  int ypos;
  
  for(loop=0; loop<NUMSTARS; loop++) {
    
    /* flytta */
    stars[loop].z -= 2.5 * dt;
    if(stars[loop].z<1 || stars[loop].z == 0)
      stars[loop].z+=NUMSTARS;
    
    /* 3D -> 2D */
    xpos =(int)((stars[loop].x*SCALE)/stars[loop].z)+(SCREEN_WIDTH/2);
    ypos =(int)((stars[loop].y*SCALE)/stars[loop].z)+(SCREEN_HEIGHT/2);
    
    float size;
    size = 1.0 - ((float)stars[loop].z / 500.0);
    
    if(xpos < SCREEN_WIDTH && ypos < SCREEN_HEIGHT && xpos> 0 && ypos>100) {
      drawPixel(screen, xpos, ypos, 255,255,255);

    }
      
      
      
  }
}

/* fula linjer som flyger fram & tebax */
void initLines() {
	
  int i;
  for (i=0; i<5;i++) {
    lines[i].x1 = 20 + (i * 32);
    lines[i].y1 = 20 + (i * 10);
    lines[i].x2 = 350 + (i * 32);
    lines[i].y2 = 200 + (i * 10);
    lines[i].speedx1 =  lines[i].speedx2 = lines[i].speedy1 = lines[i].speedy2 = 2;
  }
  
}

void drawLines() {
	
  int i,spdx1,spdx2,spdy1,spdy2;
  for (i=0; i<5; i++) {
    
    /* sge_Line(screen, lines[i].x1, lines[i].y1, lines[i].x2, lines[i].y2, SDL_MapRGB(screen->format, 0,0,0)); */
    
    spdx1 = lines[i].speedx1;
    spdy1 = lines[i].speedy1;
    spdx2 = lines[i].speedx1;
    spdy2 = lines[i].speedy2;
    
    if (lines[i].x1 + (dt * spdx1) > SCREEN_WIDTH-5|| lines[i].x1 + (dt * spdx1) < 5) 
      lines[i].speedx1 *= -1;
    if (lines[i].x2 + (dt * spdx2) > SCREEN_WIDTH-5 || lines[i].x2 + (dt * spdx2) < 5) 
      lines[i].speedx2 *= -1;
    
    if (lines[i].y1 + (dt * spdy1) > SCREEN_HEIGHT-5 || lines[i].y1 + (dt * spdy1) < 5) 
      lines[i].speedy1 *= -1;
    if (lines[i].y2 + (dt * spdy2) > SCREEN_HEIGHT-5 || lines[i].y2 + (dt * spdy2) < 5) 
      lines[i].speedy2 *= -1;
    
    
    lines[i].x1 += dt * lines[i].speedx1;
    lines[i].y1 += dt * lines[i].speedy1;
    lines[i].x2 += dt * lines[i].speedx2;
    lines[i].y2 += dt * lines[i].speedy2;
    
    sge_Line(screen, lines[i].x1, lines[i].y1, lines[i].x2, lines[i].y2, SDL_MapRGB(screen->format, 255,255,255));
    
  }
  
}


/* sinus-scroller */

void initAmigaScroller() {
  
  int i;
  for (i=0; i <6; i++) 
    amigascroller[i].x = i * 50; amigascroller[i].going_out = 0;
  
}

void drawAmigaScroller() {
  
  int i;
  for (i=0; i<6; i++) {
    
    if (!amigascroller[i].going_out) {
      amigascroller[i].x += 3 * dt;
      amigascroller[i].y = 40 * sin(0.013 * amigascroller[i].x);
      //sge_FilledRect(screen, 0, 425 + amigascroller[i].y, SCREEN_WIDTH,  425 + amigascroller[i].y + 15, SDL_MapRGB(screen->format, current_song*i+90, (i*current_song) + 130, (i*current_song) + 180)); 
      sge_FilledRect(screen, 0, 40 + amigascroller[i].y, SCREEN_WIDTH,  40 + amigascroller[i].y + 15, SDL_MapRGB(screen->format, i*35, i*35, i*35)); 
    }
    
  }
  
}


void loadSongs() {
  
  int i = 0;
  char str1[100];
  char str2[100];
 
  strcpy(songlist[0].title," ");

  strcpy(songlist[1].filename,"songs/fegolhuzz-chipdiskintro.xm");
  strcpy(songlist[1].title,"FEGOLHUZZ CHIPDISK");  


  DIR *dp;
  struct dirent *ep;

  dp = opendir ("./songs/");
  if (dp != NULL)
    {
      i=2;
      while (ep = readdir (dp)) {
        //puts (ep->d_name);
        if (strcmp("..",ep->d_name) && strcmp(".",ep->d_name) && strcmp("fegolhuzz-chipdiskintro.xm",ep->d_name)) {

          /* lgg till songs/ - prefix */
          strcpy(str1, "songs/");
          strcpy(str2, ep->d_name);
          strcat (str1, str2);

          /* flska in i listan och strippa fegolhuzz + .xm till titlen */
          strcpy(songlist[i].filename,str1);

          char *strptr;
          strptr = str2 + 9;  

          while (*(strptr++)) {
            if (*strptr == '.')
              *strptr = '\0';
            else
              *strptr = toupper(*strptr);
          }
          
            
          strcpy(songlist[i].title,str2 + 10);
          //songlist[i].length = strlen(songlist[i].title)
          //puts(songlist[i].title);
          
          i++;

        }
        
      }
      (void) closedir (dp);
    }
  else
    puts ("Couldn't open the directory.");

  num_of_songs = i;

 
}





void F_CALLBACKAPI instcallback(FMUSIC_MODULE *mod, unsigned char param) {

  blink=1;

}








int main() {

  img_logo = IMG_Load("gfx/chipdisk.png");
  img_raster = IMG_Load("gfx/raster.png");

  img_hand = IMG_Load("gfx/hand.png");
  img_hand_left = IMG_Load("gfx/hand_left.png");

  img_figge = IMG_Load("gfx/figge.png");
  img_figge_stor = IMG_Load("gfx/figge_stor.png");

  img_fulmust = IMG_Load("gfx/fulmust.png");
  img_fulmust_stor = IMG_Load("gfx/fulmust_stor.png");

  img_transa = IMG_Load("gfx/transa.png");

  char buffer[100];

  current_song = 1;

   
  /* Initiera SDL */	
  SDL_Init (SDL_INIT_VIDEO);
	
  if (FULLSCREEN) {
    screen = SDL_SetVideoMode (SCREEN_WIDTH, SCREEN_HEIGHT, 16, SDL_HWSURFACE|SDL_FULLSCREEN|SDL_DOUBLEBUF);
  }
  else {
    screen = SDL_SetVideoMode (SCREEN_WIDTH, SCREEN_HEIGHT, 16, SDL_SWSURFACE|SDL_DOUBLEBUF);
  }
	
  SDL_WM_SetCaption("feglhuzz chipdisk","fegolhuzz chipdisk");

  atexit(SDL_Quit);
	

  /* Ls in ltlista */
  loadSongs();

 
  /* Sparka igng FMOD */
  FSOUND_Init (44100, 32, 0);
  playSong(current_song);
  FMUSIC_SetInstCallback(handle, instcallback, 0x30);

	
  /* Inita starfieldet & lines och annat*/
  font = sge_BF_OpenFont("gfx/font.bmp", SGE_BFTRANSP|SGE_BFSFONT);
  font2 = sge_BF_OpenFont("gfx/font2.bmp", SGE_BFTRANSP|SGE_BFSFONT);
	
  initsinScroller();
  initStars();
  initLines();
  initAmigaScroller();
  initGreetingsScroller();
	
  /* ingen autoupdate.. flimmrar fult. */
  sge_Update_OFF();
	
  int done = 0;
  
	
  while (!done) {
    
    /* kalkylera en konstant fr fps-indie. */
    td2=SDL_GetTicks();
    dt=((float)(td2-td)*0.1);
    td=td2;		
		
    
    /* rensa */
    sge_ClearSurface(screen, SDL_MapRGB(screen->format, 0,0,0));
    
				
    /* ett starfield.. mm. */
    drawStars(screen);
    drawAmigaScroller();

    
    //drawLines();

    drawImg(screen, img_logo, SCREEN_WIDTH/2 - img_logo->w / 2,10);
    drawImg(screen, img_figge, 50, SCREEN_HEIGHT - 130);
    drawImg(screen, img_fulmust, SCREEN_WIDTH-130, SCREEN_HEIGHT - 130);

    sge_BF_textout(screen, font, "FEGOLHUZZ", 60, SCREEN_HEIGHT-35);
    sge_BF_textout(screen, font, "MUSIC AND GFX", 10, SCREEN_HEIGHT-20);

    sge_BF_textout(screen, font, "FULMUST", 480, SCREEN_HEIGHT-35);
    sge_BF_textout(screen, font, "JUST THE CODE", 480, SCREEN_HEIGHT-20);

    //sge_BF_textout(screen, font, "PRESS M FOR MENU", 200, 455);



    drawImg(screen, img_raster, SCREEN_WIDTH/2 - 150, 350);
    drawSongMenu();
    
    sinScroller();
    greetingsScroller();	

    if (blink) { 
      //drawImg(screen, img_logo, 150, 150);
      drawImg(screen, img_figge_stor, 47, SCREEN_HEIGHT - 133);
      drawImg(screen, img_fulmust_stor, SCREEN_WIDTH-133, SCREEN_HEIGHT - 133);

      blink=0;
    }

    /* keypresses..  */
    while ( SDL_PollEvent(&event) )
      {
        if (event.type == SDL_QUIT )  {  done = 1;  }
        if (event.type == SDL_KEYDOWN )
          {
            if (event.key.keysym.sym == SDLK_ESCAPE ) { done = 1; }
            if (event.key.keysym.sym == SDLK_DOWN) { if(current_song+1 < num_of_songs) playSong(current_song+1); }
            if (event.key.keysym.sym == SDLK_UP) { if(current_song-1 > 0) playSong(current_song-1); }
            if (event.key.keysym.sym == SDLK_m) { 
              if (show_menu) show_menu = 0;
              else show_menu = 1;
            }
            
          }
      }	
    
    SDL_Flip(screen);	
    
  }
  
  return 0;	

}
