#include "frameworks.hpp"

const char* const fs_font = 
"\n#version 120\n"
"uniform sampler2D notes_velocity;"
"varying vec2 coords;"
"uniform float xy_scale_factor;"
"uniform float sequence_time;"
"float line(vec2 p, vec2 a, vec2 b)"
"{"
  "vec2 pa = p - a;"
  "vec2 ba = b - a;"
  "float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);"
  "return length(pa - ba * h);"
"}"
"float _u(vec2 uv, float w, float v) {"
  "return length(vec2("
  "abs(length(vec2(uv.x,"
  "max(0.0,-(.4-v)-uv.y) ))-w)"
  ",max(0.,uv.y-.4)));"
"}"
"float _i(vec2 uv) {"
  "return length(vec2(uv.x,max(0.,abs(uv.y)-.4)));"
"}"
"float _j(vec2 uv) {"
  "uv.x+=.2;"
  "uv.y+=.55;"
  "float x = uv.x>0.&&uv.y<0.?"
  "abs(length(uv)-.25)"
  ":min(length(uv+vec2(0.,.25)),"
  "length(vec2(uv.x-.25,max(0.,abs(uv.y-.475)-.475))));"
  "return x;"
"}"
"float _l(vec2 uv) {"
  "uv.y -= .2;"
  "return length(vec2(uv.x,max(0.,abs(uv.y)-.6)));"
"}"
"float _o(vec2 uv) {"
  "return abs(length(vec2(uv.x,max(0.,abs(uv.y)-.15)))-.25);"
"}"
"float aa(vec2 uv) {"
  "uv = -uv;"
  "float x = abs(length(vec2(max(0.,abs(uv.x)-.05),uv.y-.2))-.2);"
  "x = min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y-.2)-.2))));"
  "return min(x,(uv.x<0.?uv.y<0.:atan(uv.x,uv.y+0.15)>2.)?_o(uv):length(vec2(uv.x-.22734,uv.y+.254)));"
"}"
"float bb(vec2 uv) {"
  "float x = _o(uv);"
  "uv.x += .25;"
  "return min(x,_l(uv));"
"}"
"float cc(vec2 uv) {"
  "float x = _o(uv);"
  "uv.y= abs(uv.y);"
  "return uv.x<0.||atan(uv.x,uv.y-0.15)<1.14?x:"
  "min(length(vec2(uv.x+.25,max(0.0,abs(uv.y)-.15))),"
  "length(uv+vec2(-.22734,-.254)));"
"}"
"float dd(vec2 uv) {"
  "uv.x *= -1.;"
  "return bb(uv);"
"}"
"float ee(vec2 uv) {"
  "float x = _o(uv);"
  "return min(uv.x<0.||uv.y>.05||atan(uv.x,uv.y+0.15)>2.?x:length(vec2(uv.x-.22734,uv.y+.254)),"
  "length(vec2(max(0.,abs(uv.x)-.25),uv.y-.05)));"
"}"
"float ff(vec2 uv) {"
  "uv.x *= -1.;"
  "uv.x += .05;"
  "float x = _j(vec2(uv.x,-uv.y));"
  "uv.y -= .4;"
  "x = min(x,length(vec2(max(0.,abs(uv.x-.05)-.25),uv.y)));"
  "return x;"
"}"
"float gg(vec2 uv) {"
  "float x = _o(uv);"
  "return min(x,uv.x>0.||atan(uv.x,uv.y+.6)<-2.?"
  "_u(uv,0.25,-0.2):"
  "length(uv+vec2(.23,.7)));"
"}"
"float hh(vec2 uv) {"
  "uv.y *= -1.;"
  "float x = _u(uv,.25,.25);"
  "uv.x += .25;"
  "uv.y *= -1.;"
  "return min(x,_l(uv));"
"}"
"float ii(vec2 uv) {"
  "return min(_i(uv),length(vec2(uv.x,uv.y-.6)));"
"}"
"float jj(vec2 uv) {"
  "uv.x+=.05;"
  "return min(_j(uv),length(vec2(uv.x-.05,uv.y-.6)));"
"}"
"float kk(vec2 uv) {"
  "float x = line(uv,vec2(-.25,-.1), vec2(0.25,0.4));"
  "x = min(x,line(uv,vec2(-.15,.0), vec2(0.25,-0.4)));"
  "uv.x+=.25;"
  "return min(x,_l(uv));"
"}"
"float ll(vec2 uv) {"
  "return _l(uv);"
"}"
"float mm(vec2 uv) {"
  "uv.y *= -1.;"
  "uv.x-=.175;"
  "float x = _u(uv,.175,.175);"
  "uv.x+=.35;"
  "x = min(x,_u(uv,.175,.175));"
  "uv.x+=.175;"
  "return min(x,_i(uv));"
"}"
"float nn(vec2 uv) {"
  "uv.y *= -1.;"
  "float x = _u(uv,.25,.25);"
  "uv.x+=.25;"
  "return min(x,_i(uv));"
"}"
"float oo(vec2 uv) {"
  "return _o(uv);"
"}"
"float pp(vec2 uv) {"
  "float x = _o(uv);"
  "uv.x += .25;"
  "uv.y += .4;"
  "return min(x,_l(uv));"
"}"
"float qq(vec2 uv) {"
  "uv.x = -uv.x;"
  "return pp(uv);"
"}"
"float rr(vec2 uv) {"
  "uv.x -= .05;"
  "float x =atan(uv.x,uv.y-0.15)<1.14&&uv.y>0.?_o(uv):length(vec2(uv.x-.22734,uv.y-.254));"
  "uv.x+=.25;"
  "return min(x,_i(uv));"
"}"
"float ss(vec2 uv) {"
  "if (uv.y <.225-uv.x*.5 && uv.x>0. || uv.y<-.225-uv.x*.5)"
  "uv = -uv;"
  "float a = abs(length(vec2(max(0.,abs(uv.x)-.05),uv.y-.2))-.2);"
  "float b = length(vec2(uv.x-.231505,uv.y-.284));"
  "float x = atan(uv.x-.05,uv.y-0.2)<1.14?a:b;"
  "return x;"
"}"
"float tt(vec2 uv) {"
  "uv.x *= -1.;"
  "uv.y -= .4;"
  "uv.x += .05;"
  "float x = min(_j(uv),length(vec2(max(0.,abs(uv.x-.05)-.25),uv.y)));"
  "return x;"
"}"
"float uu(vec2 uv) {"
  "return _u(uv,.25,.25);"
"}"
"float vv(vec2 uv) {"
  "uv.x=abs(uv.x);"
  "return line(uv,vec2(0.25,0.4), vec2(0.,-0.4));"
"}"
"float ww(vec2 uv) {"
  "uv.x=abs(uv.x);"
  "return min(line(uv,vec2(0.3,0.4), vec2(.2,-0.4)),"
  "line(uv,vec2(0.2,-0.4), vec2(0.,0.1)));"
"}"
"float xx(vec2 uv) {"
  "uv=abs(uv);"
  "return line(uv,vec2(0.,0.), vec2(.3,0.4));"
"}"
"float yy(vec2 uv) {"
  "return min(line(uv,vec2(.0,-.2), vec2(-.3,0.4)),"
  "line(uv,vec2(.3,.4), vec2(-.3,-0.8)));"
"}"
"float zz(vec2 uv) {"
  "float l = line(uv,vec2(0.25,0.4), vec2(-0.25,-0.4));"
  "uv.y=abs(uv.y);"
  "float x = length(vec2(max(0.,abs(uv.x)-.25),uv.y-.4));"
  "return min(x,l);"
"}"
"float AA(vec2 uv) {"
  "float x = length(vec2("
  "abs(length(vec2(uv.x,"
  "max(0.0,uv.y-.35) ))-0.25)"
  ",min(0.,uv.y+.4)));"
  "return min(x,length(vec2(max(0.,abs(uv.x)-.25),uv.y-.1) ));"
"}"
"float BB(vec2 uv) {"
  "uv.y -=.1;"
  "uv.y = abs(uv.y);"
  "float x = length(vec2("
  "abs(length(vec2(max(0.0,uv.x),"
  "uv.y-.25))-0.25)"
  ",min(0.,uv.x+.25)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y)-.5)) ));"
"}"
"float CC(vec2 uv) {"
  "float x = abs(length(vec2(uv.x,max(0.,abs(uv.y-.1)-.25)))-.25);"
  "uv.y -= .1;"
  "uv.y= abs(uv.y);"
  "return uv.x<0.||atan(uv.x,uv.y-0.25)<1.14?x:"
  "min(length(vec2(uv.x+.25,max(0.0,abs(uv.y)-.25))),"
  "length(uv+vec2(-.22734,-.354)));"
"}"
"float DD(vec2 uv) {"
  "uv.y -=.1;"
  "float x = length(vec2("
  "abs(length(vec2(max(0.0,uv.x),"
  "max(0.0,abs(uv.y)-.25)))-0.25)"
  ",min(0.,uv.x+.25)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y)-.5)) ));"
"}"
"float EE(vec2 uv) {"
  "uv.y -=.1;"
  "uv.y = abs(uv.y);"
  "float x = min(length(vec2(max(0.,abs(uv.x)-.25),uv.y)),"
  "length(vec2(max(0.,abs(uv.x)-.25),uv.y-.5)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y)-.5))));"
"}"
"float FF(vec2 uv) {"
  "uv.y -=.1;"
  "float x = min(length(vec2(max(0.,abs(uv.x)-.25),uv.y)),"
  "length(vec2(max(0.,abs(uv.x)-.25),uv.y-.5)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y)-.5))));"
"}"
"float GG(vec2 uv) {"
  "float x = abs(length(vec2(uv.x,max(0.,abs(uv.y-.1)-.25)))-.25);"
  "uv.y -= .1;"
  "float a = atan(uv.x,max(0.,abs(uv.y)-0.25));"
  "x = uv.x<0.||a<1.14 || a>3.?x:"
  "min(length(vec2(uv.x+.25,max(0.0,abs(uv.y)-.25))),"
  "length(uv+vec2(-.22734,-.354)));"
  "x = min(x,line(uv,vec2(.22734,-.1),vec2(.22734,-.354)));"
  "return min(x,line(uv,vec2(.22734,-.1),vec2(.05,-.1)));"
"}"
"float HH(vec2 uv) {"
  "uv.y -=.1;"
  "uv.x = abs(uv.x);"
  "float x = length(vec2(max(0.,abs(uv.x)-.25),uv.y));"
  "return min(x,length(vec2(uv.x-.25,max(0.,abs(uv.y)-.5))));"
"}"
"float II(vec2 uv) {"
  "uv.y -= .1;"
  "float x = length(vec2(uv.x,max(0.,abs(uv.y)-.5)));"
  "uv.y = abs(uv.y);"
  "return min(x,length(vec2(max(0.,abs(uv.x)-.1),uv.y-.5)));"
"}"
"float JJ(vec2 uv) {"
  "uv.x += .125;"
  "float x = length(vec2("
  "abs(length(vec2(uv.x,"
  "min(0.0,uv.y+.15) ))-0.25)"
  ",max(0.,max(-uv.x,uv.y-.6))));"
  "return min(x,length(vec2(max(0.,abs(uv.x-.125)-.125),uv.y-.6)));"
"}"
"float KK(vec2 uv) {"
  "float x = line(uv,vec2(-.25,-.1), vec2(0.25,0.6));"
  "x = min(x,line(uv,vec2(-.1, .1), vec2(0.25,-0.4)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y-.1)-.5))));"
"}"
"float LL(vec2 uv) {"
  "uv.y -=.1;"
  "float x = length(vec2(max(0.,abs(uv.x)-.2),uv.y+.5));"
  "return min(x,length(vec2(uv.x+.2,max(0.,abs(uv.y)-.5))));"
"}"
"float MM(vec2 uv) {"
  "uv.y-=.1;"
  "float x = min(length(vec2(uv.x-.35,max(0.,abs(uv.y)-.5))),"
  "line(uv,vec2(-.35,.5),vec2(.0,-.1)));"
  "x = min(x,line(uv,vec2(.0,-.1),vec2(.35,.5)));"
  "return min(x,length(vec2(uv.x+.35,max(0.,abs(uv.y)-.5))));"
"}"
"float NN(vec2 uv) {"
  "uv.y-=.1;"
  "float x = min(length(vec2(uv.x-.25,max(0.,abs(uv.y)-.5))),"
  "line(uv,vec2(-.25,.5),vec2(.25,-.5)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y)-.5))));"
"}"
"float OO(vec2 uv) {"
  "return abs(length(vec2(uv.x,max(0.,abs(uv.y-.1)-.25)))-.25);"
"}"
"float PP(vec2 uv) {"
  "float x = length(vec2("
  "abs(length(vec2(max(0.0,uv.x),"
  "uv.y-.35))-0.25)"
  ",min(0.,uv.x+.25)));"
  "return min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y-.1)-.5)) ));"
"}"
"float QQ(vec2 uv) {"
  "float x = abs(length(vec2(uv.x,max(0.,abs(uv.y-.1)-.25)))-.25);"
  "uv.y += .3;"
  "uv.x -= .2;"
  "return min(x,length(vec2(abs(uv.x+uv.y),max(0.,abs(uv.x-uv.y)-.2)))/sqrt(2.));"
"}"
"float RR(vec2 uv) {"
  "float x = length(vec2("
  "abs(length(vec2(max(0.0,uv.x),"
  "uv.y-.35))-0.25)"
  ",min(0.,uv.x+.25)));"
  "x = min(x,length(vec2(uv.x+.25,max(0.,abs(uv.y-.1)-.5)) ));"
  "return min(x,line(uv,vec2(0.0,0.1),vec2(0.25,-0.4)));"
"}"
"float SS(vec2 uv) {"
  "uv.y -= .1;"
  "if (uv.y <.275-uv.x*.5 && uv.x>0. || uv.y<-.275-uv.x*.5)"
  "uv = -uv;"
  "float a = abs(length(vec2(max(0.,abs(uv.x)),uv.y-.25))-.25);"
  "float b = length(vec2(uv.x-.236,uv.y-.332));"
  "float x = atan(uv.x-.05,uv.y-0.25)<1.14?a:b;"
  "return x;"
"}"
"float TT(vec2 uv) {"
  "uv.y -= .1;"
  "float x = length(vec2(uv.x,max(0.,abs(uv.y)-.5)));"
  "return min(x,length(vec2(max(0.,abs(uv.x)-.25),uv.y-.5)));"
"}"
"float UU(vec2 uv) {"
  "float x = length(vec2("
  "abs(length(vec2(uv.x,"
  "min(0.0,uv.y+.15) ))-0.25)"
  ",max(0.,uv.y-.6)));"
  "return x;"
"}"
"float VV(vec2 uv) {"
  "uv.x=abs(uv.x);"
  "return line(uv,vec2(0.25,0.6), vec2(0.,-0.4));"
"}"
"float WW(vec2 uv) {"
  "uv.x=abs(uv.x);"
  "return min(line(uv,vec2(0.3,0.6), vec2(.2,-0.4)),"
  "line(uv,vec2(0.2,-0.4), vec2(0.,0.2)));"
"}"
"float XX(vec2 uv) {"
  "uv.y -= .1;"
  "uv=abs(uv);"
  "return line(uv,vec2(0.,0.), vec2(.3,0.5));"
"}"
"float YY(vec2 uv) {"
  "return min(min(line(uv,vec2(.0, .1), vec2(-.3, 0.6)),"
  "line(uv,vec2(.0, .1), vec2( .3, 0.6))),"
  "length(vec2(uv.x,max(0.,abs(uv.y+.15)-.25))));"
"}"
"float ZZ(vec2 uv) {"
  "float l = line(uv,vec2(0.25,0.6), vec2(-0.25,-0.4));"
  "uv.y-=.1;"
  "uv.y=abs(uv.y);"
  "float x = length(vec2(max(0.,abs(uv.x)-.25),uv.y-.5));"
  "return min(x,l);"
"}"
"float _11(vec2 uv) {"
  "return min(min("
  "line(uv,vec2(-0.2,0.45),vec2(0.,0.6)),"
  "length(vec2(uv.x,max(0.,abs(uv.y-.1)-.5)))),"
  "length(vec2(max(0.,abs(uv.x)-.2),uv.y+.4)));"
"}"
"float _22(vec2 uv) {"
  "float x = min(line(uv,vec2(0.185,0.17),vec2(-.25,-.4)),"
  "length(vec2(max(0.,abs(uv.x)-.25),uv.y+.4)));"
  "uv.y-=.35;"
  "uv.x += 0.025;"
  "return min(x,abs(atan(uv.x,uv.y)-0.63)<1.64?abs(length(uv)-.275):"
  "length(uv+vec2(.23,-.15)));"
"}"
"float _33(vec2 uv) {"
  "uv.y-=.1;"
  "uv.y = abs(uv.y);"
  "uv.y-=.25;"
  "return atan(uv.x,uv.y)>-1.?abs(length(uv)-.25):"
  "min(length(uv+vec2(.211,-.134)),length(uv+vec2(.0,.25)));"
"}"
"float _44(vec2 uv) {"
  "float x = min(length(vec2(uv.x-.15,max(0.,abs(uv.y-.1)-.5))),"
  "line(uv,vec2(0.15,0.6),vec2(-.25,-.1)));"
  "return min(x,length(vec2(max(0.,abs(uv.x)-.25),uv.y+.1)));"
"}"
"float _55(vec2 uv) {"
  "float b = min(length(vec2(max(0.,abs(uv.x)-.25),uv.y-.6)),"
  "length(vec2(uv.x+.25,max(0.,abs(uv.y-.36)-.236))));"
  "uv.y += 0.1;"
  "uv.x += 0.05;"
  "float c = abs(length(vec2(uv.x,max(0.,abs(uv.y)-.0)))-.3);"
  "return min(b,abs(atan(uv.x,uv.y)+1.57)<.86 && uv.x<0.?"
  "length(uv+vec2(.2,.224))"
  ":c);"
"}"
"float _66(vec2 uv) {"
  "uv.y-=.075;"
  "uv = -uv;"
  "float b = abs(length(vec2(uv.x,max(0.,abs(uv.y)-.275)))-.25);"
  "uv.y-=.175;"
  "float c = abs(length(vec2(uv.x,max(0.,abs(uv.y)-.05)))-.25);"
  "return min(c,cos(atan(uv.x,uv.y+.45)+0.65)<0.||(uv.x>0.&& uv.y<0.)?b:"
  "length(uv+vec2(0.2,0.6)));"
"}"
"float _77(vec2 uv) {"
  "return min(length(vec2(max(0.,abs(uv.x)-.25),uv.y-.6)),"
  "line(uv,vec2(-0.25,-0.39),vec2(0.25,0.6)));"
"}"
"float _88(vec2 uv) {"
  "float l = length(vec2(max(0.,abs(uv.x)-.08),uv.y-.1+uv.x*.07));"
  "uv.y-=.1;"
  "uv.y = abs(uv.y);"
  "uv.y-=.245;"
  "return min(abs(length(uv)-.255),l);"
"}"
"float _99(vec2 uv) {"
  "uv.y-=.125;"
  "float b = abs(length(vec2(uv.x,max(0.,abs(uv.y)-.275)))-.25);"
  "uv.y-=.175;"
  "float c = abs(length(vec2(uv.x,max(0.,abs(uv.y)-.05)))-.25);"
  "return min(c,cos(atan(uv.x,uv.y+.45)+0.65)<0.||(uv.x>0.&& uv.y<0.)?b:"
  "length(uv+vec2(0.2,0.6)));"
"}"
"float _00(vec2 uv) {"
  "uv.y-=.1;"
  "return abs(length(vec2(uv.x,max(0.,abs(uv.y)-.25)))-.25);"
"}"
"float ddot(vec2 uv) {"
  "uv.y+=.4;"
  "return length(uv)*0.97;"
"}"
"float comma(vec2 uv) {"
  "return min(ddot(uv),line(uv,vec2(.031,-.405),vec2(-.029,-.52)));"
"}"
"float exclam(vec2 uv) {"
  "return min(ddot(uv),length(vec2(uv.x,max(0.,abs(uv.y-.2)-.4)))-uv.y*.06);"
"}"
"float question(vec2 uv) {"
  "float x = min(ddot(uv),length(vec2(uv.x,max(0.,abs(uv.y+.035)-.1125))));"
  "uv.y-=.35;"
  "uv.x += 0.025;"
  "return min(x,abs(atan(uv.x,uv.y)-1.05)<2.?abs(length(uv)-.275):"
  "length(uv+vec2(.225,-.16))-.0);"
"}"
"float open1(vec2 uv) {"
  "uv.x-=.62;"
  "return abs(atan(uv.x,uv.y)+1.57)<1.?"
  "abs(length(uv)-.8)"
  ":length(vec2(uv.x+.435,abs(uv.y)-.672));"
"}"
"float close1(vec2 uv) {"
  "uv.x = -uv.x;"
  "return open1(uv);"
"}"
"float dotdot(vec2 uv) {"
  "uv.y -= .1;"
  "uv.y = abs(uv.y);"
  "uv.y-=.25;"
  "return length(uv);"
"}"
"float dotcomma(vec2 uv) {"
  "uv.y -= .1;"
  "float x = line(uv,vec2(.0,-.28),vec2(-.029,-.32));"
  "uv.y = abs(uv.y);"
  "uv.y-=.25;"
  "return min(length(uv),x);"
"}"
"float eequal(vec2 uv) {"
  "uv.y -= .1;"
  "uv.y = abs(uv.y);"
  "return length(vec2(max(0.,abs(uv.x)-.25),uv.y-.15));"
"}"
"float aadd(vec2 uv) {"
  "uv.y -= .1;"
  "return min(length(vec2(max(0.,abs(uv.x)-.25),uv.y)),"
  "length(vec2(uv.x,max(0.,abs(uv.y)-.25))));"
"}"
"float ssub(vec2 uv) {"
  "return length(vec2(max(0.,abs(uv.x)-.25),uv.y-.1));"
"}"
"float mmul(vec2 uv) {"
  "uv.y -= .1;"
  "uv = abs(uv);"
  "return min(line(uv,vec2(0.866*.25,0.5*.25),vec2(0.))"
  ",length(vec2(uv.x,max(0.,abs(uv.y)-.25))));"
"}"
"float ddiv(vec2 uv) {"
  "return line(uv,vec2(-0.25,-0.4),vec2(0.25,0.6));"
"}"
"float lt(vec2 uv) {"
  "uv.y-=.1;"
  "uv.y = abs(uv.y);"
  "return line(uv,vec2(0.25,0.25),vec2(-0.25,0.));"
"}"
"float gt(vec2 uv) {"
  "uv.x=-uv.x;"
  "return lt(uv);"
"}"
"float hash(vec2 uv) {"
  "uv.y-=.1;"
  "uv.x -= uv.y*.1;"
  "uv = abs(uv);"
  "return min(length(vec2(uv.x-.125,max(0.,abs(uv.y)-.3))),"
  "length(vec2(max(0.,abs(uv.x)-.25),uv.y-.125)));"
"}"
"float and(vec2 uv) {"
  "uv.y-=.44;"
  "uv.x+=.05;"
  "float x = abs(atan(uv.x,uv.y))<2.356?abs(length(uv)-.15):1.0;"
  "x = min(x,line(uv,vec2(-0.106,-0.106),vec2(0.4,-0.712)));"
  "x = min(x,line(uv,vec2( 0.106,-0.106),vec2(-0.116,-0.397)));"
  "uv.x-=.025;"
  "uv.y+=.54;"
  "x = min(x,abs(atan(uv.x,uv.y)-.785)>1.57?abs(length(uv)-.2):1.0);"
  "return min(x,line(uv,vec2( 0.141,-0.141),vec2( 0.377,0.177)));"
"}"
"float or(vec2 uv) {"
  "uv.y -= .1;"
  "return length(vec2(uv.x,max(0.,abs(uv.y)-.5)));"
"}"
"float und(vec2 uv) {"
  "return length(vec2(max(0.,abs(uv.x)-.25),uv.y+.4));"
"}"
"float open2(vec2 uv) {"
  "uv.y -= .1;"
  "uv.y = abs(uv.y);"
  "return min(length(vec2(uv.x+.125,max(0.,abs(uv.y)-.5))),"
  "length(vec2(max(0.,abs(uv.x)-.125),uv.y-.5)));"
"}"
"float close2(vec2 uv) {"
  "uv.x=-uv.x;"
  "return open2(uv);"
"}"
"float open3(vec2 uv) {"
  "uv.y -= .1;"
  "uv.y = abs(uv.y);"
  "float x = length(vec2("
  "abs(length(vec2((uv.x*sign(uv.y-.25)-.2),"
  "max(0.0,abs(uv.y-.25)-.05) ))-0.2)"
  ",max(0.,abs(uv.x)-.2)));"
  "return x;"
"}"
"float close3(vec2 uv) {"
  "uv.x=-uv.x;"
  "return open3(uv);"
"}"
"vec2 clc(vec2 uv, float cp, float w, float ital) {"
  "return uv-vec2(cp-(w*.5)+uv.y*ital,0.);"
"}"
"bool hit(vec2 uv,inout float cp,float w, float px) {"
  "return abs((cp+=w)-uv.x)<w+.2;"
"}"
"\n#define ch(l,w) if (hit(uv,cp,w,px)) { x=min(x,l(clc(uv,cp,w,ital))); us=cur;}\n"
"#define a_ ch(aa,0.7);\n"
"#define b_ ch(bb,0.7);\n"
"#define c_ ch(cc,0.7);\n"
"#define d_ ch(dd,0.7);\n"
"#define e_ ch(ee,0.7);\n"
"#define f_ ch(ff,0.6);\n"
"#define g_ ch(gg,0.7);\n"
"#define h_ ch(hh,0.7);\n"
"#define i_ ch(ii,0.3);\n"
"#define j_ ch(jj,0.3);\n"
"#define k_ ch(kk,0.7);\n"
"#define l_ ch(ll,0.3);\n"
"#define m_ ch(mm,0.9);\n"
"#define n_ ch(nn,0.7);\n"
"#define o_ ch(oo,0.7);\n"
"#define p_ ch(pp,0.7);\n"
"#define q_ ch(qq,0.7);\n"
"#define r_ ch(rr,0.7);\n"
"#define s_ ch(ss,0.7);\n"
"#define t_ ch(tt,0.7);\n"
"#define u_ ch(uu,0.7);\n"
"#define v_ ch(vv,0.7);\n"
"#define w_ ch(ww,0.9);\n"
"#define x_ ch(xx,0.8);\n"
"#define y_ ch(yy,0.8);\n"
"#define z_ ch(zz,0.7);\n"
"#define A_ ch(AA,0.7);\n"
"#define B_ ch(BB,0.7);\n"
"#define C_ ch(CC,0.7);\n"
"#define D_ ch(DD,0.7);\n"
"#define E_ ch(EE,0.7);\n"
"#define F_ ch(FF,0.7);\n"
"#define G_ ch(GG,0.7);\n"
"#define H_ ch(HH,0.7);\n"
"#define I_ ch(II,0.5);\n"
"#define J_ ch(JJ,0.5);\n"
"#define K_ ch(KK,0.7);\n"
"#define L_ ch(LL,0.5);\n"
"#define M_ ch(MM,0.9);\n"
"#define N_ ch(NN,0.7);\n"
"#define O_ ch(OO,0.7);\n"
"#define P_ ch(PP,0.7);\n"
"#define Q_ ch(QQ,0.7);\n"
"#define R_ ch(RR,0.7);\n"
"#define S_ ch(SS,0.7);\n"
"#define T_ ch(TT,0.7);\n"
"#define U_ ch(UU,0.7);\n"
"#define V_ ch(VV,0.7);\n"
"#define W_ ch(WW,0.9);\n"
"#define X_ ch(XX,0.8);\n"
"#define Y_ ch(YY,0.8);\n"
"#define Z_ ch(ZZ,0.7);\n"
"#define _1 ch(_11,0.7);\n"
"#define _2 ch(_22,0.7);\n"
"#define _3 ch(_33,0.7);\n"
"#define _4 ch(_44,0.7);\n"
"#define _5 ch(_55,0.7);\n"
"#define _6 ch(_66,0.7);\n"
"#define _7 ch(_77,0.7);\n"
"#define _8 ch(_88,0.7);\n"
"#define _9 ch(_99,0.7);\n"
"#define _0 ch(_00,0.7);\n"
"#define _dot ch(ddot,0.3);\n"
"#define _comma ch(comma,0.3);\n"
"#define _exclam ch(exclam,0.3);\n"
"#define _question ch(question,0.8);\n"
"#define _open1 ch(open1,0.7);\n"
"#define _close1 ch(close1,0.7);\n"
"#define _dotdot ch(dotdot,0.3);\n"
"#define _dotcomma ch(dotcomma,0.3);\n"
"#define _equal ch(eequal,0.7);\n"
"#define _add ch(aadd,0.7);\n"
"#define _sub ch(ssub,0.7);\n"
"#define _mul ch(mmul,0.7);\n"
"#define _div ch(ddiv,0.7);\n"
"#define _lt ch(lt,0.7);\n"
"#define _gt ch(gt,0.7);\n"
"#define _hash ch(hash,0.7);\n"
"#define _and ch(and,0.9);\n"
"#define _or ch(or,0.3);\n"
"#define _und ch(und,0.7);\n"
"#define _open2 ch(open2,0.6);\n"
"#define _close2 ch(close2,0.6);\n"
"#define _open3 ch(open3,0.7);\n"
"#define _close3 ch(close3,0.7);\n"
"#define _ cp+=.5;\n"
"#define BOLD cur.w = 1.5-cur.w;\n"
"#define ITAL ital = 0.15-ital;\n"
"#define RED cur.r = 0.8-cur.r;\n"
"#define GREEN cur.g = 0.6-cur.g;\n"
"#define BLUE cur.b = 1.0-cur.b;\n"
"#define crlf uv.y += 2.0; cp = 0.;\n"
"void text(vec2 uv, inout float cp, float px, inout float x, inout vec4 cur, inout vec4 us, float ital);"
"const float instCount = 11.0;"
"const float nbNotes = 128.0;"
"float getNoteVelocity(float n, float inst)"
"{"
  "vec2 tex;"
  "tex.x = n/nbNotes + 0.5/nbNotes;"
  "tex.y = inst/instCount + 0.5/instCount;"
  "return texture2D(notes_velocity,tex).x;"
"}"
"void main()"
"{"
  "float scale = 1.1/2.5;"
  "vec2 mcoords = coords;"
  "mcoords.y +=0.1;"
  "vec2 uv = mcoords * 22.0 * scale;"
  "uv.x = uv.x * xy_scale_factor;"
  "float px = 22.0/600.0*scale;"
  "float x = 100.;"
  "float cp = 0.;"
  "vec4 cur = vec4(0.,0.,0.,0.5);"
  "vec4 us = cur;"
  "float ital = 0.0;"
  "uv.x += 10.1;"
  "int lnr = int(floor(uv.y/2.0));"
  "uv.y = mod(uv.y,2.0)-1.0;"
"if (lnr==0) { text(uv,cp,px,x,cur,us,ital); }"
  "vec2 nuv = coords*0.5 + vec2(0.5,0.0);"
  "nuv.x *= xy_scale_factor;"
  "nuv.x = 2.0 - nuv.x;"
  "float vel = 0.0;"
  "for (float i = 0.0; i < instCount ;i++)"
  "{"
    "vel = max(vel, getNoteVelocity((0.1+0.3*nuv.x)*nbNotes,i));"
  "}"
  "float weight = 0.08*vel+0.01+us.w*min(sequence_time*.02-.03,0.03);"
  "vec3 back_color = vec3(0.0);"
  "vec3 text_color = vec3(0.7, 0.6, 0.3);"
  "vec3 color = mix(text_color,back_color,smoothstep(weight-px,weight+px, x));"
  "vec3 color_inv = text_color-color;"
  "color = mix(color, color_inv,min(vel,abs(0.5*nuv.y)));"
  "if (sequence_time > 3.)"
  "{"
    "color.xyz *= exp(3.-sequence_time);"
  "}"
  "gl_FragColor = vec4(color,1.0);"
"}";
const char* const fs_raymarcher = 
"\n#version 120\n"
"#define PI 3.14159265\n"
"uniform sampler2D notes_velocity;"
"varying vec2 coords;"
"uniform float xy_scale_factor;"
"uniform float sequence_time;"
"uniform float track_time;"
"uniform vec3 cam_position;"
"uniform vec4 cam_rotation;"
"const float instCount = 11.0;"
"const float nbNotes = 128.0;"
"const float dLimit = 0.001;"
"const float dFar = 60.;"
"float rd_m = .9;"
"const vec3 forward = vec3(0.0,0.0,1.0);"
"float snare = 0.0;"
"\n#define MAT_SKY 0.\n"
"#define MAT_MIRROR 1.\n"
"#define MAT_PYRAMID 2.\n"
"#define MAT_SAND 3.\n"
"#define MAT_BLACKMIRROR 4.\n"
"#define mmin(v,mat,d) (v.x>d ? vec2(d,mat) : v);\n"
"#define fmin(v,mat,f,d) (v.x>f ? vec2(d,mat) : v);\n"
"vec2 map(vec3 p);"
"vec4 shade(vec3 p, vec3 n, vec3 ro, vec3 rd, float mat);"
"void globals();"
"float vmax(vec3 v) {"
  "return max(max(v.x, v.y), v.z);"
"}"
"float fBoxCheap(vec3 p, vec3 b) {"
  "return vmax(abs(p) - b);"
"}"
"void pR(inout vec2 p, float a) {"
  "p = cos(a)*p + sin(a)*vec2(p.y, -p.x);"
"}"
"float pModPolar(inout vec2 p, float repetitions) {"
  "float angle = 2.*PI/repetitions;"
  "float a = atan(p.y, p.x) + angle/2.;"
  "float r = length(p);"
  "float c = floor(a/angle);"
  "a = mod(a,angle) - angle/2.;"
  "p = vec2(cos(a), sin(a))*r;"
  "if (abs(c) >= (repetitions/2.)) c = abs(c);"
  "return c;"
"}"
"float fOpUnionStairs(float a, float b, float r, float n) {"
  "float s = r/n;"
  "float u = b-r;"
  "return min(min(a,b), 0.5 * (u + a + abs ((mod (u - a + s, 2. * s)) - s)));"
"}"
"float fPlane(vec3 p, vec3 n, float distanceFromOrigin) {"
  "return dot(p, n) + distanceFromOrigin;"
"}"
"float snoise(vec2 p) {"
  "vec2 f = fract(p);"
  "p = floor(p);"
  "float v = p.x+p.y*1000.0;"
  "vec4 r = vec4(v, v+1.0, v+1000.0, v+1001.0);"
  "r = fract(100000.0*sin(r*.001));"
  "f = f*f*(3.0-2.0*f);"
  "return 2.0*(mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y))-1.0;"
"}"
"float terrainSand(vec2 p, int octaves) {"
  "float h = 0.0;"
  "float f = 1.0;"
  "for (int i=0 ; i<octaves ; i++) {"
    "h += abs(snoise(p*f)/f);"
    "f *= 2.0;"
  "}"
  "return h;"
"}"
"vec3 normal( in vec3 p )"
"{"
  "vec3 eps = vec3(0.01, 0.0, 0.0);"
  "return normalize( vec3("
  "map(p+eps.xyy).x-map(p-eps.xyy).x,"
  "map(p+eps.yxy).x-map(p-eps.yxy).x,"
  "map(p+eps.yyx).x-map(p-eps.yyx).x"
  ") );"
"}"
"float ambientOcclusion( in vec3 pos, in vec3 nor )"
"{"
  "float ao = 0.0;"
  "float sca = 15.0;"
  "for( int i=0; i<5; i++ )"
  "{"
    "float hr = 1.5*(0.01 + 0.015*float(i*i));"
    "float dd = map( pos + hr*nor ).x;"
    "ao += (hr-dd);"
    "sca *= 0.5;"
  "}"
  "return 1.0 - clamp( ao, 0.0, 1.0 );"
"}"
"float pale(vec3 p, float r, float height) {"
  "float d = length(p.yz) - r;"
  "d = max(d, abs(p.x) - height);"
  "vec3 ps = p;"
  "ps.y *= 3.;"
  "float h = length(ps - vec3(height/2.,-height/1.2,0.)) - height/1.;"
  "return max(-h,d);"
"}"
"float getNoteVelocity(float n, float inst)"
"{"
  "vec2 tex;"
  "tex.x = n/nbNotes + 0.5/nbNotes;"
  "tex.y = inst/instCount + 0.5/instCount;"
  "return texture2D(notes_velocity,tex).x;"
"}"
"vec3 rotate_dir(vec4 q, vec3 dir)"
"{"
  "vec3 v = dir.xyz;"
  "return v + 2.0 * cross(q.xyz, cross(q.xyz, v) + q.w * v);"
"}"
"vec4 rm(vec3 ro, vec3 rd)"
"{"
  "vec3 p = ro;"
  "float d;"
  "vec2 dmat;"
  "for (int i = 0; i < 96; i++)"
  "{"
    "dmat = map(p);"
    "d = distance(ro, p);"
    "if (abs(dmat.x) < dLimit || d > dFar)"
    "{"
      "break;"
    "}"
    "p += rd * dmat.x * rd_m;"
  "}"
  "return vec4(p, dmat.y);"
"}"
"void main()"
"{"
  "vec3 color = vec3(1.);"
  "vec2 uv = vec2(coords.x*xy_scale_factor,coords.y);"
  "vec3 ro = cam_position;"
  "vec3 rd = rotate_dir(cam_rotation, normalize(vec3(uv,2.0)));"
  "vec3 n;"
  "vec4 pmat;"
  "snare = max("
  "max("
  "max(getNoteVelocity(81.,4.),getNoteVelocity(74.,4.)),"
  "getNoteVelocity(62.,4.)),"
  "getNoteVelocity(86.,4.));"
  "globals();"
  "for (int i = 0; i < 3; i++)"
  "{"
    "pmat = rm(ro,rd);"
    "n = normal(pmat.xyz);"
    "vec4 cr = shade(pmat.xyz, n, ro, rd, pmat.w);"
    "color = cr.xyz * color;"
    "if (cr.w > 0.)"
    "{"
      "ro = pmat.xyz + n*4.*dLimit;"
      "rd = reflect(rd, n);"
    "}"
    "else"
    "{"
      "break;"
    "}"
  "}"
  "color = pow(color, vec3(1.5/2.2));"
  "gl_FragColor = vec4(color,1.0);"
"}";
