{ SCROLL UNIT : Programmation SQUIRREL }
{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P+,Q-,R-,S+,T+,V+,X+}
Unit Scroll;

INTERFACE

PROCEDURE Scroll_Up (x, y, l, h : word; speed : byte);
PROCEDURE Scroll_Down (x, y, l, h : word; speed : byte);

IMPLEMENTATION

{ 640x350 & 640x480  ...  x16 }

PROCEDURE Scroll_Up (x, y, l, h : word; speed : byte);
ASSEMBLER;
ASM
    push  ds               { sauver DS ! }

    mov   dx, $3CE         { Graphique controleur }
    mov   ax, $0105        { $01 Write 1/Read 0. $05 reg. Mode  }
    out   dx, ax

    cld                    { tant qu' faire, autant aller dans le bon sens }

    mov   cx, h
    mov   ax, cx
    shl   ax, 4
    shl   cx, 6
    add   cx, ax           { cx = h * 80 }

    mov   bx, y
    mov   ax, bx
    shl   ax, 4
    shl   bx, 6
    add   bx, ax           { bx = y * 80 }
    mov   ax, x
    shr   ax, 3
    add   bx, ax           { bx = y * 80 + x / 8 }

    xor   dh, dh
    mov   dl, speed
    mov   ax, dx
    shl   ax, 4
    shl   dx, 6
    add   dx, ax           { dx = vitesse * 80 }

    mov   ax, cx           { ax = cx = nombre de dplacements }
    add   ax, bx

    mov   cl, test8086                              { Type de processeur.. }

    mov   si, $A000
    mov   ds, si
    mov   es, si           { ds & es ^ $A000, Mmoire vido }

    cmp   cl, 1                                        { je me passe du G+ }
{    je    @yop286          { Instructions 16 bits }
{    ja    @yop386          { Instructions 32 bits }
                            { sinon, simples instr. 8 bits }

{[08][ 8086 only ] }
@yop8086:                  { boucle... }

    mov   si, bx
    mov   di, si
    sub   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 3
    rep   movsb            { On repete cx fois }

    add   bx, 80           { incrementer l'offset }
    cmp   bx, ax
    jb    @yop8086         { pas fini ? ---> yop ! }

    jmp   @fin


{[16][ 80286 only ] }
@yop286:                   { boucle... }

    mov   si, bx
    mov   di, si
    sub   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 4
    rep   movsw            { On repete cx fois des word }
    test  l, 8             { Paire ??? }
    jz    @Paire16bit
    movsb                  { c'est impair ! }

@Paire16bit:
    add   bx, 80           { incrementer le deplacement }
    cmp   bx, ax
    jb    @yop286          { pas fini ? ---> yop ! }

    jmp   @fin

{[32][ 80386 et suivants ] }
@yop386:                   { boucle... }

    mov   si, bx
    mov   di, si
    sub   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 5
  { rep   movsd            { On repete cx fois des long } db $F3,$66,$A5
    mov   cx, l
    shr   cx, 3
    and   cx, 3
    rep   movsb            { Complement  4 }

    add   bx, 80           { incrementer le deplacement }
    cmp   bx, ax
    jb    @yop386          { pas fini ? ---> yop ! }

    jmp   @fin

@fin:
    pop   ds               { on restaure DS }
  END;

PROCEDURE Scroll_Down (x, y, l, h : word; speed : byte);
ASSEMBLER;
ASM
    push  ds               { sauver DS ! }

    mov   dx, $3CE         { Graphique controleur }
    mov   ax, $0105        { $01 Write 1/Read 0. $05 reg. Mode  }
    out   dx, ax

    cld

    mov   cx, h
    mov   ax, cx
    shl   ax, 4
    shl   cx, 6
    add   cx, ax           { cx = h * 80 }

    mov   bx, y
    mov   ax, bx
    shl   ax, 4
    shl   bx, 6
    add   bx, ax           { bx = y * 80 }
    mov   ax, x
    shr   ax, 3
    add   bx, ax           { bx = y * 80 + x / 8 }

    xor   dh, dh
    mov   dl, speed
    mov   ax, dx
    shl   ax, 4
    shl   dx, 6
    add   dx, ax           { dx = vitesse * 80 }

    mov   ax, cx           { ax = cx = nombre de dplacements }

    mov   cl, test8086                              { Type de processeur.. }

    mov   si, $A000
    mov   ds, si
    mov   es, si           { ds & es ^ $A000, Mmoire vido }

    cmp   cl, 1                                        { je me passe du G+ }
{    je    @yop286          { Instructions 16 bits }
{    ja    @yop386          { Instructions 32 bits }
                           { sinon, simples instr. 8 bits }

{[08][ 8086 only ] }
@yop8086:                  { boucle... }

    mov   si, bx
    add   si, ax
    mov   di, si
    add   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 3
    rep   movsb            { On repete cx fois }

    sub   ax, 80           { incrementer l'offset }
    cmp   ax, 0
    ja    @yop8086         { pas fini ? ---> yop ! }

    jmp   @fin


{[16][ 80286 only ] }
@yop286:                   { boucle... }

    mov   si, bx
    add   si, ax           { si = bx + cx soit offset + deplacement }
    mov   di, si
    add   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 4
    rep   movsw            { On repete cx fois des word }
    test  l, 8             { Paire ??? }
    jz    @Paire16bit
    movsb                  { c'est impair ! }

@Paire16bit:
    sub   ax, 80           { incrementer le deplacement }
    cmp   ax, 0
    jne   @yop286          { pas fini ? ---> yop ! }

    jmp   @fin

{[32][ 80386 et suivants ] }
@yop386:                   { boucle... }

    mov   si, bx
    add   si, ax           { si = bx + cx soit offset + deplacement }
    mov   di, si
    add   di, dx           { di = si + vitesse de dplacement }

    mov   cx, l            { cx = largeur / 8 }
    shr   cx, 5
  { rep   movsd            { On repete cx fois des long } db $F3,$66,$A5
    mov   cx, l
    shr   cx, 3
    and   cx, 3
    rep   movsb            { Complement  4 }

    sub   ax, 80           { incrementer le deplacement }
    cmp   ax, 0
    jne   @yop386          { pas fini ? ---> yop ! }

    jmp   @fin

@fin:
    pop   ds               { on restaure DS }
  END;

END.


Les dplacements 16/32 bits ne marchent pas car la carte VGA s'embrouille
les papattes dans ses registres latches. Je n'ai pas encore tout compris
sur le sujet, mais il est claire qu'en lisant 2 ou 4 octets  la fois,
l'ensemble des registres latches qui l'entoure ne peuvent contenir eux
de 2  4 valeurs !! Donc nous voil condamns au mode 8 bits ! :-(

                                                               Squirrel.
