{}
{ DMA - Unit gestion DMA }
{}
Unit DMA;

INTERFACE {--Globals--------------------------------------------------------}

Const
   DMARead      = $44;  {Mode transfert lecture}
   DMAWrite     = $48;  {Mode transfert criture}

Procedure DMAInit(Channel:BYTE;Mode:BYTE;Count:WORD;Address:POINTER);

IMPLEMENTATION {--Locals----------------------------------------------------}

Const
   DMAMask      : array[0..7] of byte = ($0A,$0A,$0A,$0A,$D4,$D4,$D4,$D4);
   DMAMode      : array[0..7] of byte = ($0B,$0B,$0B,$0B,$D6,$D6,$D6,$D6);
   DMAFlipFlop  : array[0..7] of byte = ($0C,$0C,$0C,$0C,$D8,$D8,$D8,$D8);
   DMACount     : array[0..7] of byte = ($01,$03,$05,$07,$C2,$C6,$CA,$CE);
   DMAAddress   : array[0..7] of byte = ($00,$02,$04,$06,$C0,$C4,$C8,$CC);
   DMAPage      : array[0..7] of byte = ($87,$83,$81,$82,$8F,$8B,$89,$8A);

Procedure DMAInit(Channel:BYTE;Mode:BYTE;Count:WORD;Address:POINTER); assembler;
Asm
        xor     dx,dx
        xor     bx,bx
        mov     bl,Channel

      { Disable canal DMA }
        mov     dl,[offset DMAMask+bx]
        mov     al,bl
        and     al,00000011b
        or      al,00000100b
        out     dx,al

      { Remet Flip-Flop  0 }
        mov     dl,[offset DMAFlipFlop+bx]
        xor     al,al
        out     dx,al

      { Slectionne le mode de transfert }
        mov     dl,[offset DMAMode+bx]
        mov     al,bl
        and     al,00000011b
        or      al,Mode
        out     dx,al

      { Envoie la taille du bloc  transfrer }
        mov     dl,[offset DMACount+bx]
        mov     ax,Count
        out     dx,al
        mov     al,ah
        out     dx,al

      { Envoie l'adresse et la page du bloc }
        mov     cl,4
        mov     ax,word ptr [Address+2]
        mov     ch,ah
        shr     ch,cl
        shl     ax,cl
        add     ax,word ptr [Address]
        adc     ch,0

        {To the dma...}
        mov     dl,[offset DMAAddress+bx]
        out     dx,al
        mov     al,ah
        out     dx,al
        mov     dl,[offset DMAPage+bx]
        mov     al,ch
        out     dx,al

      { Enable canal DMA }
        mov     dl,[offset DMAMask+bx]
        mov     al,bl
        and     al,00000011b
        out     dx,al
End;

End.
