INCLUDE "COUNTER.INC"

ORG 256

RESX EQU 640
RESY EQU 480

 PUSH AX
 MOV BX,013FH;813FH
 OUT 61H,AL

;640x480x32bits video mode:
; #13Fh - VMware
; #121h - ATI/AMD
; #112h - nVidia/Intel/DOSBox
setvideo:
 MOV AX,4F02H
 INT 10H
 SHR    BL,1
 INC    BX
 INC    BX
 CMP    AX,SI
 JNC    setvideo

 OUT 61H,AL
 MOV AL,90H
 OUT 43H,AL

 MOV    SI,DX;0A000H
 MOV    ES,SI

 SUB BX,BX
nextframe:
 CALL ESCAPE
 SHL AX,2
 MOV [SI+5],AX
 CWD
 MOV DI,-1
 MOV BP,RESY*3/2
nextline:
 MOV CX,RESX*4/2;+256
nextpixel:
 INC    DI
 JNZ    nobank
 MOV    AX,4F05H
 INT    10H
 INC    DX
nobank:

shoot:
 PUSHA                  ;   0   +2   +4   +6   +8  +10  +12  +14  +16  +18  +20
 MOV    BP,SP           ;  di   si   bp   sp   bx   dx   cx   ax   ip  256    0
                        ; scr A000    v   -4    0  bnk    u  4FH  ret  256    0
 MOV    DI,MAXCOL
 FILD   WORD [BP+4]             ; v
 FMUL   ST0,ST0                 ; v2
 FILD   WORD [BP+12]            ; u v2
 FMUL   ST0,ST0                 ; u2 v2
 FADDP                          ; u2+v2
 FILD   DWORD [BP+6]            ; r2 u2+v2
 FCOMI  ST0,ST1                 ; r2 u2+v2
 FSUBRP ST1,ST0                 ; z2
 JA     intersection
 MOV    AX,[BP+4]
 DEC    DI
 FLD    ST0
 SAR    AX,2
 JNS    back

 NEG AX

 FILD   WORD [BP+4]
 FIADD  WORD [DI+1]
 FIADD  WORD [BP+7]
 FMUL   ST0,ST0
 FISUB  WORD [SI+4]
 FISTP  DWORD [SI+BP]
 TEST   BYTE [SI+BP+1],111b*32
 JZ     back

 FILD   WORD [BP+12]
 FIDIV  WORD [BP+4]
 FIMUL  WORD [BP+7]
 FISTP  WORD [SI+BP]
 TEST   BYTE [SI+BP],1111B*8
 JZ     back

 SAR AX,1

back:
bgr:
 PUSH   AX                      ; Intensity
 NOT    AH                      ; Shadow test
 AND    AL,AH                   ; Diffuse
 ADD    AL,37                   ; Diffuse+Ambient
 MUL    BYTE [DI+BX]            ; Color*(Diffuse+Ambient)
 FCOMI  ST0,ST1                 ; Shine N.H
 SALC                           ; Highlight test
 OR     AL,AH                   ; Color*(Diffuse+Ambient)+Specular
 ADD    [SI+BX],AL
 POP    AX
 INC    BX
 JPO    bgr
 FCOMPP
 POPA

 MOVSW
 MOVSB
clear:
 DEC    SI
 MOV    [SI],BL
 JPO    clear

 ADD    CX,SP
 CMP    CX,-RESX*4/2+1;+256
 JG     nextpixel
 ADC    BP,SP
 CMP    BP,-RESY*3/2
 JG    nextline

 JMP nextframe

intersection:
 FSQRT                          ; z
 FILD   WORD [BP+4]             ; v z
 FIADD  WORD [BP+12]            ; u+v z
 FADD   ST0,ST1                 ; r*N.S z
 FADD   ST1,ST0                 ; r*N.S r*N.H
 FMUL   DWORD [DI]              ; Intensity r*N.H
 FISTP  WORD [SI+BP]            ; r*N.H
 FILD   WORD [DI]               ; Shine
 MOV    AX,[SI+BP]
 JMP    back

Shine:                          ; 2.4427
MAXCOL  DW 625,3EFAH
