INCLUDE "COUNTER.INC"

BUFFER EQU (256+256)

ORG 256
 DW 127         ; constant 127 -> amplitude for sinus table
;DW 3C00H       ; constant 1/128 -> calculating PI/128 for sinus table

 XCHG AX,CX
 PUSHA
 MOV DI,BUFFER
 MOV SI,image-1
 MOV BL,72
.2:
 LODSW
.3:
 ADD CL,BL
 MOV AL,44
 REP STOSB
 MOV CL,8
 SALC
 REP STOSB
 MOV CX,320-8
 SUB CX,BX
 ADD DX,[SI]
 ADC BL,[SI]
 DEC AX
 REP STOSB
 JNS .3
 INC SI
 CMP BYTE [SI],97
 JNZ .2
 POPA

 MOV BH,0FBH
 CALL SINUS

 PUSH 0A000H-BUFFER/16
 POP ES

 MOV DL,99      ; less garbage at 1st frame
; NEG BP
 MOV BP,3700
nextframe:
 CALL ESCAPE
; MOV AX,[COUNTER]
; SHL AX,1
 MOV BL,AL;H;[COUNTER+1]
nextline:
 NEG CX
nextpixel:
 INC CX
 JNS star

mask:
; LEA SI,[DI+127]
 MOV SI,DI
;_scroll:
 CMP BYTE [SI],BH
 JB copy

star:
 MOV SI,BUFFER+320*40+58
 PUSHA
 MOV DH,CL
 MOV CX,204H
.2:

 MOV AL,[BX]
 IMUL DL
 ADD BL,64
 XCHG DI,AX
 MOV AL,[BX]
 IMUL DH
 ADD AX,DI
 SUB BL,64+51
 CMP AX,BP
 JG .3
 MOV AL,55
 DEC CL
 JZ putpixel
 JMP .2
.3:
 DEC CH
 JNZ .2

tunnel:
 POPA
 PUSHA
 MOV AL,DL
 CBW
 XOR AH,DL
 MOV DH,AH
 MOV AL,CH
 CBW
 XOR AH,CL
 SALC
 SUB AL,DH
 SUB AL,AH
 SUB DH,AH
 MUL AL
 SALC
 XOR AL,AH
 XCHG AL,AH
 SUB AL,BL
 SHL DH,2
 AND AL,DH

 SHR AX,4
 SALC
 AND AL,AH
 ADD AL,16
 CBW

putpixel:
 MOV [SI],AX;EAX
 POPA

copy:
 MOVSB
 CMP CX,160
 JNE nextpixel
 INC DX
 CMP DL,100
 JNE nextline

 MOV DI,BUFFER
; ADD BP,16
; CMP BP,3700
; JL @F
; MOV SI,_scroll-1
; SUB BP,16
; DEC BYTE [SI]
; JNS @F
; INC BYTE [SI]
@@:
; INC BL
 NEG DL
; MOV AX,[COUNTER+1]
; SUB AX,[COUNTER0]
; TEST AH,AH
; JNZ exit
; IN AL,60H
; DEC AX
 JMP nextframe

exit:
RETN

image:
 DB 85,0,84
 DB 2,-6,171
 DB 45,0,100
 DB 1,-8,0
 DB 5,-1,0
 DB 0,26,0
 DB 24,0,102
 DB 4,-6,0
 DB 25,0,97
