INCLUDE "COUNTER.INC"

RESX EQU 320
RESY EQU 200
COLOR EQU 41

_SI2 EQU SI-512-2

ORG 256
 MOV ES,DX
 MOV CH,250
 REP STOSW

 MOV BX,-32
 ADD SI,SI
 MOV WORD [SI],4

nextpixel:
 FLDZ                   ; 0
 FLDZ                   ; 0 0

 PUSHA
 MOV    CL,64
 CWD
 XCHG   AX,DI
 DIV    BP
 SUB    AX,RESY/2
 XCHG   AX,DX
 CMP    AL,60           ; clip the most expensive pixels
 JB     skip2           ; on the left
 SUB    AX,RESX/2
_x2:
 CMP    AX,100          ; and on the right
 JG     skip2
 FILD   WORD [SI]       ; 4 0 0
 FLDZ                   ; 0 4 0 0

march:                  ; o z y x
 FLD    ST3             ; x o z y x
 FMUL   ST0,ST0         ; x2 o z y x
 FLD    ST2             ; z x2 o z y x
 FMUL   ST0,ST0         ; z2 x2 o z y x
 FADDP  ST1,ST0         ; z2+x2 o z y x
 FSQRT                  ; s o z y x
 FISUB  WORD [SI]       ; s-r o z y x
 NEG    CX
 JS     march
 FADD   DWORD [SI+2]    ; t s o z y x
 FIDIV  WORD [_SI2+_x2] ; t/(RX/2) s o z y x
 FLD    ST0             ; t/(RX/2) t/(RX/2) s o z y x
 FLD    ST0             ; t/(RX/2) t/(RX/2) t/(RX/2) s o z y x
m2:
 MOV    [BP+SI],DX
 XCHG   AX,DX
 FIMUL  WORD [BP+SI]    ; t*dy t/(RX/2) s o z y x
 FADDP  ST6,ST0         ; t/(RX/2) s o z y x
 CMC
 JNC    m2

 FIMUL  WORD [SI-512+_x1] ; 2*t s o z y x
 FLD    ST0
 FSTP   TWORD [BP+SI]   ; accuracy test1
 FIDIV  WORD [SI]       ; dz s o z y x
 FADDP  ST3,ST0         ; s o z y x
 FST    ST1             ; o z y x
 FSTP   TWORD [BP+SI-6] ; accuracy test2

 CMP    BYTE [BP+SI+8],254; very low value? exponent test for dz
 JNL    noskip
 CMP    [BP+SI],BX      ; no significat change? mantisa test for s
 MOV    BX,[BP+SI]
 JE     skip
noskip:
 LOOP   march

skip:
 FXCH   ST3             ; x z y m
 FPATAN                 ; atanzx y m
 FXCH   ST2             ; m y atanzx
 FPATAN                 ; atanym atanzx
 FADDP  ST1,ST0         ; atanym+atanzx
 FLDLG2                 ; lg2 atanym+atanzx
skip2:
 POPA

 MOV    [BP+SI],CX
 FIMUL  WORD [BP+SI] ; counter atanym+atanzx
 FADDP  ST1,ST0         ; atanym+atanzx+counter
 FIMUL  WORD [SI-512+_c7]      ; 7*(atanym+atanzx+counter)
 FISTP  WORD [BP+SI] ; -
 AND    WORD [BP+SI],3; mask 2 bits -> 4 colors
 IMUL   AX,[BP+SI],COLOR
 STOSB
 CMP DI,320*200-1
nextframe:
 JBE nextpixel

 CMP    BX,[SI]
 JE     p2
p1:
 INC    BX
p2:
 MOV    [BP+SI],BX
 FILD   WORD [SI]
 FIDIVR WORD [BP+SI]
 FSTP   DWORD [SI+2]

 CALL ESCAPE
 AND AL,254
 XCHG CX,AX

 SUB DI,DI
 JMP nextframe

_c7:
 DW     7               ; constant 7
_x1:
 DW     320
