; ---------------------------------------------------------------------------------
; nanorail - by: superogue/marquee design (superogue1@protonmail.com)
; (c)2020 marquee design
;
; Greetings to: 
; blossom, rrrola, hellmood, tomcat/abaddon, sensenstahl, kuemmel, fsqrt, harekiet
; nuey, bruce, sjaak, ile, aaldert, fready and everyone else at demotivation
; ---------------------------------------------------------------------------------
org 100h

start:
      
push    word 0A000h   
pop     es             
mov     al,13h  
int     10h   

; all aboard?
pusha
mov ah,9
mov dl,text-100h
int 21h
mov di,3246h+(24*320)-16*70-30
mov ch,9
copyloop:
es lodsb
floorval:
aaa
jz addcolor_skip
add al,240
addcolor_skip:
stosw
stosb
loop copyloop
xor di,di
xor ax,ax
mov ch,5
rep stosw
popa

; the train takes off...
mov dx,331h		; 3
mov al,63		; 2
out dx,al		; 1
dec dx			; 1
rep outsb		; 1/2

; bring some color!
mov dx,3C9h 
palloop:
mov ax,cx
neg al
out dx,al
shr  ax,1
out  dx,al
shr  ax,1
out  dx,al
loop palloop

push 0a000h-70
pop es
frameloop:
mainloop:
mov ax,0cccdh 	; bring your coca rrrola
mul di	
sub dh,104
neg dh
xor ax,ax
mov cx,bp
test ch,4
jz storepixel

; the fpu code
fninit			
pusha
fninit
fild word [byte bx-6]		; set camera height
fidiv word [tdiv]
fsin
fmul dword [scalevalue]
fadd dword [addvalue]
fild word [bx-8]			; calculate perspective
fmul st1
fild word [bx-9]
fabs
fdiv st1
fistp word [bx-4]		; to ax
fild word [floorval]
fdiv st1
fist word [bx-6]		; to cx		
popa

; horizon
test dh,128
jnz drawground
; sky
mov ax,bp
shr ax,2
test al,128
jnz noflip
neg al
noflip:
sub al,dh
shr al,2
mov dh,127
test bp,2048
jz drawpixel
add dh,64
jmp drawpixel

drawground:
mov dl,cl
shr dl,1
add al,7
test al,128
jz drawtrack
mov dh,72
tile:
sub cx,bp
xor al,cl
aam 12
aaa
jmp drawpixel

drawtrack:	
test al,7
jnz innertrack
mov dh,248
jmp drawpixel
innertrack:
sub cx,bp
test cl,4
jnz drawbeam
mov dh,16
jmp tile
jmp drawpixel
drawbeam:
xor dx,dx
drawpixel:
add al,dh
storepixel:
stosb
inc di
inc di
jnz mainloop
; to the next frame
inc di
inc bp 		
in al,60h
dec al
jnz frameloop

; intro data
db 0xc3,0x7e,0x93,1,127		; choo choo!
text db 'NANORAIL$'
scalevalue dd 0.15
addvalue dd 0.22	
tdiv dw 0060h

; - enjoy! 


