// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

//Texture shaded polygon filler by Mr.Dsteuz/Proxium
//Last Date: 17 June 1999

unsigned char shade_table[65536];

typedef struct
{
int x,y,u,v,c;
} shaded_texture_vtx;

shaded_texture_vtx spc[3];
int startc,endc,cstepc,crx,clx;

void calculate_shade_table()
{
float a,b,c;
for(b=0;b<255;b++)
{
for(a=0;a<255;a++)
{
if(a<=128) c=b*(a/128); else c=a+(b-128)*((255-a)/127);
shade_table[int(a*256+b)]=c;
}
}
}

void shaded_texture_hline(int x1,int x2,int u1,int u2,int v1,int v2,int c1,int c2,int y)
{
if(y>=cliptop)
{
x1>>=16,x2>>=16,temp=x2-x1;
if(temp!=0) cstepu=(u2-u1)/temp,cstepv=(v2-v1)/temp,cstepc=(c2-c1)/temp;
if(x1<clipleft) u1+=(clipleft-x1)*cstepu,v1+=(clipleft-x1)*cstepv,c1+=(clipleft-x1)*cstepc,x1=clipleft;
if(x2>clipright) x2=clipright;
if((xst=x2-x1)>0)
{
_asm {  push ebp
        mov ebx,0
        mov eax,y
        shl eax,6
        mov edi,eax
        shl eax,2
        add edi,eax
        add edi,x1
        shl edi,2
        add edi,offset frame
        mov eax,ebx
        mov esi,texture_img
        mov cx,word ptr u1+1
        mov dx,word ptr v1+1
l1:     mov bl,ch
        add cx,word ptr cstepu+1
        mov bh,dh
        add dx,word ptr cstepv+1
        mov ax,word ptr c1+1
        add ax,word ptr cstepc+1
        mov word ptr c1+1,ax
        mov al,[esi+ebx*4]
        mov al,[shade_table+eax]
        mov [edi],al
        mov al,[esi+ebx*4+1]
        mov al,[shade_table+eax]
        mov [edi+1],al
        mov al,[esi+ebx*4+2]
        mov al,[shade_table+eax]
        mov [edi+2],al
        add edi,4
        dec xst
        jnz l1
        pop ebp
}
}
}
}

void shaded_texture_poly(unsigned char *texture)
{
texture_img=texture;
if(spc[0].y>spc[1].y)
{
temp=spc[1].x,spc[1].x=spc[0].x,spc[0].x=temp;
temp=spc[1].y,spc[1].y=spc[0].y,spc[0].y=temp;
temp=spc[1].u,spc[1].u=spc[0].u,spc[0].u=temp;
temp=spc[1].v,spc[1].v=spc[0].v,spc[0].v=temp;
temp=spc[1].c,spc[1].c=spc[0].c,spc[0].c=temp;
}
if(spc[1].y>spc[2].y)
{
temp=spc[2].x,spc[2].x=spc[1].x,spc[1].x=temp;
temp=spc[2].y,spc[2].y=spc[1].y,spc[1].y=temp;
temp=spc[2].u,spc[2].u=spc[1].u,spc[1].u=temp;
temp=spc[2].v,spc[2].v=spc[1].v,spc[1].v=temp;
temp=spc[2].c,spc[2].c=spc[1].c,spc[1].c=temp;
}
if(spc[0].y>spc[1].y)
{
temp=spc[1].x,spc[1].x=spc[0].x,spc[0].x=temp;
temp=spc[1].y,spc[1].y=spc[0].y,spc[0].y=temp;
temp=spc[1].u,spc[1].u=spc[0].u,spc[0].u=temp;
temp=spc[1].v,spc[1].v=spc[0].v,spc[0].v=temp;
temp=spc[1].c,spc[1].c=spc[0].c,spc[0].c=temp;
}
if((spc[2].y-spc[0].y)!=0)
{
startx=spc[0].x<<16,endx=startx;
startu=spc[0].u<<16,endu=startu;
startv=spc[0].v<<16,endv=startv;
startc=spc[0].c<<16,endc=startc;
temp=spc[2].y-spc[0].y;
lx=((spc[2].x-spc[0].x)<<16)/temp;
ulx=((spc[2].u-spc[0].u)<<16)/temp;
vlx=((spc[2].v-spc[0].v)<<16)/temp;
clx=((spc[2].c-spc[0].c)<<16)/temp;
if((spc[1].y-spc[0].y)!=0)
{
temp=spc[1].y-spc[0].y;
rx=((spc[1].x-spc[0].x)<<16)/temp;
urx=((spc[1].u-spc[0].u)<<16)/temp;
vrx=((spc[1].v-spc[0].v)<<16)/temp;
crx=((spc[1].c-spc[0].c)<<16)/temp;
while((spc[1].y>spc[0].y)&&(spc[0].y<clipbottom))
{
if(startx<endx) shaded_texture_hline(startx,endx,endu,startu,endv,startv,endc,startc,spc[0].y);
else shaded_texture_hline(endx,startx,startu,endu,startv,endv,startc,endc,spc[0].y);
startx+=rx,endx+=lx,startu+=ulx,endu+=urx,startv+=vlx,endv+=vrx,startc+=clx,endc+=crx,spc[0].y++;
}
}
if((spc[2].y-spc[1].y)!=0)
{
startx=spc[1].x<<16;
endu=spc[1].u<<16,endv=spc[1].v<<16,endc=spc[1].c<<16;
temp=spc[2].y-spc[1].y;
rx=((spc[2].x-spc[1].x)<<16)/temp;
urx=((spc[2].u-spc[1].u)<<16)/temp;
vrx=((spc[2].v-spc[1].v)<<16)/temp;
crx=((spc[2].c-spc[1].c)<<16)/temp;
while((spc[2].y>spc[1].y)&&(spc[1].y<clipbottom))
{
if(startx<endx) shaded_texture_hline(startx,endx,endu,startu,endv,startv,endc,startc,spc[1].y);
else shaded_texture_hline(endx,startx,startu,endu,startv,endv,startc,endc,spc[1].y);
startx+=rx,endx+=lx,startu+=ulx,endu+=urx,startv+=vlx,endv+=vrx,startc+=clx,endc+=crx,spc[1].y++;
}
}
}
}