// Nerve 64kb intro source (c) '99 Proxium
// you may modify for personal needs or experiments
// you may use the algorithms in non commercial productions if you credit us

//Texture processor!
//Version 1.2.9

// start it with init srand(x) number

// 1 lines              number,step,r,g,b
// 2 lights             number,maxrad,addmaxrad,r>>,g>>,b>>
// 3 blur               number
// 4 connects texture   x,y
// 5 circle             number,maxrad,r,g,b
// 6 walking points     number,maxlen,twirl,r,g,b
// 7 brightness         r,g,b (in percents)
// 8 invert colors
// 9 distortion         num1,mul,radius
// 10 enviroument set   x,y,radius
// 11 clear texture
// 12 copy to buffer
// 13 chain with buffer
// 14 add with buffer
// 0 end of creating

unsigned char lnsimg[65536];
unsigned char lnsimg2[65536];
unsigned char texbuf[262144];
unsigned char texbuf2[270400];
unsigned char texbuf3[262144];
unsigned char sintab[256];
unsigned char table[256*256*2];
//unsigned char shade_table[65536];

void create_shade_table()
{
        float a1,b1,c1;
        for(b1=0;b1<255;b1++)
        {
        for(a1=0;a1<255;a1++)
        {
        if(a1<=128) c1=b1*(a1/128); else c1=a1+(b1-128)*((255-a1)/127);
        shade_table[int(a1*256+b1)]=c1;
        }
        }
}

void tdistort(char t1,char b1,char b)
{
        int a,c=0;
        char t2,t3,t4;
        t2=t1,t3=t1,t4=t1;

        for(a=0;a<256;a++) sintab[a]=b1*cos(a*pi/b);

_asm {  mov esi,offset texbuf
        mov edi,offset texbuf2
        mov ecx,65536
l1:     mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz l1
}

_asm {  mov edi,offset table
        mov esi,offset sintab
        mov eax,0
        mov dx,256
p1vert: mov cx,256
p1hor:  mov al,cl
        add al,t1
        mov al,[esi+eax]
        mov bh,al
        mov al,dl
        add al,t2
        mov al,[esi+eax]
        add al,bh
        mov [edi],al
        mov al,cl
        add al,t3
        mov al,[esi+eax]
        mov bh,al
        mov al,dl
        add al,t4
        mov al,[esi+eax]
        add al,bh
        mov [edi+65536],al
        inc edi
        loop p1hor
        dec dx
        jnz p1vert
}

_asm {  mov ebx,offset table
        mov edi,offset texbuf
        mov esi,offset texbuf2
        mov dx,256
wvert:  mov cx,256
wler:   mov eax,0
        mov al,[ebx]
        add al,cl
        mov ah,[ebx+65536]
        add ah,dl
        mov eax,[esi+eax*4]
        mov [edi],eax
        inc ebx
        add edi,4
        loop wler
        dec dx
        jnz wvert
        xor eax,eax
        mov edi,offset texbuf2
        mov ecx,65536
l1:     mov [edi],eax
        add edi,4
        dec ecx
        jnz l1
}
}

void tpset(char x,char y,char r,char g,char b,int ln)
{
if((x>=0)&&(y>=0)&&(x<=255)&&(y<=255))
{
_asm {  movzx eax,byte ptr x
        mov ah,y
        shl eax,2
        mov edi,eax
        add edi,offset texbuf
        mov al,b
        mov ah,g
        rol eax,16
        mov al,r
        ror eax,16
        mov ecx,ln
        and eax,0x7f7f7f7f
l1:     mov ebx,[edi]
        shr ebx,1
        and ebx,0x7f7f7f7f
        add ebx,eax
        mov [edi],ebx
        add edi,4
        dec ecx
        jnz l1
}
}
}

void tline(int x,int y,int x1,int y1,char r,char g,char b,int ln)
{
        int a,len;
        int xd,yd,dx,dy;
        int xs,ys;

        xd=x1-x;
        yd=y1-y;

        len=fabs(xd)+fabs(yd);
        if (len==0) return;
        dx=(xd<<16)/len;
        dy=(yd<<16)/len;
        x=x<<16,y=y<<16;
        a=0;

        while (a<=len)
{
        xs=x>>16;
        ys=y>>16;
        tpset(xs,ys,r,g,b,ln);
        x+=dx;
        y+=dy;
        a++;
}
}

void tzip(int x,int y,int len,char rnd3,char r,char g,char b,int ln)
{
        int rnd1,rnd2;

        while(len!=0)
{
        tpset(x,y,r,g,b,ln);

        rnd1=rand()%rnd3+1;
        rnd2=rand()%rnd3+1;

        if((rand()%rnd1+1)==rnd1) x++;
        else x--;
        if((rand()%rnd2+1)==rnd2) y++;
        else y--;
        len--;
}
}

void tcircle(int x,int y,int rad,char r,char g,char b,int ln)
{

 int max,min;
 int rmax,rmin;
 max=0;
 min=rad;
 rmax=rad*rad;
 rmin=rad*(rad-1);

 while(max<=min)
 {
  tpset(x+max,y-min,r,g,b,ln);
  tpset(x-max,y-min,r,g,b,ln);
  tpset(x+max,y+min,r,g,b,ln);
  tpset(x-max,y+min,r,g,b,ln);
  tpset(x-min,y-max,r,g,b,ln);
  tpset(x+min,y-max,r,g,b,ln);
  tpset(x-min,y+max,r,g,b,ln);
  tpset(x+min,y+max,r,g,b,ln);
  max++;
  if((rmax-=max*2)<=rmin) min--,rmin-=min*2;
 }
}

void tblur(char len)
{
_asm{   mov esi,offset texbuf
        mov edi,offset texbuf2
        add edi,2088
        mov edx,256
ll2:    mov ecx,256
ll1:    mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz ll1
        add edi,16
        dec edx
        jnz ll2
        mov cl,len
l3:     mov edi,offset texbuf2
        add edi,1044
        mov ebx,258
        push ecx
l2:     mov ecx,258
        push edi
l1:     mov eax,[edi-4]
        shr eax,2
        and eax,0x3f3f3f3f
        mov edx,[edi+4]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov edx,[edi+1040]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov edx,[edi-1040]
        shr edx,2
        and edx,0x3f3f3f3f
        add eax,edx
        mov [edi],eax
        add edi,4
        dec ecx
        jnz l1
        pop edi
        add edi,1040
        dec ebx
        jnz l2
        pop ecx
        dec cl
        jnz l3
        mov esi,offset texbuf2
        mov edi,offset texbuf
        add esi,2088
        mov edx,256
lll2:   mov ecx,256
lll1:   mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz lll1
        add esi,16
        dec edx
        jnz lll2
}
}

void Initlns()
{
        int x1,y1,m0,m4=4;

_asm{   mov edi,offset lnsimg
        mov y1,-64
l3:     mov x1,-64
l2:     fild word ptr x1
        fimul word ptr x1
        fild word ptr y1
        fimul word ptr y1
        fadd
        fsqrt
        fimul word ptr m4
        fistp word ptr m0
        mov ax,word ptr m0
        not al
        test ah,ah
        jz ll1
        xor al,al
ll1:    cmp al,170
        jc ll2
        mov al,170
ll2:    test al,al
        jz ll3
ll3:    mov ah,al
        mov bl,al
        ror eax,16
        mov al,bl
        mov ah,al
        ror eax,16
        mov [edi],eax
        add edi,4
        inc x1
        cmp word ptr x1,64
        jnz l2
        inc y1
        cmp word ptr y1,64
        jnz l3
}
}

void tprtlns(int xlf,int ylf,short sizelf,char r,char g,char b)
{
        if (sizelf>=1)
{
        short xllp=0;
        short frmspr=0;
        short tospr=0;
        int newsize=sizelf/2;
        short size2=32768/sizelf;
        short yloop=sizelf;
        short xloop=sizelf;
        xlf-=newsize;
        ylf-=newsize;

        if((xlf+xloop)>256) xloop=256-xlf;
        if((ylf+yloop)>256) yloop=256-ylf;

        int xlflp=0-xlf;
        int ylflp=0-ylf;

        if(xlf<0) xloop-=xlflp,tospr=xlflp*size2,xlf=0;
        if(ylf<0) yloop-=ylflp,frmspr=ylflp*size2,ylf=0;

        if((xloop>0)&&(yloop>0))
{
_asm {  movzx eax,byte ptr xlf
        mov ah,byte ptr ylf
        shl eax,2
        mov edi,eax
        add edi,offset texbuf
        mov dx,size2
        xor ebx,ebx
        mov cx,yloop
        mov bx,frmspr
ld2:    movzx esi,bh
        add bx,dx
        shl esi,9
        add esi,offset lnsimg
        push bx
        push cx
        push edi
        mov bx,tospr
        mov ax,xloop
        mov xllp,ax
ld1:    movzx eax,bh
        mov eax,[eax*4+esi]
        mov cl,b
        shr al,cl
        add al,[edi]
        jnc ql3
        mov al,255
ql3:    mov [edi],al
        shr eax,8
        mov cl,g
        shr al,cl
        add al,[edi+1]
        jnc ql4
        mov al,255
ql4:    mov [edi+1],al
        shr eax,8
        mov cl,r
        shr al,cl
        add al,[edi+2]
        jnc ql5
        mov al,255
ql5:    mov [edi+2],al
        add bx,dx
        add edi,4
        dec xllp
        jnz ld1
        pop edi
        pop cx
        pop bx
        add edi,1024
        dec cx
        jnz ld2
}
}
}
}

void tcreate(short from[],unsigned char *to)
{
        int a=0,b,c,d,e;
        srand(from[a]);
        a++;

_asm {  mov edi,offset texbuf
        mov ebx,offset texbuf3
        xor eax,eax
        mov ecx,65536
l1:     mov [edi],eax
        mov [ebx],eax
        add edi,4
        add ebx,4
        dec ecx
        jnz l1
}

        create_shade_table();

for(;;)
{
        b=from[a];

        if(b==0)
{
_asm {  mov esi,offset texbuf
        mov edi,to
        mov ecx,65536
l1:     mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz l1
        }
        break;
        }
        if(b==1)
        {
        for(c=0;c<from[a+1];c+=from[a+2]) tline(rand()%320,rand()%320,rand()%320,rand()%320,c<<from[a+3],c<<from[a+4],c<<from[a+5],rand()%7+1);
        a+=6;
        }
        if(b==2)
        {
        for(c=0;c<from[a+1];c++) tprtlns(rand()%256,rand()%256,rand()%from[a+2]+from[a+3],c&from[a+4],c&from[a+5],c&from[a+6]);
        a+=7;
        }
        if(b==3) tblur(from[a+1]),a+=2;
        if(b==4)
        {
        b=from[a+1];
        c=from[a+2];

_asm {  mov esi,offset texbuf
        add esi,1024
        movzx eax,byte ptr b
        mov ah,byte ptr c
        shl eax,2
        add esi,eax
        mov edi,offset texbuf2
        mov ebx,128
l2:     push esi
        mov ecx,128
l1:     mov eax,[esi]
        mov [edi],eax
        add esi,4
        add edi,4
        dec ecx
        jnz l1
        pop esi
        add esi,1024
        dec ebx
        jnz l2
        mov esi,offset texbuf2
        mov edi,offset texbuf
        push ebp
        mov ebx,1020
        add ebx,edi
        mov ebp,261120
        add ebp,edi
        mov edx,262140
        add edx,edi
        mov ecx,128
l3:     push ecx
        push edi
        push ebx
        push ebp
        push edx
        mov ecx,128
l4:     mov eax,[esi]
        mov [edi],eax
        mov [ebx],eax
        mov [ebp],eax
        mov [edx],eax
        sub ebx,4
        sub edx,4
        add ebp,4
        add esi,4
        add edi,4
        dec ecx
        jnz l4
        pop edx
        pop ebp
        pop ebx
        pop edi
        pop ecx
        add ebx,1024
        sub ebp,1024
        sub edx,1024
        add edi,1024
        dec ecx
        jnz l3
        pop ebp
        }
        a+=3;
        }
        if(b==5)
        {
        for(c=0;c<from[a+1];c++) tcircle(rand()%320,rand()%320,rand()%(from[a+2]+1),c<<from[a+3],c<<from[a+4],c<<from[a+5],rand()%7+1);
        a+=6;
        }
        if(b==6)
        {
        for(c=0;c<from[a+1];c++) tzip(rand()%320,rand()%320,rand()%from[a+2],from[a+3],c<<from[a+4],c<<from[a+5],c<<from[a+6],rand()%5+1);
        a+=7;
        }
        if(b==7)
        {
        for(c=0;c<262144;c+=4)
        {
        d=texbuf[c+2]*from[a+1]/100;
        if(d>255) d=255;
        texbuf[c+2]=d;
        d=texbuf[c+1]*from[a+2]/100;
        if(d>255) d=255;
        texbuf[c+1]=d;
        d=texbuf[c]*from[a+3]/100;
        if(d>255) d=255;
        texbuf[c]=d;
        }
        a+=4;
        }
        if(b==8)
        {
        _asm {  mov esi,offset texbuf
                mov ecx,262144
        l1:     mov al,[esi]
                not al
                mov [esi],al
                inc esi
                dec ecx
                jnz l1
        }
        a++;
        }
        if(b==9) tdistort(from[a+1],from[a+2],from[a+3]),a+=4;
        if(b==10)
        {
        int x,y,x2,y2,dist,temp,color;

        for(y=0;y<256;y++)
        {
        for(x=0;x<256;x++)
        {
        x2=x-from[a+1];
        y2=y-from[a+2];
        dist=from[a+3]-sqrt(x2*x2+y2*y2);
        if(dist>127) dist=127;
        if(dist<0) dist=0;
        temp=y*1024+x*4;
        texbuf[temp]=shade_table[dist*256+texbuf[temp]];
        texbuf[temp+1]=shade_table[dist*256+texbuf[temp+1]];
        texbuf[temp+2]=shade_table[dist*256+texbuf[temp+2]];
        }
        }
        a+=4;
        }
        if(b==11)
        {
        _asm {  mov edi,offset texbuf
                xor eax,eax
                mov ecx,64000
        l1:     mov [edi],eax
                add edi,4
                dec ecx
                jnz l1
        }
        a++;
        }
        if(b==12)
        {
        _asm {  mov esi,offset texbuf
                mov edi,offset texbuf3
                mov ecx,64000
        l1:     mov eax,[esi]
                mov [edi],eax
                add esi,4
                add edi,4
                dec ecx
                jnz l1
        }
        a++;
        }
        if(b==13)
        {
        _asm {  mov esi,offset texbuf3
                mov edi,offset texbuf
                mov ecx,256000
        l1:     movzx ax,byte ptr [esi]
                movzx bx,byte ptr [edi]
                add ax,bx
                shr ax,1
                mov [edi],al
                inc esi
                inc edi
                dec ecx
                jnz l1
        }
        a++;
        }
        if(b==14)
        {
        _asm {  mov esi,offset texbuf3
                mov edi,offset texbuf
                mov ecx,256000
        l1:     mov al,[esi]
                add al,[edi]
                jnc l2
                mov al,255
        l2:     mov [edi],al
                inc esi
                inc edi
                dec ecx
                jnz l1
        }
        a++;
        }
        }
}