﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace puppyfarm {
    class Utils {
        static String[] digraphs = {
            "la",  "ve",  "ta",  "re",  "or",  "za",  "us",  "ac",
            "te",  "ce",  "at",  "a",   "e",   "o",   "le",  "fa",
            "he",  "na",  "ar",  "to",  "oi",  "ne",  "no",  "ba",
            "bo",  "ha",  "ve",  "va",  "ax",  "is",  "or",  "in",
            "mo",  "on",  "cra", "ud",  "sa",  "tu",  "ju",  "pi",
            "mi",  "gu",  "it",  "ob",  "os",  "ut",  "ne",  "as",
            "en",  "ky",  "tha", "um",  "ka",  "qt",  "zi",  "ou",
            "ga",  "dro", "dre", "pha", "phi", "sha", "she", "fo",
            "cre", "tri", "ro",  "sta", "stu", "de",  "gi",  "pe",
            "the", "thi", "thy", "lo",  "ol",  "clu", "cla", "le",
            "di",  "so",  "ti",  "es",  "ed",  "bi",  "po",  "ni",
            "ex",  "ad",  "un",  "pho", "ci",  "ge",  "se",  "co"
        };

        private static bool CheckSensibleName(String name) {
            int vowels = 0;
            int samechar = 0;
            char lastchar = '*';

            for (int i = 0; i < name.Length; i++) {
                char c = name[i];

                if (c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u')
                    vowels++;
                else
                    vowels = 0;

                if (vowels == 3) return false;  // Too many vowels together

                if (c == lastchar)
                    samechar++;
                else
                    samechar = 0;
                if (samechar == 2) return false;    // Too many of same letter together

                lastchar = c;
            }

            return true;
        }

        //static Hashtable usedNames = new Hashtable();
        public static String GetElitishName(int seed) {
            Random r = new Random(seed);

            String name = "aaa";

            int length = 2 + (int)(r.NextDouble() * 2.0f);    // 2-3 syllables

            if ((int)(r.NextDouble() * 15.0f) == 1)         // Oh ok then, go to 4 sometimes :D
                length++;

            //while (!CheckSensibleName(name) || usedNames.Contains(name)) {
            while (!CheckSensibleName(name)) {
                name = "";
                for (int i = 0; i < length; i++) {
                    String dgr = "";

                tryagain:
                    dgr = digraphs[r.Next(digraphs.Length)]; // Get a random syllable and make sure that no three-letter syllable is used as the last one
                    if (i == length - 1 && dgr.Length > 2) goto tryagain;

                    name += dgr;
                }
                name = Char.ToUpper(name[0]) + name.Substring(1);
            }

            //usedNames.Add(name, 1);
            return name;
        }
    }
}
