
#include "shared.h"

/* Global data */
vuint16 *vdp1_vram = (vuint16 *)VDP1_VRAM;
vuint16 *vdp1_fb   = (vuint16 *)VDP1_FB;
vuint16 *vdp2_vram = (vuint16 *)VDP2_VRAM;
vuint16 *vdp2_cram = (vuint16 *)VDP2_CRAM;
vuint16 *vdp2_reg  = (vuint16 *)VDP2_REG;

void vdp_init(void)
{
    int i;
    TVMD = 0x0000;

    *((unsigned short *) 0x25f8000e) = *((unsigned short *) 0x25f8000e) & (~0x3000);

    // Map Offset Register: Bitmap screen will be located at VRAM offset 0
    *((unsigned short *) 0x25f8003c) = 0;

    // Character Control Register: 256 colors, enable NBG0 as a bitmap
    // |8 for 1024x256 bitmap
    *((unsigned short *) 0x25f80028) = 0x0012|8;

    // Screen Scroll Value Registers: No scroll
    *((unsigned short *) 0x25f80070) = 0;
    *((unsigned short *) 0x25f80072) = 0;
    *((unsigned short *) 0x25f80074) = 0;

    // Screen Display Enable Register: Invalidate the transparency code for
    // NBG0 and display NBG0
    *((unsigned short *) 0x25f80020) = 0x0001;

    /* Clear VRAM */
    for(i = 0; i < 0x40000; i++)
        vdp2_vram[i] = 0x0000;

    /* Clear CRAM */
    for(i = 0; i < 0x0800; i++)
        vdp2_cram[i] = 0x0000;
}

void vdp_shutdown(void)
{
    int i;

    TVMD = 0x0000;

    for(i = 0; i < 0x100; i++)
        vdp2_reg[i] = 0x0000;

    for(i = 0; i < 0x40000; i++)
        vdp2_vram[i] = 0x0000;

    for(i = 0; i < 0x0800; i++)
        vdp2_cram[i] = 0x0000;
}

void wait_hblank_in(void)
{
    while((TVSTAT & 4) == 0);
}

void wait_hblank_out(void)
{
    while((TVSTAT & 4) == 4);
}

void wait_vblank_in(void)
{
    while((TVSTAT & 8) == 0);
}

void wait_vblank_out(void)
{
    while((TVSTAT & 8) == 8);
}

void wait_vblank(void)
{
    while((TVSTAT & 8) == 0);
    while((TVSTAT & 8) == 8);
}

void wait_hblank(void)
{
    while((TVSTAT & 4) == 0);
    while((TVSTAT & 4) == 4);
}
