
#ifndef _SMPC_H_
#define _SMPC_H_

/* SMPC direct I/O ports A and B */
#define PDR1        (*(vuint8  *)0x20100075)
#define PDR2        (*(vuint8  *)0x20100077)
#define DDR1        (*(vuint8  *)0x20100079)
#define DDR2        (*(vuint8  *)0x2010007B)
#define IOSEL       (*(vuint8  *)0x2010007D)
#define EXLE        (*(vuint8  *)0x2010007F)

#define PAD_DELAY   16
#define PAD_LBUTTON (1<<15)
#define PAD_RBUTTON (1<< 3)
#define PAD_X       (1<< 2)
#define PAD_Y       (1<< 1)
#define PAD_Z       (1<< 0)
#define PAD_START   (1<<11)
#define PAD_A       (1<<10)
#define PAD_C       (1<< 9)
#define PAD_B       (1<< 8)
#define PAD_RIGHT   (1<< 7)
#define PAD_LEFT    (1<< 6)
#define PAD_DOWN    (1<< 5)
#define PAD_UP      (1<< 4)

typedef struct {
    uint32 new, old, delta;
    uint8 tpx,tpy,lt,rt;
} analog_pad_t;

typedef struct {
    uint32 new, old, delta;
} pad_t;

/* Function prototypes */
void pad_init(void);
void pad_shutdown(void);
uint16 pad_read(int which);

#endif /* _SMPC_H_ */

