! Fire effect for SEGA Saturn
! /Mic, 2008
!
! Runs very slow on a real Saturn since it operates directly on VRAM.
! Could probably be sped up if an offscreen buffer was used, but then
! code size would increase.

.text
.align 1
.global _start

_start:

	mov.l	RAMCTL,r14
	mov.l	RAMCTL_mask,r6
	mov.w	@r14,r0
	and	r0,r6
	mov.w	r6,@r14

! Setup palette

	mov 	#0,r8
	mov 	#0x1F,r5
	mov.l 	color_mask,r6
	mov 	#64,r0
	mov.l 	palette_address,r4
_setup_palette:
	mov.w 	r8,@r4			! @r4 = r8
	mov 	r8,r2
	shll2 	r2
	shll2 	r2
	add 	r2,r2
	or 	r5,r2
	mov.w 	r2,@(r0,r4)		! @(64,r4) = 0x1F | r8<<5
	shll 	r0
	mov 	r8,r2
	shll8 	r2
	shll2 	r2
	or 	r6,r2
	mov.w 	r2,@(r0,r4)		! @(128,r4) = 0x07FF | r8<<10
	shlr 	r0
	add 	#2,r4
	add 	#1,r8
	cmp/gt	r5,r8
	bf 	_setup_palette
		
! Set the remaining colors to white

	add	#-33,r8
	add	#127,r4
	add	#1,r4
	mov	#160,r0
	extu.b	r0,r0
_set_colors_to_white:
	mov.w	r8,@r4
	dt	r0
	bf/s	_set_colors_to_white
	add 	#2,r4


! Set up the VDP2 registers

	mov.w	bit15,r10
	mov	#64,r8
	shll2	r8
	add 	#0x2e,r14	!Point to MPOFN
	mov	#0,r2
	mov.w	r2,@r14
	add 	#0x3c,r14	! Point to ZMXIN0
	mov.w 	r2,@-r14	! Clear SCYDN0
	mov.w 	r2,@-r14	! SCYIN0
	mov.w 	r2,@-r14	! SCXDN0
	mov.w 	r2,@-r14	! SCXIN0
	add 	#-72,r14	! Point to CHCTLA
	mov	#0x12,r2
	mov.w	r2,@r14
	add	#-8,r14		! Point to BGON
	add	#1,r8
	mov.w	r8,@r14
	add	#-32,r14	! Point to TVMD
	mov.w	r10,@r14
	add	#4,r14		! Point to TVSTAT

_forever:
_wait_vbl_over:
	mov.w	@r14,r0
	tst	#8,r0	
	bf	_wait_vbl_over
_wait_vbl_start:
	mov.w	@r14,r0
	tst	#8,r0
	bt	_wait_vbl_start

	mov #0,r8			! X
_xloop:
	mov.l	video_memory,r4
	add	r8,r4
	mov 	#112,r9 
	mov	#2,r1
	swap.b	r1,r1
	mov	r1,r15
	add	r15,r15
	
	mov	r4,r5
	add	#-2,r5
	add	r15,r5
	mov	r4,r6
	
_yloop:
	mov	r5,r7
	add	r15,r7
	add	#4,r7
				
! Read 4 pixels

	mov.b	@r5,r10
	mov.b	@(2,r5),r0
	extu.b	r0,r11
	mov.b	@(4,r5),r0
	extu.b	r0,r12
	mov.b	@r7,r13
	extu.b 	r10,r0
	extu.b 	r13,r13
				
! Calculate average

	add	r11,r0
	add	r12,r0
	add	r13,r0
	shlr2	r0
				
! Decrement color value if >0

	cmp/eq 	#0,r0
	bt 	_no_dec
	dt 	r0
_no_dec:

! Duplicate bits 0..7 into bits 8..15

	swap.b	r0,r10
	or 	r0,r10

	mov r6,r0
	mov.w r10,@r6			! Draw 2 pixels	
	mov.w r10,@(r0,r1)		! Draw 2 more pixels one scanline below
	
	add	r15,r5			! Move 2 lines down
	dt 	r9
	bf/s 	_yloop
	add	r15,r6			! Move 2 lines down

! Generate a pseudo-random number

	mov.l	rng_data,r10		! Point to seed1 in RAM
	mov	r10,r0
	add	#2,r0			! Point to the random number table in RAM
	mov.b 	@r10+,r11 		! seed1
	shll 	r11
	mov.w 	@(r0,r11),r12		
	shlr 	r11
	mov.b 	@r10+,r4		! seed2
	shll 	r4
	mov.w 	@(r0,r4),r13
	add	r13,r12			! Add the two numbers
	mov.w 	r12,@(r0,r4)
	shlr 	r4
	add	#1,r11			! Increase seed1
	add	#1,r4			! Increase seed2
	mov	#0x7,r13		
	and	r13,r11
	and	r13,r4
	mov	r12,r2			! Put the random number in r2
	mov.b	r4,@-r10		! Store seed2
	mov.b	r11,@-r10		! Store seed1

	add	#28,r2
	mov 	#191,r10
	extu.b	r10,r10
	and	r10,r2
			
	mov.l	spark,r0

	add	#2,r8
	cmp/eq	r1,r8
	bf/s	_xloop
	mov.b	r2,@(r0,r8)		! Store random pixel
	bra _forever			
	nop

		
.align 1

bit15:
	.short	-32768

.align 2

video_memory:
	.long	0x25e00000
palette_address:
	.long	0x25f00000
color_mask:
	.long 0x07FF
spark:
	.long 0x25e1c000
RAMCTL:
	.long	0x25f8000e
RAMCTL_mask:
	.long	0xcfff
rng_data:
	.long _rng_data
	
_rng_data:	
	! Seeds
	.byte 1 
	.byte 4 
_random:
	.word 25662,56977,36314,46707



	