; SMS sprite test
; /Mic 2004
;
; Assemble with WLA-DX
;
; Draws 9 sprites on the same scanline, only the first 8 should
; be visible.


.define PAGE_SIZE $4000

.memorymap
	defaultslot 0

	slotsize PAGE_SIZE
	slot 0 0
	slot 1 PAGE_SIZE
	slot 2 PAGE_SIZE*2
	
	slotsize $2000
	slot 3 $C000
	slot 4 $E000
.endme


.rombanksize $4000
.rombanks 2


.bank 0
.org $0000


di
im 1
ld sp,$dff0				; Set stack pointer
jp main


; IRQ handler
.org $0038
	di
	jp vblank_routine


; NMI handler	
.org $0066
	retn


.org $0100

main:

	ld a,$01
	out ($BF),a
	ld a,$C0
	out ($BF),a
	ld a,$2B			; Set bg color 1 to a reddish gray
	out ($BE),a

	ld a,$11
	out ($BF),a
	ld a,$C0
	out ($BF),a
	ld a,$38			; Set sprite color 1 to light blue
	out ($BE),a

	ld a,$00
	out ($BF),a
	ld a,$40
	out ($BF),a
	ld hl,pattern_data+PAGE_SIZE	; Pointer to pattern_data
	ld bc,$900			; 72 tiles * 32 byte
	copy_pat:
		ld a,(hl)
		inc hl
		out ($BE),a
		dec c
		jr nz,copy_pat
		dec b
		jr nz,copy_pat

	; Print some text
	ld hl,string1+PAGE_SIZE
	ld c,6
	ld b,1
	call print_bg

	ld hl,string2+PAGE_SIZE
	ld c,4
	ld b,3
	call print_bg

	ld hl,string3+PAGE_SIZE
	ld c,4
	ld b,4
	call print_bg

	ld a,$00			; Set sprite base address to $0000
	out ($BF),a
	ld a,$86	
	out ($BF),a

	ld a,$60			; Enable the screen & vsync irqs
	out ($BF),a
	ld a,$81	
	out ($BF),a

	ei				; Enable interrupts

	forever:
		jp forever		; Sit and wait for interrupts


.org $0400

; hl=string, c=column, b=row	(c=0..31, r=0..23)
print_bg:
	push hl
	ld de,0
	ld hl,$3800
	or d				; Just to clear the CF

	; Multiply b by 64 and shift the overflowing bits into d
	sll b
	rl d
	sll b
	rl d
	sll b
	rl d
	sll b
	rl d
	sll b
	rl d
	sll b
	rl d

	sll c
	add hl,de
	ld a,b
	ld b,0
	add hl,bc
	ld c,a
	add hl,bc
	ld a,l
	out ($BF),a
	ld a,h
	xor $40
	out ($BF),a
	pop bc
	ld d,0
	print_bg_loop:
		ld a,(bc)
		cp 0
		jr z,null_term

		inc bc
		ld e,a
		ld hl,char_set+PAGE_SIZE
		add hl,de
		ld a,(hl)
		out ($BE),a
		ld a,d
		out ($BE),a
		jp print_bg_loop
	null_term:
	ret


.org $0600
vblank_routine:
	; Point to sprite memory
	ld a,$00
	out ($BF),a
	ld a,$7F
	out ($BF),a	

	; Y coordinates, same for all
	ld a,$68
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a
	out ($BE),a

	ld a,$80
	out ($BF),a
	ld a,$7F
	out ($BF),a	

	; X,tile# pairs
	ld a,$60
	out ($BE),a
	ld a,$01
	out ($BE),a
	ld a,$68
	out ($BE),a
	ld a,$02
	out ($BE),a
	ld a,$70
	out ($BE),a
	ld a,$03
	out ($BE),a
	ld a,$78
	out ($BE),a
	ld a,$04
	out ($BE),a
	ld a,$80
	out ($BE),a
	ld a,$05
	out ($BE),a
	ld a,$88
	out ($BE),a
	ld a,$06
	out ($BE),a
	ld a,$90
	out ($BE),a
	ld a,$07
	out ($BE),a
	ld a,$98
	out ($BE),a
	ld a,$08
	out ($BE),a
	ld a,$A0
	out ($BE),a
	ld a,$09
	out ($BE),a
	ld a,$A8
	out ($BE),a
	
	ei
	reti
	
	
.bank 1
.org $0000
pattern_data:
	.incbin "serif8.pat"

char_set:
	.incbin "serif8.set"

string1:	
	.db "SMS sprite test  /Mic"
	.db 0
string2:	
	.db "You should see the digits"
	.db 0
string3:	
	.db "0..7 in blue below."
	.db 0

rom_title:
	.db "SpriTest"
	.db 0


.org $3fe0
.db "SDSC"
.db $00			; Major ver
.db $01			; Minor ver
.db $24			; Day
.db $03			; Month
.db $04, $20		; Year

.org $3fec
.dw rom_title+PAGE_SIZE
.db $FF,$FF		; Release notes pointer


.org $3ff0

.db "TMR SEGA"
.db $00,$00
.db $00,$00	
.db $00,$00
.db $00,$00	
			


	