;Starring - 256byte intro  by TomCat/Abaddon
;DOSBox version without timing

BUFFER EQU (256+256)

ORG 256
 DW 127         ; constant 127 -> amplitude for sinus table
 DW 3C00H       ; constant 1/128 -> calculating PI/128 for sinus table

 SUB EAX,EAX

 XCHG CX,AX
 PUSHA
 MOV DI,BUFFER
 MOV SI,image-1
 MOV BL,72
.2:
 LODSW
.3:
 ADD CL,BL
 MOV AL,44
 REP STOSB
 MOV CL,8
 SALC
 REP STOSB
 MOV CX,320-8
 SUB CX,BX
 ADD DX,[SI]
 ADC BL,[SI]
 DEC AX
 REP STOSB
 JNS .3
 INC SI
 CMP BYTE [SI],97
 JNZ .2
 POPA

 MOV BH,0FBH
@@:
 FLDPI          ; PI
 FMUL DWORD [SI]; PI/128
 FIMUL WORD [DI]; counter*PI/128
 FSIN           ; SIN(counter*PI/128)
 FIMUL WORD [SI]; 127*SIN(counter*PI/128)
 FISTP WORD [BX+SI]; -
 INC BX
;MOV AL,13H+80H ; INT8 speedup
;OUT 40H,AL
 DEC BYTE [DI]  ; loop 256x
 JNZ @B         ; BX = sinus table (FC00H)

 MOV AL,13H     ; set video mode 320x200
 INT 10H        ; call VGA Bios
 CLI
 PUSH 0A000H-BUFFER/16
 POP ES

 NEG BP
nextline:
 NEG CX
nextpixel:
 INC CX
 JNS star

mask:
 LEA SI,[DI+127]
_scroll:
 CMP BYTE [SI],BH
 JB copy

star:
 MOV SI,BUFFER+320*40+56
 PUSHA
 MOV DH,CL
 MOV CX,204H
.2:

 MOV AL,[BX]
 IMUL DL
 ADD BL,64
 XCHG DI,AX
 MOV AL,[BX]
 IMUL DH
 ADD AX,DI
 SUB BL,64+51
 CMP AX,BP
 JG .3
 MOV AL,55
 DEC CL
 JZ putpixel
 JMP .2
.3:
 DEC CH
 JNZ .2

tunnel:
 POPA
 PUSHA
 MOV AL,DL
 CBW
 XOR AH,DL
 MOV DH,AH
 MOV AL,CH
 CBW
 XOR AH,CL
 SALC
 SUB AL,DH
 SUB AL,AH
 SUB DH,AH
 MUL AL
 SALC
 XOR AL,AH
 XCHG AL,AH
 SUB AL,BL
 SHL DH,2
 AND AL,DH

 SHR AX,4
 SALC
 AND AL,AH
 ADD AL,16
 CBW

putpixel:
 MOV [SI],EAX
 POPA

copy:
 MOVSB
 CMP CX,160
 JNE nextpixel
 INC DX
 CMP DL,100
nextframe:
 JNE nextline

 MOV DI,BUFFER
 ADD BP,16
 CMP BP,3700
 JL @F
 MOV SI,_scroll-1
 SUB BP,16
 DEC BYTE [SI]
 JNS @F
 INC BYTE [SI]
@@:
 INC BL
 NEG DL
;HLT

 IN AL,60H
 DEC AX
 JNZ nextframe
RETN

image:
 DB 85,0,84
 DB 2,-6,171
 DB 45,0,100
 DB 1,-8,0
 DB 5,-1,0
 DB 0,26,0
 DB 24,0,102
 DB 4,-6,0
 DB 25,0,97
