﻿
; Sound sheep volume 1 * code principal

; Tom et Jerry du GPA * 18/04/2020 

; implantation des donnees :

; player musique implante en &7000
; la routine d'envoi des donnees a l'EF9345 ne balance que 6 lignes de 80 octets
; au lieu de 25 de 80. But de la chose, passer sous les 50eme de secondes avec la musique
; et le vumetre. 

; organisation ram :

;	adresse la plus haute &7F7F
;	adresse la plus base &4E4F

; On est tres chaud du coup au niveau ram utilisable pour le Basic. Le petit listing
; qui fait l'affichage et teste les touches 1 a 6 a particulierement ete degraisse
; pour tenir en memoire.

; Les redefinitions des caracteres sont bien au chaud dans l'EF9345, aucun besoin de
; les stocker quelque part en ram. Merci l'EF9345 !

; Player implante en &7410
; Code principal implante en &7000 (on laisse un peu de marge des fois que)


ORG &7000
WRITE "MAIN.BIN"

player_AKG_init equ &7410
player_AKG_play equ &7413
player_AKG_stop equ &7416

VG5000_ay_command equ 255
VG5000_ay_data equ 254
VG5000_ay_data_read equ 253


JP bootit      ; detournement des interruptions

JP aff_images  ; affichage des sprites du mouton et du soleil


base_video_vumetre equ &4288+&50

tab_volumes db &00,&00,&00  ; le player AKG recopie ici les hauteurs des volumes

music_choice db &6  ; on met une valeur ici pour supprimer un poke dans le listing Basic
music_status db &0

; &67D0 Boules & bits = &82A soit &830
; &6570 Sub hunter bonus = &256 soit &260
; &62B0 Relentless menu = &2BF soit &2C0
; &5EE0 Square roots Starkos = &3CC soit &3D0
; &5150 Logon's run = &D8A soit &D90
; &4E50 Sheeps travel in autumn = &2FA soit &300

music_datas defw &67D0,&5150,&62B0,&6570,&5EE0,&4E50


bootit
	DI
	PUSH IX
	PUSH HL

	LD HL,clean_reset
	LD (&47EF),HL

	LD A,&C3
	LD (&47D0),A
	LD HL,hacked
	LD (&47D1),HL

	JP back_to_basic


; Jack l'embrouille, on passe sur la routine d'affichage bidouillee en lieu et place
; de celle en &38. On peut adapter cette routine a ses besoins (la, on n'envoie a
; l'EF9345 que six lignes de donnees au lieu de 25 !


hacked	POP IY ; en theorie, IY est inutilise par le systeme
	JP ef9345


; Routine de vrai reset, appele par un autre detournement du vecteur &47EE.

clean_reset
	DI
	CALL player_AKG_stop
	RST &0


; ===================================================================
; Affichage du mouton et du soleil
; Vieille routine recupere de la version VG5232 du code, probablement
; pas bien propre, mais bon...
; ===================================================================


image_high equ 12   ; hauteur de l'image
image_length equ 17 ; largeur de l'image


; implantation des listes de caracteres redefinis composant les images


tab_image

; image mouton

db 12
db 17

db &0  ; couleur texte
db &80+&60 ; couleur mode graphique

defw sprite_mouton
defw &4004+160+36+160+80 ; Colonne 20 ligne 5

; image soleil

db 5
db 6

db &3
db &E3 ; &80 + &60 (fond cyan) + &3 (jaune)


defw sprite_soleil
defw &4004 + 60 ; Colonne 30 ligne 0

; fin de la table des parametres des sprites

db &00
ptr_tab_datas_sprites defw &0


; =================================
; Routine d'affichage des "sprites"
; =================================

aff_images

	DI
	PUSH IX
	PUSH HL

	LD HL,tab_image
	LD (ptr_tab_datas_sprites),HL

aff_images_1

	LD HL,(ptr_tab_datas_sprites)

	LD A,(HL)
	AND A
	JP Z,back_to_basic

	LD (poke_hauteur+1),A
	INC HL

	LD A,(HL)
	LD (poke_longueur+1),A
	INC HL

	LD A,(HL)
	LD (color_texte+1),A
	INC HL

	LD A,(HL)
	LD (color_graphique+1),A
	INC HL

	LD E,(HL)
	INC HL
	LD D,(HL)
	INC HL

	LD C,(HL)
	INC HL
	LD B,(HL)
	INC HL
	LD (ptr_tab_datas_sprites),HL

	PUSH BC
	POP HL

; boucle principale d'affichage

poke_hauteur
	LD B,image_high ; hauteur de l'image

aff_img2
	PUSH BC
	PUSH HL

poke_longueur
	LD B,image_length ; largeur de l'image

aff_img1
	LD A,(DE)

	AND A
	JR NZ,aff_img4 ; si valeur 0, on affiche le caractere texte non redefini 32

	LD A,32
	JR aff_img6

aff_img4
	CP &1           ; si valeur 1, on affiche le caractere texte non redefini 127
	JR NZ,aff_img5
	LD A,127
	JR aff_img6

aff_img5
	LD C,A
	SUB 128
	JR NC,aff_graphic
aff_texte
	LD A,C

	SET 7,A ; on active le bit 7 du premier octet pour indiquer qu'il
                ; s'agit d'un caractere redefini
aff_img6
	LD (HL),A
	INC HL

color_texte
	LD (HL),&00   ; mode texte, couleur noire
	JR aff_img3

aff_graphic

	ADD A,32

	SET 7,A 
	LD (HL),A
	INC HL

color_graphique
	LD (HL),&80+&60  ; mode graphique, fond jaune, texte noir

aff_img3
	INC HL
	INC DE
	DJNZ aff_img1

	POP HL	
	LD BC,80         ; on passe a la ligne suivante
	ADD HL,BC
	POP BC
	DJNZ aff_img2

	JP aff_images_1

; ======================================
; Routine d'envoi des donnees a l'EF9345
; ======================================

; J'ai conserve la routine a l'identique de celle implantee en &38,
; Les instructions inutilisees sont juste en remarque.

; Modifications effectuees
; changement de l'adresse de depart dans HL du buffer memoire
; decalage de la premiere ligne affichee
; reduction du nombre de lignes affichees

;----------------------------------
;Interruption masquable (IRQ)
;----------------------------------
	call    &47d0         ; routine "utilisateur"
			      ; c'est elle qui nous permet de faire le	
                              ; detournement.
ef9345	push IX
	PUSH HL

	push    af

;	dec     (ix+&00)      ; compteur d'interruptions pour
;	LD A,(IX+&0)

;	AND A
;	jp      nz,u0186      ;le rafraichissement de l'ecran

;	ld      a,(ix+&02)    ; valeur de reference compteur interruptions
;	ld      (ix+&00),a
;	bit     0,(ix+&01)    ; flag si l'ecran doit etre rafraichi (47FB)
;	res     0,(ix+&01)
;	jp      z,u0186

	push    bc
	push    de
	push    hl

;---------------------------------
;Affichage de l'ecran
;---------------------------------

	ld      a,&28     ; 28=Command register + exec request
	out     (&8f),a
	ld      a,&82     ; 82=Indirect 
	out     (&cf),a
	ld      a,&29     ;   29=Data register R1 + exec request
	out     (&8f),a
;	jp      u00bc

;--------------------------------------
; Affichage de l'ecran (suite)
;--------------------------------------

u00bc	ld      a,(ix+&03)    ; couleur bordure et aspect curseur
	and     &bf
	out     (&cf),a      ; ecriture dans R1 + commande IND 

	ld      c,&cf

;	ld      a,&26         ; 26=Main pointer R6 (Y)
;	out     (&8f),a
;	xor     a
;	out     (c),a         ; raz de Y 
;	ld      a,&27         ; 27=Main pointer R7 (X)
;	out     (&8f),a
;	xor     a
;	out     (c),a         ; raz de X

;-------------------------------------
; Envoi de la premiere ligne de l'ecran
;-------------------------------------

;	ld      hl,&4000    ; adresse memoire ecran

	ld      e,&03       

;	ld      b,&50       ; compteur d'octets a envoyer = 80
;	ld      a,&20          
;	out     (&8f),a     ; 20=Command register
;	out     (c),e       ; KRG ecriture en memoire avec increment 
;u00e0	ld      a,&22 		;	<----    22=Data register R2 
;	out     (&8f),a     ;|
;	outi                ;|   envoi de (hl++) = attribut
;	ld      a,&29       ;|   29=Data register R1 + exec request
;	out     (&8f),a     ;|
;	outi                ;|   envoi de (hl++) = caractere
;	jr      nz,u00e0    ;-- 

 
	ld      a,&26       ; 26=Main pointer R6 (Y)
	out     (&8f),a

hack_ligne_depart

	ld      a,&08 + 8   ; on decale de huit lignes vers le bas
	out     (c),a
	ld      a,&27       ; 27=Main pointer R7 (X)
	out     (&8f),a
	xor     a
	out     (c),a

;-----------------------------------------------------------
; Envoi des lignes suivantes, c'est ici qu'on peu bidouiller
;-----------------------------------------------------------

hack_base_video

	LD HL,  &42D0    ; on affiche a partir de la ligne 8
	ld      d,6      ; nombre de lignes à envoyer = 24 normalement
u00ff	ld      b,&78     ; <--------------------------- boucle = largeur x 3 (defaut 120)
	ld      a,&20
	out     (&8f),a  ;      20=Status

u0105	in      a,(&cf)  ; <-
	or      a        ;  |
	jp      m,u0105  ;---

	ld      a,&20          
	out     (&8f),a  ;      20=Command register
	out     (c),e    ;      KRG ecriture en memoire avec increment 

u0111	ld      a,&20    ;<------              
	out     (&8f),a  ;      | 20=Status

u0115	in      a,(&cf) ;  <-  | 
	or      a        ;    | |
	jp      m,u0115  ; ---  |

	ld      a,&22    ;      |    
	out     (&8f),a  ;      | 22=Data register R2
	outi             ;      | envoi de (hl++) = attribut

	ld      a,&29    ;      |    
	out     (&8f),a  ;      | 29=Data register R1 + exec request
	outi             ;      | envoi de (hl++) = caractere
	djnz    u0111    ;-------

	ld      a,&20          
	out     (&8f),a  ;      20=Status  

u012d	in      a,(&cf) ; <-
	or      a        ;  |
	jp      m,u012d  ;---

	ld      a,&28          
	out     (&8f),a  ;      28=Command register + exec request
	ld      a,&b0    
	out     (c),a    ;      INY = increment Y
	dec     d
	jr      nz,u00ff  ; ------------------------------> boucle

	bit     6,(ix+&03)
	jr      z,u0183   ;-------> fin
	ld      hl,(&4805) 
	ld      a,h        
	or      a          
	jr      z,u014e   ; -  
	add     a,&07     ; | 
	ld      h,a       ; | 
u014e	ld      c,&cf    ;<-  
	ld      a,&26
	out     (&8f),a   ;    26=Main pointer R6 (Y)
	out     (c),h
	ld      a,&27     ;    27=Main pointer R7 (X)
	out     (&8f),a
	out     (c),l
	ld      a,&28         
	out     (&8f),a   ;    28=Command register + exec request
	ld      a,&0a
	out     (c),a     ;    KRG=write sans increment         
	ld      a,&20     ;    20=Command register
	out     (&8f),a

u0168	in      a,(&cf)  ; <-
	or      a         ;  |
	jp      m,u0168   ;---

	ld      a,&28     ;    28=Command register + exec request
	out     (&8f),a
	ld      a,&82         
	out     (&cf),a  ;    IND=Indirect read R2
	ld      a,&29     ;    29=Data register R1 + exec request
	out     (&8f),a
	set     6,(ix+&03)
	ld      a,(ix+&03)
	out     (&cf),a

u0183	pop     hl        ;     <----- fin de l'affichage   
	pop     de
	pop     bc


; =================================
;  On joue la musique plus : 
;  Test si on change de musique
;  Test de la touche Espace
; =================================


u0186

; valeurs pokees a chaque frame, on peut avoir des valeurs differentes si on a
; force la mise a jour de l'affichage de la musique choisie.
; C'est utile pour pouvoir revenir a l'affichage du vumetre apres avoir change
; de musique (la routine en question modifie ces valeurs pour afficher en
; inversion video le numero du morceau joue).

	LD A,&10
	LD (hack_ligne_depart+1),A

	LD HL,&42D0
	LD (hack_base_video+1),HL

	CALL control_music

	LD HL,music_status

; On verifie si la touche Espace a ete appuyee pour arreter la musique courante

	LD A,(music_choice)  ; si on a le numero d'une musique, on l'initialise
	AND A
	JR Z,no_music_choice

	LD (HL),&1
	JR no_space_pressed

no_music_choice
	LD A,(HL)
	CP &2
	JR NZ,no_space_pressed

	IN A,(&81)              ; on teste si espace a ete pressee. 
	BIT 2,A
	JR NZ,no_space_pressed

	LD (HL),&3

; On rend la main au systeme

no_space_pressed

;	inc     (ix+&06)  ; <------ sortie sans affichage

	LD A,&1           ; on force un affichage a chaque appel du RST&38 !
	LD (&47FB),A

	POP AF

back_to_basic

	POP HL
	POP IX
	ei                ; enable interrupts      
	ret               ; On rend la main au Basic !


; ===============================================
;  Routine de gestion de la musique
;  Frontend pour le player Arkos tracker 2.0 AKG
; ===============================================

control_music

	PUSH AF
	PUSH BC
	PUSH HL
	PUSH DE
	PUSH IX
	PUSH IY

	EXX      ; si on ne sauvegarde pas les registres secondaires,
	PUSH BC  ; le player Arkos tracker 2 fait tout planter...
	PUSH HL  ; probleme avec EXX ? A tester ulterieurement.
	PUSH DE 


	LD A,(music_status)
	AND A               ; on ne fait rien
	JP z,back_to_control_music1

	CP &1
	JR Z,init_music  ; 
	CP &2
	JR Z,play_music  ;
	CP &3
	JP Z,stop_music  ;

back_to_control_music1

	CALL vumetres

	POP DE
	POP HL
	POP BC
	EXX       

	POP IY
	POP IX
	POP DE
	POP HL
	POP BC
	POP AF
	RET


init_music
	CALL display_choosen_music

	LD A,&10+9
	LD (hack_ligne_depart+1),A

	LD HL,&45A0
	LD (hack_base_video+1),HL

	CALL choose_music
	JR back_to_control_music1

play_music

	CALL player_AKG_play 
	JR back_to_control_music1

stop_music
	CALL player_akg_stop
	JR back_to_control_music1

choose_music

	LD A,(music_choice) ; entre 1 et 6
	DEC A
	ADD A,A ; x2
	LD C,A
	LD B,&0

	LD HL,music_datas
	ADD HL,BC

	LD E,(HL)
	INC HL
	LD D,(HL)

	EX DE,HL

	XOR A                 ; toutes les musiques n'ont qu'un seul theme
	CALL player_akg_init
	LD A,&2
	LD (music_status),A
	XOR A
	LD (music_choice),A
	RET	


; =================================================
;  Inversion video du numero de la musique choisie
; =================================================

display_choosen_music

	LD A,(music_choice) ; 1 a 6
	LD E,A

	LD A,&6
	LD BC,&FFAC
	LD HL,&4733      ; &45A5+80*5

display_choosen_music1   ; on affichage en partant du bas et en remontant
                         ; cela simplifie la routine
	LD D,&0
	CP E
	JR NZ,display_choosen_music2
	LD D,&40

display_choosen_music2
	LD (HL),D
	INC HL
	INC HL
	LD (HL),D
	INC HL
	INC HL
	LD (HL),D

	ADD HL,BC
	DEC A
	JR NZ,display_choosen_music1
	RET
	

; **********************
;    Code du vumetre
; **********************

vumetres

	LD B,&3

vumetres_1

	PUSH BC
	PUSH HL
	PUSH DE

	LD A,&E1
;	LD A,(IY+&0)     ; deplace ici pour pouvoir utiliser une
	LD (couleur+1),A ; couleur differente sur le sprite "son hardware"

	LD A,(DE)

	BIT 4,A          ; test si enveloppe hardware
	JR Z,vumetres_2

	LD DE,sprite_hardware
	LD A,&B1  ; &81
	LD (couleur+1),A
	JR vumetres_3

vumetres_2
	EX DE,HL

	ADD A,A ; a x 2

	LD L,A
	ADD A,A ; a x 4

	ADD A,L ; x6 (max 15x6 donc pas de debordement)
	LD L,A

	LD H,&0
	LD BC,sprites_vumetre
	ADD HL,BC ; BC + 6x HL

	EX DE,HL ; HL = adresse video, DE = pointeur sur sprite


; la routine est toute pourrite, il y a moyen de faire mieux
; ==========================================================

vumetres_3

	LD B,&6

affiche_barre
	PUSH BC

	LD A,(DE)

	OR &80  ; probablement necessaire pour afficher correctement

	LD (HL),A
	INC L
	INC DE
couleur
	LD C,&00
	LD (HL),C
	INC HL

	LD (HL),A ; largeur de 2 
	INC L
	LD (HL),C
	INC HL

	LD (HL),A ; largeur de 3
	INC L
	LD (HL),C
	INC HL

	INC L       ; On force la couleur du fond sur le caractere
	LD (HL),&E6 ; suivant le vumetre. On met tout en &6, sinon, on
                    ; propage la couleur du fond, merci l'EF9345 !


	LD BC,80-7
	ADD HL,BC

	POP BC
	DJNZ affiche_barre

	POP DE
	INC DE ; volume suivant

	POP HL
	LD BC,10
	ADD HL,BC

	POP BC

	DJNZ vumetres_1
	RET



; tab_couleurs db &E1,&E4,&E2


; =======================
; Definition des sprites
; =======================

sprites_vumetre

; ligne 1 volume 0 1 2
db 110,110,110,110,110,110
db 110,110,110,110,110,111
db 110,110,110,110,110,112

; ligne 2 volume 3 4 5
db 110,110,110,110,113,115
db 110,110,110,110,114,115
db 110,110,110,110,115,115

; ligne 3/4 volume 6 7 8
db 110,110,110,111,115,115
db 110,110,110,112,115,115
db 110,110,113,115,115,115

; ligne 4/5 volume 9 10 11
db 110,110,114,115,115,115
db 110,110,115,115,115,115
db 110,111,115,115,115,115

; ligne 5/6 volume 12 13 14
db 110,112,115,115,115,115
db 113,115,115,115,115,115
db 114,115,115,115,115,115
db 115,115,115,115,115,115

; enveloppe hardware detectee

sprite_hardware

db 109,109,109,109,109,109


sprite_mouton

; 17 caracteres sur 12 lignes

db  0, 0, 0, 0, 0, 0, 0, 0, 32, 33, 34, 35, 0, 0, 0, 0, 0
db  0, 0, 0, 0, 0, 0, 36, 37, 38, 39, 0, 40, 41, 42, 0, 0, 0
db  0, 43, 44, 45, 46, 47, 48, 0, 49, 0, 0, 0, 0, 50, 51, 0, 0
db  0, 52, 53, 54, 55, 56, 57, 0, 43, 58, 0, 0, 0, 0, 59, 60, 0
db  61, 62, 63, 64, 65, 0, 66, 67, 68, 0, 0, 0, 69, 70, 0, 71, 72
db  73, 74, 75, 76, 77, 78, 79, 1, 80, 81, 0, 0, 82, 83, 0, 84, 85
db  86, 87, 1, 1, 1, 88, 89, 90, 1, 91, 0, 0, 0, 0, 0, 92, 93
db  94, 95, 1, 1, 1, 96, 35, 0, 97, 98, 0, 0, 0, 99, 100, 101, 0
db  102, 103, 104, 105, 106, 107, 108, 109, 0, 0, 0, 0, 110, 111, 0, 0, 0
db  0, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 0, 0, 0, 0
db  0, 0, 0, 124, 125, 126, 127, 128, 129, 130, 1, 131, 132, 0, 0, 0, 0
db  0, 0, 133, 134, 135, 136, 136, 137, 136, 138, 136, 136, 139, 140, 0, 0, 0

sprite_soleil

; 6 caracteres sur 5 lignes

db  0, 141, 142, 143, 144, 0
db  145, 1, 1, 1, 146, 147
db  95, 1, 1, 1, 1, 148
db  149, 1, 1, 1, 1, 150
db  151, 152, 153, 154, 155, 0