; joku 1k by Yzi

%include "functions.inc"
%include "shader.inc"

align 1
bits 32


;%define NO_PANNING
;%define NO_BASS
%define NO_SWING

%define FRAMECOUNT_DWORD ebp
%define FRAMECOUNT_BYTE ebp


section .data

section .data_sglCreateShaderProgramv_s data align=1
glCreateShaderProgramv_s:
    db "glCreateShaderProgramv", 0

section .data_sglUseProgram_s data align=1
glUseProgram_s:
	db "glUseProgram", 0

;section .data_main_shader_pointer data align=1
global main_shader_pointer
main_shader_pointer:
	dd _shader_glsl
	
;section .data_musa_vars data align=1
;midiout_handle: dd 0
;tempvar: dd 0

;section .data_musa_sequence data align=1
section .data_screen_settings data align=1

pfd:
	db 0x00, 0x00, 0x00, 0x00, 0x21;, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
DMSCREENSETTINGS: ; DEVMODE struct
midiout_handle:	db 0x00, 0x00, 0x00, 0x00
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	db 0x9C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
	dd 1280 ;width
	dd 720 ;height
	db 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00

    ; MIDI status bytes
    ; 0x0000xxCy : Program Change (xx) on channel y
    ; 0x00vvnn9y : Note On, channel y, note nn, velocity vv
    ; 0x00007BBy : All Notes Off, channel y
    ; 0x00vvnnBy : Control Change (xx) on channel y, controller nn, value vv

;framecount dd 0
patch dd 0
note dd 0
; a dd 0
vel dd 0
chan dd 0

%define CHAN_EDI edi
%define A_EBX ebx
%define VEL_ESI esi

section .code_musa code align=1
addTune:
; 14   : {
	cmp     FRAMECOUNT_DWORD, (64+64+64+64)*16
        jg      exit

	pushad

; 9    :     if (!((framecount) & 7)) {
	mov	eax, FRAMECOUNT_DWORD
	;and	eax, 7
;	test eax, 7
	;jne	$LN5@addTune
;	jnz	$LN5@addTune

; 11   :         int chan = (framecount >> 3) & 7;
	mov	CHAN_EDI, FRAMECOUNT_DWORD
	;mov	CHAN_EDI, eax
	shr	CHAN_EDI, 3
	and	CHAN_EDI, 7
	;mov	[chan], eax
	;mov	CHAN_EDI, eax

; 13   :         int a = ((framecount) % 5);
	;mov	eax, FRAMECOUNT_DWORD		; framecount
	xor	edx, edx
	mov	ecx, 5
	div	ecx
	;mov	[a], edx
	mov A_EBX, edx

; 14   :         int note = (24 + ((framecount >> 9) % 4) * 5) + ((a * 7) % (a?24:12)) + (a?24:0);
	;mov	eax, FRAMECOUNT_DWORD
	;shr	eax, 9
;	xor	edx, edx
;	mov	ecx, 4
;	div	ecx
;	mov	ecx, edx
;	imul	ecx, 5
	mov	ecx, FRAMECOUNT_DWORD
	shr	ecx, 9
	and	ecx, 3
	imul 	ecx, 5
	
	mov	eax, A_EBX ; [a]
	imul	eax, 7
	mov	esi, A_EBX ; [a]
	neg	esi
	sbb	esi, esi
	and	esi, 12					; 0000000cH
	add	esi, 12					; 0000000cH
	cdq
	idiv	esi
	lea	edx, [ecx+edx+24]
	mov	eax, A_EBX ; [a]
	neg	eax
	sbb	eax, eax
	and	eax, 24					; 00000018H
	add	edx, eax
	mov	[note], edx

; 12   :         int vel = 128 - (int)abs((int)((framecount >> 4) % 256 - 127));
	mov	eax, FRAMECOUNT_DWORD
	shr	eax, 4
	and eax, 255
	sub eax, 127

	; eax = abs(eax)
	;mov eax, edx
	cdq
	xor eax, edx
	sub eax, edx
	
	;mov	edx, 128				; 00000080H
	;sub	edx, eax
	;mov	[vel], edx
	mov VEL_ESI, 127 ; 128
	sub VEL_ESI, eax

; 15   :         int patch = 51; //  + (framecount & 1);
	mov	byte [patch], 51		; 00000033H

	lea	eax, [A_EBX*2]

; 16   :         if (note < 35) { patch = 35; vel = 127 - a * 4; }
	cmp	byte [note], 35		; 00000023H
	jge	SHORT $LN3@addTune
	mov	byte [patch], 35		; 00000023H
	mov VEL_ESI, 127
	sub VEL_ESI, eax
	jmp	SHORT $LN2@addTune
$LN3@addTune:

; 17   :         else if (note > 70) { /* patch = 52; */ note -= 24; vel -= 24; }
	cmp	byte [note], 70		; 00000046H
	jle	SHORT $LN2@addTune
	sub dword [note], 24
	sub VEL_ESI, 24
$LN2@addTune:
; 19   :         midiOutShortMsg(midiout_handle, 0x00007BB0 + (chan & 7));        
	mov	eax, CHAN_EDI
	and	eax, 7
	add	eax, 31664				; 00007bb0H
	push	eax
	;mov	ecx, [midiout_handle]
	;push	ecx	
	push	dword [midiout_handle]
	call [__imp__midiOutShortMsg@8]

; 20   :         midiOutShortMsg(midiout_handle, 0x000000c0 + chan + (patch << 8));
	mov	eax, [patch]
	shl	eax, 8
	;mov	ecx, CHAN_EDI
	lea	edx, [CHAN_EDI+eax+192]
	push	edx
	;mov	eax, [midiout_handle]
	push	dword [midiout_handle]
	call [__imp__midiOutShortMsg@8]
	
; 21   :         midiOutShortMsg(midiout_handle, 0x00000090 + chan + (note << 8) + (vel << 16));
	mov	eax, [note]
	shl	eax, 8
	;mov	ecx, CHAN_EDI
	lea	edx, [CHAN_EDI+eax+144]
	;mov	eax, [vel]
	mov eax, VEL_ESI
	shl	eax, 16					; 00000010H
	add	edx, eax
	push	edx
	;mov	ecx, [midiout_handle]
	;push	ecx
	push	dword [midiout_handle]
	call [__imp__midiOutShortMsg@8]

; 23   :         // cc 10 : panning
; 24   :         midiOutShortMsg(midiout_handle, 0x000000b0 + chan + (10 << 8) + (((chan * 24)) << 16)); 
	mov	eax, CHAN_EDI
	imul	eax, 24					; 00000018H
	shl	eax, 16					; 00000010H
	;mov	ecx, CHAN_EDI
	lea	edx, [CHAN_EDI+eax+2736]
	push	edx
	;mov	eax, [midiout_handle]
	;push	eax
	push	dword [midiout_handle]
	call [__imp__midiOutShortMsg@8]
	
$LN5@addTune:
; 25   :     }
; 26   : }
loppu:

	popad
	ret
    ; MIDI status bytes
    ; 0x0000xxCy : Program Change (xx) on channel y
    ; 0x00vvnn9y : Note On, channel y, note nn, velocity vv
    ; 0x00007BBy : All Notes Off, channel y
    ; 0x00vvnnBy : Control Change (xx) on channel y, controller nn, value vv


section .code_main code align=1

global main
main:

%ifndef NO_SWING
	; swing/groove pattern
;	push 0b00000000000000000000001000000001
	push 0b00000000000000000000010000000001
	;push 0b00000000000000001000000000100000
	;pop	ebp
	;lea ebp, [0b00000000000000000000010000000001]
	;mov ebp, 0b00000100001000010000010000000001
%endif
	push	0 ; <-- framecount EBX
	; push	0 ; <-- EBP

	;push some function parameters to stack in (reverse) sequence for better compression
	;CreateWindow parameters
	push	0
	push	0
	push	0
	push	0 ;width  (not needed)
	push	0 ;height (not needed)
	push	0
	push	0
	push	0
	push	0x91000000 ;popup | visible | (NOT) maximize
	push	0
	push	0xC018
	push	0

	;ShowCursor parameter
	push	0

	;screenmode parameters
	;ChangeDisplaySettings(&screenSettings, CDS_FULLSCREEN)
	push	4 ;CDS_FULLSCREEN
	push	DMSCREENSETTINGS
	call	[__imp__ChangeDisplaySettingsA@8]

	push	0
	push	0
	push	0
	push	0
	push	midiout_handle
	call	[__imp__midiOutOpen@20]

	;ShowCursor(0);
	call	[__imp__ShowCursor@4]

	;CreateWindow((LPCSTR)0xC018, 0, WS_POPUP | WS_VISIBLE | WS_MAXIMIZE, 0, 0, 0, 0, 0, 0, 0, 0)
	call	[__imp__CreateWindowExA@48]
	;return value in eax
	;GetDC([eax])
	push	eax
	call	[__imp__GetDC@4]

%define HDC_EDI edi
	;store hDC in edi
	push	eax
	pop 	HDC_EDI
	;mov HDC_EDI, eax
	
	;ChoosePixelFormat(hDC, &pfd)
	push	pfd
	push	HDC_EDI
	call	[__imp__ChoosePixelFormat@8]

	;SetPixelFormat(hDC, [eax], &pfd)
	push	pfd
	push	eax
	push	HDC_EDI
	call	[__imp__SetPixelFormat@12]

	;wglCreateContext(hDC)
	push	HDC_EDI
	call	[__imp__wglCreateContext@4]

	;wglMakeCurrent(hDC, [eax])
	push	eax
	push	HDC_EDI
	call	[__imp__wglMakeCurrent@8]

	push	main_shader_pointer
	push	1
	push	0x00008b30 ;GL_FRAGMENT_SHADER
	push	glCreateShaderProgramv_s
	call	[__imp__wglGetProcAddress@4]
	call	eax

	push	eax
	push	glUseProgram_s
	call	[__imp__wglGetProcAddress@4]
	call	eax

	pop 	FRAMECOUNT_DWORD
	; SWING PATTERN HAS TO BE AT [ESP] NOW !!!
main_loop:
	add FRAMECOUNT_DWORD, 1
	;inc FRAMECOUNT_DWORD
	test FRAMECOUNT_DWORD, 7
	jnz nyei
	call addTune
nyei:
	push	27 ;VK_ESCAPE
	
; these four go to glRecti()
    push	-1
    push	-1
    push	1
    push	1

	push	1
	push	0
	push	0
	push	0
	push	0
	call	[__imp__PeekMessageA@20]
	
    push	0
    push	0
    push	FRAMECOUNT_DWORD
    call	[__imp__glColor3ui@12]
    ;add 	ebp, 16

    call	[__imp__glRecti@16]

    push	HDC_EDI
    call	[__imp__SwapBuffers@4]

	call	[__imp__GetAsyncKeyState@4]
	;test	eax, eax
	test	al, al
	je		main_loop

exit:
	;push	0
	call	[__imp__ExitProcess@4]